/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jogamp.common.os.elf.ElfHeaderPart2;
import jogamp.common.os.elf.IOUtils;
import jogamp.common.os.elf.Section;
import jogamp.common.os.elf.SectionArmAttributes;
import jogamp.common.os.elf.Shdr;

public class SectionHeader {
    public static final int SHT_NULL = 0;
    public static final int SHT_PROGBITS = 1;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_RELA = 4;
    public static final int SHT_HASH = 5;
    public static final int SHT_DYNAMIC = 6;
    public static final int SHT_NOTE = 7;
    public static final int SHT_NOBITS = 8;
    public static final int SHT_REL = 9;
    public static final int SHT_SHLIB = 10;
    public static final int SHT_DYNSYM = 11;
    public static final int SHT_NUM = 12;
    public static final int SHT_LOPROC = 0x70000000;
    public static final int SHT_HIPROC = Integer.MAX_VALUE;
    public static final int SHT_LOUSER = Integer.MIN_VALUE;
    public static final int SHT_HIUSER = -1;
    public static final int SHT_ARM_EXIDX = 0x70000001;
    public static final int SHT_ARM_PREEMPTMAP = 0x70000002;
    public static final int SHT_ARM_ATTRIBUTES = 0x70000003;
    public static final int SHT_AARCH64_ATTRIBUTES = 0x70000003;
    public static final int SHT_ARM_DEBUGOVERLAY = 0x70000004;
    public static final int SHT_ARM_OVERLAYSECTION = 0x70000005;
    public static final short SHN_UNDEF = 0;
    public static final short SHN_LORESERVE = -256;
    public static final short SHN_LOPROC = -256;
    public static final short SHN_HIPROC = -225;
    public static final short SHN_ABS = -15;
    public static final short SHN_COMMON = -14;
    public static final short SHN_HIRESERVE = -1;
    public final ElfHeaderPart2 eh2;
    public final Shdr raw;
    private final int idx;
    private String name;

    SectionHeader(ElfHeaderPart2 elfHeaderPart2, byte[] byArray, int n2, int n3, int n4) {
        this(elfHeaderPart2, ByteBuffer.wrap(byArray, 0, byArray.length), n4);
    }

    SectionHeader(ElfHeaderPart2 elfHeaderPart2, ByteBuffer byteBuffer, int n2) {
        this.eh2 = elfHeaderPart2;
        this.raw = Shdr.create(elfHeaderPart2.eh1.machDesc.ordinal(), byteBuffer);
        this.idx = n2;
        this.name = null;
    }

    public String toString() {
        return "SectionHeader[idx " + this.idx + ", name " + this.name + ", type " + IOUtils.toHexString(this.getType()) + ", link " + this.raw.getSh_link() + ", info " + IOUtils.toHexString(this.raw.getSh_info()) + ", flags " + IOUtils.toHexString(this.getFlags()) + "]";
    }

    void initName(Section section, int n2) throws IndexOutOfBoundsException {
        this.name = IOUtils.getString(section.data, section.offset + n2, section.length - n2, null);
    }

    public int getIndex() {
        return this.idx;
    }

    public int getType() {
        return this.raw.getSh_type();
    }

    public long getFlags() {
        return this.raw.getSh_flags();
    }

    public long getSize() {
        return this.raw.getSh_size();
    }

    public String getName() {
        return this.name;
    }

    public Section readSection(RandomAccessFile randomAccessFile) throws IOException, IllegalArgumentException {
        int n2 = IOUtils.long2Int(this.raw.getSh_size());
        if (0 == n2 || 0 > n2) {
            throw new IllegalArgumentException("Shdr[" + this.idx + "] has invalid int size: " + this.raw.getSh_size() + " -> " + n2);
        }
        byte[] byArray = new byte[n2];
        return this.readSectionImpl(randomAccessFile, byArray, 0, n2);
    }

    public Section readSection(RandomAccessFile randomAccessFile, byte[] byArray, int n2, int n3) throws IOException, IllegalArgumentException {
        int n4 = IOUtils.long2Int(this.raw.getSh_size());
        if (0 == n4 || 0 > n4) {
            throw new IllegalArgumentException("Shdr[" + this.idx + "] has invalid int size: " + this.raw.getSh_size() + " -> " + n4);
        }
        if (n3 > n4) {
            throw new IllegalArgumentException("Shdr[" + this.idx + "] has only " + n4 + " bytes, while read request is of " + n3 + " bytes");
        }
        return this.readSectionImpl(randomAccessFile, byArray, n2, n3);
    }

    Section readSectionImpl(RandomAccessFile randomAccessFile, byte[] byArray, int n2, int n3) throws IOException, IllegalArgumentException {
        long l2 = this.raw.getSh_offset();
        IOUtils.seek(randomAccessFile, l2);
        IOUtils.readBytes(randomAccessFile, byArray, n2, n3);
        if (0x70000003 == this.getType()) {
            return new SectionArmAttributes(this, byArray, n2, n3);
        }
        return new Section(this, byArray, n2, n3);
    }
}

