/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicPlayer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.Registry;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class Log {
    public static boolean isEnabled = true;
    private static DataOutputStream log = null;
    private static String fileName = "jmf.log";
    private static int indent = 0;
    private static JMFSecurity jmfSecurity = null;
    private static Method[] m = new Method[1];
    private static Class[] cl = new Class[1];
    private static Object[][] args = new Object[1][0];
    private static boolean ieSec = false;
    private static String permission = null;
    private static int permissionid = 0;
    static boolean errorWarned;

    private static synchronized boolean requestPerm() {
        try {
            if (!ieSec) {
                permission = "write file";
                permissionid = 4;
                jmfSecurity.requestPermission(m, cl, args, 4);
                m[0].invoke((Object)cl[0], args[0]);
            } else {
                PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            }
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    private static synchronized void writeHeader() {
        if (jmfSecurity != null && !Log.requestPerm()) {
            return;
        }
        Log.write("#\n# JMF " + BasicPlayer.VERSION + "\n#\n");
        String os2 = null;
        String osver = null;
        String osarch = null;
        String java = null;
        String jver = null;
        try {
            os2 = System.getProperty("os.name");
            osarch = System.getProperty("os.arch");
            osver = System.getProperty("os.version");
            java = System.getProperty("java.vendor");
            jver = System.getProperty("java.version");
        }
        catch (Throwable e2) {
            return;
        }
        if (os2 != null) {
            Log.comment("Platform: " + os2 + ", " + osarch + ", " + osver);
        }
        if (java != null) {
            Log.comment("Java VM: " + java + ", " + jver);
        }
        Log.write("");
    }

    public static synchronized void comment(Object str) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                log.writeBytes("## " + str + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void warning(Object str) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                log.writeBytes("!! " + str + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void profile(Object str) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                log.writeBytes("$$ " + str + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void error(Object str) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            if (!errorWarned) {
                System.err.println("An error has occurred.  Check jmf.log for details.");
                errorWarned = true;
            }
            try {
                log.writeBytes("XX " + str + "\n");
            }
            catch (IOException iOException) {}
        } else {
            System.err.println(str);
        }
    }

    public static synchronized void dumpStack(Throwable e2) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            e2.printStackTrace(new PrintWriter(log, true));
            Log.write("");
        } else {
            e2.printStackTrace();
        }
    }

    public static synchronized void write(Object str) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                int i2 = indent;
                while (i2 > 0) {
                    log.writeBytes("    ");
                    --i2;
                }
                log.writeBytes(str + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void setIndent(int i2) {
        indent = i2;
    }

    public static synchronized void incrIndent() {
        ++indent;
    }

    public static synchronized void decrIndent() {
        --indent;
    }

    public static int getIndent() {
        return indent;
    }

    static {
        String string = fileName;
        synchronized (string) {
            if (isEnabled && log == null) {
                Object llog = Registry.get("allowLogging");
                if (llog != null && llog instanceof Boolean && !((Boolean)llog).booleanValue()) {
                    isEnabled = false;
                }
                if (isEnabled) {
                    try {
                        jmfSecurity = JMFSecurityManager.getJMFSecurity();
                        if (jmfSecurity != null) {
                            if (jmfSecurity.getName().startsWith("jmf-security")) {
                                permission = "write file";
                                permissionid = 4;
                                jmfSecurity.requestPermission(m, cl, args, 4);
                                m[0].invoke((Object)cl[0], args[0]);
                                permission = "delete file";
                                permissionid = 8;
                                jmfSecurity.requestPermission(m, cl, args, 8);
                                m[0].invoke((Object)cl[0], args[0]);
                                permission = "read system property";
                                permissionid = 1;
                                jmfSecurity.requestPermission(m, cl, args, 1);
                                m[0].invoke((Object)cl[0], args[0]);
                            } else if (jmfSecurity.getName().startsWith("internet")) {
                                PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                                PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                                ieSec = true;
                            }
                        }
                    }
                    catch (Exception e2) {
                        isEnabled = false;
                    }
                }
                if (isEnabled) {
                    isEnabled = false;
                    try {
                        Object ldir = Registry.get("secure.logDir");
                        String dir2 = ldir != null && ldir instanceof String && !"".equals(ldir) ? (String)ldir : System.getProperty("user.dir");
                        String file = dir2 + File.separator + fileName;
                        log = new DataOutputStream(new FileOutputStream(file));
                        if (log != null) {
                            System.err.println("Open log file: " + file);
                            isEnabled = true;
                            Log.writeHeader();
                        }
                    }
                    catch (Exception e3) {
                        System.err.println("Failed to open log file.");
                    }
                }
            }
        }
        errorWarned = false;
    }
}

