/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class FixpCoord
implements Serializable,
Comparable<FixpCoord> {
    public static final int FRACTION_BITS = 20;
    public static final double FIXP_SCALE = 1048576.0;
    public static final long GRIDS_IN_LAMBDA = 400L;
    public static final ECoord ZERO = new ECoord(0L);
    public static final FixpCoord FIXP = new FixpCoord(1L);
    public static final ECoord GRID = new ECoord(0x100000L);
    public static final ECoord SIZE_GRID = new ECoord(0x200000L);
    public static final ECoord LAMBDA = new ECoord(0x19000000L);
    private static final long LAMBDA_UNIT = 0x19000000L;
    static final long FRACTION_MASK = 1048575L;
    private static final int GRIDS_SIGNIFICAND = 25;
    private static final int GRIDS_EXPONENT = 4;
    private static final int SIGNIFICAND_WIDTH = 53;
    private static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    private static final long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final int EXP_BIAS = 1023;
    private final long fixp;

    FixpCoord(long fixp) {
        this.fixp = fixp;
    }

    public static FixpCoord fromFixp(long fixp) {
        if (fixp == 0L) {
            return ZERO;
        }
        if ((fixp & 0xFFFFFL) == 0L) {
            return new ECoord(fixp);
        }
        return new FixpCoord(fixp);
    }

    static ECoord fromAlignedFixp(long fixp) {
        return fixp == 0L ? ZERO : new ECoord(fixp);
    }

    public static FixpCoord fromLambda(double lambda) {
        if (lambda == 0.0) {
            return ZERO;
        }
        return FixpCoord.fromFixp(FixpCoord.lambdaToFixp(lambda));
    }

    public static ECoord fromLambdaRoundGrid(double lambda) {
        if (lambda == 0.0) {
            return ZERO;
        }
        return FixpCoord.fromAlignedFixp(FixpCoord.lambdaToGridFixp(lambda));
    }

    public static ECoord fromLambdaRoundSizeGrid(double lambda) {
        if (lambda == 0.0) {
            return ZERO;
        }
        return FixpCoord.fromAlignedFixp(FixpCoord.lambdaToSizeGridFixp(lambda));
    }

    public static long lambdaToSizeGridFixp(double lambda) {
        return FixpCoord.lambdaRound(lambda, SIZE_GRID);
    }

    public static long lambdaToGridFixp(double lambda) {
        return FixpCoord.lambdaRound(lambda, GRID);
    }

    public static long lambdaToFixp(double lambda) {
        long fixp;
        long ieeeBits = Double.doubleToRawLongBits(lambda);
        int biasedExp = (int)((ieeeBits & 0x7FF0000000000000L) >> 52);
        int q = biasedExp + -1051;
        long significand = ieeeBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        long signMul = significand * 25L;
        if (q < 0) {
            int shift = -q;
            if (q <= -64) {
                return 0L;
            }
            fixp = (signMul - ((signMul ^ 0xFFFFFFFFFFFFFFFFL) >> shift & 1L) >> shift - 1) + 1L >> 1;
        } else {
            if (q > 63 || (signMul & -1L << 63 - q) != 0L) {
                throw new ArithmeticException();
            }
            fixp = signMul << q;
            assert (fixp > 0L);
        }
        return ieeeBits >= 0L ? fixp : -fixp;
    }

    public boolean isExact(ECoord resolution) {
        return FixpCoord.isMultiple(this.fixp, resolution);
    }

    public ECoord round(ECoord resolution) {
        long newFixp = FixpCoord.round(this.fixp, resolution);
        return newFixp == this.fixp ? (ECoord)this : FixpCoord.fromAlignedFixp(newFixp);
    }

    public ECoord floor(ECoord resolution) {
        long newFixp = FixpCoord.floor(this.fixp, resolution);
        return newFixp == this.fixp ? (ECoord)this : FixpCoord.fromAlignedFixp(newFixp);
    }

    public ECoord ceil(ECoord resolution) {
        long newFixp = FixpCoord.ceil(this.fixp, resolution);
        return newFixp == this.fixp ? (ECoord)this : FixpCoord.fromAlignedFixp(newFixp);
    }

    public static boolean isMultiple(long fixp, ECoord resolution) {
        return GenMath.isMultiple(fixp, resolution.getFixp());
    }

    public static long lambdaRound(double lambda, ECoord resolution) {
        return FixpCoord.roundLambda(lambda, resolution.getFixp(), 25, 4);
    }

    private static long roundLambda(double lambda, long res, int scaleSignificand, int scaleExponent) {
        long ieeeBits = Double.doubleToRawLongBits(lambda);
        int biasedExp = (int)((ieeeBits & 0x7FF0000000000000L) >> 52);
        int q = biasedExp + (scaleExponent + -1055);
        long significand = ieeeBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        long signMul = significand * (long)scaleSignificand;
        if (q < 0) {
            int shift = -q;
            if (shift >= 64 || res > signMul >> shift - 1) {
                return 0L;
            }
            long newFixp = GenMath.roundToMultiple(signMul, res << shift);
            return ieeeBits >= 0L ? newFixp : -(newFixp >>>= shift);
        }
        if (q > 63 || (signMul & -1L << 63 - q) != 0L) {
            throw new ArithmeticException();
        }
        long fixp = GenMath.roundToMultiple(signMul << q, res);
        assert (fixp > 0L);
        return ieeeBits >= 0L ? fixp : -fixp;
    }

    public static long round(long fixp, ECoord resolution) {
        return GenMath.roundToMultiple(fixp, resolution.getFixp());
    }

    public static long floor(long fixp, ECoord resolution) {
        return GenMath.roundToMultipleFloor(fixp, resolution.getFixp());
    }

    public static long ceil(long fixp, ECoord resolution) {
        return GenMath.roundToMultipleCeiling(fixp, resolution.getFixp());
    }

    public int signum() {
        return this.fixp > 0L ? 1 : (this.fixp < 0L ? -1 : 0);
    }

    public double getLambda() {
        return FixpCoord.fixpToLambda(this.fixp);
    }

    public static double fixpToLambda(long fixp) {
        return (double)fixp / 4.194304E8;
    }

    public static double fixpToGridDouble(long fixp) {
        return (double)fixp * 9.5367431640625E-7;
    }

    public static Point2D.Double fixpToGridPoint(long fixpX, long fixpY) {
        return new Point2D.Double(FixpCoord.fixpToGridDouble(fixpX), FixpCoord.fixpToGridDouble(fixpY));
    }

    public static Point2D.Double fixpToLambdaPoint(long fixpX, long fixpY) {
        return new Point2D.Double(FixpCoord.fixpToLambda(fixpX), FixpCoord.fixpToLambda(fixpY));
    }

    public long getFixp() {
        return this.fixp;
    }

    public FixpCoord add(FixpCoord y) {
        if (y.fixp == 0L) {
            return this;
        }
        if (this.fixp == 0L) {
            return y;
        }
        return FixpCoord.fromFixp(this.fixp + y.fixp);
    }

    public FixpCoord subtract(FixpCoord y) {
        if (y.fixp == 0L) {
            return this;
        }
        return FixpCoord.fromFixp(this.fixp - y.fixp);
    }

    public FixpCoord multiply(double scale) {
        if (scale == 1.0) {
            return this;
        }
        return FixpCoord.fromFixp((long)Math.rint((double)this.fixp * scale));
    }

    public FixpCoord multiply(long scale) {
        if (scale == 1L) {
            return this;
        }
        return FixpCoord.fromFixp(this.fixp * scale);
    }

    public FixpCoord min(FixpCoord y) {
        return this.fixp <= y.fixp ? this : y;
    }

    public FixpCoord max(FixpCoord y) {
        return this.fixp >= y.fixp ? this : y;
    }

    public boolean equals(Object o2) {
        return o2 instanceof FixpCoord && this.fixp == ((FixpCoord)o2).fixp;
    }

    public int hashCode() {
        return (int)this.fixp;
    }

    public String toString() {
        return Double.toString(this.getLambda());
    }

    @Override
    public int compareTo(FixpCoord that) {
        return this.fixp < that.fixp ? -1 : (this.fixp == that.fixp ? 0 : 1);
    }
}

