/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.FixpCoord;
import java.awt.geom.Rectangle2D;

public abstract class AbstractFixpRectangle
extends Rectangle2D {
    public abstract long getFixpMinX();

    public abstract long getFixpMinY();

    public abstract long getFixpMaxX();

    public abstract long getFixpMaxY();

    public abstract void setFixp(long var1, long var3, long var5, long var7);

    public abstract AbstractFixpRectangle createFixp(long var1, long var3, long var5, long var7);

    public long getFixpWidth() {
        return this.getFixpMaxX() - this.getFixpMinX();
    }

    public long getFixpHeight() {
        return this.getFixpMaxY() - this.getFixpMinY();
    }

    public long getFixpCenterX() {
        return this.getFixpMinX() + this.getFixpMaxX() >> 1;
    }

    public long getFixpCenterY() {
        return this.getFixpMinY() + this.getFixpMaxY() >> 1;
    }

    @Override
    public void setRect(double x, double y, double w, double h2) {
        long fixpMinX = FixpCoord.lambdaToFixp(x);
        long fixpMinY = FixpCoord.lambdaToFixp(y);
        long fixpMaxX = fixpMinX + FixpCoord.lambdaToFixp(w);
        long fixpMaxY = fixpMinY + FixpCoord.lambdaToFixp(h2);
        this.setFixp(fixpMinX, fixpMinY, fixpMaxX, fixpMaxY);
    }

    @Override
    public int outcode(double x, double y) {
        long fixpMinX = this.getFixpMinX();
        long fixpMinY = this.getFixpMinY();
        long fixpMaxX = this.getFixpMaxX();
        long fixpMaxY = this.getFixpMaxY();
        int out = 0;
        if (fixpMinX >= fixpMaxX) {
            out |= 5;
        } else if (x * 4.194304E8 < (double)fixpMinX) {
            out |= 1;
        } else if (x * 4.194304E8 > (double)fixpMaxX) {
            out |= 4;
        }
        if (fixpMinY >= fixpMaxY) {
            out |= 0xA;
        } else if (y * 4.194304E8 < (double)fixpMinY) {
            out |= 2;
        } else if (y * 4.194304E8 > (double)fixpMaxY) {
            out |= 8;
        }
        return out;
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        if (r instanceof AbstractFixpRectangle) {
            AbstractFixpRectangle src = (AbstractFixpRectangle)r;
            long x1 = Math.max(this.getFixpMinX(), src.getFixpMinX());
            long y1 = Math.max(this.getFixpMinY(), src.getFixpMinY());
            long x2 = Math.min(this.getFixpMaxX(), src.getFixpMaxX());
            long y2 = Math.min(this.getFixpMaxY(), src.getFixpMaxY());
            return this.createFixp(x1, y1, x2, y2);
        }
        AbstractFixpRectangle dest = this.createFixp(0L, 0L, 0L, 0L);
        Rectangle2D.intersect(this, r, dest);
        return dest;
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        if (r instanceof AbstractFixpRectangle) {
            AbstractFixpRectangle src = (AbstractFixpRectangle)r;
            long x1 = Math.min(this.getFixpMinX(), src.getFixpMinX());
            long y1 = Math.min(this.getFixpMinY(), src.getFixpMinY());
            long x2 = Math.max(this.getFixpMaxX(), src.getFixpMaxX());
            long y2 = Math.max(this.getFixpMaxY(), src.getFixpMaxY());
            return this.createFixp(x1, y1, x2, y2);
        }
        AbstractFixpRectangle dest = this.createFixp(0L, 0L, 0L, 0L);
        Rectangle2D.union(this, r, dest);
        return dest;
    }

    @Override
    public void add(Rectangle2D r) {
        if (r instanceof AbstractFixpRectangle) {
            AbstractFixpRectangle af = (AbstractFixpRectangle)r;
            this.setFixp(Math.min(this.getFixpMinX(), af.getFixpMinX()), Math.min(this.getFixpMinY(), af.getFixpMinY()), Math.max(this.getFixpMaxX(), af.getFixpMaxX()), Math.max(this.getFixpMaxY(), af.getFixpMaxY()));
        } else {
            super.add(r);
        }
    }

    @Override
    public void setRect(Rectangle2D r) {
        if (r instanceof AbstractFixpRectangle) {
            AbstractFixpRectangle af = (AbstractFixpRectangle)r;
            this.setFixp(af.getFixpMinX(), af.getFixpMinY(), af.getFixpMaxX(), af.getFixpMaxY());
        } else {
            super.setRect(r);
        }
    }

    @Override
    public double getX() {
        return FixpCoord.fixpToLambda(this.getFixpMinX());
    }

    @Override
    public double getY() {
        return FixpCoord.fixpToLambda(this.getFixpMinY());
    }

    @Override
    public double getWidth() {
        return FixpCoord.fixpToLambda(this.getFixpWidth());
    }

    @Override
    public double getHeight() {
        return FixpCoord.fixpToLambda(this.getFixpHeight());
    }

    @Override
    public double getMinX() {
        return FixpCoord.fixpToLambda(this.getFixpMinX());
    }

    @Override
    public double getMinY() {
        return FixpCoord.fixpToLambda(this.getFixpMinY());
    }

    @Override
    public double getMaxX() {
        return FixpCoord.fixpToLambda(this.getFixpMaxX());
    }

    @Override
    public double getMaxY() {
        return FixpCoord.fixpToLambda(this.getFixpMaxY());
    }

    @Override
    public double getCenterX() {
        return FixpCoord.fixpToLambda(this.getFixpCenterX());
    }

    @Override
    public double getCenterY() {
        return FixpCoord.fixpToLambda(this.getFixpCenterY());
    }

    public FixpCoord getCoordWidth() {
        return FixpCoord.fromFixp(this.getFixpWidth());
    }

    public FixpCoord getCoordHeight() {
        return FixpCoord.fromFixp(this.getFixpHeight());
    }

    public FixpCoord getCoordMinX() {
        return FixpCoord.fromFixp(this.getFixpMinX());
    }

    public FixpCoord getCoordMinY() {
        return FixpCoord.fromFixp(this.getFixpMinY());
    }

    public FixpCoord getCoordMaxX() {
        return FixpCoord.fromFixp(this.getFixpMaxX());
    }

    public FixpCoord getCoordMaxY() {
        return FixpCoord.fromFixp(this.getFixpMaxY());
    }

    public FixpCoord getCoordCenterX() {
        return FixpCoord.fromFixp(this.getFixpCenterX());
    }

    public FixpCoord getCoordCenterY() {
        return FixpCoord.fromFixp(this.getFixpCenterX());
    }

    public double getLambdaX() {
        return FixpCoord.fixpToLambda(this.getFixpMinX());
    }

    public double getLambdaY() {
        return FixpCoord.fixpToLambda(this.getFixpMinY());
    }

    public double getLambdaWidth() {
        return FixpCoord.fixpToLambda(this.getFixpWidth());
    }

    public double getLambdaHeight() {
        return FixpCoord.fixpToLambda(this.getFixpHeight());
    }

    public double getLambdaMinX() {
        return FixpCoord.fixpToLambda(this.getFixpMinX());
    }

    public double getLambdaMinY() {
        return FixpCoord.fixpToLambda(this.getFixpMinY());
    }

    public double getLambdaMaxX() {
        return FixpCoord.fixpToLambda(this.getFixpMaxX());
    }

    public double getLambdaMaxY() {
        return FixpCoord.fixpToLambda(this.getFixpMaxY());
    }

    public double getLambdaCenterX() {
        return FixpCoord.fixpToLambda(this.getFixpCenterX());
    }

    public double getLambdaCenterY() {
        return FixpCoord.fixpToLambda(this.getFixpCenterY());
    }

    public long getFixpX() {
        return this.getFixpMinX();
    }

    public long getFixpY() {
        return this.getFixpMinY();
    }

    @Override
    public boolean isEmpty() {
        return this.getFixpWidth() <= 0L || this.getFixpHeight() <= 0L;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[x=" + this.getX() + ",y=" + this.getY() + ",w=" + this.getWidth() + ",h=" + this.getHeight() + "]";
    }
}

