/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Reader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GenPkgImports {
    private final Map<String, Map<String, String>> packages = new TreeMap<String, Map<String, String>>();
    private final Map<String, Set<String>> dependences = new TreeMap<String, Set<String>>();
    private final Map<String, Map<String, String>> sortedPackages = new LinkedHashMap<String, Map<String, String>>();

    private static void check(boolean b2) {
        assert (b2);
    }

    private static void checkNotNil(ACL2Object x) {
        GenPkgImports.check(!ACL2.NIL.equals(x));
    }

    private int calcDiff(Map<String, String> table, Map<String, String> real) {
        int intersectionSize = 0;
        for (Map.Entry<String, String> e2 : real.entrySet()) {
            String symName = e2.getKey();
            String pkgName = e2.getValue();
            if (!pkgName.equals(table.get(symName))) continue;
            ++intersectionSize;
        }
        return table.size() + real.size() - 2 * intersectionSize;
    }

    private void readPackages(ACL2Object alist) {
        while (ACL2.consp(alist).bool()) {
            ACL2Object pair = ACL2.car(alist);
            GenPkgImports.checkNotNil(ACL2.consp(pair));
            GenPkgImports.checkNotNil(ACL2.stringp(ACL2.car(pair)));
            String pk = ACL2.car(pair).stringValueExact();
            LinkedHashMap<String, String> imports = new LinkedHashMap<String, String>();
            ACL2Object impAlist = ACL2.cdr(pair);
            while (ACL2.consp(impAlist).bool()) {
                ACL2Object imp2 = ACL2.car(impAlist);
                GenPkgImports.checkNotNil(ACL2.consp(imp2));
                String pkgName = ACL2.car(imp2).stringValueExact();
                String symName = ACL2.cdr(imp2).stringValueExact();
                String old = imports.put(symName, pkgName);
                GenPkgImports.check(old == null);
                impAlist = ACL2.cdr(impAlist);
            }
            this.packages.put(pk, imports);
            alist = ACL2.cdr(alist);
        }
    }

    private void initDependencies() {
        for (Map.Entry<String, Map<String, String>> e2 : this.packages.entrySet()) {
            String pk = e2.getKey();
            Map<String, String> imports = e2.getValue();
            TreeSet<String> impPackages = new TreeSet<String>();
            for (String impPkg : imports.values()) {
                impPackages.add(impPkg);
            }
            this.dependences.put(pk, impPackages);
        }
        for (String pk : this.dependences.keySet()) {
            this.visitDeps(this.sortedPackages, pk);
        }
        GenPkgImports.check(this.sortedPackages.size() == this.dependences.size());
    }

    private void visitDeps(Map<String, Map<String, String>> visited, String top) {
        if (!visited.containsKey(top)) {
            Set<String> deps = this.dependences.get(top);
            GenPkgImports.check(deps != null);
            for (String dep : deps) {
                this.visitDeps(visited, dep);
            }
            Map<String, String> old = visited.put(top, this.packages.get(top));
            GenPkgImports.check(old == null);
        }
    }

    private String q(String s) {
        if (((String)s).isEmpty() || ((String)s).indexOf(32) >= 0) {
            s = "|" + (String)s + "|";
        }
        return s;
    }

    private GenPkgImports(ACL2Object root) {
        this.readPackages(root);
        this.initDependencies();
        for (Map.Entry<String, Map<String, String>> e2 : this.sortedPackages.entrySet()) {
            String pkgName;
            String symName;
            String pk = e2.getKey();
            Map<String, String> imports = e2.getValue();
            int bestDiff = imports.size();
            String bestPk = null;
            Map<Object, Object> bestImports = Collections.emptyMap();
            for (Map.Entry<String, Map<String, String>> entry : this.sortedPackages.entrySet()) {
                String pk1 = entry.getKey();
                Map<String, String> imports1 = entry.getValue();
                if (pk1.equals(pk)) break;
                int diff = this.calcDiff(imports1, imports);
                if (diff >= bestDiff) continue;
                bestDiff = diff;
                bestPk = pk1;
                bestImports = imports1;
            }
            System.out.print(this.q(pk));
            if (bestPk != null) {
                System.out.print(" " + this.q(bestPk));
            }
            System.out.println();
            for (Map.Entry<String, Map<String, String>> entry : bestImports.entrySet()) {
                symName = entry.getKey();
                pkgName = (String)((Object)entry.getValue());
                if (pkgName.equals(imports.get(symName))) continue;
                System.out.println("-" + this.q(pkgName) + ":" + this.q(symName));
            }
            for (Map.Entry<String, Object> entry : imports.entrySet()) {
                symName = entry.getKey();
                pkgName = (String)entry.getValue();
                if (pkgName.equals(bestImports.get(symName))) continue;
                System.out.println("+" + this.q(pkgName) + ":" + this.q(symName));
            }
            System.out.println();
        }
    }

    public static void gen(File f2) {
        try {
            ACL2Object.initHonsMananger("PkgImports");
            ACL2Reader sr = new ACL2Reader(f2);
            new GenPkgImports(sr.root);
        }
        catch (IOException iOException) {
        }
        finally {
            ACL2Object.closeHonsManager();
        }
    }
}

