/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.HonsManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ACL2Symbol
extends ACL2Object {
    final String nm;
    final Package pkg;
    private static final Map<String, Package> knownPackages = new HashMap<String, Package>();
    static final Package COMMON_LISP;
    static final Package KEYWORD;
    static final ACL2Symbol NIL;
    static final ACL2Symbol T;

    private static void readPkgImports() {
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader(ACL2Symbol.class.getResourceAsStream("pkg-imports.dat")));){
            String line;
            String curPkgName = null;
            HashSet<ACL2Symbol> curImports = null;
            block10: while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == ';') continue;
                switch (line.charAt(0)) {
                    case '+': 
                    case '-': {
                        String pkgName;
                        int ind;
                        if (line.charAt(1) == '|') {
                            ind = line.indexOf(2, 124);
                            pkgName = line.substring(2, ind);
                            ++ind;
                        } else {
                            ind = line.indexOf(58);
                            pkgName = line.substring(1, ind);
                        }
                        Package pkg = knownPackages.get(pkgName);
                        assert (line.charAt(ind) == ':');
                        String symName = ACL2Symbol.unquote(line.substring(ind + 1));
                        if (line.charAt(0) == '-') {
                            boolean ok = curImports.remove(pkg.symbols.get(symName));
                            assert (ok);
                            continue block10;
                        }
                        assert (!pkg.imports.containsKey(symName));
                        boolean ok = curImports.add(pkg.getSymbol(symName));
                        assert (ok);
                        continue block10;
                    }
                    default: {
                        int ind;
                        if (curPkgName != null) {
                            Package newPackage = new Package(curPkgName, curImports);
                            Package old = knownPackages.put(curPkgName, newPackage);
                            assert (old == null);
                        }
                        if (line.charAt(0) == '|') {
                            ind = line.indexOf(124, 1);
                            curPkgName = line.substring(1, ind);
                            ++ind;
                        } else {
                            ind = line.indexOf(32);
                            if (ind < 0) {
                                ind = line.length();
                            }
                            curPkgName = line.substring(0, ind);
                        }
                        while (ind < line.length() && line.charAt(ind) == ' ') {
                            ++ind;
                        }
                        if (ind == line.length()) {
                            curImports = new HashSet<ACL2Symbol>();
                            break;
                        }
                        String oldPkg = ACL2Symbol.unquote(line.substring(ind));
                        curImports = new HashSet<ACL2Symbol>(ACL2Symbol.knownPackages.get((Object)oldPkg).imports.values());
                    }
                }
            }
            if (curPkgName != null) {
                Package newPackage = new Package(curPkgName, curImports);
                Package old = knownPackages.put(curPkgName, newPackage);
                assert (old == null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String unquote(String s) {
        if (s.charAt(0) == '|') {
            if (s.charAt(s.length() - 1) != '|') {
                return null;
            }
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private ACL2Symbol(Package pkg, String nm) {
        super(ACL2Symbol.hashCodeOf(pkg.name, nm), HonsManager.GLOBAL);
        for (int i2 = 0; i2 < nm.length(); ++i2) {
            if (nm.charAt(i2) < '\u0100') continue;
            throw new IllegalArgumentException();
        }
        this.pkg = pkg;
        this.nm = nm;
    }

    @Override
    public String rep() {
        StringBuilder sb = new StringBuilder();
        if (this.pkg.equals(KEYWORD)) {
            sb.append(':');
        } else {
            sb.append(this.pkg.name).append("::");
        }
        if (this.isPrintable()) {
            sb.append(this.nm);
        } else {
            sb.append('|').append(this.nm).append('|');
        }
        return sb.toString();
    }

    private boolean isPrintable() {
        for (int i2 = 0; i2 < this.nm.length(); ++i2) {
            char c2 = this.nm.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case ':': {
                    return false;
                }
            }
            if (!Character.isLowerCase(c2) && (i2 != 0 || !Character.isDigit(c2))) continue;
            return false;
        }
        return true;
    }

    static synchronized Package getPackage(String pkgName) {
        Package pkg = knownPackages.get(pkgName);
        if (pkg == null) {
            pkg = new Package(pkgName, Collections.emptySet());
            knownPackages.put(pkgName, pkg);
        }
        return pkg;
    }

    static {
        ACL2Symbol.readPkgImports();
        COMMON_LISP = ACL2Symbol.getPackage("COMMON-LISP");
        KEYWORD = ACL2Symbol.getPackage("KEYWORD");
        NIL = COMMON_LISP.getSymbol("NIL");
        T = COMMON_LISP.getSymbol("T");
    }

    static class Package {
        final String name;
        private final Map<String, ACL2Symbol> imports = new HashMap<String, ACL2Symbol>();
        private final Map<String, ACL2Symbol> symbols = new HashMap<String, ACL2Symbol>();

        Package(String name, Set<ACL2Symbol> importsSyms) {
            if (name.isEmpty()) {
                throw new IllegalArgumentException();
            }
            for (int i2 = 0; i2 < name.length(); ++i2) {
                if (name.charAt(i2) < '\u0100') continue;
                throw new IllegalArgumentException();
            }
            this.name = name;
            for (ACL2Symbol impSym : importsSyms) {
                ACL2Symbol old = this.imports.put(impSym.nm, impSym);
                assert (old == null);
            }
        }

        synchronized ACL2Symbol getSymbol(String symName) {
            ACL2Symbol sym = this.imports.get(symName);
            if (sym != null) {
                return sym;
            }
            sym = this.symbols.get(symName);
            if (sym == null) {
                sym = new ACL2Symbol(this, symName);
                ACL2Symbol old = this.symbols.put(symName, sym);
                assert (old == null);
            }
            return sym;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

