/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2Character;
import com.sun.electric.util.acl2.ACL2Complex;
import com.sun.electric.util.acl2.ACL2Cons;
import com.sun.electric.util.acl2.ACL2Integer;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Rational;
import com.sun.electric.util.acl2.ACL2String;
import com.sun.electric.util.acl2.ACL2Symbol;
import com.sun.electric.util.acl2.Complex;
import com.sun.electric.util.acl2.HonsManager;
import com.sun.electric.util.acl2.Rational;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ACL2Reader {
    public final ACL2Object root;
    public final int nNat;
    public final int nInt;
    public final int nRat;
    public final int nComplex;
    public final int nChar;
    public final int nStr;
    public final int nNormStr;
    public final int nPkg;
    public final int nSym;
    public final int nCons;
    public final int nNormCons;
    private static final int MAGIC_V1 = -1408103481;
    private static final int MAGIC_V2 = -1408103480;
    static final int MAGIC_V3 = -1408103479;
    private final int magic;
    private final List<ACL2Object> allObjs = new ArrayList<ACL2Object>();

    private static void check(boolean p) {
        if (!p) {
            throw new RuntimeException();
        }
    }

    private static BigInteger readInt(DataInputStream in) throws IOException {
        BigInteger result = BigInteger.ZERO;
        int n2 = 0;
        while (true) {
            byte b2 = in.readByte();
            result = result.or(BigInteger.valueOf(b2 & 0x7F).shiftLeft(n2 * 7));
            if (b2 >= 0) break;
            ++n2;
        }
        return result;
    }

    private String readStr(DataInputStream in) throws IOException {
        int len = ACL2Reader.readInt(in).intValueExact();
        if (this.magic >= -1408103479) {
            len >>>= 1;
        }
        return ACL2Reader.readString(in, len);
    }

    private static String readString(DataInputStream in, int len) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < len; ++i2) {
            sb.append((char)(in.readByte() & 0xFF));
        }
        return sb.toString();
    }

    public ACL2Reader(File f2) throws IOException {
        HonsManager hm = HonsManager.current.get();
        try (DataInputStream in = new DataInputStream(new FileInputStream(f2));){
            int magicEnd;
            int i2;
            this.magic = in.readInt();
            ACL2Reader.check(this.magic >= -1408103481 && this.magic <= -1408103479);
            if (this.magic >= -1408103480) {
                this.allObjs.add(ACL2Symbol.NIL);
                this.allObjs.add(ACL2Symbol.T);
            }
            int len = ACL2Reader.readInt(in).intValueExact();
            this.nNat = ACL2Reader.readInt(in).intValueExact();
            for (int i3 = 0; i3 < this.nNat; ++i3) {
                BigInteger n2 = ACL2Reader.readInt(in);
                this.allObjs.add(ACL2Integer.intern(n2, hm));
            }
            int ratsLen = ACL2Reader.readInt(in).intValueExact();
            int nNegInt = 0;
            for (i2 = 0; i2 < ratsLen; ++i2) {
                BigInteger sign = ACL2Reader.readInt(in);
                ACL2Reader.check(sign.equals(BigInteger.ZERO) || sign.equals(BigInteger.ONE));
                BigInteger num = ACL2Reader.readInt(in);
                BigInteger denom = ACL2Reader.readInt(in);
                if (sign.signum() != 0) {
                    num = num.negate();
                }
                if (denom.equals(BigInteger.ONE)) {
                    this.allObjs.add(ACL2Integer.intern(num, hm));
                    ++nNegInt;
                    continue;
                }
                this.allObjs.add(ACL2Rational.intern(Rational.valueOf(num, denom), hm));
            }
            this.nInt = this.nNat + nNegInt;
            this.nRat = ratsLen - nNegInt;
            this.nComplex = ACL2Reader.readInt(in).intValueExact();
            for (i2 = 0; i2 < this.nComplex; ++i2) {
                BigInteger signR = ACL2Reader.readInt(in);
                ACL2Reader.check(signR.equals(BigInteger.ZERO) || signR.equals(BigInteger.ONE));
                BigInteger numR = ACL2Reader.readInt(in);
                BigInteger denomR = ACL2Reader.readInt(in);
                if (signR.signum() != 0) {
                    numR = numR.negate();
                }
                Rational re = Rational.valueOf(numR, denomR);
                BigInteger signI = ACL2Reader.readInt(in);
                ACL2Reader.check(signI.equals(BigInteger.ZERO) || signI.equals(BigInteger.ONE));
                BigInteger numI = ACL2Reader.readInt(in);
                BigInteger denomI = ACL2Reader.readInt(in);
                if (signI.signum() != 0) {
                    numI = numI.negate();
                }
                Rational im = Rational.valueOf(numI, denomI);
                this.allObjs.add(ACL2Complex.intern(new Complex(re, im), hm));
            }
            this.nChar = ACL2Reader.readInt(in).intValueExact();
            for (i2 = 0; i2 < this.nChar; ++i2) {
                char c2 = (char)(in.readByte() & 0xFF);
                this.allObjs.add(ACL2Character.intern(c2));
            }
            this.nStr = ACL2Reader.readInt(in).intValueExact();
            int nNormStrings = 0;
            for (long i4 = 0L; i4 < (long)this.nStr; ++i4) {
                int strlen = ACL2Reader.readInt(in).intValueExact();
                boolean normed = false;
                if (this.magic >= -1408103479) {
                    normed = (strlen & 1) != 0;
                    strlen >>>= 1;
                }
                String s = ACL2Reader.readString(in, strlen);
                if (normed) {
                    ++nNormStrings;
                }
                this.allObjs.add(normed ? ACL2String.intern(s, hm) : new ACL2String(s));
            }
            this.nNormStr = nNormStrings;
            this.nPkg = ACL2Reader.readInt(in).intValueExact();
            int numSymsTotal = 0;
            for (int i5 = 0; i5 < this.nPkg; ++i5) {
                String pkgName = this.readStr(in);
                long numSyms = ACL2Reader.readInt(in).longValueExact();
                int j2 = 0;
                while ((long)j2 < numSyms) {
                    String name = this.readStr(in);
                    this.allObjs.add(ACL2Object.valueOf(pkgName, name));
                    ++j2;
                }
                numSymsTotal = (int)((long)numSymsTotal + numSyms);
            }
            this.nSym = numSymsTotal;
            this.nCons = ACL2Reader.readInt(in).intValueExact();
            int nNormConses = 0;
            for (int i6 = 0; i6 < this.nCons; ++i6) {
                int car = ACL2Reader.readInt(in).intValueExact();
                int cdr = ACL2Reader.readInt(in).intValueExact();
                boolean normed = false;
                if (this.magic >= -1408103480) {
                    normed = (car & 1) != 0;
                    car >>>= 1;
                }
                ACL2Object carObj = this.allObjs.get(car);
                ACL2Object cdrObj = this.allObjs.get(cdr);
                if (normed) {
                    ++nNormConses;
                }
                this.allObjs.add(normed ? ACL2Cons.intern(carObj, cdrObj, hm) : new ACL2Cons(carObj, cdrObj));
            }
            this.nNormCons = nNormConses;
            if (this.magic >= -1408103479) {
                int fal0;
                while ((fal0 = ACL2Reader.readInt(in).intValueExact()) != 0) {
                    ACL2Reader.readInt(in).intValueExact();
                }
            }
            ACL2Reader.check((magicEnd = in.readInt()) == this.magic);
            this.root = this.allObjs.get(this.magic >= -1408103480 ? len : len - 1);
        }
    }

    public String getStats() {
        return this.nInt + this.nRat + this.nComplex + this.nChar + this.nStr + this.nSym + " atoms and " + this.nCons + " conses. TreeCount=" + String.valueOf(ACL2Reader.treeCount(this.root, new HashMap<ACL2Cons, BigInteger>()));
    }

    private static BigInteger treeCount(ACL2Object top, Map<ACL2Cons, BigInteger> memoize) {
        if (top instanceof ACL2Cons) {
            ACL2Cons cons = (ACL2Cons)top;
            BigInteger count = memoize.get(cons);
            if (count == null) {
                count = BigInteger.ONE.add(ACL2Reader.treeCount(cons.car, memoize)).add(ACL2Reader.treeCount(cons.cdr, memoize));
                memoize.put(cons, count);
            }
            return count;
        }
        return BigInteger.ONE;
    }
}

