/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2Complex;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Rational;
import com.sun.electric.util.acl2.HonsManager;
import com.sun.electric.util.acl2.Rational;
import java.math.BigInteger;
import java.util.Map;

class ACL2Integer
extends ACL2Object {
    final BigInteger v;

    ACL2Integer(BigInteger v) {
        this(null, v);
    }

    private ACL2Integer(HonsManager hm, BigInteger v) {
        super(ACL2Integer.hashCodeOf(v), hm);
        this.v = v;
    }

    static ACL2Integer intern(BigInteger v, HonsManager hm) {
        Map<BigInteger, ACL2Integer> allNormed = hm.integers;
        ACL2Integer result = allNormed.get(v);
        if (result == null) {
            result = new ACL2Integer(hm, v);
            allNormed.put(v, result);
        }
        return result;
    }

    @Override
    public int intValueExact() {
        return this.v.intValueExact();
    }

    @Override
    public long longValueExact() {
        return this.v.longValueExact();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return this.v;
    }

    @Override
    boolean isACL2Number() {
        return true;
    }

    @Override
    Rational ratfix() {
        return Rational.valueOf(this.v, BigInteger.ONE);
    }

    @Override
    ACL2Object unaryMinus() {
        return new ACL2Integer(this.v.negate());
    }

    @Override
    ACL2Object unarySlash() {
        int sig = this.v.signum();
        if (sig > 0) {
            return this.v.bitLength() <= 1 ? this : new ACL2Rational(Rational.valueOf(BigInteger.ONE, this.v));
        }
        if (sig < 0) {
            BigInteger a2 = this.v.negate();
            return a2.bitLength() <= 1 ? this : new ACL2Rational(Rational.valueOf(BigInteger.valueOf(-1L), a2));
        }
        return this;
    }

    @Override
    ACL2Object binaryPlus(ACL2Object y) {
        return this.v.signum() == 0 ? y.fix() : y.binaryPlus(this);
    }

    @Override
    ACL2Object binaryPlus(ACL2Integer y) {
        return this.v.signum() == 0 ? y : new ACL2Integer(this.v.add(y.v));
    }

    @Override
    ACL2Object binaryPlus(ACL2Rational y) {
        return this.v.signum() == 0 ? y : y.binaryPlus(this);
    }

    @Override
    ACL2Object binaryPlus(ACL2Complex y) {
        return this.v.signum() == 0 ? y : y.binaryPlus(this);
    }

    @Override
    ACL2Object binaryStar(ACL2Object y) {
        return this.v.signum() == 0 ? this : y.binaryStar(this);
    }

    @Override
    ACL2Object binaryStar(ACL2Integer y) {
        return this.v.signum() == 0 ? this : new ACL2Integer(this.v.multiply(y.v));
    }

    @Override
    ACL2Object binaryStar(ACL2Rational y) {
        return this.v.signum() == 0 ? this : y.binaryStar(this);
    }

    @Override
    ACL2Object binaryStar(ACL2Complex y) {
        return this.v.signum() == 0 ? this : y.binaryStar(this);
    }

    @Override
    int signum() {
        return this.v.signum();
    }

    @Override
    int compareTo(ACL2Object y) {
        return this.v.signum() == 0 ? -y.signum() : -y.compareTo(this);
    }

    @Override
    int compareTo(ACL2Integer y) {
        return this.v.signum() == 0 ? -y.signum() : this.v.compareTo(y.v);
    }

    @Override
    int compareTo(ACL2Rational y) {
        return this.v.signum() == 0 ? -y.signum() : -y.compareTo(this);
    }

    @Override
    int compareTo(ACL2Complex y) {
        return this.v.signum() == 0 ? -y.signum() : -y.compareTo(this);
    }

    @Override
    public String rep() {
        return this.v.toString();
    }

    @Override
    ACL2Object internImpl(HonsManager hm) {
        return ACL2Integer.intern(this.v, hm);
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof ACL2Integer) {
            ACL2Integer that = (ACL2Integer)o2;
            if (this.hashCode == that.hashCode && (this.honsOwner == null || this.honsOwner != that.honsOwner)) {
                return this.v.equals(that.v);
            }
        }
        return false;
    }
}

