/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2Integer;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Rational;
import com.sun.electric.util.acl2.Complex;
import com.sun.electric.util.acl2.HonsManager;
import java.util.Map;

class ACL2Complex
extends ACL2Object {
    final Complex v;

    ACL2Complex(Complex v) {
        this(null, v);
    }

    private ACL2Complex(HonsManager hm, Complex v) {
        super(v.hashCode(), hm);
        if (v.isRational()) {
            throw new IllegalArgumentException();
        }
        this.v = v;
    }

    static ACL2Complex intern(Complex v, HonsManager hm) {
        Map<Complex, ACL2Complex> allNormed = hm.complexes;
        ACL2Complex result = allNormed.get(v);
        if (result == null) {
            result = new ACL2Complex(hm, v);
            allNormed.put(v, result);
        }
        return result;
    }

    @Override
    boolean isACL2Number() {
        return true;
    }

    @Override
    ACL2Object unaryMinus() {
        return new ACL2Complex(this.v.negate());
    }

    @Override
    ACL2Object unarySlash() {
        return new ACL2Complex(this.v.inverse());
    }

    @Override
    ACL2Object binaryPlus(ACL2Object y) {
        return y.binaryPlus(this);
    }

    @Override
    ACL2Object binaryPlus(ACL2Integer y) {
        return new ACL2Complex(this.v.add(y.v));
    }

    @Override
    ACL2Object binaryPlus(ACL2Rational y) {
        return new ACL2Complex(this.v.add(y.v));
    }

    @Override
    ACL2Object binaryPlus(ACL2Complex y) {
        return ACL2Complex.valueOf(this.v.add(y.v));
    }

    @Override
    ACL2Object binaryStar(ACL2Object y) {
        return y.binaryStar(this);
    }

    @Override
    ACL2Object binaryStar(ACL2Integer y) {
        return new ACL2Complex(this.v.mul(y.v));
    }

    @Override
    ACL2Object binaryStar(ACL2Rational y) {
        return new ACL2Complex(this.v.mul(y.v));
    }

    @Override
    ACL2Object binaryStar(ACL2Complex y) {
        return ACL2Complex.valueOf(this.v.mul(y.v));
    }

    @Override
    int signum() {
        return this.v.signum();
    }

    @Override
    int compareTo(ACL2Object y) {
        return -y.compareTo(this);
    }

    @Override
    int compareTo(ACL2Integer y) {
        return this.v.compareTo(y.v);
    }

    @Override
    int compareTo(ACL2Rational y) {
        return this.v.compareTo(y.v);
    }

    @Override
    int compareTo(ACL2Complex y) {
        return this.v.compareTo(y.v);
    }

    @Override
    public String rep() {
        return this.v.toString();
    }

    @Override
    ACL2Object internImpl(HonsManager hm) {
        return ACL2Complex.intern(this.v, hm);
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof ACL2Complex) {
            ACL2Complex that = (ACL2Complex)o2;
            if (this.hashCode == that.hashCode && (this.honsOwner == null || this.honsOwner != that.honsOwner)) {
                return this.v.equals(that.v);
            }
        }
        return false;
    }
}

