/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.utils;

import com.sun.electric.tool.util.concurrent.utils.BlockedRange;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import com.sun.electric.tool.util.concurrent.utils.Range;
import java.util.ArrayList;
import java.util.List;

public class BlockedRange1D
extends BlockedRange<BlockedRange1D> {
    private Range range;
    private Integer current = null;

    public BlockedRange1D(int start, int end, int step) {
        this.range = new Range(start, end, step);
    }

    public int start() {
        return this.range.start();
    }

    public int end() {
        return this.range.end();
    }

    public int step() {
        return this.range.step();
    }

    @Override
    public List<BlockedRange1D> splitBlockedRange(int step) {
        if (this.current != null && this.current >= this.range.end()) {
            return null;
        }
        ArrayList<BlockedRange1D> result = ConcurrentCollectionFactory.createArrayList();
        for (int i2 = 0; i2 < step; ++i2) {
            if (this.current == null) {
                this.current = this.range.start();
            }
            if (this.current >= this.range.end()) {
                return result;
            }
            result.add(new BlockedRange1D(this.current, Math.min(this.current + this.range.step(), this.range.end()), this.range.step()));
            this.current = this.current + this.range.step();
        }
        return result;
    }

    @Override
    public BlockedRange1D createInstance(int number, int total) {
        int size = this.range.end() - this.range.start();
        int split = size / total;
        BlockedRange1D result = new BlockedRange1D(number * split, number + 1 == total ? this.range.end() : (number + 1) * split, this.range.step());
        return result;
    }
}

