/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

public class StepSize {
    private double separation;
    private double low;
    private double high;
    private int rangeScale;
    private int stepScale;

    public double getLowValue() {
        return this.low;
    }

    public double getHighValue() {
        return this.high;
    }

    public double getSeparation() {
        return this.separation;
    }

    public int getStepScale() {
        return this.stepScale;
    }

    public int getRangeScale() {
        return this.rangeScale;
    }

    public StepSize(double h2, double l2, int n2) {
        this.low = l2;
        this.high = h2;
        this.stepScale = 0;
        this.rangeScale = 0;
        double range = Math.max(Math.abs(l2), Math.abs(h2));
        if (range == 0.0) {
            this.separation = 0.0;
            return;
        }
        if (Double.isInfinite(l2) || Double.isInfinite(h2)) {
            this.separation = 0.0;
            return;
        }
        while (range >= 10.0) {
            range /= 10.0;
            ++this.rangeScale;
        }
        while (range <= 1.0) {
            range *= 10.0;
            --this.rangeScale;
        }
        double d2 = Math.abs(h2 - l2) / (double)n2;
        if (Math.abs(d2 / (h2 + l2)) < 1.0E-7) {
            d2 = 0.1;
        }
        int mp = 0;
        while (d2 >= 10.0) {
            d2 /= 10.0;
            ++mp;
            ++this.stepScale;
        }
        while (d2 <= 1.0) {
            d2 *= 10.0;
            --mp;
            --this.stepScale;
        }
        double m2 = Math.pow(10.0, mp);
        int di = (int)d2;
        if (di == 0) {
            this.separation = 0.0;
            return;
        }
        if (di > 2 && di <= 5) {
            di = 5;
        } else if (di > 5) {
            di = 10;
        }
        int li = (int)(l2 / m2);
        int hi = (int)(h2 / m2);
        li = li / di * di;
        hi = hi / di * di;
        if (li < 0) {
            li -= di;
        }
        if (hi > 0) {
            hi += di;
        }
        this.low = (double)li * m2;
        this.high = (double)hi * m2;
        this.separation = (double)di * m2;
    }
}

