/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.WindowFrame;
import javax.swing.JPanel;

public abstract class WindowContextClass
extends JPanel
implements HighlightListener {
    protected Cell cell;
    protected Highlighter highlighter;
    protected WindowFrame wf;

    public WindowContextClass(Cell c2, WindowFrame wf) {
        this.cell = c2;
        this.wf = wf;
        this.highlighter = new Highlighter(0, wf);
        Highlighter.addHighlightListener(this);
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public String composeTitle(String prefix, int pageNo) {
        StringBuffer title = new StringBuffer();
        if (this.cell != null) {
            title.append(prefix + this.cell.libDescribe());
            if (this.cell.isMultiPage()) {
                title.append(" - Page " + (pageNo + 1));
            }
            Library curLib = Library.getCurrent();
            if (this.cell.getLibrary() != curLib && curLib != null) {
                title.append(" - Current library: " + curLib.getName());
            }
        } else {
            title.append("***NONE***");
        }
        return title.toString();
    }
}

