/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.dialogs.SeaOfGatesCell;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.MutableInteger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class RoutingDebug {
    private static final double goalWidth = 0.005;
    private static final double layerOffset = 0.04;
    private static final double possibleGoalOffset = 3.0;
    private static RoutingDialog debugDialog = null;
    private static Set<SeaOfGatesEngine.SearchVertex> onPath = new HashSet<SeaOfGatesEngine.SearchVertex>();
    private static SVState currentSVHighlight = null;
    private static Highlighter highlighter = null;
    private static Cell cell;
    private static boolean endADebug;
    private static int svOrder;
    private static Map<Integer, Color> netColors;
    private static Map<Integer, String> netNames;
    private static int colorAssigned;
    private static DebugType debuggingType;
    private static Color[] allColors;
    private static List<SeaOfGatesEngine.RoutesOnNetwork> allSpineRoutes;

    public static void startDebugging() {
        debugDialog = new RoutingDialog();
        RoutingDebug.debugDialog.routingMode.setSelected(true);
        User.setRoutingMode(true);
        ToolBar.setCursorMode(ToolBar.CursorMode.ROUTING);
    }

    private static void endDebugging() {
        User.setRoutingMode(false);
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.ROUTING) {
            ToolBar.setCursorMode(ToolBar.CursorMode.CLICKZOOMWIRE);
        }
        if (debugDialog != null) {
            debugDialog.setVisible(false);
            debugDialog.dispose();
            debugDialog = null;
        }
    }

    public static boolean isActive() {
        return debugDialog != null;
    }

    private static void showRouting(boolean endA) {
        EditWindow wnd = EditWindow.getCurrent();
        cell = wnd.getCell();
        highlighter = wnd.getRulerHighlighter();
        debuggingType = DebugType.DISPLAYROUTING;
        endADebug = endA;
        RoutingDebug.debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.getOptionsFromPreferences(false);
        RoutingDebug.debugDialog.router.setPrefs(prefs);
        RoutingDebug.debugDialog.svInfo = new HashMap<SeaOfGatesEngine.SearchVertex, SVState>();
        netNames = new HashMap<Integer, String>();
        svOrder = 1;
        SeaOfGates.seaOfGatesRoute(UserInterfaceMain.getEditingPreferences(), RoutingDebug.debugDialog.router);
    }

    public static boolean isEndADebugging() {
        return endADebug;
    }

    public static void setNetName(Integer netID, String name) {
        netNames.put(netID, name);
    }

    public static void debugRoute(SeaOfGatesEngine.NeededRoute nr) {
        if (debugDialog == null) {
            return;
        }
        DebugThread runnable = new DebugThread(nr);
        runnable.startJob();
    }

    public static void saveSVLink(SeaOfGatesEngine.SearchVertex sv, int lastDirection) {
        if (debugDialog != null && lastDirection >= 0) {
            SVState svs = RoutingDebug.ensureDebuggingShadow(sv.getLast(), false);
            svs.nextVertices[lastDirection] = sv;
        }
    }

    public static void saveSVDetails(SeaOfGatesEngine.SearchVertex sv, String[] details, boolean forcePrinting) {
        if (debugDialog != null) {
            SVState svs = RoutingDebug.ensureDebuggingShadow(sv, false);
            svs.details = details;
        }
        if (forcePrinting) {
            for (String s : details) {
                System.out.println(s);
            }
        }
    }

    public static SeaOfGatesEngine.SearchVertex findDebugSearchVertex(MouseEvent evt) {
        if (debugDialog == null || RoutingDebug.debugDialog.svInfo == null) {
            return null;
        }
        EditWindow wnd = (EditWindow)evt.getSource();
        if (wnd.getScale() < 25.0) {
            return null;
        }
        Point2D dbClick = wnd.screenToDatabase(evt.getX(), evt.getY());
        double bestDist = Double.MAX_VALUE;
        SeaOfGatesEngine.SearchVertex bestSV = null;
        for (SeaOfGatesEngine.SearchVertex sv : RoutingDebug.debugDialog.svInfo.keySet()) {
            double dY;
            double off = (double)sv.getZ() * 0.04;
            double dX = sv.getX() + off - dbClick.getX();
            double dist = Math.sqrt(dX * dX + (dY = sv.getY() + off - dbClick.getY()) * dY);
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            bestSV = sv;
        }
        if (bestDist < 1.0) {
            return bestSV;
        }
        return null;
    }

    public static void previewSelectedSV(SeaOfGatesEngine.SearchVertex sv, boolean center) {
        SVState svsHigh;
        if (debugDialog == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Highlighter h2 = wnd.getRulerHighlighter();
        SVState svs = RoutingDebug.debugDialog.svInfo.get(sv);
        if (currentSVHighlight != null) {
            currentSVHighlight.setBackgroundColor(null, h2);
        }
        if (RoutingDebug.debugDialog.currentSV != null && (svsHigh = RoutingDebug.debugDialog.svInfo.get(RoutingDebug.debugDialog.currentSV)) != null) {
            svsHigh.setBackgroundColor(Color.WHITE, h2);
            h2.finished();
        }
        if ((currentSVHighlight = svs) != null) {
            currentSVHighlight.setBackgroundColor(Color.RED, h2);
            h2.finished();
            if (center) {
                Rectangle2D windowBound = wnd.getDisplayedBounds();
                if (sv.getX() < windowBound.getMinX() || sv.getX() > windowBound.getMaxX() || sv.getY() < windowBound.getMinY() || sv.getY() > windowBound.getMaxY()) {
                    wnd.setOffset(new Point2D.Double(sv.getX(), sv.getY()));
                }
            }
            wnd.fullRepaint();
        }
    }

    public static void showSelectedSV(SeaOfGatesEngine.SearchVertex sv) {
        if (sv != null) {
            debugDialog.seeSelectedSV(sv);
        }
    }

    private static void showGeometryInArea(SeaOfGatesEngine.NeededRoute nr) {
        ERectangle drawn;
        List<SeaOfGatesEngine.SOGBound> assigned;
        Layer layer;
        int i2;
        debuggingType = DebugType.NONE;
        if (debugDialog == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        Rectangle2D limit = nr.getBounds();
        Highlighter h2 = wnd.getRulerHighlighter();
        h2.clear();
        colorAssigned = 0;
        netColors = new HashMap<Integer, Color>();
        double highestX = Double.MIN_VALUE;
        double highestY = Double.MIN_VALUE;
        debugDialog.setRouteDescription("Netlist information for selected area", null);
        RoutingDebug.showBlockageRect(cell, limit, h2, Color.ORANGE);
        HashMap allAssigned = new HashMap();
        for (i2 = 0; i2 < RoutingDebug.debugDialog.router.getNumMetals(); ++i2) {
            layer = RoutingDebug.debugDialog.router.getPrimaryMetalLayer(i2);
            assigned = new ArrayList();
            allAssigned.put(layer, assigned);
            Iterator<SeaOfGatesEngine.SOGBound> sea = RoutingDebug.debugDialog.router.searchMetalTree(layer, limit);
            while (sea.hasNext()) {
                SeaOfGatesEngine.SOGBound sBound = sea.next();
                if (sBound.getNetID() != null && sBound.getNetID().intValue() != 0) {
                    assigned.add(sBound);
                    continue;
                }
                drawn = RoutingDebug.showGeometryPiece(sBound, limit, layer);
                if (drawn == null) continue;
                if (drawn.getMaxX() > highestX) {
                    highestX = drawn.getMaxX();
                }
                if (!(drawn.getMaxY() > highestY)) continue;
                highestY = drawn.getMaxY();
            }
        }
        for (i2 = 0; i2 < RoutingDebug.debugDialog.router.getNumMetals(); ++i2) {
            layer = RoutingDebug.debugDialog.router.getPrimaryMetalLayer(i2);
            assigned = (List)allAssigned.get(layer);
            for (SeaOfGatesEngine.SOGBound sBound : assigned) {
                drawn = RoutingDebug.showGeometryPiece(sBound, limit, layer);
                if (drawn == null) continue;
                if (drawn.getMaxX() > highestX) {
                    highestX = drawn.getMaxX();
                }
                if (!(drawn.getMaxY() > highestY)) continue;
                highestY = drawn.getMaxY();
            }
        }
        double pos = highestY - 2.0;
        RoutingDebug.showBlockageRect(cell, new Rectangle2D.Double(highestX + 1.0, pos, 4.0, 2.0), h2, Color.BLACK);
        h2.addMessage(cell, "Detected Blockage", EPoint.fromLambda(highestX + 6.0, pos + 1.0));
        RoutingDebug.showBlockageRect(cell, new Rectangle2D.Double(highestX + 1.0, pos -= 3.0, 4.0, 2.0), h2, Color.BLUE);
        h2.addMessage(cell, "User-Supplied Blockage", EPoint.fromLambda(highestX + 6.0, pos + 1.0));
        RoutingDebug.showBlockageRect(cell, new Rectangle2D.Double(highestX + 1.0, pos -= 3.0, 4.0, 2.0), h2, Color.GRAY);
        h2.addMessage(cell, "Endpoint Blockage", EPoint.fromLambda(highestX + 6.0, pos + 1.0));
        pos -= 3.0;
        for (Integer netIDI : netColors.keySet()) {
            RoutingDebug.showBlockageRect(cell, new Rectangle2D.Double(highestX + 1.0, pos, 4.0, 2.0), h2, netColors.get(netIDI));
            Object netName = netNames.get(netIDI);
            if (netName == null) {
                netName = "Net " + netIDI;
            }
            h2.addMessage(cell, (String)netName, EPoint.fromLambda(highestX + 6.0, pos + 1.0));
            pos -= 3.0;
        }
        h2.finished();
        EditWindow.repaintAllContents();
    }

    private static void showBlockageRect(Cell cell, Rectangle2D bounds, Highlighter h2, Color col) {
        Point2D.Double p1 = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
        Point2D.Double p2 = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        Point2D.Double p3 = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
        Point2D.Double p4 = new Point2D.Double(bounds.getMaxX(), bounds.getMinY());
        h2.addLine(p1, p2, cell, true, col, false);
        h2.addLine(p2, p3, cell, true, col, false);
        h2.addLine(p3, p4, cell, true, col, false);
        h2.addLine(p4, p1, cell, true, col, false);
    }

    private static ERectangle showGeometryPiece(SeaOfGatesEngine.SOGBound sBound, Rectangle2D limit, Layer lay) {
        MutableInteger mi = sBound.getNetID();
        Integer netIDI = mi == null ? Integer.valueOf(0) : Integer.valueOf(mi.intValue());
        Color color = Color.BLACK;
        if (sBound.isPseudoBlockage()) {
            color = Color.GRAY;
        } else if (sBound.isUserSuppliedBlockage()) {
            color = Color.BLUE;
        } else if (netIDI != 0 && (color = netColors.get(netIDI)) == null) {
            color = allColors[colorAssigned % allColors.length];
            netColors.put(netIDI, color);
            ++colorAssigned;
        }
        ERectangle draw = sBound.getBounds();
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        Highlighter h2 = wnd.getRulerHighlighter();
        if (sBound instanceof SeaOfGatesEngine.SOGPoly) {
            SeaOfGatesEngine.SOGPoly pol = (SeaOfGatesEngine.SOGPoly)sBound;
            PolyBase pb = pol.getPoly();
            PolyBase.Point[] points = pb.getPoints();
            for (int i2 = 0; i2 < points.length; ++i2) {
                int lastI = i2 == 0 ? points.length - 1 : i2 - 1;
                h2.addLine(points[lastI], points[i2], cell, true, color, false);
            }
        } else {
            double lX = draw.getMinX();
            double hX = draw.getMaxX();
            double lY = draw.getMinY();
            double hY = draw.getMaxY();
            if (lX < limit.getMinX()) {
                lX = limit.getMinX();
                draw = null;
            }
            if (hX > limit.getMaxX()) {
                hX = limit.getMaxX();
                draw = null;
            }
            if (lY < limit.getMinY()) {
                lY = limit.getMinY();
                draw = null;
            }
            if (hY > limit.getMaxY()) {
                hY = limit.getMaxY();
                draw = null;
            }
            if (draw == null) {
                draw = ERectangle.fromLambda(lX, lY, hX - lX, hY - lY);
            }
            RoutingDebug.showBlockageRect(cell, draw, h2, color);
        }
        return draw;
    }

    public static void doGlobalRouting() {
        RoutingDebug.debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.getOptionsFromPreferences(false);
        debuggingType = DebugType.RUNGLOBALROUTING;
        RoutingDebug.debugDialog.router.setPrefs(prefs);
        SeaOfGates.seaOfGatesRoute(UserInterfaceMain.getEditingPreferences(), RoutingDebug.debugDialog.router);
    }

    public static String getDesiredRouteToDebug() {
        String selection = debugDialog != null ? RoutingDebug.debugDialog.whichOne.getText().trim() : null;
        return selection;
    }

    public static boolean isTestGlobalRouting() {
        return debugDialog != null && debuggingType == DebugType.RUNGLOBALROUTING;
    }

    public static void setGlobalRouting(SeaOfGatesEngine.GlobalRouter gr) {
        RoutingDebug.debugDialog.globalRoutingResults = gr;
    }

    public static void showGlobalRouting() {
        EditWindow wnd = EditWindow.getCurrent();
        Highlighter h2 = wnd.getRulerHighlighter();
        h2.clear();
        debugDialog.showGlobalRoutingGrid();
        debugDialog.showGlobalRoutingPath(null);
        h2.finished();
        wnd.repaint();
    }

    private static void showSpines() {
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        highlighter = wnd.getRulerHighlighter();
        allSpineRoutes = null;
        String routeName = RoutingDebug.debugDialog.whichOne.getText().trim();
        if (routeName.length() == 0) {
            Job.getUserInterface().showErrorMessage("Must set name of route first in 'Route to Debug' field.", "Missing Information");
            return;
        }
        new ShowSpineNets(cell, routeName);
    }

    public static void showSpineNetworks(List<SeaOfGatesEngine.RoutesOnNetwork> allRoutes) {
        allSpineRoutes = allRoutes;
    }

    public static boolean isShowingSpines() {
        return debugDialog != null && debuggingType == DebugType.SHOWSPINES;
    }

    private static void rewireNets() {
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        highlighter = wnd.getRulerHighlighter();
        new RewireNets(cell);
    }

    public static boolean isRewireNetworks() {
        return debugDialog != null && debuggingType == DebugType.REWIRENETS;
    }

    public static SVState ensureDebuggingShadow(SeaOfGatesEngine.SearchVertex sv, boolean start) {
        if (debugDialog == null) {
            return null;
        }
        SVState svs = RoutingDebug.debugDialog.svInfo.get(sv);
        if (svs == null) {
            Object msg = start ? "START" : "" + svOrder++;
            svs = new SVState(sv, (String)msg);
            RoutingDebug.debugDialog.svInfo.put(sv, svs);
        }
        return svs;
    }

    static {
        allColors = new Color[]{new Color(255, 64, 64), new Color(0, 153, 0), new Color(0, 0, 255), new Color(153, 0, 122), new Color(255, 128, 128), new Color(0, 255, 0), new Color(64, 255, 255), new Color(255, 128, 230), new Color(153, 102, 0), new Color(204, 136, 0), new Color(255, 127, 64), new Color(0, 204, 103), new Color(0, 0, 153), new Color(255, 191, 217)};
        allSpineRoutes = null;
    }

    private static class RoutingDialog
    extends EModelessDialog {
        private SeaOfGatesEngine router;
        private SeaOfGates.SeaOfGatesCellParameters sogp;
        private Technology tech;
        private Cell cell;
        private Map<SeaOfGatesEngine.SearchVertex, SVState> svInfo;
        private SeaOfGatesEngine.SearchVertex[] seeSV;
        private SeaOfGatesEngine.SearchVertex currentSV;
        private SeaOfGatesEngine.GlobalRouter globalRoutingResults;
        private JLabel routeDescriptionFrom;
        private JLabel routeDescriptionTo;
        private JLabel routeResult;
        private JLabel labValue;
        private JLabel grInfo;
        private JComboBox layerToShow;
        private JCheckBox showLayerGrid;
        private JCheckBox routingMode;
        private JTextField whichOne;
        private JTextField whichStep;
        private JTextArea[] dirData;
        private JButton[] dirShow;
        private JLabel[] costShow;
        private Font plainFont;
        private Font boldFont;

        public RoutingDialog() {
            super(TopLevel.getCurrentJFrame());
            String SPACE_KEY = "space-key";
            KeyStroke space = KeyStroke.getKeyStroke(32, 0);
            this.getRootPane().getInputMap(2).put(space, "space-key");
            this.getRootPane().getActionMap().put("space-key", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    this.spacePressed();
                }
            });
            this.seeSV = new SeaOfGatesEngine.SearchVertex[6];
            this.currentSV = null;
            this.tech = Technology.getCurrent();
            EditWindow wnd = EditWindow.getCurrent();
            this.cell = wnd.getCell();
            if (this.cell != null) {
                this.sogp = new SeaOfGates.SeaOfGatesCellParameters(this.cell);
            }
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Debug Routing");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    RoutingDebug.endDebugging();
                }
            });
            int yPos = 0;
            JButton runA = new JButton("Route From A->B");
            runA.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showRouting(true);
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.33;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)runA, gbc);
            this.layerToShow = new JComboBox();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.weightx = 0.33;
            gbc.anchor = 13;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.layerToShow, gbc);
            Iterator<ArcProto> it = this.tech.getArcs();
            while (it.hasNext()) {
                String gridData;
                ArcProto ap = it.next();
                if (!ap.getFunction().isMetal() || (gridData = this.sogp.getGrid(ap)) == null) continue;
                this.layerToShow.addItem(ap.getName());
            }
            this.showLayerGrid = new JCheckBox("Show Grid");
            this.showLayerGrid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.toggleGridDisplay();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.weightx = 0.33;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.showLayerGrid, gbc);
            JButton runB = new JButton("Route From B->A");
            runB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showRouting(false);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.33;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)runB, gbc);
            JLabel lab2 = new JLabel("Route to Debug:");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.weightx = 0.33;
            gbc.anchor = 13;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            this.whichOne = new JTextField("");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.weightx = 0.33;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.whichOne, gbc);
            this.routeDescriptionFrom = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.routeDescriptionFrom, gbc);
            this.routeDescriptionTo = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.routeDescriptionTo, gbc);
            this.routeResult = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.routeResult, gbc);
            JPanel panel = this.makeSVPanel();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            gbc.weighty = 0.5;
            this.getContentPane().add((Component)panel, gbc);
            JButton doGlobalRouting = new JButton("Show Global Routing");
            doGlobalRouting.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.doGlobalRouting();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos;
            gbc.weightx = 0.3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)doGlobalRouting, gbc);
            JButton rewire = new JButton("Rewire for Routing");
            rewire.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.rewireNets();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = yPos;
            gbc.weightx = 0.3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)rewire, gbc);
            JButton showSpines = new JButton("Show Spines");
            showSpines.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDebug.showSpines();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = yPos++;
            gbc.weightx = 0.3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)showSpines, gbc);
            JPanel grPanel = new JPanel();
            grPanel.setLayout(new GridBagLayout());
            grPanel.setBorder(BorderFactory.createTitledBorder("Global Routing"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = yPos++;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)grPanel, gbc);
            this.grInfo = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            grPanel.add((Component)this.grInfo, gbc);
            this.routingMode = new JCheckBox("Routing Mode");
            this.routingMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.toggleRoutingMode();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = ++yPos;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.routingMode, gbc);
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        private JPanel makeSVPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder("Routing Steps"));
            JButton backButton = new JButton("Back");
            backButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.showBack();
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            panel.add((Component)backButton, gbc);
            JButton nextButton = new JButton("Next");
            nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.showNext();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            panel.add((Component)nextButton, gbc);
            this.whichStep = new JTextField("");
            this.whichStep.setColumns(5);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.anchor = 13;
            gbc.insets = new Insets(4, 4, 4, 1);
            panel.add((Component)this.whichStep, gbc);
            JButton goButton = new JButton("Show Routing Step");
            goButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.showStepButton();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 2, 4, 4);
            panel.add((Component)goButton, gbc);
            this.labValue = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 4;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            panel.add((Component)this.labValue, gbc);
            this.dirData = new JTextArea[6];
            this.dirShow = new JButton[6];
            this.costShow = new JLabel[6];
            for (int i2 = 0; i2 < 6; ++i2) {
                this.dirShow[i2] = new JButton("See");
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = i2 * 2 + 2;
                gbc.gridheight = 2;
                gbc.anchor = 11;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                panel.add((Component)this.dirShow[i2], gbc);
                String lab = "";
                switch (i2) {
                    case 0: {
                        lab = "-X";
                        break;
                    }
                    case 1: {
                        lab = "+X";
                        break;
                    }
                    case 2: {
                        lab = "-Y";
                        break;
                    }
                    case 3: {
                        lab = "+Y";
                        break;
                    }
                    case 4: {
                        lab = "Down";
                        break;
                    }
                    case 5: {
                        lab = "Up";
                    }
                }
                JLabel dirLabel = new JLabel(lab);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = i2 * 2 + 2;
                gbc.weightx = 0.1;
                gbc.anchor = 15;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 0, 4);
                panel.add((Component)dirLabel, gbc);
                this.costShow[i2] = new JLabel("");
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = i2 * 2 + 3;
                gbc.weightx = 0.1;
                gbc.anchor = 11;
                gbc.insets = new Insets(0, 4, 4, 4);
                panel.add((Component)this.costShow[i2], gbc);
                this.dirData[i2] = new JTextArea("");
                this.dirData[i2].setEditable(false);
                this.dirData[i2].setCursor(null);
                this.dirData[i2].setOpaque(false);
                this.dirData[i2].setFocusable(true);
                this.dirData[i2].setLineWrap(true);
                this.dirData[i2].setFont(UIManager.getFont("Label.font"));
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = i2 * 2 + 2;
                gbc.gridwidth = 2;
                gbc.gridheight = 2;
                gbc.weightx = 0.9;
                gbc.weighty = 0.2;
                gbc.anchor = 18;
                gbc.fill = 1;
                gbc.insets = new Insets(4, 4, 4, 4);
                panel.add((Component)this.dirData[i2], gbc);
            }
            this.dirShow[0].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.see(0);
                }
            });
            this.dirShow[1].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.see(1);
                }
            });
            this.dirShow[2].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.see(2);
                }
            });
            this.dirShow[3].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.see(3);
                }
            });
            this.dirShow[4].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.see(4);
                }
            });
            this.dirShow[5].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.see(5);
                }
            });
            this.plainFont = this.dirShow[0].getFont();
            this.boldFont = this.plainFont.deriveFont(1);
            return panel;
        }

        private void setRouteDescription(String desc1, String desc2) {
            this.routeDescriptionFrom.setText(desc1);
            this.routeDescriptionTo.setText(desc2);
        }

        private void see(int index) {
            SeaOfGatesEngine.SearchVertex sv = this.seeSV[index];
            if (sv == null) {
                return;
            }
            this.seeSelectedSV(sv);
        }

        private void toggleGridDisplay() {
            String arcName = (String)this.layerToShow.getSelectedItem();
            ArcProto ap = this.tech.findArcProto(arcName);
            if (ap == null) {
                System.out.println("ERROR: Cannot find arc '" + arcName + " in technology " + this.tech.getTechName());
                return;
            }
            String grid = this.sogp.getGrid(ap);
            if (grid == null) {
                return;
            }
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter h2 = wnd.getHighlighter();
            h2.clear();
            if (this.showLayerGrid.isSelected()) {
                ArrayList<Double> coords = new ArrayList<Double>();
                String[] parts = grid.split(",");
                for (int i2 = 0; i2 < parts.length; ++i2) {
                    String part = parts[i2].trim();
                    if (part.length() == 0) continue;
                    if (!Character.isDigit(part.charAt(part.length() - 1))) {
                        part = part.substring(0, part.length() - 1);
                    }
                    double val = TextUtils.atof(part);
                    coords.add(val);
                }
                boolean hor = true;
                if (this.sogp.isHorizontalEven()) {
                    if (ap.getFunction().getLevel() % 2 != 0) {
                        hor = false;
                    }
                } else if (ap.getFunction().getLevel() % 2 == 0) {
                    hor = false;
                }
                SeaOfGatesCell.showGrid(wnd, h2, coords, hor, wnd.getScale(), -1);
            }
            h2.finished();
            wnd.repaint();
        }

        private void showBack() {
            if (this.currentSV == null || this.currentSV.getLast() == null) {
                return;
            }
            this.seeSelectedSV(this.currentSV.getLast());
        }

        private void toggleRoutingMode() {
            if (this.routingMode.isSelected()) {
                User.setRoutingMode(true);
                ToolBar.setCursorMode(ToolBar.CursorMode.ROUTING);
            } else {
                User.setRoutingMode(false);
                if (ToolBar.getCursorMode() == ToolBar.CursorMode.ROUTING) {
                    ToolBar.setCursorMode(ToolBar.CursorMode.CLICKZOOMWIRE);
                }
            }
        }

        private void showNext() {
            if (debugDialog == null || RoutingDebug.debugDialog.svInfo == null) {
                return;
            }
            SeaOfGatesEngine.SearchVertex foundSV = null;
            if (this.currentSV == null) {
                return;
            }
            SVState svs = this.svInfo.get(this.currentSV);
            Object stepNum = svs.message.equals("START") ? "1" : "" + (TextUtils.atoi(svs.message) + 1);
            for (SeaOfGatesEngine.SearchVertex sv : RoutingDebug.debugDialog.svInfo.keySet()) {
                svs = this.svInfo.get(sv);
                if (!svs.message.equals(stepNum)) continue;
                foundSV = sv;
                break;
            }
            if (foundSV != null) {
                this.seeSelectedSV(foundSV);
            } else {
                System.out.println("No Routing Step numbered " + (String)stepNum);
            }
        }

        private void showStepButton() {
            if (debugDialog == null || RoutingDebug.debugDialog.svInfo == null) {
                return;
            }
            String stepNum = this.whichStep.getText().trim();
            SeaOfGatesEngine.SearchVertex foundSV = null;
            for (SeaOfGatesEngine.SearchVertex sv : RoutingDebug.debugDialog.svInfo.keySet()) {
                SVState svs = this.svInfo.get(sv);
                if (!svs.message.equals(stepNum)) continue;
                foundSV = sv;
                break;
            }
            if (foundSV != null) {
                this.seeSelectedSV(foundSV);
            } else {
                System.out.println("No Routing Step numbered " + stepNum);
            }
        }

        private void seeSelectedSV(SeaOfGatesEngine.SearchVertex sv) {
            Object msg;
            SVState oldSVS;
            if (debugDialog == null) {
                return;
            }
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter h2 = wnd.getRulerHighlighter();
            if (this.currentSV != null && (oldSVS = this.svInfo.get(this.currentSV)) != null) {
                oldSVS.setBackgroundColor(null, h2);
            }
            this.currentSV = sv;
            SVState svs = this.svInfo.get(sv);
            svs.setBackgroundColor(Color.WHITE, h2);
            for (int i2 = 0; i2 < 6; ++i2) {
                this.dirData[i2].setText("");
                this.dirShow[i2].setText("See");
                this.dirShow[i2].setEnabled(false);
                this.dirShow[i2].setFont(this.plainFont);
                this.costShow[i2].setText("");
            }
            Highlight.Message hMsg = (Highlight.Message)svs.label;
            if (svs.details == null) {
                String msg2 = "At (" + TextUtils.formatDistance(sv.getX()) + "," + TextUtils.formatDistance(sv.getY()) + "," + sv.describeMetal() + "), Cost=" + sv.getCost();
                msg2 = sv.getGRBucket() < 0 ? msg2 + ", NO Global Routing" : msg2 + ", Global Routing Bucket: " + sv.getGRBucket();
                if (sv.getLast() != null) {
                    SVState svsLast = this.svInfo.get(sv.getLast());
                    hMsgLast = (Highlight.Message)svsLast.label;
                    msg2 = msg2 + ", previous point " + hMsgLast.getInfo() + " at (" + TextUtils.formatDistance(sv.getLast().getX()) + "," + TextUtils.formatDistance(sv.getLast().getY()) + "," + sv.getLast().describeMetal() + ")";
                }
                this.labValue.setText(hMsg.getInfo() + ": " + msg2 + ", DID NOT GET PROPAGATED");
            } else {
                String lab = hMsg.getInfo() + ": " + svs.details[0];
                if (sv.getLast() != null) {
                    SVState svsLast = this.svInfo.get(sv.getLast());
                    hMsgLast = (Highlight.Message)svsLast.label;
                    lab = lab + ", previous point " + hMsgLast.getInfo() + " at (" + TextUtils.formatDistance(sv.getLast().getX()) + "," + TextUtils.formatDistance(sv.getLast().getY()) + "," + sv.getLast().describeMetal() + ")";
                }
                if (onPath.contains(sv)) {
                    lab = lab + ", ON FINAL PATH";
                }
                this.labValue.setText(lab);
                for (int i3 = 0; i3 < 6; ++i3) {
                    if (svs.details[i3 + 1] == null) continue;
                    if (svs.details[i3 + 1].indexOf(124) >= 0) {
                        String leading = "> ";
                        String[] subParts = svs.details[i3 + 1].split("\\|");
                        msg = subParts[0];
                        for (int j2 = 1; j2 < subParts.length; ++j2) {
                            msg = (String)msg + "\n" + leading + subParts[j2];
                        }
                        this.dirData[i3].setText((String)msg);
                    } else {
                        this.dirData[i3].setText(svs.details[i3 + 1]);
                    }
                    this.seeSV[i3] = svs.nextVertices[i3];
                    if (this.seeSV[i3] == null) continue;
                    SVState svsNext = this.svInfo.get(this.seeSV[i3]);
                    if (svsNext == null) {
                        this.dirShow[i3].setText("?");
                    } else {
                        Highlight.Message hMsgNext = (Highlight.Message)svsNext.label;
                        this.dirShow[i3].setText(hMsgNext.getInfo());
                        this.dirShow[i3].setEnabled(true);
                        if (onPath.contains(this.seeSV[i3])) {
                            this.dirShow[i3].setFont(this.boldFont);
                        }
                    }
                    this.costShow[i3].setText("Cost: " + this.seeSV[i3].getCost());
                }
            }
            if (sv.getWavefront().getGRDirection() == 0) {
                this.grInfo.setText("No Global Routing data");
            } else {
                int b2;
                SeaOfGatesEngine.Wavefront wf = sv.getWavefront();
                SeaOfGatesEngine.NeededRoute nr = wf.getNeededRoute();
                Rectangle2D[] buckets = nr.getGRBuckets();
                Rectangle2D[] orderedBuckets = wf.getOrderedBuckets();
                msg = "<html>";
                for (b2 = 0; b2 < orderedBuckets.length; ++b2) {
                    msg = (String)msg + "Bucket " + b2 + " is " + TextUtils.formatDistance(buckets[b2].getMinX()) + "&lt;=X&lt;=" + TextUtils.formatDistance(buckets[b2].getMaxX()) + " and " + TextUtils.formatDistance(buckets[b2].getMinY()) + "&lt;=Y&lt;=" + TextUtils.formatDistance(buckets[b2].getMaxY()) + "<p>";
                }
                for (b2 = 0; b2 < orderedBuckets.length; ++b2) {
                    msg = (String)msg + "Ordered Bucket " + b2 + " is " + TextUtils.formatDistance(orderedBuckets[b2].getMinX()) + "&lt;=X&lt;=" + TextUtils.formatDistance(orderedBuckets[b2].getMaxX()) + " and " + TextUtils.formatDistance(orderedBuckets[b2].getMinY()) + "&lt;=Y&lt;=" + TextUtils.formatDistance(orderedBuckets[b2].getMaxY()) + "<p>";
                }
                msg = (String)msg + "</html>";
                this.grInfo.setText((String)msg);
            }
            wnd.fullRepaint();
            this.pack();
        }

        @Override
        protected void escapePressed() {
            RoutingDebug.endDebugging();
        }

        protected void spacePressed() {
            Component comp = this.getFocusOwner();
            if (!(comp instanceof JTextArea)) {
                return;
            }
            JTextArea ta = (JTextArea)comp;
            int start = ta.getSelectionStart();
            int end = ta.getSelectionEnd();
            String addr = ta.getText().substring(start, end).toLowerCase();
            int commaPos = addr.indexOf(44);
            if (commaPos >= 0) {
                double x = TextUtils.atofDistance(addr.substring(0, commaPos));
                double y = TextUtils.atofDistance(addr.substring(commaPos + 1));
                Point2D.Double p1 = new Point2D.Double(x - 5.0, y - 5.0);
                Point2D.Double p2 = new Point2D.Double(x - 5.0, y + 5.0);
                Point2D.Double p3 = new Point2D.Double(x + 5.0, y + 5.0);
                Point2D.Double p4 = new Point2D.Double(x + 5.0, y - 5.0);
                EditWindow wnd = EditWindow.getCurrent();
                Cell cell = wnd.getCell();
                Highlighter h2 = wnd.getHighlighter();
                h2.clear();
                h2.addLine(p1, p3, cell, true, Color.RED, true);
                h2.addLine(p2, p4, cell, true, Color.RED, true);
                h2.finished();
                wnd.repaint();
                return;
            }
            int andPos = addr.indexOf(" and ");
            int xPos = addr.indexOf("<=x<=");
            int yPos = addr.indexOf("<=y<=");
            if (andPos >= 0 && xPos >= 0 && yPos >= 0) {
                double lX = TextUtils.atofDistance(addr.substring(0, xPos));
                double hX = TextUtils.atofDistance(addr.substring(xPos + 5, andPos));
                double lY = TextUtils.atofDistance(addr.substring(andPos + 5, yPos));
                double hY = TextUtils.atofDistance(addr.substring(yPos + 5));
                Point2D.Double p1 = new Point2D.Double(lX, lY);
                Point2D.Double p2 = new Point2D.Double(lX, hY);
                Point2D.Double p3 = new Point2D.Double(hX, hY);
                Point2D.Double p4 = new Point2D.Double(hX, lY);
                EditWindow wnd = EditWindow.getCurrent();
                Cell cell = wnd.getCell();
                Highlighter h3 = wnd.getHighlighter();
                h3.clear();
                h3.addLine(p1, p2, cell, true, Color.RED, true);
                h3.addLine(p2, p3, cell, true, Color.RED, true);
                h3.addLine(p3, p4, cell, true, Color.RED, true);
                h3.addLine(p4, p1, cell, true, Color.RED, true);
                h3.addLine(p1, p3, cell, true, Color.RED, true);
                h3.addLine(p2, p4, cell, true, Color.RED, true);
                h3.finished();
                wnd.repaint();
                return;
            }
            Job.getUserInterface().showInformationMessage("CANNOT PARSE: " + addr, "SELECTION ERROR");
        }

        private void showGlobalRoutingGrid() {
            EditWindow wnd = EditWindow.getCurrent();
            Cell cell = wnd.getCell();
            Highlighter h2 = wnd.getRulerHighlighter();
            ERectangle bounds = cell.getBounds();
            double bucketWidth = bounds.getWidth() / (double)this.globalRoutingResults.getXBuckets();
            double bucketHeight = bounds.getHeight() / (double)this.globalRoutingResults.getYBuckets();
            for (int x = 0; x <= this.globalRoutingResults.getXBuckets(); ++x) {
                double xPos = bounds.getMinX() + (double)x * bucketWidth;
                h2.addLine(EPoint.fromLambda(xPos, bounds.getMinY()), EPoint.fromLambda(xPos, bounds.getMaxY()), cell, false, Color.RED, false);
            }
            for (int y = 0; y <= this.globalRoutingResults.getYBuckets(); ++y) {
                double yPos = bounds.getMinY() + (double)y * bucketHeight;
                h2.addLine(EPoint.fromLambda(bounds.getMinX(), yPos), EPoint.fromLambda(bounds.getMaxX(), yPos), cell, false, Color.RED, false);
            }
        }

        private void showGlobalRoutingPath(SeaOfGatesEngine.NeededRoute nr) {
            EditWindow wnd = EditWindow.getCurrent();
            Cell cell = wnd.getCell();
            Highlighter h2 = wnd.getRulerHighlighter();
            HashSet<Integer> xUsed = new HashSet<Integer>();
            HashSet<Integer> yUsed = new HashSet<Integer>();
            for (SeaOfGatesEngine.GRNet net : RoutingDebug.debugDialog.globalRoutingResults.getNets()) {
                for (SeaOfGatesEngine.GRWire w : net.getWires()) {
                    if (nr != null && w.getNeededRoute() != nr) continue;
                    EPoint p1 = w.getPoint1();
                    EPoint p2 = w.getPoint2();
                    SeaOfGatesEngine.GRBucket n1 = w.getBucket1();
                    SeaOfGatesEngine.GRBucket n2 = w.getBucket2();
                    SeaOfGatesEngine.GRBucket prev = null;
                    double prevX = 0.0;
                    double prevY = 0.0;
                    for (int i2 = 0; i2 < w.getNumPathElements(); ++i2) {
                        SeaOfGatesEngine.GRBucket n3 = w.getPathBucket(i2);
                        Rectangle2D bucketBound = n3.getBounds();
                        double x = bucketBound.getCenterX();
                        double y = bucketBound.getCenterY();
                        boolean adjusted = false;
                        if (n3 == n1) {
                            x = p1.getX();
                            y = p1.getY();
                            adjusted = true;
                        }
                        if (n3 == n2) {
                            x = p2.getX();
                            y = p2.getY();
                            adjusted = true;
                        }
                        if (!adjusted) {
                            Integer yi;
                            Integer xi;
                            if (i2 > 0) {
                                if (w.getPathBucket(i2 - 1).getBounds().getCenterX() == x) {
                                    if (w.getPathBucket(i2 - 1) == n1) {
                                        x = p1.getX();
                                    }
                                    if (w.getPathBucket(i2 - 1) == n2) {
                                        x = p2.getX();
                                    }
                                }
                                if (w.getPathBucket(i2 - 1).getBounds().getCenterY() == y) {
                                    if (w.getPathBucket(i2 - 1) == n1) {
                                        y = p1.getY();
                                    }
                                    if (w.getPathBucket(i2 - 1) == n2) {
                                        y = p2.getY();
                                    }
                                }
                            }
                            if (i2 < w.getNumPathElements() - 1) {
                                if (w.getPathBucket(i2 + 1).getBounds().getCenterX() == x) {
                                    if (w.getPathBucket(i2 + 1) == n1) {
                                        x = p1.getX();
                                    }
                                    if (w.getPathBucket(i2 + 1) == n2) {
                                        x = p2.getX();
                                    }
                                }
                                if (w.getPathBucket(i2 + 1).getBounds().getCenterY() == y) {
                                    if (w.getPathBucket(i2 + 1) == n1) {
                                        y = p1.getY();
                                    }
                                    if (w.getPathBucket(i2 + 1) == n2) {
                                        y = p2.getY();
                                    }
                                }
                            }
                            while (xUsed.contains(xi = Integer.valueOf((int)x))) {
                                x += 1.0;
                            }
                            xUsed.add(xi);
                            while (yUsed.contains(yi = Integer.valueOf((int)y))) {
                                y += 1.0;
                            }
                            yUsed.add(yi);
                        }
                        if (prev != null) {
                            h2.addLine(EPoint.fromLambda(prevX, prevY), EPoint.fromLambda(x, y), cell, false, Color.GREEN, false);
                        }
                        if (i2 == 0 || i2 == w.getNumPathElements() - 1) {
                            int xSize = 2;
                            h2.addLine(EPoint.fromLambda(x - (double)xSize, y - (double)xSize), EPoint.fromLambda(x + (double)xSize, y + (double)xSize), cell, false, Color.GREEN, false);
                            h2.addLine(EPoint.fromLambda(x - (double)xSize, y + (double)xSize), EPoint.fromLambda(x + (double)xSize, y - (double)xSize), cell, false, Color.GREEN, false);
                        }
                        prev = n3;
                        prevX = x;
                        prevY = y;
                    }
                }
            }
            h2.finished();
            wnd.repaint();
        }

        private void showPathToGoal(SeaOfGatesEngine.NeededRoute nr, SeaOfGatesEngine.SearchVertex result, Cell cell, Highlighter h2) {
            EPoint goalCoord = null;
            if (result == SeaOfGatesEngine.svAborted) {
                this.routeResult.setText("Result: Aborted by user");
            } else if (result == SeaOfGatesEngine.svExhausted) {
                this.routeResult.setText("Result: Examined all possibilities");
            } else if (result == SeaOfGatesEngine.svLimited) {
                this.routeResult.setText("Result: Stopped after " + this.router.getPrefs().complexityLimit + " steps");
            } else {
                SeaOfGatesEngine.SearchVertex svLast;
                this.routeResult.setText("Result: Success!");
                SVState svs = RoutingDebug.ensureDebuggingShadow(result, false);
                svs.changeLabel("!!GOAL!!", h2);
                goalCoord = EPoint.fromLambda(result.getX(), result.getY());
                while ((svLast = result.getLast()) != null) {
                    if (result.getZ() != svLast.getZ()) {
                        int lowZ = Math.min(result.getZ(), svLast.getZ());
                        int highZ = Math.max(result.getZ(), svLast.getZ());
                        double lowOff = (double)lowZ * 0.04;
                        double highOff = (double)highZ * 0.04;
                        h2.addLine(EPoint.fromLambda(result.getX() + lowOff, result.getY() + lowOff + 0.005), EPoint.fromLambda(result.getX() + highOff - 0.005, result.getY() + highOff), cell, true, Color.WHITE, false);
                        h2.addLine(EPoint.fromLambda(result.getX() + lowOff + 0.005, result.getY() + lowOff), EPoint.fromLambda(result.getX() + highOff, result.getY() + highOff - 0.005), cell, true, Color.WHITE, false);
                    } else {
                        double off = (double)result.getZ() * 0.04;
                        if (result.getX() != svLast.getX()) {
                            h2.addLine(EPoint.fromLambda(result.getX() + off, result.getY() + off - 0.005), EPoint.fromLambda(svLast.getX() + off, svLast.getY() + off - 0.005), cell, true, Color.WHITE, false);
                            h2.addLine(EPoint.fromLambda(result.getX() + off, result.getY() + off + 0.005), EPoint.fromLambda(svLast.getX() + off, svLast.getY() + off + 0.005), cell, true, Color.WHITE, false);
                        } else {
                            h2.addLine(EPoint.fromLambda(result.getX() + off - 0.005, result.getY() + off), EPoint.fromLambda(svLast.getX() + off - 0.005, svLast.getY() + off), cell, true, Color.WHITE, false);
                            h2.addLine(EPoint.fromLambda(result.getX() + off + 0.005, result.getY() + off), EPoint.fromLambda(svLast.getX() + off + 0.005, svLast.getY() + off), cell, true, Color.WHITE, false);
                        }
                    }
                    result = svLast;
                }
            }
            SeaOfGatesEngine.PossibleEndpoints endChoices = endADebug ? nr.getBPossibleEndpoints() : nr.getAPossibleEndpoints();
            for (SeaOfGatesEngine.PossibleEndpoint pe : endChoices.getEndpoints()) {
                EPoint pt = pe.getCoord();
                if (goalCoord != null && pt.getX() == goalCoord.getX() && pt.getY() == goalCoord.getY()) continue;
                EPoint ptOff = EPoint.fromLambda(pt.getX() + 3.0, pt.getY() + 3.0);
                h2.addLine(EPoint.fromLambda(ptOff.getX(), ptOff.getY()), EPoint.fromLambda(pt.getX(), pt.getY()), cell, true, Color.BLACK, false);
                h2.addMessage(cell, "G", ptOff);
            }
        }

        private void showSearchVertices(Cell cell, Highlighter h2, SeaOfGatesEngine.Wavefront wf) {
            double toTaperLength;
            double fromTaperLength;
            double toTaperWidth;
            double fromTaperWidth;
            PortInst piF = wf.getFromPortInst();
            PortInst piT = wf.getToPortInst();
            SeaOfGatesEngine.NeededRoute nr = wf.getNeededRoute();
            boolean aToB = wf.isAtoB();
            if (aToB) {
                fromTaperWidth = nr.getATaperWidth();
                toTaperWidth = nr.getBTaperWidth();
                fromTaperLength = nr.getATaperLength();
                toTaperLength = nr.getBTaperLength();
            } else {
                fromTaperWidth = nr.getBTaperWidth();
                toTaperWidth = nr.getATaperWidth();
                fromTaperLength = nr.getBTaperLength();
                toTaperLength = nr.getATaperLength();
            }
            String fromMsg = "FROM: (" + TextUtils.formatDistance(wf.getFromX()) + "," + TextUtils.formatDistance(wf.getFromY()) + ", " + SeaOfGatesEngine.describeMetal(wf.getFromZ(), wf.getFromMask()) + "): port " + piF.getPortProto().getName() + " of node " + piF.getNodeInst().describe(false);
            if (fromTaperLength > 0.0) {
                fromMsg = fromMsg + ", Taper width is " + TextUtils.formatDistance(fromTaperWidth);
            }
            String toMsg = "TO: (" + TextUtils.formatDistance(wf.getTo().getCenterX()) + "," + TextUtils.formatDistance(wf.getTo().getCenterY()) + ", " + SeaOfGatesEngine.describeMetal(wf.getToZ(), wf.getToMask()) + "): port " + piT.getPortProto().getName() + " of node " + piT.getNodeInst().describe(false);
            if (toTaperLength > 0.0) {
                toMsg = toMsg + ", Taper width is " + TextUtils.formatDistance(toTaperWidth);
            }
            this.setRouteDescription(fromMsg, toMsg);
            HashMap<CallSite, Integer> lowestZ = new HashMap<CallSite, Integer>();
            Map<Integer, Map<Integer, SeaOfGatesEngine.SearchVertex>>[] searchVertexPlanes = wf.getSearchVertexPlanes();
            for (int z = 0; z < this.router.getNumMetals(); ++z) {
                Map<Integer, Map<Integer, SeaOfGatesEngine.SearchVertex>> plane = searchVertexPlanes[z];
                if (plane == null) continue;
                for (Integer y : plane.keySet()) {
                    Map<Integer, SeaOfGatesEngine.SearchVertex> row = plane.get(y);
                    for (Integer x : row.keySet()) {
                        SeaOfGatesEngine.SearchVertex sv = row.get(x);
                        SVState svs = RoutingDebug.ensureDebuggingShadow(sv, false);
                        svs.showLabel(h2);
                        if (sv.getLast() == null) continue;
                        if (sv.getZ() != sv.getLast().getZ()) {
                            int lowZ = Math.min(sv.getZ(), sv.getLast().getZ());
                            int highZ = Math.max(sv.getZ(), sv.getLast().getZ());
                            double lowOff = (double)lowZ * 0.04;
                            double highOff = (double)highZ * 0.04;
                            h2.addLine(EPoint.fromLambda(sv.getX() + lowOff, sv.getY() + lowOff), EPoint.fromLambda(sv.getX() + highOff, sv.getY() + highOff), cell, true, Color.WHITE, false);
                        } else {
                            double off = (double)sv.getZ() * 0.04;
                            Color col = this.router.getPrimaryMetalLayer(sv.getZ()).getGraphics().getColor();
                            h2.addLine(EPoint.fromLambda(sv.getX() + off, sv.getY() + off), EPoint.fromLambda(sv.getLast().getX() + off, sv.getLast().getY() + off), cell, false, col, false);
                        }
                        String coordLoc = TextUtils.formatDistance(sv.getX()) + "/" + TextUtils.formatDistance(sv.getY());
                        Integer height = (Integer)lowestZ.get(coordLoc);
                        int lowZ = Math.min(sv.getZ(), sv.getLast().getZ());
                        if (height == null) {
                            height = lowZ;
                        } else {
                            int lowest = Math.min(height, lowZ);
                            height = lowest;
                        }
                        lowestZ.put((CallSite)((Object)coordLoc), height);
                    }
                }
            }
            for (String loc : lowestZ.keySet()) {
                Integer height = (Integer)lowestZ.get(loc);
                if (height <= 0) continue;
                String[] locCoords = loc.split("/");
                double x = TextUtils.atof(locCoords[0]);
                double y = TextUtils.atof(locCoords[1]);
                double off = (double)height.intValue() * 0.04;
                h2.addLine(EPoint.fromLambda(x, y), EPoint.fromLambda(x + off, y + off), cell, false, Color.BLACK, false);
            }
        }
    }

    private static enum DebugType {
        NONE,
        DISPLAYROUTING,
        REWIRENETS,
        SHOWSPINES,
        RUNGLOBALROUTING;

    }

    private static class DebugThread
    extends Job {
        private DebugThread(SeaOfGatesEngine.NeededRoute nr) {
            super("Debug Sea-Of-Gates Route", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            SeaOfGatesEngine.Wavefront wf = endADebug ? nr.getWavefrontAtoB() : nr.getWavefrontBtoA();
            SeaOfGatesEngine.SearchVertex result = wf.getFinalSearchVertex();
            highlighter.clear();
            RoutingDebug.showGeometryInArea(nr);
            Point2D.Double p1 = new Point2D.Double(nr.getAX(), nr.getAY());
            Point2D.Double p2 = new Point2D.Double(nr.getBX(), nr.getBY());
            highlighter.addLine(p1, p2, cell, true, Color.GREEN, false);
            debugDialog.showPathToGoal(nr, result, cell, highlighter);
            onPath.clear();
            for (SeaOfGatesEngine.SearchVertex sv = result; sv != null; sv = sv.getLast()) {
                onPath.add(sv);
            }
            debugDialog.showSearchVertices(cell, highlighter, wf);
            if (RoutingDebug.debugDialog.globalRoutingResults != null) {
                debugDialog.showGlobalRoutingGrid();
                debugDialog.showGlobalRoutingPath(nr);
            }
            highlighter.finished();
            EditWindow.repaintAllContents();
        }

        @Override
        public boolean doIt() throws JobException {
            return true;
        }

        @Override
        public void terminateOK() {
            SeaOfGatesEngine.SearchVertex svStart = null;
            for (SeaOfGatesEngine.SearchVertex sv : RoutingDebug.debugDialog.svInfo.keySet()) {
                if (sv.getLast() != null) continue;
                svStart = sv;
                break;
            }
            if (svStart == null) {
                System.out.println("WARNING: Cannot find starting search-vertex");
                return;
            }
            RoutingDebug.showSelectedSV(svStart);
        }
    }

    private static class SVState {
        EPoint anchor;
        String message;
        Highlight label;
        String[] details;
        SeaOfGatesEngine.SearchVertex[] nextVertices = new SeaOfGatesEngine.SearchVertex[6];

        SVState(SeaOfGatesEngine.SearchVertex sv, String msg) {
            double off = (double)sv.getZ() * 0.04;
            this.anchor = EPoint.fromLambda(sv.getX() + off, sv.getY() + off);
            if (msg == null) {
                msg = sv.describeMetal();
            }
            this.message = msg;
            this.label = highlighter.addMessage(cell, this.message, this.anchor);
        }

        void showLabel(Highlighter h2) {
            if (this.label != null) {
                h2.remove(this.label);
            }
            this.label = h2.addMessage(cell, this.message, this.anchor);
        }

        void changeLabel(String msg, Highlighter h2) {
            this.message = msg;
            this.showLabel(h2);
        }

        void setBackgroundColor(Color backgroundColor, Highlighter h2) {
            if (this.label != null) {
                h2.remove(this.label);
            }
            this.label = h2.addMessage(cell, this.message, this.anchor, 0, backgroundColor);
        }
    }

    public static class ShowSpineNets
    extends Job {
        private Cell cell;
        private EditingPreferences ep;
        private String routeName;
        private static final int TAPSIZE = 8;
        private static final int TAPOFFSET = 25;

        public ShowSpineNets(Cell c2, String rn) {
            super("Show Spines", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = c2;
            this.routeName = rn;
            this.ep = UserInterfaceMain.getEditingPreferences();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            debuggingType = DebugType.SHOWSPINES;
            RoutingDebug.debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
            prefs.getOptionsFromPreferences(false);
            RoutingDebug.debugDialog.router.setPrefs(prefs);
            RoutingDebug.debugDialog.svInfo = new HashMap<SeaOfGatesEngine.SearchVertex, SVState>();
            netNames = new HashMap<Integer, String>();
            svOrder = 1;
            Job job = Job.getRunningJob();
            RoutingDebug.debugDialog.router.routeIt(SeaOfGatesHandlers.getDefault(this.cell, RoutingDebug.debugDialog.router.getPrefs().resultCellName, RoutingDebug.debugDialog.router.getPrefs().contactPlacementAction, job, this.ep), this.cell, false, null);
            return true;
        }

        @Override
        public void terminateOK() {
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter h2 = wnd.getRulerHighlighter();
            h2.clear();
            for (SeaOfGatesEngine.RoutesOnNetwork ron : allSpineRoutes) {
                if (!ron.getName().equals(this.routeName)) continue;
                List<SteinerTree.SteinerTreePortPair> pairs = ron.getPairs();
                for (SteinerTree.SteinerTreePortPair pair : pairs) {
                    List<PortInst> taps = pair.getSpineTaps();
                    double fX = pair.getPort1().getCenter().getX();
                    double fY = pair.getPort1().getCenter().getY();
                    double tX = pair.getPort2().getCenter().getX();
                    double tY = pair.getPort2().getCenter().getY();
                    boolean hor = Math.abs(fX - tX) > Math.abs(fY - tY);
                    double offX = 0.0;
                    double offY = 0.0;
                    if (hor) {
                        offY = 25.0;
                        fY = tY = Math.max(fY, tY);
                    } else {
                        offX = -25.0;
                        fX = tX = Math.min(fX, tX);
                    }
                    Color col = taps == null ? Color.GREEN : Color.RED;
                    h2.addLine(EPoint.fromLambda(fX + offX, fY + offY), EPoint.fromLambda(tX + offX, tY + offY), this.cell, true, col, false);
                    Poly poly = new Poly(new Rectangle2D.Double(pair.getPort1().getCenter().getX() - 8.0, pair.getPort1().getCenter().getY() - 8.0, 16.0, 16.0));
                    poly.setStyle(Poly.Type.FILLED);
                    h2.addPoly(poly, this.cell, Color.RED);
                    h2.addLine(EPoint.fromLambda(fX + offX, fY + offY), pair.getPort1().getCenter(), this.cell, true, col, false);
                    poly = new Poly(new Rectangle2D.Double(pair.getPort2().getCenter().getX() - 8.0, pair.getPort2().getCenter().getY() - 8.0, 16.0, 16.0));
                    poly.setStyle(Poly.Type.FILLED);
                    h2.addPoly(poly, this.cell, Color.RED);
                    h2.addLine(EPoint.fromLambda(tX + offX, tY + offY), pair.getPort2().getCenter(), this.cell, true, col, false);
                    if (taps == null) continue;
                    for (PortInst pi : taps) {
                        EPoint pt = pi.getCenter();
                        poly = new Poly(new Rectangle2D.Double(pt.getX() - 8.0, pt.getY() - 8.0, 16.0, 16.0));
                        poly.setStyle(Poly.Type.FILLED);
                        h2.addPoly(poly, this.cell, Color.RED);
                        if (hor) {
                            h2.addLine(EPoint.fromLambda(pt.getX(), pt.getY()), EPoint.fromLambda(pt.getX(), tY + offY), this.cell, true, col, false);
                            continue;
                        }
                        h2.addLine(EPoint.fromLambda(pt.getX(), pt.getY()), EPoint.fromLambda(tX + offX, pt.getY()), this.cell, true, col, false);
                    }
                }
            }
            h2.finished();
            wnd.repaint();
        }
    }

    public static class RewireNets
    extends Job {
        private Cell cell;
        private EditingPreferences ep;

        public RewireNets(Cell c2) {
            super("Rewire Networks", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = c2;
            this.ep = UserInterfaceMain.getEditingPreferences();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
            Iterator<ArcInst> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                selected.add(ai);
            }
            if (selected.isEmpty()) {
                return true;
            }
            debuggingType = DebugType.REWIRENETS;
            endADebug = true;
            RoutingDebug.debugDialog.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
            prefs.getOptionsFromPreferences(false);
            RoutingDebug.debugDialog.router.setPrefs(prefs);
            RoutingDebug.debugDialog.svInfo = new HashMap<SeaOfGatesEngine.SearchVertex, SVState>();
            netNames = new HashMap<Integer, String>();
            svOrder = 1;
            Job job = Job.getRunningJob();
            RoutingDebug.debugDialog.router.routeIt(SeaOfGatesHandlers.getDefault(this.cell, RoutingDebug.debugDialog.router.getPrefs().resultCellName, RoutingDebug.debugDialog.router.getPrefs().contactPlacementAction, job, this.ep), this.cell, false, selected);
            return true;
        }
    }
}

