/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.TextUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MessagesWindow
implements MouseListener,
ClipboardOwner {
    private JTextArea info;
    private Container contentFrame;
    private Container jf;
    private static boolean initialized = false;
    private static Font currentFont = null;
    private static final HashSet<MessagesWindow> messagesWindows = new HashSet();
    private static final StringBuffer text = new StringBuffer();

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (!User.isDockMessagesWindow()) {
            new MessagesWindow();
        }
        MessagesWindow.appendString(ActivityLogger.getLoggingInformation());
    }

    public static Iterable<MessagesWindow> getMessagesWindows() {
        return messagesWindows;
    }

    public Container getContent() {
        return this.contentFrame;
    }

    public MessagesWindow() {
        Dimension scrnSize = TopLevel.getScreenSize();
        Dimension msgSize = new Dimension(scrnSize.width / 3 * 2, scrnSize.height / 100 * 15);
        Point msgPos = new Point(150, scrnSize.height / 100 * 85);
        if (TopLevel.isMDIMode()) {
            JInternalFrame jInternalFrame = new JInternalFrame("Electric Messages", true, false, true, true);
            this.jf = jInternalFrame;
            this.contentFrame = jInternalFrame.getContentPane();
            jInternalFrame.setFrameIcon(TopLevel.getFrameIcon());
            this.jf.setLocation(msgPos);
        } else if (!User.isDockMessagesWindow()) {
            JFrame jFrame = new JFrame("Electric Messages");
            this.jf = jFrame;
            jFrame.setDefaultCloseOperation(0);
            if (ClientOS.isOSMac()) {
                jFrame.setJMenuBar(MenuCommands.menuBar().genInstance());
            }
            this.contentFrame = jFrame.getContentPane();
            jFrame.setIconImage(TopLevel.getFrameIcon().getImage());
            Point pt = User.getDefaultMessagesPos();
            if (pt == null) {
                pt = msgPos;
            }
            this.jf.setLocation(pt);
            Dimension override = User.getDefaultMessagesSize();
            if (override != null) {
                this.jf.setPreferredSize(override);
            }
        } else {
            this.contentFrame = new JPanel();
        }
        this.contentFrame.setLayout(new BorderLayout());
        this.info = new JTextArea(20, 110);
        this.info.setLineWrap(false);
        this.info.setFont(new Font("Monospaced", 0, 12));
        this.info.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.info, 22, 30);
        scrollPane.setPreferredSize(msgSize);
        this.contentFrame.add((Component)scrollPane, "Center");
        if (TopLevel.isMDIMode()) {
            ((JInternalFrame)this.jf).pack();
            TopLevel.addToDesktop((JInternalFrame)this.jf);
        } else if (!User.isDockMessagesWindow()) {
            ((JFrame)this.jf).pack();
            ((JFrame)this.jf).setVisible(true);
        }
        if (currentFont == null) {
            currentFont = this.info.getFont();
        }
        if (User.isDockMessagesWindow()) {
            this.appendStr(text.toString());
        }
        messagesWindows.add(this);
    }

    public boolean isFocusOwner() {
        if (this.jf == null) {
            return false;
        }
        if (TopLevel.isMDIMode()) {
            return ((JInternalFrame)this.jf).isSelected();
        }
        return this.jf.isFocusOwner();
    }

    public static MessagesWindow getFocusOwner() {
        for (MessagesWindow mw : messagesWindows) {
            if (!mw.isFocusOwner()) continue;
            return mw;
        }
        return null;
    }

    public void requestFocus() {
        if (!Job.isClientThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessagesWindow.this.requestFocusUnsafe();
                }
            });
            return;
        }
        this.requestFocusUnsafe();
    }

    private void requestFocusUnsafe() {
        if (this.jf == null) {
            return;
        }
        if (TopLevel.isMDIMode()) {
            ((JInternalFrame)this.jf).toFront();
            try {
                ((JInternalFrame)this.jf).setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            ((JFrame)this.jf).toFront();
            this.jf.requestFocus();
        }
    }

    public Rectangle getMessagesLocation() {
        if (this.jf == null) {
            return this.contentFrame.getBounds();
        }
        return this.jf.getBounds();
    }

    public static int getMinMessagesCharWidth() {
        int min = Integer.MAX_VALUE;
        for (MessagesWindow mw : messagesWindows) {
            min = Math.min(mw.info.getColumns(), min);
        }
        return min;
    }

    public static void tileWithEdit() {
        if (User.isDockMessagesWindow()) {
            return;
        }
        for (MessagesWindow mw : messagesWindows) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf == null) {
                return;
            }
            Rectangle eb = TopLevel.isMDIMode() ? wf.getInternalFrame().getBounds() : wf.getFrame().getBounds();
            Rectangle mb = mw.getMessagesLocation();
            mb.x = eb.x;
            mb.width = eb.width;
            mb.y = eb.y + eb.height;
            if (mw.jf == null) continue;
            mw.jf.setBounds(mb);
        }
    }

    public static void appendString(String str) {
        if (messagesWindows.size() == 0 && !User.isDockMessagesWindow()) {
            System.err.println(str);
            return;
        }
        if (User.isDockMessagesWindow()) {
            text.append(str);
        }
        for (MessagesWindow mw : messagesWindows) {
            mw.appendStr(str);
        }
    }

    private void appendStr(String str) {
        this.info.append(str);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessagesWindow.this.info.setCaretPosition(MessagesWindow.this.info.getDocument().getLength());
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.doContext(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.doContext(e2);
        }
    }

    @Override
    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    private void doContext(MouseEvent e2) {
        JPopupMenu menu = new JPopupMenu("Messages Window");
        JMenuItem menuItem = new JMenuItem("Cut");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MessagesWindow.this.copyText(false, true);
            }
        });
        menuItem = new JMenuItem("Copy");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MessagesWindow.this.copyText(false, false);
            }
        });
        menuItem = new JMenuItem("Paste");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MessagesWindow.this.pasteText();
            }
        });
        menu.addSeparator();
        menuItem = new JMenuItem("Cut All");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MessagesWindow.this.copyText(true, true);
            }
        });
        menuItem = new JMenuItem("Copy All");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MessagesWindow.this.copyText(true, false);
            }
        });
        if (Job.getDebug()) {
            menuItem = new JMenuItem("Save All");
            menu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    MessagesWindow.this.saveAll();
                }
            });
        }
        menuItem = new JMenuItem("Clear");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MessagesWindow.this.clear(true);
            }
        });
        menu.show((Component)e2.getSource(), e2.getX(), e2.getY());
    }

    public void pasteText() {
        this.info.paste();
    }

    public void copyText(boolean all, boolean cut) {
        if (all) {
            if (cut) {
                this.info.selectAll();
                this.info.cut();
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(this.info.getText()), this);
            }
        } else if (cut) {
            this.info.cut();
        } else {
            this.info.copy();
        }
    }

    public void saveAll() {
        String fileName = OpenFile.chooseOutputFile(FileType.TEXT, null, "Message");
        if (fileName == null) {
            return;
        }
        URL libURL = TextUtils.makeURLToFile(fileName);
        File f2 = new File(libURL.getPath());
        try {
            System.out.println("Saving console messages in '" + fileName + " '");
            PrintWriter wr = new PrintWriter(f2);
            wr.print(this.info.getText());
            wr.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void clear(boolean all) {
        if (all) {
            this.info.setText("");
        } else {
            this.info.replaceSelection("");
        }
    }

    public static void clearAll() {
        text.setLength(0);
        for (MessagesWindow mw : messagesWindows) {
            mw.clear(true);
        }
    }

    public void selectAll() {
        this.info.selectAll();
    }

    public static void selectFont() {
        if (TopLevel.isMDIMode()) {
            TopLevel jf = TopLevel.getCurrentJFrame();
            new FontSelectDialog(jf);
        } else {
            new FontSelectDialog(null);
        }
    }

    private static class FontSelectDialog
    extends EDialog {
        private Font initialFont;
        private String initialFontName;
        private int initialFontSize;
        private JLabel sampleText;
        private JList fontNameList;
        private JList fontSizeList;

        public FontSelectDialog(Frame parent) {
            super(parent, true);
            this.setTitle("Set Messages Window Font");
            this.getContentPane().setLayout(new GridBagLayout());
            this.initialFont = currentFont;
            this.initialFontName = this.initialFont.getName();
            this.initialFontSize = this.initialFont.getSize();
            JLabel fontLabel = new JLabel("Font:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontLabel, gbc);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontNames = ge.getAvailableFontFamilyNames();
            JScrollPane fontNamePane = new JScrollPane();
            DefaultListModel<String> fontNameListModel = new DefaultListModel<String>();
            this.fontNameList = new JList(fontNameListModel);
            this.fontNameList.setSelectionMode(0);
            fontNamePane.setViewportView(this.fontNameList);
            int initialIndex = 0;
            for (int i2 = 0; i2 < fontNames.length; ++i2) {
                if (fontNames[i2].equals(this.initialFontName)) {
                    initialIndex = i2;
                }
                fontNameListModel.addElement(fontNames[i2]);
            }
            this.fontNameList.setSelectedIndex(initialIndex);
            this.fontNameList.ensureIndexIsVisible(initialIndex);
            this.fontNameList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    this.updateSampleText();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontNamePane, gbc);
            JLabel sizeLabel = new JLabel("Size:");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)sizeLabel, gbc);
            JScrollPane fontSizePane = new JScrollPane();
            DefaultListModel<String> fontSizeListModel = new DefaultListModel<String>();
            this.fontSizeList = new JList(fontSizeListModel);
            this.fontSizeList.setSelectionMode(0);
            fontSizePane.setViewportView(this.fontSizeList);
            fontSizeListModel.addElement("8");
            fontSizeListModel.addElement("9");
            fontSizeListModel.addElement("10");
            fontSizeListModel.addElement("11");
            fontSizeListModel.addElement("12");
            fontSizeListModel.addElement("14");
            fontSizeListModel.addElement("16");
            fontSizeListModel.addElement("18");
            fontSizeListModel.addElement("20");
            fontSizeListModel.addElement("22");
            fontSizeListModel.addElement("24");
            fontSizeListModel.addElement("28");
            fontSizeListModel.addElement("32");
            fontSizeListModel.addElement("36");
            fontSizeListModel.addElement("40");
            fontSizeListModel.addElement("48");
            fontSizeListModel.addElement("72");
            this.fontSizeList.setSelectedValue(Integer.toString(this.initialFontSize), true);
            this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    this.updateSampleText();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontSizePane, gbc);
            this.sampleText = new JLabel("The Electric VLSI Design System");
            this.sampleText.setBorder(BorderFactory.createTitledBorder("Sample text"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.sampleText, gbc);
            this.sampleText.setFont(this.initialFont);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.OK();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)okButton, gbc);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.cancel();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancelButton, gbc);
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    this.cancel();
                }
            });
            this.setVisible(true);
        }

        private void cancel() {
            this.dispose();
        }

        private void updateSampleText() {
            String currentFontName = this.initialFontName;
            if (this.fontNameList.getSelectedIndex() != -1) {
                currentFontName = (String)this.fontNameList.getSelectedValue();
            }
            int currentFontSize = this.initialFontSize;
            if (this.fontSizeList.getSelectedIndex() != -1) {
                currentFontSize = TextUtils.atoi((String)this.fontSizeList.getSelectedValue());
            }
            Font font = new Font(currentFontName, 0, currentFontSize);
            this.sampleText.setFont(font);
        }

        private void OK() {
            String currentFontName = this.initialFontName;
            if (this.fontNameList.getSelectedIndex() != -1) {
                currentFontName = (String)this.fontNameList.getSelectedValue();
            }
            int currentFontSize = this.initialFontSize;
            if (this.fontSizeList.getSelectedIndex() != -1) {
                currentFontSize = TextUtils.atoi((String)this.fontSizeList.getSelectedValue());
            }
            if (!currentFontName.equals(this.initialFontName) || currentFontSize != this.initialFontSize) {
                this.initialFont = new Font(currentFontName, 0, currentFontSize);
                this.initialFontSize = currentFontSize;
                currentFont = this.initialFont;
                for (MessagesWindow mw : messagesWindows) {
                    mw.info.setFont(this.initialFont);
                }
                System.out.println("Messages window font is now " + currentFontName + ", size " + currentFontSize);
            }
            this.cancel();
        }
    }
}

