/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class MeasureListener
implements WindowFrame.ElectricEventListener {
    public static MeasureListener theOne = new MeasureListener();
    private static double lastMeasuredDistanceX = 0.0;
    private static double lastMeasuredDistanceY = 0.0;
    private static double lastValidMeasuredDistanceX = 0.0;
    private static double lastValidMeasuredDistanceY = 0.0;
    private static boolean measuring = false;
    private static List<Highlight> lastHighlights = new ArrayList<Highlight>();
    private Point2D dbStart;
    private long gridOffX = 0L;
    private long gridOffY = 0L;
    private Robot robot = null;

    private MeasureListener() {
    }

    public static double getLastMeasuredDistanceX() {
        return lastValidMeasuredDistanceX;
    }

    public static double getLastMeasuredDistanceY() {
        return lastValidMeasuredDistanceY;
    }

    private void startMeasure(Point2D dbStart) {
        lastValidMeasuredDistanceX = lastMeasuredDistanceX;
        lastValidMeasuredDistanceY = lastMeasuredDistanceY;
        this.dbStart = dbStart;
        measuring = true;
        lastHighlights.clear();
    }

    private void dragOutMeasure(EditWindow wnd, Point2D dbPoint) {
        if (measuring && this.dbStart != null) {
            Point2D start = this.dbStart;
            Point2D end = dbPoint;
            Highlighter highlighter = wnd.getRulerHighlighter();
            for (Highlight h2 : lastHighlights) {
                highlighter.remove(h2);
            }
            lastHighlights.clear();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            Technology tech = cell.getTechnology();
            if (User.isCadenceMeasurementStyle()) {
                ScreenPoint stScreen = wnd.databaseToScreen(start);
                ScreenPoint enScreen = wnd.databaseToScreen(end);
                double dbDist = start.distance(end);
                double screenDist = Math.sqrt((stScreen.getX() - enScreen.getX()) * (stScreen.getX() - enScreen.getX()) + (stScreen.getY() - enScreen.getY()) * (stScreen.getY() - enScreen.getY()));
                if (dbDist > 0.0 && screenDist > 0.0) {
                    double dbLargeTickSize = 8.0 / screenDist * dbDist;
                    double dbSmallTickSize = 3.0 / screenDist * dbDist;
                    int lineAngle = DBMath.figureAngle(start, end);
                    int tickAngle = (lineAngle + 900) % 3600;
                    lastHighlights.add(highlighter.addLine(start, end, cell));
                    double tickX = start.getX() + DBMath.cos(tickAngle) * dbLargeTickSize;
                    double tickY = start.getY() + DBMath.sin(tickAngle) * dbLargeTickSize;
                    Point2D.Double tickLocation = new Point2D.Double(tickX, tickY);
                    lastHighlights.add(highlighter.addLine(start, tickLocation, cell));
                    lastHighlights.add(highlighter.addMessage(cell, "0", tickLocation));
                    tickX = end.getX() + DBMath.cos(tickAngle) * dbLargeTickSize;
                    tickY = end.getY() + DBMath.sin(tickAngle) * dbLargeTickSize;
                    tickLocation = new Point2D.Double(tickX, tickY);
                    lastHighlights.add(highlighter.addLine(end, tickLocation, cell));
                    lastHighlights.add(highlighter.addMessage(cell, TextUtils.formatDistance(dbDist, tech), tickLocation));
                    double minorTickDist = Math.min(wnd.getGridXSpacing(), wnd.getGridYSpacing());
                    int numMinorTicks = (int)(dbDist / minorTickDist);
                    while ((double)numMinorTicks >= screenDist / 10.0) {
                        numMinorTicks = (int)(dbDist / (minorTickDist *= 2.0));
                    }
                    for (int i2 = 1; i2 <= numMinorTicks; ++i2) {
                        double distSoFar = minorTickDist * (double)i2;
                        double minorTickX = start.getX() + distSoFar * DBMath.cos(lineAngle);
                        double minorTickY = start.getY() + distSoFar * DBMath.sin(lineAngle);
                        tickX = minorTickX + DBMath.cos(tickAngle) * dbSmallTickSize;
                        tickY = minorTickY + DBMath.sin(tickAngle) * dbSmallTickSize;
                        tickLocation = new Point2D.Double(tickX, tickY);
                        lastHighlights.add(highlighter.addLine(new Point2D.Double(minorTickX, minorTickY), tickLocation, cell));
                        if (!(distSoFar > dbDist - minorTickDist)) {
                            if (i2 % 5 != 0) continue;
                            lastHighlights.add(highlighter.addMessage(cell, TextUtils.formatDistance(distSoFar, tech), tickLocation));
                            continue;
                        }
                        break;
                    }
                }
            } else {
                lastHighlights.add(highlighter.addMessage(cell, "(" + TextUtils.formatDistance(start.getX(), tech) + "," + TextUtils.formatDistance(start.getY(), tech) + ")", start));
                lastHighlights.add(highlighter.addMessage(cell, "(" + TextUtils.formatDistance(end.getX(), tech) + "," + TextUtils.formatDistance(end.getY(), tech) + ")", end));
                lastHighlights.add(highlighter.addLine(start, end, cell));
                lastMeasuredDistanceX = Math.abs(start.getX() - end.getX());
                lastMeasuredDistanceY = Math.abs(start.getY() - end.getY());
                Point2D.Double center = new Point2D.Double((start.getX() + end.getX()) / 2.0, (start.getY() + end.getY()) / 2.0);
                double dist = start.distance(end);
                String show = TextUtils.formatDistance(dist, tech) + " (dX=" + TextUtils.formatDistance(lastMeasuredDistanceX, tech) + " dY=" + TextUtils.formatDistance(lastMeasuredDistanceY, tech) + ")";
                lastHighlights.add(highlighter.addMessage(cell, show, center, 1, null));
            }
            highlighter.finished();
            wnd.clearDoingAreaDrag();
            wnd.repaint();
        }
    }

    public void reset() {
        WindowFrame wf;
        if (measuring) {
            measuring = false;
        }
        if ((wf = WindowFrame.getCurrentWindowFrame()).getContent() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)wf.getContent();
            Highlighter highlighter = wnd.getRulerHighlighter();
            highlighter.clear();
            highlighter.finished();
            wnd.repaint();
        } else if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            Iterator<Panel> it = ww.getPanels();
            while (it.hasNext()) {
                Panel p = it.next();
                p.clearMeasurements();
            }
        }
    }

    private void finishMeasure(EditWindow wnd) {
        Highlighter highlighter = wnd.getRulerHighlighter();
        if (measuring) {
            for (Highlight h2 : lastHighlights) {
                highlighter.remove(h2);
            }
            lastHighlights.clear();
            measuring = false;
        } else {
            highlighter.clear();
        }
        highlighter.finished();
        wnd.repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        boolean ctrl;
        boolean bl = ctrl = (evt.getModifiersEx() & 0x80) != 0;
        if (evt.getSource() instanceof EditWindow) {
            int newX = evt.getX();
            int newY = evt.getY();
            EditWindow wnd = (EditWindow)evt.getSource();
            Point2D dbMouse = wnd.screenToDatabase(newX, newY);
            this.doGridding(wnd, evt, dbMouse);
            if (this.isLeftMouse(evt)) {
                if (measuring && ctrl && this.dbStart != null) {
                    dbMouse = MeasureListener.convertToOrthogonal(this.dbStart, dbMouse);
                }
                this.startMeasure(dbMouse);
            }
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.finishMeasure(wnd);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        boolean ctrl;
        this.gridMouse(evt);
        boolean bl = ctrl = (evt.getModifiersEx() & 0x80) != 0;
        if (evt.getSource() instanceof EditWindow) {
            int newX = evt.getX();
            int newY = evt.getY();
            EditWindow wnd = (EditWindow)evt.getSource();
            Point2D dbMouse = wnd.screenToDatabase(newX, newY);
            if (ctrl && this.dbStart != null) {
                dbMouse = MeasureListener.convertToOrthogonal(this.dbStart, dbMouse);
            }
            this.doGridding(wnd, evt, dbMouse);
            this.dragOutMeasure(wnd, dbMouse);
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.mouseDragged(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e2) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (chr == 27) {
                this.finishMeasure(wnd);
            }
        }
    }

    private boolean isLeftMouse(MouseEvent evt) {
        return ClientOS.isOSMac() ? !evt.isMetaDown() && SwingUtilities.isLeftMouseButton(evt) : SwingUtilities.isLeftMouseButton(evt);
    }

    public static Point2D convertToOrthogonal(Point2D startPoint, Point2D mousePoint) {
        double xdist = Math.abs(mousePoint.getX() - startPoint.getX());
        double ydist = Math.abs(mousePoint.getY() - startPoint.getY());
        if (ydist > xdist) {
            return new Point2D.Double(startPoint.getX(), mousePoint.getY());
        }
        return new Point2D.Double(mousePoint.getX(), startPoint.getY());
    }

    private void gridMouse(MouseEvent evt) {
        if (User.isGridAlignMeasurementCursor() && evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            long mouseX = (long)evt.getX() + this.gridOffX;
            long mouseY = (long)evt.getY() + this.gridOffY;
            Point2D dbMouse = wnd.screenToDatabase(mouseX, mouseY);
            Point2D.Double align = new Point2D.Double(dbMouse.getX(), dbMouse.getY());
            EditWindow.gridAlign(align);
            ScreenPoint newPos = wnd.databaseToScreen(align);
            this.gridOffX = mouseX - newPos.getX();
            this.gridOffY = mouseY - newPos.getY();
            try {
                if (this.robot == null) {
                    this.robot = new Robot();
                }
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
            Point newPosPt = new Point(newPos.getIntX(), newPos.getIntY());
            SwingUtilities.convertPointToScreen(newPosPt, wnd);
            if (this.robot != null) {
                this.robot.mouseMove(newPosPt.x, newPosPt.y);
            }
        }
    }

    private void doGridding(EditWindow wnd, MouseEvent evt, Point2D dbMouse) {
        boolean shift;
        boolean bl = shift = (evt.getModifiersEx() & 0x40) != 0;
        if (shift && wnd != null && wnd.getCell() != null) {
            Point2D snapDist = wnd.screenToDatabase(0L, 15L);
            double snapDistance = Math.sqrt(snapDist.getX() * snapDist.getX() + snapDist.getY() * snapDist.getY());
            GeometrySearch search = new GeometrySearch(wnd, snapDistance);
            ArrayList<Line2D> possibleLines = new ArrayList<Line2D>();
            ArrayList<Point2D> possiblePoints = new ArrayList<Point2D>();
            search.searchGeometries(wnd.getCell(), dbMouse, possibleLines, possiblePoints);
            Point2D closest = new Point2D.Double();
            double closestDist = Double.MAX_VALUE;
            for (Line2D line : possibleLines) {
                double dist;
                Point2D hitPoint = DBMath.closestPointToSegment(line.getP1(), line.getP2(), dbMouse);
                if (hitPoint == null || !((dist = hitPoint.distance(dbMouse)) < closestDist)) continue;
                closestDist = dist;
                closest = hitPoint;
            }
            for (Point2D point : possiblePoints) {
                double dist = point.distance(dbMouse) / 2.0;
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closest = point;
            }
            if (closestDist < snapDistance) {
                dbMouse.setLocation(closest);
                return;
            }
        }
        EditWindow.gridAlign(dbMouse);
    }

    public class GeometrySearch
    extends HierarchyEnumerator.Visitor {
        private double searchDist;
        private List<Line2D> closeLines;
        private List<Point2D> closePoints;
        private ERectangle geomBBnd;
        private final LayerVisibility lv;

        public GeometrySearch(EditWindow wnd, double snapDistance) {
            this.lv = wnd.getLayerVisibility();
            this.searchDist = snapDistance;
        }

        public void searchGeometries(Cell cell, Point2D point, List<Line2D> lines, List<Point2D> points) {
            this.closeLines = lines;
            this.closePoints = points;
            this.geomBBnd = ERectangle.fromLambda(point.getX() - this.searchDist, point.getY() - this.searchDist, this.searchDist * 2.0, this.searchDist * 2.0);
            HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)this);
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            FixpTransform xformToRoot = info.getTransformToRoot();
            FixpTransform xformFromRoot = null;
            try {
                xformFromRoot = xformToRoot.createInverse();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            assert (xformFromRoot != null);
            Rectangle2D.Double rect = new Rectangle2D.Double();
            ((Rectangle2D)rect).setRect(this.geomBBnd);
            DBMath.transformRect(rect, xformFromRoot);
            boolean continueDown = false;
            Iterator<Geometric> it = cell.searchIterator(rect, true);
            while (it.hasNext()) {
                double dist;
                Poly poly;
                int box;
                Poly[] polys;
                Geometric geom = it.next();
                if (geom instanceof NodeInst) {
                    NodeInst oNi = (NodeInst)geom;
                    if (oNi.isCellInstance()) {
                        if (!oNi.getNodeInst().isExpanded()) {
                            Rectangle2D.Double rectDst = new Rectangle2D.Double();
                            xformToRoot.transform((Rectangle2D)geom.getBounds(), rectDst);
                            this.addRect(rectDst);
                            continue;
                        }
                        continueDown = true;
                        continue;
                    }
                    polys = oNi.getProto().getTechnology().getShapeOfNode(oNi);
                    for (box = 0; box < polys.length; ++box) {
                        poly = polys[box];
                        if (!this.lv.isVisible(poly.getLayer())) continue;
                        poly.transform(oNi.rotateOut());
                        dist = poly.polyDistance(rect);
                        if (!(dist <= this.searchDist)) continue;
                        this.addPoly(poly, xformToRoot);
                    }
                    continue;
                }
                ArcInst ai = (ArcInst)geom;
                polys = ai.getProto().getTechnology().getShapeOfArc(ai);
                for (box = 0; box < polys.length; ++box) {
                    poly = polys[box];
                    if (!this.lv.isVisible(poly.getLayer()) || !((dist = poly.polyDistance(rect)) <= this.searchDist)) continue;
                    this.addPoly(poly, xformToRoot);
                }
            }
            return continueDown;
        }

        private void addPoly(Poly poly, FixpTransform xformToRoot) {
            poly.transform(xformToRoot);
            PolyBase.Point[] pts = poly.getPoints();
            if (pts == null) {
                this.addRect(poly.getBounds2D());
                return;
            }
            if (poly.getStyle() == Poly.Type.OPENED || poly.getStyle() == Poly.Type.OPENEDT1 || poly.getStyle() == Poly.Type.OPENEDT2 || poly.getStyle() == Poly.Type.OPENEDT3) {
                int i2;
                for (i2 = 1; i2 < pts.length; ++i2) {
                    this.closeLines.add(new Line2D.Double(pts[i2 - 1], pts[i2]));
                }
                for (i2 = 0; i2 < pts.length; ++i2) {
                    this.closePoints.add(pts[i2]);
                }
                return;
            }
            for (int i3 = 0; i3 < pts.length; ++i3) {
                this.closePoints.add(pts[i3]);
                PolyBase.Point lastPt = i3 == 0 ? pts[pts.length - 1] : pts[i3 - 1];
                this.closeLines.add(new Line2D.Double(lastPt, pts[i3]));
            }
        }

        private void addRect(Rectangle2D rect) {
            Point2D.Double p1 = new Point2D.Double(rect.getMinX(), rect.getMinY());
            Point2D.Double p2 = new Point2D.Double(rect.getMinX(), rect.getMaxY());
            Point2D.Double p3 = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
            Point2D.Double p4 = new Point2D.Double(rect.getMaxX(), rect.getMinY());
            Line2D.Double l1 = new Line2D.Double(p1, p2);
            Line2D.Double l2 = new Line2D.Double(p2, p3);
            Line2D.Double l3 = new Line2D.Double(p3, p4);
            Line2D.Double l4 = new Line2D.Double(p4, p1);
            this.closeLines.add(l1);
            this.closeLines.add(l2);
            this.closeLines.add(l3);
            this.closeLines.add(l4);
            this.closePoints.add(p1);
            this.closePoints.add(p2);
            this.closePoints.add(p3);
            this.closePoints.add(p4);
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return no.getNodeInst().isExpanded();
        }
    }
}

