/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class LibraryPalette
extends JPanel
implements DatabaseChangeListener,
MouseListener,
PaletteFrame.PlaceNodeEventListener {
    private Library library = null;
    private JScrollPane scrollPane;
    private JList cellJList;
    private Map<Library, Rectangle> viewPortMap = new HashMap<Library, Rectangle>();
    private JPopupMenu cellPopup;
    private PaletteFrame.PlaceNodeListener lastPlaceNodeListener = null;

    public LibraryPalette(Dimension preferredSize) {
        this.initComponents(preferredSize);
        UserInterfaceMain.addDatabaseChangeListener(this);
    }

    public void setLibrary(Library lib) {
        if (this.library != lib) {
            this.viewPortMap.put(this.library, this.cellJList.getVisibleRect());
        }
        this.library = lib;
        this.updateCellList();
    }

    private void initComponents(Dimension preferredSize) {
        this.scrollPane = new JScrollPane();
        this.cellJList = new JList();
        this.cellJList.setCellRenderer(new CustomCellRenderer());
        this.cellJList.setSelectionMode(0);
        this.cellJList.addMouseListener(this);
        this.scrollPane.setViewportView(this.cellJList);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setPreferredSize(preferredSize);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.updateCellList();
    }

    private void updateCellList() {
        if (this.library == null) {
            this.cellJList.setListData(new Object[0]);
            return;
        }
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        Iterator<Cell> it = this.library.getCells();
        while (it.hasNext()) {
            cellList.add(it.next());
        }
        this.cellJList.setListData(cellList.toArray());
        Rectangle rect = this.viewPortMap.get(this.library);
        if (rect != null) {
            this.cellJList.scrollRectToVisible(rect);
        }
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e2) {
        this.updateCellList();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.isShiftDown() || e2.isControlDown() || e2.isAltDown()) {
            return;
        }
        if (e2.isMetaDown()) {
            this.initCellPopup();
            int index = this.cellJList.locationToIndex(new Point(e2.getX(), e2.getY()));
            Object selected = this.cellJList.getModel().getElementAt(index);
            if (selected == null) {
                return;
            }
            this.cellJList.setSelectedValue(selected, false);
            this.cellPopup.show(this, e2.getX(), e2.getY());
        } else {
            Object selected = this.cellJList.getSelectedValue();
            if (selected == null) {
                return;
            }
            Cell cell = (Cell)selected;
            if (e2.getClickCount() == 2) {
                this.selectedCellEdit();
                if (this.lastPlaceNodeListener != null) {
                    this.lastPlaceNodeListener.finished(EditWindow.getCurrent(), true);
                }
            } else {
                if (cell.isSchematic()) {
                    return;
                }
                this.lastPlaceNodeListener = PaletteFrame.placeInstance(cell, this, false);
            }
        }
    }

    @Override
    public void placeNodeStarted(Object nodeToBePlaced) {
    }

    @Override
    public void placeNodeFinished(boolean cancelled) {
        this.cellJList.clearSelection();
        this.lastPlaceNodeListener = null;
    }

    private void initCellPopup() {
        if (this.cellPopup != null) {
            return;
        }
        this.cellPopup = new JPopupMenu();
        JMenuItem m2 = new JMenuItem("Edit");
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LibraryPalette.this.selectedCellEdit();
            }
        });
        this.cellPopup.add(m2);
        m2 = new JMenuItem("Duplicate");
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LibraryPalette.this.selectedCellDuplicate();
            }
        });
        this.cellPopup.add(m2);
        m2 = new JMenuItem("Rename");
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LibraryPalette.this.selectedCellRename();
            }
        });
        this.cellPopup.add(m2);
        m2 = new JMenuItem("Delete");
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LibraryPalette.this.selectedCellDelete();
            }
        });
        this.cellPopup.add(m2);
    }

    private void selectedCellEdit() {
        Cell cell = (Cell)this.cellJList.getSelectedValue();
        if (cell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            WindowFrame.createEditWindow(cell);
        } else {
            wf.setCellWindow(cell, null);
        }
        this.cellJList.clearSelection();
    }

    private void selectedCellDuplicate() {
        Cell cell = (Cell)this.cellJList.getSelectedValue();
        if (cell == null) {
            return;
        }
        new CellMenu.NewCellName(1, cell, null);
        this.cellJList.clearSelection();
    }

    private void selectedCellRename() {
        Cell cell = (Cell)this.cellJList.getSelectedValue();
        if (cell == null) {
            return;
        }
        String newName = JOptionPane.showInputDialog(this, "New name for cell " + cell.getName(), cell.getName() + "NEW");
        if (newName == null) {
            return;
        }
        CircuitChanges.renameCellInJob(cell, newName);
        this.cellJList.clearSelection();
    }

    private void selectedCellDelete() {
        Cell cell = (Cell)this.cellJList.getSelectedValue();
        if (cell == null) {
            return;
        }
        CircuitChanges.deleteCell(cell, true, false);
        this.cellJList.clearSelection();
    }

    class CustomCellRenderer
    extends DefaultListCellRenderer {
        CustomCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            Cell cell = (Cell)value;
            super.getListCellRendererComponent((JList<?>)list, cell.noLibDescribe(), index, iss, chf);
            return this;
        }
    }
}

