/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.user.ui.KeyStrokePair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;

public class KeyBindings
implements ActionListener {
    private String actionDesc;
    private List<KeyStrokePair> keyStrokePairs;
    private List<KeyStrokePair> defaultKeyStrokePairs;
    private List<ActionListener> actionListeners;
    private Object eventSource;
    private boolean usingDefaultKeys;
    private boolean enabled;
    private static final String sep = "; ";

    public KeyBindings(String actionDesc) {
        this.actionDesc = actionDesc;
        this.keyStrokePairs = new ArrayList<KeyStrokePair>();
        this.defaultKeyStrokePairs = new ArrayList<KeyStrokePair>();
        this.actionListeners = new ArrayList<ActionListener>();
        this.eventSource = null;
        this.usingDefaultKeys = true;
        this.enabled = true;
    }

    public void addKeyBinding(KeyStroke prefixStroke, KeyStroke stroke) {
        KeyStrokePair k2 = KeyStrokePair.getKeyStrokePair(prefixStroke, stroke);
        this.keyStrokePairs.add(k2);
    }

    public void addKeyBinding(KeyStrokePair k2) {
        this.keyStrokePairs.add(k2);
    }

    public void addKeyBindings(String str) {
        String[] pairs = str.split(sep);
        for (int i2 = 0; i2 < pairs.length; ++i2) {
            String pair = pairs[i2];
            KeyStrokePair k2 = KeyStrokePair.getKeyStrokePair(pair);
            if (k2 == null) continue;
            this.keyStrokePairs.add(k2);
        }
    }

    public void removeKeyBinding(KeyStrokePair k2) {
        this.keyStrokePairs.remove(k2);
    }

    public void addDefaultKeyBinding(KeyStroke prefixStroke, KeyStroke stroke) {
        KeyStrokePair k2 = KeyStrokePair.getKeyStrokePair(prefixStroke, stroke);
        this.defaultKeyStrokePairs.add(k2);
    }

    public void addDefaultKeyBinding(KeyStrokePair k2) {
        this.defaultKeyStrokePairs.add(k2);
    }

    public void clearKeyBindings() {
        this.keyStrokePairs.clear();
    }

    public void addActionListener(ActionListener a2) {
        this.actionListeners.add(a2);
    }

    public void removeActionListener(ActionListener a2) {
        this.actionListeners.remove(a2);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (!this.enabled) {
            return;
        }
        if (this.eventSource != null) {
            e2.setSource(this.eventSource);
        }
        for (ActionListener action : this.actionListeners) {
            action.actionPerformed(e2);
        }
    }

    public String bindingsToString() {
        StringBuffer buf = new StringBuffer("");
        Iterator<KeyStrokePair> it = this.keyStrokePairs.iterator();
        while (it.hasNext()) {
            KeyStrokePair k2 = it.next();
            buf.append(k2.toString());
            if (!it.hasNext()) continue;
            buf.append(sep);
        }
        return buf.toString();
    }

    public String describe() {
        return "KeyBindings for '" + this.actionDesc + "': [ " + this.bindingsToString() + " ]";
    }

    public String getActionDesc() {
        return this.actionDesc;
    }

    public Iterator<ActionListener> getActionListeners() {
        return this.actionListeners.iterator();
    }

    public Iterator<KeyStrokePair> getKeyStrokePairs() {
        return this.keyStrokePairs.iterator();
    }

    public Iterator<KeyStrokePair> getDefaultKeyStrokePairs() {
        return this.defaultKeyStrokePairs.iterator();
    }

    public void setEventSource(Object source) {
        this.eventSource = source;
    }

    public void setUsingDefaultKeys(boolean b2) {
        this.usingDefaultKeys = b2;
    }

    public boolean getUsingDefaultKeys() {
        return this.usingDefaultKeys;
    }

    public void setEnabled(boolean b2) {
        this.enabled = b2;
    }

    public boolean getEnabled() {
        return this.enabled;
    }
}

