/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.tool.user.tests.PlacementParameterSetter;
import com.sun.electric.util.TextUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PlacementTest
extends AbstractTest {
    public PlacementTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new PlacementTest("MinCut"));
        list.add(new PlacementTest("ForceDirected1"));
        list.add(new PlacementTest("ForceDirected2"));
        list.add(new PlacementTest("Genetic1"));
        list.add(new PlacementTest("Genetic2"));
        list.add(new PlacementTest("SimulatedAnnealing1"));
        list.add(new PlacementTest("SimulatedAnnealing2"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Placement/output/";
    }

    public Boolean MinCut() {
        return PlacementTest.runParallelPlacementTestAlgorithm("Min-Cut", this.getRegressionPath(), "placementTests.jelib", "PlacementTest4", 0, 0, true);
    }

    public Boolean ForceDirected1() {
        return PlacementTest.runParallelPlacementTestAlgorithm("Force-Directed-1", this.getRegressionPath(), "placementTests.jelib", "PlacementTest4", 2, 10, false);
    }

    public Boolean ForceDirected2() {
        return PlacementTest.runParallelPlacementTestAlgorithm("Force-Directed-2", this.getRegressionPath(), "placementTests.jelib", "PlacementTest4", 2, 10, false);
    }

    public Boolean Genetic1() {
        return PlacementTest.runParallelPlacementTestAlgorithm("Genetic-1", this.getRegressionPath(), "placementTests.jelib", "PlacementTest4", 2, 10, false);
    }

    public Boolean Genetic2() {
        return PlacementTest.runParallelPlacementTestAlgorithm("Genetic-2", this.getRegressionPath(), "placementTests.jelib", "PlacementTest4", 2, 10, false);
    }

    public Boolean SimulatedAnnealing1() {
        return PlacementTest.runParallelPlacementTestAlgorithm("Simulated-Annealing-1", this.getRegressionPath(), "placementTests.jelib", "PlacementTest4", 2, 10, false);
    }

    public Boolean SimulatedAnnealing2() {
        return PlacementTest.runParallelPlacementTestAlgorithm("Simulated-Annealing-2", this.getRegressionPath(), "placementTests.jelib", "PlacementTest4", 2, 10, false);
    }

    public static Boolean runParallelPlacementTestAlgorithm(String testName, String rootPath, String libName, String cell, int numOfThreads, int runtime, boolean test) {
        PlacementFrame[] algorithms = PlacementAdapter.getPlacementAlgorithms();
        PlacementFrame algorithm = null;
        for (int i2 = 0; i2 < algorithms.length; ++i2) {
            if (!algorithms[i2].getAlgorithmName().equals(testName)) continue;
            algorithm = algorithms[i2];
            break;
        }
        if (algorithm == null) {
            return Boolean.FALSE;
        }
        return PlacementTest.doPlacement(rootPath, libName, cell, algorithm, numOfThreads, runtime, test);
    }

    private static Boolean doPlacement(String rootPath, String libName, String cellName, PlacementFrame algorithm, int numOfThreads, int runtime, boolean test) {
        URL fileURL;
        Library rootLib;
        Object trueRootPath = rootPath != null ? rootPath + "/tools/Placement/" : "";
        String outputDir = (String)trueRootPath + "output/";
        PlacementTest.ensureOutputDirectory(outputDir);
        String testName = algorithm.getAlgorithmName() + "-" + runtime + "sec-" + numOfThreads + "thr";
        MessagesStream.getMessagesStream().save(outputDir + testName + ".log");
        PlacementTest.setFoundry(Technology.getMocmosTechnology());
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        Placement.PlacementPreferences prefs = new Placement.PlacementPreferences(true);
        prefs.placementAlgorithm = algorithm.getAlgorithmName();
        PlacementParameterSetter paramSetter = PlacementParameterSetter.algorithmMapping.get(algorithm.getAlgorithmName());
        if (paramSetter != null) {
            paramSetter.setParameter(prefs, numOfThreads, runtime, algorithm, true);
        }
        if ((rootLib = Library.findLibrary(libName)) == null && (rootLib = LibraryFiles.readLibrary(ep, fileURL = TextUtils.makeURLToFile((String)trueRootPath + "data/libs/" + libName), libName, FileType.JELIB, true)) == null) {
            System.out.println("Can't find library '" + libName + "'");
            return Boolean.FALSE;
        }
        Cell cell = rootLib.findNodeProto(cellName + "{lay}");
        PlacementFrame pf = Placement.getCurrentPlacementAlgorithm(prefs);
        Cell newCell = Placement.placeCellNoJob(cell, ep, pf, prefs, false, null);
        Output.saveJelib(outputDir + testName + ".jelib", newCell.getLibrary());
        if (test) {
            return PlacementTest.compareLibraryResults((String)trueRootPath, testName, newCell.getLibrary(), new char[]{'H', 'C', 'F', 'R', 'T', 'O', '#'});
        }
        return Boolean.TRUE;
    }
}

