/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class MakeFakeCircuitry
extends Job {
    private String theTechnology;
    private String theLibrary;
    private Cell myCell;
    private Map<CellId, BitSet> nodesToExpand = new HashMap<CellId, BitSet>();

    public static void makeFakeCircuitryCommand(String lib, String tech, Boolean asJob, EditingPreferences ep) {
        if (asJob.booleanValue()) {
            new MakeFakeCircuitry(lib, tech);
        } else {
            MakeFakeCircuitry.doItInternal(lib, tech, new HashMap<CellId, BitSet>(), ep);
        }
    }

    protected MakeFakeCircuitry(String lib, String tech) {
        super("Make fake circuitry", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.theLibrary = lib;
        this.theTechnology = tech;
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        this.myCell = MakeFakeCircuitry.doItInternal(this.theLibrary, this.theTechnology, this.nodesToExpand, this.getEditingPreferences());
        this.fieldVariableChanged("myCell");
        this.fieldVariableChanged("nodesToExpand");
        return true;
    }

    @Override
    public void terminateOK() {
        this.getDatabase().expandNodes(this.nodesToExpand);
        Job.getUserInterface().displayCell(this.myCell);
    }

    private static Cell doItInternal(String library, String technology, Map<CellId, BitSet> nodesToExpand, EditingPreferences ep) {
        ArcInst metal2Arc;
        PortInst transRPortR;
        ArcProto m2Proto;
        EDatabase database = EDatabase.currentDatabase();
        Technology tech = Technology.findTechnology(technology);
        if (tech == null) {
            System.out.println("Technology not found in MakeFakeCircuitry");
            return null;
        }
        StringBuffer polyName = new StringBuffer("Polysilicon");
        String lateral = "top";
        int traRot = 0;
        int rotTraRot = 3150;
        if (technology.equals("mocmos")) {
            polyName.append("-1");
            lateral = "right";
        } else {
            traRot = 2700;
            rotTraRot = 2250;
        }
        NodeProto m1m2Proto = Cell.findNodeProto(technology + ":Metal-1-Metal-2-Con");
        NodeProto m2PinProto = Cell.findNodeProto(technology + ":Metal-2-Pin");
        NodeProto p1PinProto = Cell.findNodeProto(technology + ":" + String.valueOf(polyName) + "-Pin");
        NodeProto m1PolyConProto = Cell.findNodeProto(technology + ":Metal-1-" + String.valueOf(polyName) + "-Con");
        NodeProto pTransProto = Cell.findNodeProto(technology + ":P-Transistor");
        NodeProto nTransProto = Cell.findNodeProto(technology + ":N-Transistor");
        NodeProto invisiblePinProto = Cell.findNodeProto("generic:Invisible-Pin");
        ArcProto m1Proto = ArcProto.findArcProto(technology + ":Metal-1");
        if (m1Proto == null) {
            m1Proto = ArcProto.findArcProto(technology + ":metal-1");
        }
        if ((m2Proto = ArcProto.findArcProto(technology + ":Metal-2")) == null) {
            m2Proto = ArcProto.findArcProto(technology + ":metal-2");
        }
        ArcProto p1Proto = ArcProto.findArcProto(technology + ":" + String.valueOf(polyName));
        Library mainLib = Library.newInst(library, null);
        Cell myCell = Cell.makeInstance(ep, mainLib, technology + "test{lay}");
        NodeInst metal12Via = NodeInst.newInst(m1m2Proto, ep, new Point2D.Double(-20.0, 20.0), m1m2Proto.getDefWidth(ep), m1m2Proto.getDefHeight(ep), myCell);
        NodeInst contactNode = NodeInst.newInst(m1PolyConProto, ep, new Point2D.Double(20.0, 20.0), m1PolyConProto.getDefWidth(ep), m1PolyConProto.getDefHeight(ep), myCell);
        NodeInst metal2Pin = NodeInst.newInst(m2PinProto, ep, new Point2D.Double(-20.0, 10.0), m2PinProto.getDefWidth(ep), m2PinProto.getDefHeight(ep), myCell);
        NodeInst poly1PinA = NodeInst.newInst(p1PinProto, ep, new Point2D.Double(20.0, -20.0), p1PinProto.getDefWidth(ep), p1PinProto.getDefHeight(ep), myCell);
        NodeInst poly1PinB = NodeInst.newInst(p1PinProto, ep, new Point2D.Double(20.0, -10.0), p1PinProto.getDefWidth(ep), p1PinProto.getDefHeight(ep), myCell);
        NodeInst transistor = NodeInst.newInst(pTransProto, ep, new Point2D.Double(0.0, -20.0), pTransProto.getDefWidth(ep), pTransProto.getDefHeight(ep), myCell, Orientation.fromAngle(traRot), null);
        NodeInst rotTrans = NodeInst.newInst(nTransProto, ep, new Point2D.Double(0.0, 10.0), nTransProto.getDefWidth(ep), nTransProto.getDefHeight(ep), myCell, Orientation.fromAngle(rotTraRot), "rotated");
        if (metal12Via == null || contactNode == null || metal2Pin == null || poly1PinA == null || poly1PinB == null || transistor == null || rotTrans == null) {
            return myCell;
        }
        PortInst m1m2Port = metal12Via.getOnlyPortInst();
        PortInst contactPort = contactNode.getOnlyPortInst();
        PortInst m2Port = metal2Pin.getOnlyPortInst();
        PortInst p1PortA = poly1PinA.getOnlyPortInst();
        PortInst p1PortB = poly1PinB.getOnlyPortInst();
        PortInst transPortR = transistor.findPortInst("poly-" + lateral);
        if (transPortR == null) {
            transPortR = transistor.findPortInst("p-trans-poly-" + lateral);
        }
        if ((transRPortR = rotTrans.findPortInst("poly-" + lateral)) == null) {
            transRPortR = rotTrans.findPortInst("n-trans-poly-" + lateral);
        }
        if ((metal2Arc = ArcInst.makeInstance(m2Proto, ep, m2Port, m1m2Port)) == null) {
            return myCell;
        }
        metal2Arc.setRigid(true);
        ArcInst metal1Arc = ArcInst.makeInstance(m1Proto, ep, contactPort, m1m2Port);
        if (metal1Arc == null) {
            return myCell;
        }
        ArcInst polyArc1 = ArcInst.makeInstance(p1Proto, ep, contactPort, p1PortB);
        if (polyArc1 == null) {
            return myCell;
        }
        ArcInst polyArc3 = ArcInst.makeInstance(p1Proto, ep, p1PortB, p1PortA);
        if (polyArc3 == null) {
            return myCell;
        }
        ArcInst polyArc2 = ArcInst.makeInstance(p1Proto, ep, transPortR, p1PortA);
        if (polyArc2 == null) {
            return myCell;
        }
        ArcInst polyArc4 = ArcInst.makeInstance(p1Proto, ep, transRPortR, p1PortB);
        if (polyArc4 == null) {
            return myCell;
        }
        Export.newInst(myCell, m1m2Port, "in", ep, PortCharacteristic.IN);
        Export.newInst(myCell, p1PortA, "out", ep, PortCharacteristic.OUT);
        System.out.println("Created " + String.valueOf(myCell));
        Cell higherCell = Cell.makeInstance(ep, mainLib, "higher{lay}");
        double myWidth = myCell.getDefWidth();
        double myHeight = myCell.getDefHeight();
        for (int iX = 0; iX < 2; ++iX) {
            boolean flipX = iX != 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                Orientation orient = Orientation.fromJava(i2 * 900, flipX, false);
                NodeInst instanceNode = NodeInst.newInst(myCell, ep, new Point2D.Double(i2 * 100, iX * 200), myWidth, myHeight, higherCell, orient, null);
                database.addToNodes(nodesToExpand, instanceNode);
                NodeInst instanceUNode = NodeInst.newInst(myCell, ep, new Point2D.Double(i2 * 100, iX * 200 + 100), myWidth, myHeight, higherCell, orient, null);
                if (iX != 0 || i2 != 0) continue;
                PortInst instance1Port = instanceNode.findPortInst("in");
                PortInst instance2Port = instanceUNode.findPortInst("in");
                ArcInst.makeInstance(m1Proto, ep, instance1Port, instance2Port);
            }
        }
        System.out.println("Created " + String.valueOf(higherCell));
        Cell rotTestCell = Cell.makeInstance(ep, mainLib, "rotationTest{lay}");
        TextDescriptor td = ep.getNodeTextDescriptor().withRelSize(10.0);
        for (int iY = 0; iY < 2; ++iY) {
            boolean flipY = iY != 0;
            for (int iX = 0; iX < 2; ++iX) {
                boolean flipX = iX != 0;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int angle = i3 * 900;
                    Orientation orient = Orientation.fromJava(angle, flipX, flipY);
                    int x = i3 * 100;
                    int y = iX * 100 + iY * 200;
                    NodeInst ni = NodeInst.newInst(myCell, ep, new Point2D.Double(x, y), myWidth, myHeight, rotTestCell, orient, null);
                    database.addToNodes(nodesToExpand, ni);
                    NodeInst nodeLabel = NodeInst.newInst(invisiblePinProto, ep, new Point2D.Double(x, y - 35), 0.0, 0.0, rotTestCell);
                    String message = "Rotated " + (orient == Orientation.IDENT ? "0" : orient.toString());
                    nodeLabel.newVar(Artwork.ART_MESSAGE, (Object)message, td);
                }
            }
        }
        System.out.println("Created " + String.valueOf(rotTestCell));
        Cell bigCell = Cell.makeInstance(ep, mainLib, "big{lay}");
        int arraySize = 20;
        for (int y = 0; y < arraySize; ++y) {
            for (int x = 0; x < arraySize; ++x) {
                String theName = "arr[" + x + "][" + y + "]";
                NodeInst instanceNode = NodeInst.newInst(myCell, ep, new Point2D.Double((double)x * (myWidth + 2.0), (double)y * (myHeight + 2.0)), myWidth, myHeight, bigCell, Orientation.IDENT, theName);
                instanceNode.setOff(NodeInst.NODE_NAME, 0.0, 8.0);
                if (x % 2 != y % 2) continue;
                database.addToNodes(nodesToExpand, instanceNode);
            }
        }
        System.out.println("Created " + String.valueOf(bigCell));
        return myCell;
    }
}

