/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.CIF;
import com.sun.electric.tool.io.input.DEF;
import com.sun.electric.tool.io.input.DXF;
import com.sun.electric.tool.io.input.EDIF;
import com.sun.electric.tool.io.input.GDS;
import com.sun.electric.tool.io.input.Gerber;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LEF;
import com.sun.electric.tool.io.input.Sue;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ImportForeignTest
extends AbstractTest {
    public ImportForeignTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new ImportForeignTest("Bookshelf"));
        list.add(new ImportForeignTest("CIF1"));
        list.add(new ImportForeignTest("CIF2"));
        list.add(new ImportForeignTest("CIF3"));
        list.add(new ImportForeignTest("CIF4"));
        list.add(new ImportForeignTest("DXF1"));
        list.add(new ImportForeignTest("DXF2"));
        list.add(new ImportForeignTest("DXF3"));
        list.add(new ImportForeignTest("DXF4"));
        list.add(new ImportForeignTest("DXF5"));
        list.add(new ImportForeignTest("DXF6"));
        list.add(new ImportForeignTest("EDIF1"));
        list.add(new ImportForeignTest("EDIF2"));
        list.add(new ImportForeignTest("EDIF3"));
        list.add(new ImportForeignTest("EDIF4"));
        list.add(new ImportForeignTest("EDIF5"));
        list.add(new ImportForeignTest("GDS1"));
        list.add(new ImportForeignTest("GDS2"));
        list.add(new ImportForeignTest("GDS3"));
        list.add(new ImportForeignTest("GDS4"));
        list.add(new ImportForeignTest("Gerber"));
        list.add(new ImportForeignTest("LEFDEF1"));
        list.add(new ImportForeignTest("LEFDEF2"));
        if (EvalJavaBsh.hasBeanShell()) {
            list.add(new ImportForeignTest("SUE1"));
            list.add(new ImportForeignTest("SUE2"));
            list.add(new ImportForeignTest("SUE3"));
        }
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/IO/output/";
    }

    public Boolean Bookshelf() {
        return ImportForeignTest.basicBOOKSHELF1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicBOOKSHELF1(String rootPath, Job job) {
        Bookshelf.BookshelfPreferences bp1 = new Bookshelf.BookshelfPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportBOOKSHELF-1", null, MoCMOS.getMocmosTechnology(), job, false, ".aux", null, FileType.BOOKSHELF, null, bp1, null);
    }

    public Boolean CIF1() {
        return ImportForeignTest.basicCIF1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicCIF1(String rootPath, Job job) {
        CIF.CIFPreferences ip = new CIF.CIFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportCIF-1", null, Technology.findTechnology("nmos"), job, true, ".cif", null, FileType.CIF, null, ip, null);
    }

    public Boolean CIF2() {
        return ImportForeignTest.basicCIF2(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicCIF2(String rootPath, Job job) {
        CIF.CIFPreferences ip = new CIF.CIFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportCIF-2", null, MoCMOS.getMocmosTechnology(), job, true, ".cif", null, FileType.CIF, null, ip, null);
    }

    public Boolean CIF3() {
        return ImportForeignTest.basicCIF3(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicCIF3(String rootPath, Job job) {
        CIF.CIFPreferences ip = new CIF.CIFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportCIF-3", null, MoCMOS.getMocmosTechnology(), job, true, ".cif", null, FileType.CIF, null, ip, null);
    }

    public Boolean CIF4() {
        return ImportForeignTest.basicCIF4(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicCIF4(String rootPath, Job job) {
        CIF.CIFPreferences ip = new CIF.CIFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportCIF-4", null, MoCMOS.getMocmosTechnology(), job, true, ".cif", null, FileType.CIF, null, ip, null);
    }

    public Boolean DXF1() {
        return ImportForeignTest.basicDXF1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicDXF1(String rootPath, Job job) {
        DXF.DXFPreferences ip = new DXF.DXFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportDXF-1", null, Artwork.tech(), job, true, ".dxf", null, FileType.DXF, null, ip, null);
    }

    public Boolean DXF2() {
        return ImportForeignTest.basicDXF2(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicDXF2(String rootPath, Job job) {
        DXF.DXFPreferences ip = new DXF.DXFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportDXF-2", null, null, job, true, ".dxf", null, FileType.DXF, null, ip, null);
    }

    public Boolean DXF3() {
        return ImportForeignTest.basicDXF3(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicDXF3(String rootPath, Job job) {
        DXF.DXFPreferences ip = new DXF.DXFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportDXF-3", null, Artwork.tech(), job, true, ".dxf", null, FileType.DXF, null, ip, null);
    }

    public Boolean DXF4() {
        return ImportForeignTest.basicDXF4(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicDXF4(String rootPath, Job job) {
        DXF.DXFPreferences ip = new DXF.DXFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportDXF-4", null, Artwork.tech(), job, true, ".dxf", null, FileType.DXF, null, ip, null);
    }

    public Boolean DXF5() {
        return ImportForeignTest.basicDXF5(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicDXF5(String rootPath, Job job) {
        DXF.DXFPreferences ip = new DXF.DXFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportDXF-5", null, Artwork.tech(), job, true, ".dxf", null, FileType.DXF, null, ip, null);
    }

    public Boolean DXF6() {
        return ImportForeignTest.basicDXF6(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicDXF6(String rootPath, Job job) {
        DXF.DXFPreferences ip = new DXF.DXFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportDXF-6", null, Artwork.tech(), job, true, ".dxf", null, FileType.DXF, null, ip, null);
    }

    public Boolean EDIF1() {
        return ImportForeignTest.basicEDIF1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicEDIF1(String rootPath, Job job) {
        EDIF.EDIFPreferences ip = new EDIF.EDIFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportEDIF-1", null, MoCMOS.getMocmosTechnology(), job, false, ".edif", null, FileType.EDIF, null, ip, null);
    }

    public Boolean EDIF2() {
        return ImportForeignTest.basicEDIF2(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicEDIF2(String rootPath, Job job) {
        EDIF.EDIFPreferences ip = new EDIF.EDIFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportEDIF-2", null, MoCMOS.getMocmosTechnology(), job, false, ".edif", null, FileType.EDIF, null, ip, null);
    }

    public Boolean EDIF3() {
        return ImportForeignTest.basicEDIF3(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicEDIF3(String rootPath, Job job) {
        EDIF.EDIFPreferences ip = new EDIF.EDIFPreferences(true);
        ip.cadenceCompatibility = false;
        return ImportForeignTest.runImportTest(rootPath, "ImportEDIF-3", null, MoCMOS.getMocmosTechnology(), job, false, ".edif", null, FileType.EDIF, null, ip, null);
    }

    public Boolean EDIF4() {
        return ImportForeignTest.basicEDIF4(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicEDIF4(String rootPath, Job job) {
        EDIF.EDIFPreferences ip = new EDIF.EDIFPreferences(true);
        ip.cadenceCompatibility = false;
        return ImportForeignTest.runImportTest(rootPath, "ImportEDIF-4", null, MoCMOS.getMocmosTechnology(), job, false, ".edif", null, FileType.EDIF, null, ip, null);
    }

    public Boolean EDIF5() {
        return ImportForeignTest.basicEDIF5(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicEDIF5(String rootPath, Job job) {
        EDIF.EDIFPreferences ip = new EDIF.EDIFPreferences(true);
        ip.cadenceCompatibility = false;
        return ImportForeignTest.runImportTest(rootPath, "ImportEDIF-5", null, MoCMOS.getMocmosTechnology(), job, false, ".edif", null, FileType.EDIF, null, ip, null);
    }

    public Boolean EDIF6() {
        return ImportForeignTest.basicEDIF6(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicEDIF6(String rootPath, Job job) {
        EDIF.EDIFPreferences ip = new EDIF.EDIFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportEDIF-6", null, MoCMOS.getMocmosTechnology(), job, false, ".edif", null, FileType.EDIF, null, ip, null);
    }

    public Boolean GDS1() {
        return ImportForeignTest.basicGDS1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicGDS1(String rootPath, Job job) {
        GDS.GDSPreferences ip = new GDS.GDSPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportGDS-1", null, MoCMOS.getMocmosTechnology(), job, true, ".gds", null, FileType.GDS, null, ip, null);
    }

    public Boolean GDS2() {
        return ImportForeignTest.basicGDS2(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicGDS2(String rootPath, Job job) {
        GDS.GDSPreferences ip = new GDS.GDSPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportGDS-2", null, MoCMOS.getMocmosTechnology(), job, true, ".gds", null, FileType.GDS, null, ip, null);
    }

    public Boolean GDS3() {
        return ImportForeignTest.basicGDS3(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicGDS3(String rootPath, Job job) {
        GDS.GDSPreferences ip = new GDS.GDSPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportGDS-3", null, MoCMOS.getMocmosTechnology(), job, true, ".gds", null, FileType.GDS, null, ip, null);
    }

    public Boolean GDS4() {
        return ImportForeignTest.basicGDS4(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicGDS4(String rootPath, Job job) {
        GDS.GDSPreferences ip = new GDS.GDSPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportGDS-4", null, Technology.findTechnology("mocmosold"), job, true, ".gds", null, FileType.GDS, null, ip, null);
    }

    public Boolean Gerber() {
        return ImportForeignTest.basicGERBER1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicGERBER1(String rootPath, Job job) {
        Gerber.GerberPreferences gp1 = new Gerber.GerberPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportGERBER-1-1", null, MoCMOS.getMocmosTechnology(), job, false, ".gbr", null, FileType.GERBER, null, gp1, null);
    }

    public Boolean LEFDEF1() {
        return ImportForeignTest.basicLEFDEF1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicLEFDEF1(String rootPath, Job job) {
        LEF.LEFPreferences ip1 = new LEF.LEFPreferences(true);
        DEF.DEFPreferences ip2 = new DEF.DEFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportLEFDEF-1", null, MoCMOS.getMocmosTechnology(), job, false, ".lef", ".def", FileType.LEF, FileType.DEF, ip1, ip2);
    }

    public Boolean LEFDEF2() {
        return ImportForeignTest.basicLEFDEF2(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicLEFDEF2(String rootPath, Job job) {
        LEF.LEFPreferences ip = new LEF.LEFPreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportLEFDEF-2", null, MoCMOS.getMocmosTechnology(), job, false, ".lef", null, FileType.LEF, null, ip, null);
    }

    public Boolean SUE1() {
        return ImportForeignTest.basicSUE1(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicSUE1(String rootPath, Job job) {
        Sue.SuePreferences ip = new Sue.SuePreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportSUE-1", "ImportSUE-1", MoCMOS.getMocmosTechnology(), job, true, ".sue", null, FileType.SUE, null, ip, null);
    }

    public Boolean SUE2() {
        return ImportForeignTest.basicSUE2(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicSUE2(String rootPath, Job job) {
        Sue.SuePreferences ip = new Sue.SuePreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportSUE-2", "ImportSUE-2", MoCMOS.getMocmosTechnology(), job, true, ".sue", null, FileType.SUE, null, ip, null);
    }

    public Boolean SUE3() {
        return ImportForeignTest.basicSUE3(this.getRegressionPath(), this.getStarterJob());
    }

    private static boolean basicSUE3(String rootPath, Job job) {
        Sue.SuePreferences ip = new Sue.SuePreferences(true);
        return ImportForeignTest.runImportTest(rootPath, "ImportSUE-3", "ImportSUE-3", MoCMOS.getMocmosTechnology(), job, true, ".sue", null, FileType.SUE, null, ip, null);
    }

    private static boolean runImportTest(String rootPath, String testName, String subLoc, Technology tech, Job job, boolean makeLib, String extension1, String extension2, FileType type1, FileType type2, Input.InputPreferences ip1, Input.InputPreferences ip2) {
        String currentDir = new File("").getAbsolutePath() + File.separator;
        String trueRootPath = rootPath != null && rootPath.length() > 0 ? rootPath + "/tools/IO/" : currentDir;
        String inputDir = trueRootPath + "data/libs/";
        String outputDir = trueRootPath + "output/";
        ImportForeignTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + testName + ".log");
        try {
            List<Library> libsToDelete = ImportForeignTest.getLibsInOrder();
            for (Library l2 : libsToDelete) {
                l2.kill("delete");
            }
            Library iniLib = null;
            if (makeLib) {
                String outputFileName = inputDir + (String)(subLoc == null ? "" : subLoc + "/") + testName + ".jelib";
                URL outputFileURL = TextUtils.makeURLToFile(outputFileName);
                iniLib = Library.newInst(testName, outputFileURL);
            }
            TechPool techPool = TechPool.getThreadTechPool();
            EditingPreferences ep = new EditingPreferences(true, techPool);
            String importFileName = inputDir + (String)(subLoc == null ? "" : subLoc + "/") + testName;
            if (extension2 != null) {
                importFileName = importFileName + "a";
            }
            importFileName = importFileName + extension1;
            URL importFileURL = TextUtils.makeURLToFile(importFileName);
            HashMap<Library, Cell> currentCells = new HashMap<Library, Cell>();
            HashMap<CellId, BitSet> nodesToExpand = new HashMap<CellId, BitSet>();
            ip1.disablePopups = true;
            Library libNew = Input.importLibrary(ep, ip1, importFileURL, type1, iniLib, tech, currentCells, nodesToExpand, false, job);
            if (libNew == null) {
                System.out.println("Import failed");
                return false;
            }
            if (extension2 != null) {
                String importFileName2 = inputDir + (String)(subLoc == null ? "" : subLoc + "/") + testName + "b" + extension2;
                URL importFileURL2 = TextUtils.makeURLToFile(importFileName2);
                currentCells = new HashMap();
                nodesToExpand = new HashMap();
                ip2.disablePopups = true;
                libNew = Input.importLibrary(ep, ip2, importFileURL2, type2, iniLib, tech, currentCells, nodesToExpand, false, job);
                if (libNew == null) {
                    System.out.println("Import failed");
                    return false;
                }
            }
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                if (lib.getNumCells() == 0 || lib.getName().startsWith(testName)) continue;
                lib.setName(testName + "_" + lib.getName());
            }
            List<Library> allLibraries = ImportForeignTest.getLibsInOrder();
            for (Library l3 : allLibraries) {
                if (l3.getNumCells() == 0) continue;
                Date zeroDate = new Date(0L);
                Iterator<Cell> it2 = l3.getCells();
                while (it2.hasNext()) {
                    Cell cell = it2.next();
                    cell.lowLevelSetCreationDate(zeroDate);
                    cell.lowLevelSetRevisionDate(zeroDate);
                    cell.getDatabase().backup();
                }
                boolean compares = ImportForeignTest.compareLibraryResults(trueRootPath, l3.getName(), l3, new char[]{'H', 'V', 'L', 'R', 'F', 'T', 'O', '#'});
                if (compares) continue;
                System.out.println("ImportForeignTest test '" + testName + "' FAILED");
                return false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        System.out.println("ImportForeignTest test '" + testName + "' PASSED");
        return true;
    }

    private static List<Library> getLibsInOrder() {
        ArrayList<Library> allLibraries = new ArrayList<Library>();
        boolean libsToFind = true;
        while (libsToFind) {
            libsToFind = false;
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                if (lib.isHidden()) continue;
                EDatabase database = lib.getDatabase();
                if (allLibraries.contains(lib)) continue;
                if (lib.getNumCells() != 0) {
                    boolean cleanParents = true;
                    Iterator<Cell> cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = cIt.next();
                        Iterator<CellUsage> uIt = cell.getUsagesOf();
                        while (uIt.hasNext()) {
                            CellUsage cu = uIt.next();
                            Cell parent = cu.getParent(database);
                            Library parentLib = parent.getLibrary();
                            if (parentLib == lib || allLibraries.contains(parentLib)) continue;
                            cleanParents = false;
                            break;
                        }
                        if (cleanParents) continue;
                        break;
                    }
                    if (!cleanParents) continue;
                }
                allLibraries.add(lib);
                libsToFind = true;
            }
        }
        return allLibraries;
    }
}

