/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard2;

import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizardPanel;
import com.sun.electric.tool.user.tecEditWizard2.WizardField;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GenericPanel
extends TechEditWizardPanel {
    private final String name;
    private final String title;
    private final List<String> labels;
    private final List<WizardField> fields;
    private JPanel panel;
    private JLabel image;
    private List<JTextField> ruleValues = new ArrayList<JTextField>();
    private List<JTextField> ruleNames = new ArrayList<JTextField>();

    GenericPanel(TechEditWizard parent, String name, String title, List<String> labels, List<WizardField> fields) {
        super(parent, parent.isModal());
        this.name = name;
        this.title = title;
        this.labels = labels;
        this.fields = fields;
        this.initComponents();
        String imageFileName = name + ".png";
        this.image.setIcon(Resources.getResource(this.getClass(), imageFileName));
        this.pack();
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init() {
        for (int i2 = 0; i2 < this.fields.size(); ++i2) {
            WizardField field = this.fields.get(i2);
            JTextField ruleValue = this.ruleValues.get(i2);
            JTextField ruleName = this.ruleNames.get(i2);
            ruleValue.setText(TextUtils.formatDouble(field.value));
            ruleName.setText(field.rule);
        }
    }

    @Override
    public void term() {
        for (int i2 = 0; i2 < this.fields.size(); ++i2) {
            WizardField field = this.fields.get(i2);
            JTextField ruleValue = this.ruleValues.get(i2);
            JTextField ruleName = this.ruleNames.get(i2);
            field.rule = ruleName.getText();
            field.value = TextUtils.atof(ruleValue.getText());
        }
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(this.getName());
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GenericPanel.this.closeDialog(evt);
            }
        });
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        for (int i2 = 0; i2 < this.fields.size(); ++i2) {
            JLabel jLabel = new JLabel();
            jLabel.setText(this.labels.get(i2));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i2 + 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(1, 4, 1, 0);
            this.panel.add((Component)jLabel, gridBagConstraints);
            JTextField ruleValue = new JTextField();
            this.ruleValues.add(ruleValue);
            ruleValue.setColumns(8);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i2 + 3;
            gridBagConstraints.insets = new Insets(1, 0, 1, 2);
            this.panel.add((Component)ruleValue, gridBagConstraints);
        }
        this.image = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panel.add((Component)this.image, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Distances are in nanometers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.fields.size() + 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 1, 0);
        this.panel.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(this.title);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.panel.add((Component)jLabel6, gridBagConstraints);
        for (int i3 = 0; i3 < this.fields.size(); ++i3) {
            JTextField ruleName = new JTextField();
            this.ruleNames.add(ruleName);
            ruleName.setColumns(8);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = i3 + 3;
            gridBagConstraints.insets = new Insets(1, 2, 1, 2);
            this.panel.add((Component)ruleName, gridBagConstraints);
        }
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Rule Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.panel.add((Component)jLabel7, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panel.add((Component)jLabel8, gridBagConstraints);
        this.getContentPane().add((Component)this.panel, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

