/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.tool.user.tecEditWizard.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardPanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Antenna
extends TechEditWizardPanel {
    private JPanel antenna;
    private JLabel[] metalRatioLabel;
    private JTextField[] metalRatio;
    private JTextField polyRatio;

    public Antenna(TechEditWizard parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Antenna");
        this.setName("");
        this.antenna = new JPanel();
        this.antenna.setLayout(new GridBagLayout());
        JLabel heading = new JLabel("Antenna Ratios");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.antenna.add((Component)heading, gbc);
        JLabel lab = new JLabel("Poly ratio:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.antenna.add((Component)lab, gbc);
        this.polyRatio = new JTextField();
        this.polyRatio.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.antenna.add((Component)this.polyRatio, gbc);
    }

    @Override
    public Component getComponent() {
        return this.antenna;
    }

    @Override
    public String getName() {
        return "Antenna";
    }

    @Override
    public void init() {
        int i2;
        if (this.metalRatioLabel != null) {
            for (i2 = 0; i2 < this.metalRatioLabel.length; ++i2) {
                this.antenna.remove(this.metalRatioLabel[i2]);
            }
        }
        if (this.metalRatio != null) {
            for (i2 = 0; i2 < this.metalRatio.length; ++i2) {
                this.antenna.remove(this.metalRatio[i2]);
            }
        }
        TechEditWizardData data = this.wizard.getTechEditData();
        int numMetals = data.getNumMetalLayers();
        this.metalRatioLabel = new JLabel[numMetals];
        this.metalRatio = new JTextField[numMetals];
        for (int i3 = 0; i3 < numMetals; ++i3) {
            this.metalRatioLabel[i3] = new JLabel("Metal-" + (i3 + 1) + " ratio:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2 + i3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 1, 0);
            this.antenna.add((Component)this.metalRatioLabel[i3], gbc);
            this.metalRatio[i3] = new JTextField();
            this.metalRatio[i3].setText(Double.toString(data.getMetalAntennaRatio()[i3]));
            this.metalRatio[i3].setColumns(8);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2 + i3;
            gbc.insets = new Insets(4, 0, 1, 2);
            this.antenna.add((Component)this.metalRatio[i3], gbc);
        }
        this.polyRatio.setText(Double.toString(data.getPolyAntennaRatio()));
    }

    @Override
    public void term() {
        TechEditWizardData data = this.wizard.getTechEditData();
        int numMetals = data.getNumMetalLayers();
        for (int i2 = 0; i2 < numMetals; ++i2) {
            data.setMetalAntennaRatio(i2, TextUtils.atof(this.metalRatio[i2].getText()));
        }
        data.setPolyAntennaRatio(TextUtils.atof(this.polyRatio.getText()));
    }
}

