/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.tecEdit.TechConversionResult;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LibToTech {
    private TechConversionResult error;
    private static final int TOEDGELEFT = 1;
    private static final int TOEDGERIGHT = 2;
    private static final int TOEDGETOP = 4;
    private static final int TOEDGEBOT = 8;
    private static final int FROMCENTX = 16;
    private static final int FROMCENTY = 32;
    private static final int RATIOCENTX = 64;
    private static final int RATIOCENTY = 128;

    public static void makeTechFromLib() {
        new GenerateTechnology();
    }

    public Technology makeTech(Library lib, String newName, String fileName, TechConversionResult error, EditingPreferences ep) {
        TechFactory techFactory;
        Technology tech;
        this.error = error;
        Object newTechName = newName;
        boolean modified = false;
        while (Technology.findTechnology((String)newTechName) != null) {
            newTechName = (String)newTechName + "X";
            modified = true;
        }
        if (modified) {
            System.out.println("Warning: already a technology called " + newName + ".  Naming this " + (String)newTechName);
        }
        Library[] dependentLibs = Info.getDependentLibraries(lib);
        Cell np = null;
        for (int i2 = dependentLibs.length - 1; i2 >= 0 && (np = dependentLibs[i2].findNodeProto("factors")) == null; --i2) {
        }
        if (np == null) {
            error.markError(null, null, "Cell with general information, called 'factors', is missing");
            return null;
        }
        GeneralInfo gi = this.parseCell(np);
        LayerInfo[] lList = this.extractLayers(dependentLibs);
        if (lList == null) {
            return null;
        }
        ArcInfo[] aList = this.extractArcs(dependentLibs, lList);
        if (aList == null) {
            return null;
        }
        NodeInfo[] nList = this.extractNodes(dependentLibs, lList, aList, ep);
        if (nList == null) {
            return null;
        }
        for (NodeInfo ni : nList) {
            ni.arcsShrink = ni.func.isPin() && !ni.wipes;
        }
        block3: for (int i3 = 0; i3 < lList.length; ++i3) {
            for (int j2 = 0; j2 < nList.length; ++j2) {
                if (nList[j2].func != PrimitiveNode.Function.NODE) continue;
                NodeInfo.LayerDetails nld = nList[j2].nodeLayers[0];
                if (nld.layer != lList[i3]) continue;
                lList[i3].pureLayerNode = nList[j2];
                continue block3;
            }
        }
        Variable var = null;
        Library cLib = Library.getCurrent();
        if (cLib != null) {
            var = cLib.getVar(Info.COMPMENU_KEY);
        }
        if (var != null) {
            String compMenuXML = (String)var.getObject();
            ArrayList<Xml.PrimitiveNodeGroup> nodeGroups = new ArrayList<Xml.PrimitiveNodeGroup>();
            for (int i4 = 0; i4 < nList.length; ++i4) {
                Xml.PrimitiveNodeGroup xng = new Xml.PrimitiveNodeGroup();
                Xml.PrimitiveNode xnp = new Xml.PrimitiveNode();
                xnp.name = nList[i4].name;
                xnp.function = nList[i4].func;
                xng.nodes.add(xnp);
                nodeGroups.add(xng);
            }
            ArrayList<Xml.ArcProto> arcs = new ArrayList<Xml.ArcProto>();
            for (int i5 = 0; i5 < aList.length; ++i5) {
                Xml.ArcProto xap = new Xml.ArcProto();
                xap.name = aList[i5].name;
                arcs.add(xap);
            }
            ArrayList<Xml.PrimitiveNode> pureLayerNodes = new ArrayList<Xml.PrimitiveNode>();
            for (int i6 = 0; i6 < lList.length; ++i6) {
                Xml.PrimitiveNode pln = new Xml.PrimitiveNode();
                pln.name = "node-" + lList[i6].name;
                pureLayerNodes.add(pln);
            }
            gi.menuPalette = Xml.parseComponentMenuXMLTechEdit(compMenuXML, nodeGroups, arcs, pureLayerNodes);
        }
        Xml.Technology t = this.makeXml((String)newTechName, gi, lList, nList, aList);
        URL techUrl = null;
        if (fileName != null) {
            boolean includeDateAndVersion = User.isIncludeDateAndVersionInOutput();
            String copyrightMessage = IOTool.isUseCopyrightMessage() ? IOTool.getCopyrightMessage() : null;
            t.writeXml(fileName, includeDateAndVersion, copyrightMessage);
            techUrl = TextUtils.makeURLToFile(fileName);
        }
        if ((tech = (techFactory = TechFactory.fromXml(techUrl, t)).newInst(Generic.tech())) == null) {
            System.out.println("ERROR creating new technology");
        } else {
            lib.getDatabase().addTech(tech);
            System.out.println("Technology " + tech.getTechName() + " built.");
        }
        return tech;
    }

    private GeneralInfo parseCell(Cell np) {
        GeneralInfo gi = new GeneralInfo();
        Iterator<NodeInst> it = np.getNodes();
        block16: while (it.hasNext()) {
            NodeInst ni = it.next();
            int opt = Manipulate.getOptionOnNode(ni);
            String str = Info.getValueOnNode(ni);
            switch (opt) {
                case 46: {
                    gi.shortName = str;
                    continue block16;
                }
                case 14: {
                    gi.scale = TextUtils.atof(str);
                    gi.scaleRelevant = true;
                    continue block16;
                }
                case 63: {
                    gi.resolution = TextUtils.atof(str);
                    continue block16;
                }
                case 47: {
                    gi.defaultFoundry = str;
                    continue block16;
                }
                case 48: {
                    gi.defaultNumMetals = TextUtils.atoi(str);
                    continue block16;
                }
                case 15: {
                    gi.description = str;
                    continue block16;
                }
                case 38: {
                    gi.minRes = TextUtils.atof(str);
                    continue block16;
                }
                case 39: {
                    gi.minCap = TextUtils.atof(str);
                    continue block16;
                }
                case 49: {
                    gi.maxSeriesResistance = TextUtils.atof(str);
                    continue block16;
                }
                case 42: {
                    gi.gateShrinkage = TextUtils.atof(str);
                    continue block16;
                }
                case 43: {
                    gi.includeGateInResistance = str.equalsIgnoreCase("yes");
                    continue block16;
                }
                case 44: {
                    gi.includeGround = str.equalsIgnoreCase("yes");
                    continue block16;
                }
                case 45: {
                    Color[] colors = GeneralInfo.getTransparentColors(ni);
                    if (colors == null) continue block16;
                    gi.transparentColors = colors;
                    continue block16;
                }
                case 26: {
                    continue block16;
                }
            }
            this.error.markError(ni, np, "Unknown node in miscellaneous-information cell");
        }
        return gi;
    }

    private LayerInfo[] extractLayers(Library[] dependentLibs) {
        Cell[] layerCells = Info.findCellSequence(dependentLibs, "layer-", Info.LAYERSEQUENCE_KEY);
        if (layerCells.length <= 0) {
            System.out.println("No layers found");
            return null;
        }
        LayerInfo[] lis = new LayerInfo[layerCells.length];
        for (int i2 = 0; i2 < layerCells.length; ++i2) {
            lis[i2] = LayerInfo.parseCell(layerCells[i2]);
            if (lis[i2] != null) continue;
            this.error.markError(null, layerCells[i2], "Error parsing layer information");
        }
        return lis;
    }

    private ArcInfo[] extractArcs(Library[] dependentLibs, LayerInfo[] lList) {
        Cell[] arcCells = Info.findCellSequence(dependentLibs, "arc-", Info.ARCSEQUENCE_KEY);
        if (arcCells.length <= 0) {
            System.out.println("No arcs found");
            return null;
        }
        ArcInfo[] allArcs = new ArcInfo[arcCells.length];
        for (int i2 = 0; i2 < arcCells.length; ++i2) {
            Cell np = arcCells[i2];
            allArcs[i2] = ArcInfo.parseCell(np);
            List<Example> neList = Example.getExamples(np, false, this.error, null);
            if (neList == null) {
                return null;
            }
            if (neList.size() > 1) {
                this.error.markError(null, np, "Can only be one drawing of an arc, but more were found");
                return null;
            }
            Example arcEx = neList.get(0);
            Collections.sort(arcEx.samples, new SamplesByLayerOrder(lList));
            double hWid = -1.0;
            int count = 0;
            for (Sample ns : arcEx.samples) {
                double wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                if (ns.layer == null) {
                    hWid = wid;
                    continue;
                }
                ++count;
            }
            if (hWid < 0.0) {
                this.error.markError(null, np, "No highlight layer found");
                return null;
            }
            allArcs[i2].arcDetails = new ArcInfo.LayerDetails[count];
            int layerIndex = 0;
            for (int k2 = 0; k2 < 2; ++k2) {
                for (Sample ns : arcEx.samples) {
                    double wid;
                    if (ns.layer == null) continue;
                    String sampleLayer = ns.layer.getName().substring(6);
                    LayerInfo li = null;
                    for (int j2 = 0; j2 < lList.length; ++j2) {
                        if (!sampleLayer.equals(lList[j2].name)) continue;
                        li = lList[j2];
                        break;
                    }
                    if (li == null) {
                        this.error.markError(ns.node, np, "Unknown layer: " + sampleLayer);
                        return null;
                    }
                    if (k2 == 0 ? li.desc.getTransparentLayer() == 0 : li.desc.getTransparentLayer() != 0) continue;
                    allArcs[i2].arcDetails[layerIndex] = new ArcInfo.LayerDetails();
                    allArcs[i2].arcDetails[layerIndex].layer = li;
                    Poly.Type style = Poly.Type.CLOSED;
                    if (ns.node.getProto() == Artwork.tech().filledBoxNode) {
                        style = Poly.Type.FILLED;
                    }
                    allArcs[i2].arcDetails[layerIndex].style = style;
                    allArcs[i2].arcDetails[layerIndex].width = wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                    ++layerIndex;
                }
            }
        }
        return allArcs;
    }

    private NodeInfo[] extractNodes(Library[] dependentLibs, LayerInfo[] lList, ArcInfo[] aList, EditingPreferences ep) {
        Cell[] nodeCells = Info.findCellSequence(dependentLibs, "node-", Info.NODESEQUENCE_KEY);
        if (nodeCells.length <= 0) {
            System.out.println("No nodes found");
            return null;
        }
        ArrayList<NodeInfo> nList = new ArrayList<NodeInfo>();
        for (int pass = 0; pass < 3; ++pass) {
            for (Cell np : nodeCells) {
                ArrayList<Example> variations;
                List<Example> neList;
                NodeInfo nIn = NodeInfo.parseCell(np);
                if (pass == 0 && !nIn.func.isPin() || pass == 1 && (nIn.func.isPin() || nIn.func == PrimitiveNode.Function.NODE) || pass == 2 && nIn.func != PrimitiveNode.Function.NODE) continue;
                if (nIn.func == PrimitiveNode.Function.NODE) {
                    if (nIn.serp) {
                        this.error.markError(null, np, "Pure layer " + nIn.name + " can not be serpentine");
                        return null;
                    }
                    nIn.specialType = 2;
                }
                if ((neList = Example.getExamples(np, true, this.error, variations = new ArrayList<Example>())) == null || neList.size() == 0) {
                    System.out.println("Cannot analyze " + String.valueOf(np));
                    return null;
                }
                Example firstEx = neList.get(0);
                Collections.sort(firstEx.samples, new SamplesByLayerOrder(lList));
                nIn.xSize = firstEx.hx - firstEx.lx;
                nIn.ySize = firstEx.hy - firstEx.ly;
                nIn.name = np.getName().substring(5);
                nList.add(nIn);
                if (variations.size() > 0) {
                    nIn.primitiveNodeGroupNames = new ArrayList<String>();
                    nIn.primitiveNodeGroupNames.add(nIn.name);
                    block2: for (Example variation : variations) {
                        for (Sample s : variation.samples) {
                            if (s.node.getNameKey().isTempname()) continue;
                            nIn.primitiveNodeGroupNames.add(s.node.getName());
                            continue block2;
                        }
                    }
                }
                if (this.associateExamples(neList, np)) {
                    return null;
                }
                nIn.nodeLayers = this.makePrimitiveNodeLayers(neList, np, lList, variations, ep);
                if (nIn.nodeLayers == null) {
                    return null;
                }
                if (this.fillPrimitivePorts(np, nIn, firstEx, aList)) {
                    return null;
                }
                if (!this.fillSizeOffset(np, firstEx, nIn)) continue;
                return null;
            }
        }
        NodeInfo[] nListArray = new NodeInfo[nList.size()];
        for (int i2 = 0; i2 < nList.size(); ++i2) {
            nListArray[i2] = (NodeInfo)nList.get(i2);
        }
        return nListArray;
    }

    private boolean fillSizeOffset(Cell np, Example firstEx, NodeInfo nIn) {
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        boolean found = false;
        for (Sample ns : firstEx.samples) {
            if (ns.layer != null) continue;
            found = true;
            if (ns.values != null) {
                boolean err = false;
                if (ns.values[0].getX().getMultiplier() == -0.5) {
                    lX = ns.values[0].getX().getAdder().getLambda();
                } else if (ns.values[0].getX().getMultiplier() == 0.5) {
                    lX = nIn.xSize + ns.values[0].getX().getAdder().getLambda();
                } else {
                    err = true;
                }
                if (ns.values[0].getY().getMultiplier() == -0.5) {
                    lY = ns.values[0].getY().getAdder().getLambda();
                } else if (ns.values[0].getY().getMultiplier() == 0.5) {
                    lY = nIn.ySize + ns.values[0].getY().getAdder().getLambda();
                } else {
                    err = true;
                }
                if (ns.values[1].getX().getMultiplier() == 0.5) {
                    hX = -ns.values[1].getX().getAdder().getLambda();
                } else if (ns.values[1].getX().getMultiplier() == -0.5) {
                    hX = nIn.xSize - ns.values[1].getX().getAdder().getLambda();
                } else {
                    err = true;
                }
                if (ns.values[1].getY().getMultiplier() == 0.5) {
                    hY = -ns.values[1].getY().getAdder().getLambda();
                } else if (ns.values[1].getY().getMultiplier() == -0.5) {
                    hY = nIn.ySize - ns.values[1].getY().getAdder().getLambda();
                } else {
                    err = true;
                }
                if (!err) continue;
                this.error.markError(ns.node, np, "Highlighting cannot scale from center");
                return true;
            }
            this.error.markError(ns.node, np, "No rule found for highlight");
            return true;
        }
        if (!found) {
            this.error.markError(null, np, "No highlight found");
            return true;
        }
        if (lX != 0.0 || hX != 0.0 || lY != 0.0 || hY != 0.0) {
            nIn.so = new SizeOffset(lX, hX, lY, hY);
        }
        return false;
    }

    private boolean fillPrimitivePorts(Cell np, NodeInfo nIn, Example firstEx, ArcInfo[] aList) {
        Sample ns;
        NodeInfo.PortDetails nipd;
        int i2;
        Netlist netList = np.getNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock technology generation (network information unavailable).  Please try again");
            return true;
        }
        ArrayList<NodeInfo.PortDetails> ports = new ArrayList<NodeInfo.PortDetails>();
        HashMap<NodeInfo.PortDetails, Sample> portSamples = new HashMap<NodeInfo.PortDetails, Sample>();
        for (Sample ns2 : firstEx.samples) {
            if (ns2.layer != Generic.tech().portNode) continue;
            NodeInfo.PortDetails nipd2 = new NodeInfo.PortDetails();
            portSamples.put(nipd2, ns2);
            nipd2.name = Info.getPortName(ns2.node);
            if (nipd2.name == null) {
                this.error.markError(ns2.node, np, "Port does not have a name");
                return true;
            }
            for (int c2 = 0; c2 < nipd2.name.length(); ++c2) {
                char str = nipd2.name.charAt(c2);
                if (str > ' ' && str < '\u007f') continue;
                this.error.markError(ns2.node, np, "Invalid port name");
                return true;
            }
            nipd2.angle = 0;
            Variable varAngle = ns2.node.getVar(Info.PORTANGLE_KEY);
            if (varAngle != null) {
                nipd2.angle = (Integer)varAngle.getObject();
            }
            nipd2.range = 180;
            Variable varRange = ns2.node.getVar(Info.PORTRANGE_KEY);
            if (varRange != null) {
                nipd2.range = (Integer)varRange.getObject();
            }
            nipd2.values = ns2.values;
            ports.add(nipd2);
        }
        Collections.sort(ports, new PortsByAngleAndName());
        int pol1Port = -1;
        int pol2Port = -1;
        int dif1Port = -1;
        int dif2Port = -1;
        int m1Port1 = -1;
        int m1Port2 = -1;
        int m2Port1 = -1;
        int m2Port2 = -1;
        for (i2 = 0; i2 < ports.size(); ++i2) {
            int j2;
            nipd = (NodeInfo.PortDetails)ports.get(i2);
            ns = (Sample)portSamples.get(nipd);
            nipd.connections = new ArcInfo[0];
            Variable var = ns.node.getVar(Info.CONNECTION_KEY);
            if (var == null) continue;
            CellId[] arcCells = (CellId[])var.getObject();
            ArrayList<ArcInfo> validArcCells = new ArrayList<ArcInfo>();
            block3: for (int j3 = 0; j3 < arcCells.length; ++j3) {
                Cell arcCell;
                if (arcCells[j3] == null || (arcCell = EDatabase.serverDatabase().getCell(arcCells[j3])) == null) continue;
                String cellName = arcCell.getName().substring(4);
                for (int k2 = 0; k2 < aList.length; ++k2) {
                    if (!aList[k2].name.equalsIgnoreCase(cellName)) continue;
                    validArcCells.add(aList[k2]);
                    continue block3;
                }
            }
            ArcInfo[] connections = new ArcInfo[validArcCells.size()];
            nipd.connections = connections;
            for (j2 = 0; j2 < validArcCells.size(); ++j2) {
                connections[j2] = (ArcInfo)validArcCells.get(j2);
            }
            for (j2 = 0; j2 < connections.length; ++j2) {
                ArcProto.Function fun;
                Variable meaningVar = ns.node.getVar(Info.PORTMEANING_KEY);
                int meaning = 0;
                if (meaningVar != null) {
                    meaning = (Integer)meaningVar.getObject();
                }
                if ((fun = connections[j2].func).isPoly() || meaning == 1) {
                    if (pol1Port < 0) {
                        pol1Port = i2;
                    } else if (pol2Port < 0) {
                        pol2Port = i2;
                    }
                } else if (fun.isDiffusion() || meaning == 2) {
                    if (dif1Port < 0) {
                        dif1Port = i2;
                    } else if (dif2Port < 0) {
                        dif2Port = i2;
                    }
                }
                if (fun.isMetal() && fun.getLevel() == 1 || meaning == 1) {
                    if (m1Port1 < 0) {
                        m1Port1 = i2;
                        continue;
                    }
                    if (m1Port2 >= 0) continue;
                    m1Port2 = i2;
                    continue;
                }
                if ((!fun.isMetal() || fun.getLevel() != 2) && meaning != 2) continue;
                if (m2Port1 < 0) {
                    m2Port1 = i2;
                    continue;
                }
                if (m2Port2 >= 0) continue;
                m2Port2 = i2;
            }
        }
        nIn.nodePortDetails = new NodeInfo.PortDetails[ports.size()];
        for (int j4 = 0; j4 < ports.size(); ++j4) {
            nIn.nodePortDetails[j4] = (NodeInfo.PortDetails)ports.get(j4);
        }
        block8: for (i2 = 0; i2 < nIn.nodePortDetails.length; ++i2) {
            nipd = nIn.nodePortDetails[i2];
            ns = (Sample)portSamples.get(nipd);
            nipd.netIndex = i2;
            if (!ns.node.hasConnections()) continue;
            ArcInst ai1 = ns.node.getConnections().next().getArc();
            Network net1 = netList.getNetwork(ai1, 0);
            for (int j5 = 0; j5 < i2; ++j5) {
                ArcInst ai2;
                Network net2;
                NodeInfo.PortDetails onipd = nIn.nodePortDetails[j5];
                Sample oNs = (Sample)portSamples.get(onipd);
                if (!oNs.node.hasConnections() || net1 != (net2 = netList.getNetwork(ai2 = oNs.node.getConnections().next().getArc(), 0))) continue;
                nipd.netIndex = j5;
                continue block8;
            }
        }
        if (nIn.func.isFET()) {
            if (pol1Port < 0 || pol2Port < 0 || dif1Port < 0 || dif2Port < 0) {
                if (m1Port1 >= 0 && m1Port2 >= 0 && m2Port1 >= 0 && m2Port2 >= 0) {
                    pol1Port = m1Port1;
                    pol2Port = m1Port2;
                    dif1Port = m2Port1;
                    dif2Port = m2Port2;
                } else {
                    this.error.markError(null, np, "Need 2 gate (poly/m1) and 2 gated (active/m2) ports on field-effect transistor");
                    return true;
                }
            }
            double x1Pos = (nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder().getLambda() + nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder().getLambda()) / 2.0;
            double x2Pos = (nIn.nodePortDetails[dif2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[0].getX().getAdder().getLambda() + nIn.nodePortDetails[dif2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[1].getX().getAdder().getLambda()) / 2.0;
            double y1Pos = (nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder().getLambda() + nIn.nodePortDetails[dif1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[1].getY().getAdder().getLambda()) / 2.0;
            double y2Pos = (nIn.nodePortDetails[dif2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[0].getY().getAdder().getLambda() + nIn.nodePortDetails[dif2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[1].getY().getAdder().getLambda()) / 2.0;
            if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                if (x1Pos < x2Pos) {
                    int k3 = dif1Port;
                    dif1Port = dif2Port;
                    dif2Port = k3;
                }
            } else if (y1Pos < y2Pos) {
                int k4 = dif1Port;
                dif1Port = dif2Port;
                dif2Port = k4;
            }
            x1Pos = (nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder().getLambda() + nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder().getLambda()) / 2.0;
            x2Pos = (nIn.nodePortDetails[pol2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[0].getX().getAdder().getLambda() + nIn.nodePortDetails[pol2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[1].getX().getAdder().getLambda()) / 2.0;
            y1Pos = (nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder().getLambda() + nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder().getLambda()) / 2.0;
            y2Pos = (nIn.nodePortDetails[pol2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[0].getY().getAdder().getLambda() + nIn.nodePortDetails[pol2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[1].getY().getAdder().getLambda()) / 2.0;
            if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                if (x1Pos > x2Pos) {
                    int k5 = pol1Port;
                    pol1Port = pol2Port;
                    pol2Port = k5;
                }
            } else if (y1Pos > y2Pos) {
                int k6 = pol1Port;
                pol1Port = pol2Port;
                pol2Port = k6;
            }
            ArrayList<NodeInfo.PortDetails> extras = new ArrayList<NodeInfo.PortDetails>();
            for (int j6 = 0; j6 < ports.size(); ++j6) {
                if (j6 == pol1Port || j6 == dif1Port || j6 == pol2Port || j6 == dif2Port) continue;
                extras.add((NodeInfo.PortDetails)ports.get(j6));
            }
            NodeInfo.PortDetails port0 = nIn.nodePortDetails[pol1Port];
            NodeInfo.PortDetails port1 = nIn.nodePortDetails[dif1Port];
            NodeInfo.PortDetails port2 = nIn.nodePortDetails[pol2Port];
            NodeInfo.PortDetails port3 = nIn.nodePortDetails[dif2Port];
            pol1Port = 0;
            nIn.nodePortDetails[0] = port0;
            dif1Port = 1;
            nIn.nodePortDetails[1] = port1;
            pol2Port = 2;
            nIn.nodePortDetails[2] = port2;
            dif2Port = 3;
            nIn.nodePortDetails[3] = port3;
            for (int j7 = 0; j7 < extras.size(); ++j7) {
                nIn.nodePortDetails[j7 + 4] = (NodeInfo.PortDetails)extras.get(j7);
            }
            for (int k7 = 0; k7 < nIn.nodeLayers.length; ++k7) {
                NodeInfo.LayerDetails nld = nIn.nodeLayers[k7];
                if (!nld.layer.fun.isSubstrate()) continue;
                nld.portIndex = -1;
            }
        }
        if (nIn.serp) {
            nIn.specialType = 1;
            int polIndex = -1;
            int difIndex = -1;
            for (int k8 = 0; k8 < nIn.nodeLayers.length; ++k8) {
                int funExtraNew;
                int funExtraOld;
                NodeInfo.LayerDetails nld = nIn.nodeLayers[k8];
                if (nld.layer.fun.isPoly()) {
                    polIndex = k8;
                    continue;
                }
                if (!nld.layer.fun.isDiff() || difIndex >= 0 && ((funExtraOld = nIn.nodeLayers[difIndex].layer.funExtra) == (funExtraNew = nld.layer.funExtra) || funExtraOld == 0)) continue;
                difIndex = k8;
            }
            if (difIndex < 0 || polIndex < 0) {
                this.error.markError(null, np, "No diffusion and polysilicon layers in serpentine transistor");
                return true;
            }
            Sample polNs = nIn.nodeLayers[polIndex].ns;
            ERectangle polNodeBounds = polNs.node.getBounds();
            Sample difNs = nIn.nodeLayers[difIndex].ns;
            ERectangle difNodeBounds = difNs.node.getBounds();
            for (int k9 = 0; k9 < nIn.nodeLayers.length; ++k9) {
                NodeInfo.LayerDetails nld = nIn.nodeLayers[k9];
                Sample ns3 = nld.ns;
                ERectangle nodeBounds = ns3.node.getBounds();
                if (((RectangularShape)polNodeBounds).getWidth() > ((RectangularShape)polNodeBounds).getHeight()) {
                    nld.lWidth = ((RectangularShape)nodeBounds).getMaxY() - (ns3.parent.ly + ns3.parent.hy) / 2.0;
                    nld.rWidth = (ns3.parent.ly + ns3.parent.hy) / 2.0 - ((RectangularShape)nodeBounds).getMinY();
                    nld.extendT = ((RectangularShape)difNodeBounds).getMinX() - ((RectangularShape)nodeBounds).getMinX();
                } else {
                    nld.lWidth = ((RectangularShape)nodeBounds).getMaxX() - (ns3.parent.lx + ns3.parent.hx) / 2.0;
                    nld.rWidth = (ns3.parent.lx + ns3.parent.hx) / 2.0 - ((RectangularShape)nodeBounds).getMinX();
                    nld.extendT = ((RectangularShape)difNodeBounds).getMinY() - ((RectangularShape)nodeBounds).getMinY();
                }
                nld.extendB = nld.extendT;
            }
            NodeInfo.LayerDetails[] addedLayers = new NodeInfo.LayerDetails[nIn.nodeLayers.length + 2];
            for (int k10 = 0; k10 < nIn.nodeLayers.length; ++k10) {
                addedLayers[k10] = nIn.nodeLayers[k10];
            }
            NodeInfo.LayerDetails diff1 = nIn.nodeLayers[difIndex].duplicate();
            NodeInfo.LayerDetails diff2 = nIn.nodeLayers[difIndex].duplicate();
            addedLayers[nIn.nodeLayers.length] = diff1;
            addedLayers[nIn.nodeLayers.length + 1] = diff2;
            nIn.nodeLayers = addedLayers;
            diff2.inLayers = false;
            diff1.inLayers = false;
            nIn.nodeLayers[difIndex].inElectricalLayers = false;
            diff1.portIndex = dif1Port;
            diff2.portIndex = dif2Port;
            nIn.specialValues = new double[6];
            int layerCount = 0;
            for (Sample ns4 : firstEx.samples) {
                if (ns4.values == null || ns4.layer == Generic.tech().portNode || ns4.layer == Generic.tech().cellCenterNode || ns4.layer == null) continue;
                ++layerCount;
            }
            nIn.specialValues[0] = layerCount + 1;
            if (nIn.nodePortDetails[dif1Port].values[0].getX().getAdder().getLambda() > nIn.nodePortDetails[dif1Port].values[0].getY().getAdder().getLambda()) {
                nIn.specialValues[3] = nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder().getLambda() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder().getLambda());
                nIn.specialValues[1] = nIn.xSize * nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder().getLambda() - (nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder().getLambda());
                nIn.specialValues[2] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder().getLambda() - (nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder().getLambda());
                nIn.specialValues[4] = nIn.ySize * nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder().getLambda() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder().getLambda());
                nIn.specialValues[5] = nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder().getLambda() - (nIn.xSize * nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder().getLambda());
                diff1.values[0] = diff1.values[0].withX(new EdgeH(0.0, 0.0));
                diff1.rWidth = 0.0;
                diff2.values[1] = diff2.values[0].withY(new EdgeV(0.0, 0.0));
                diff2.lWidth = 0.0;
            } else {
                nIn.specialValues[3] = nIn.xSize * nIn.nodeLayers[polIndex].values[1].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getX().getAdder().getLambda() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder().getLambda());
                nIn.specialValues[1] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder().getLambda() - (nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder().getLambda());
                nIn.specialValues[2] = nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder().getLambda() - (nIn.xSize * nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder().getLambda());
                nIn.specialValues[4] = nIn.xSize * nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder().getLambda() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder().getLambda());
                nIn.specialValues[5] = nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder().getLambda() - (nIn.ySize * nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder().getLambda());
                diff1.values[0] = diff1.values[0].withX(new EdgeH(0.0, 0.0));
                diff1.rWidth = 0.0;
                diff2.values[1] = diff2.values[1].withX(new EdgeH(0.0, 0.0));
                diff2.lWidth = 0.0;
            }
        }
        return false;
    }

    private NodeInfo.LayerDetails[] makePrimitiveNodeLayers(List<Example> neList, Cell np, LayerInfo[] lis, List<Example> variations, EditingPreferences ep) {
        Example firstEx = neList.get(0);
        if (neList.size() <= 1) {
            return this.makeNodeScaledUniformly(neList, np, lis, null, null);
        }
        ArrayList<NodeInfo.LayerDetails> nodeLayersList = new ArrayList<NodeInfo.LayerDetails>();
        for (Sample ns : firstEx.samples) {
            Technology.TechPoint[] newRule;
            if (ns.layer == Generic.tech().cellCenterNode) continue;
            FixpTransform trans = ns.node.rotateOut();
            Rectangle2D nodeBounds = this.getBoundingBox(ns.node);
            LayerInfo giLayer = null;
            if (ns.layer != null && ns.layer != Generic.tech().portNode) {
                String desiredLayer = ns.layer.getName().substring(6);
                for (int i2 = 0; i2 < lis.length; ++i2) {
                    if (!desiredLayer.equals(lis[i2].name)) continue;
                    giLayer = lis[i2];
                    break;
                }
                if (giLayer == null) {
                    System.out.println("Cannot find layer " + desiredLayer);
                    return null;
                }
            }
            firstEx.studySample = ns;
            NodeInfo.LayerDetails multiRule = null;
            for (int n2 = 1; n2 < neList.size(); ++n2) {
                Example ne = neList.get(n2);
                int total = 0;
                for (Sample nso : ne.samples) {
                    if (nso.assoc != ns) continue;
                    ne.studySample = nso;
                    ++total;
                }
                if (total == 0) {
                    this.error.markError(ns.node, np, "Still unassociated sample (shouldn't happen)");
                    return null;
                }
                if (total <= true) continue;
                if (ns.layer == null || ns.layer == Generic.tech().portNode) {
                    this.error.markError(ns.node, np, "Only contact layers may be iterated in examples");
                    return null;
                }
                multiRule = this.getMultiCutRule(ns, neList, np);
                if (multiRule != null) break;
            }
            if (multiRule != null) {
                multiRule.layer = giLayer;
                nodeLayersList.add(multiRule);
                continue;
            }
            Point2D[] pointList = null;
            int[] pointFactor = null;
            EPoint[] points = null;
            if (ns.node.getProto() == Artwork.tech().filledPolygonNode || ns.node.getProto() == Artwork.tech().closedPolygonNode || ns.node.getProto() == Artwork.tech().openedPolygonNode || ns.node.getProto() == Artwork.tech().openedDottedPolygonNode || ns.node.getProto() == Artwork.tech().openedDashedPolygonNode || ns.node.getProto() == Artwork.tech().openedThickerPolygonNode) {
                points = ns.node.getTrace();
            }
            int trueCount = 0;
            int minFactor = 0;
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i3 = 0; i3 < points.length; ++i3) {
                    pointList[i3] = new Point2D.Double(nodeBounds.getCenterX() + ((Point2D)points[i3]).getX(), nodeBounds.getCenterY() + ((Point2D)points[i3]).getY());
                    trans.transform(pointList[i3], pointList[i3]);
                }
                trueCount = points.length;
            } else {
                double[] angles = null;
                if ((ns.node.getProto() == Artwork.tech().circleNode || ns.node.getProto() == Artwork.tech().thickCircleNode) && (angles = ns.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    trueCount = 3;
                } else if (ns.node.getProto() == Artwork.tech().circleNode || ns.node.getProto() == Artwork.tech().thickCircleNode || ns.node.getProto() == Artwork.tech().filledCircleNode) {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    trueCount = 2;
                } else {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    trueCount = 2;
                }
            }
            double[] pointLeftDist = new double[pointFactor.length];
            double[] pointRightDist = new double[pointFactor.length];
            double[] pointBottomDist = new double[pointFactor.length];
            double[] pointTopDist = new double[pointFactor.length];
            double[] centerXDist = new double[pointFactor.length];
            double[] centerYDist = new double[pointFactor.length];
            double[] pointXRatio = new double[pointFactor.length];
            double[] pointYRatio = new double[pointFactor.length];
            for (int i4 = 0; i4 < pointFactor.length; ++i4) {
                pointLeftDist[i4] = pointList[i4].getX() - firstEx.lx;
                pointRightDist[i4] = firstEx.hx - pointList[i4].getX();
                pointBottomDist[i4] = pointList[i4].getY() - firstEx.ly;
                pointTopDist[i4] = firstEx.hy - pointList[i4].getY();
                centerXDist[i4] = pointList[i4].getX() - (firstEx.lx + firstEx.hx) / 2.0;
                centerYDist[i4] = pointList[i4].getY() - (firstEx.ly + firstEx.hy) / 2.0;
                pointXRatio[i4] = firstEx.hx == firstEx.lx ? 0.0 : (pointList[i4].getX() - (firstEx.lx + firstEx.hx) / 2.0) / (firstEx.hx - firstEx.lx);
                pointYRatio[i4] = firstEx.hy == firstEx.ly ? 0.0 : (pointList[i4].getY() - (firstEx.ly + firstEx.hy) / 2.0) / (firstEx.hy - firstEx.ly);
                pointFactor[i4] = i4 < trueCount ? 255 : 48;
            }
            Point2D[] pointCoords = new Point2D[pointFactor.length];
            for (int n3 = 1; n3 < neList.size(); ++n3) {
                Example ne = neList.get(n3);
                NodeInst ni = ne.studySample.node;
                FixpTransform oTrans = ni.rotateOut();
                Rectangle2D oNodeBounds = this.getBoundingBox(ni);
                EPoint[] oPoints = null;
                if (ni.getProto() == Artwork.tech().filledPolygonNode || ni.getProto() == Artwork.tech().closedPolygonNode || ni.getProto() == Artwork.tech().openedPolygonNode || ni.getProto() == Artwork.tech().openedDottedPolygonNode || ni.getProto() == Artwork.tech().openedDashedPolygonNode || ni.getProto() == Artwork.tech().openedThickerPolygonNode) {
                    oPoints = ni.getTrace();
                }
                int newCount = 2;
                if (oPoints != null) {
                    newCount = oPoints.length;
                    int numPoints = Math.min(trueCount, newCount);
                    int bestOffset = 0;
                    double bestDist = Double.MAX_VALUE;
                    for (int offset = 0; offset < numPoints; ++offset) {
                        double dist = 0.0;
                        for (int i5 = 0; i5 < numPoints; ++i5) {
                            double dX = ((Point2D)points[i5]).getX() - ((Point2D)oPoints[(i5 + offset) % numPoints]).getX();
                            double dY = ((Point2D)points[i5]).getY() - ((Point2D)oPoints[(i5 + offset) % numPoints]).getY();
                            dist += Math.hypot(dX, dY);
                        }
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestOffset = offset;
                    }
                    for (int i6 = 0; i6 < numPoints; ++i6) {
                        pointCoords[i6] = new Point2D.Double(oNodeBounds.getCenterX() + ((Point2D)oPoints[(i6 + bestOffset) % numPoints]).getX(), oNodeBounds.getCenterY() + ((Point2D)oPoints[(i6 + bestOffset) % numPoints]).getY());
                        oTrans.transform(pointCoords[i6], pointCoords[i6]);
                    }
                } else {
                    double[] angles = null;
                    if ((ni.getProto() == Artwork.tech().circleNode || ni.getProto() == Artwork.tech().thickCircleNode) && (angles = ni.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                        angles = null;
                    }
                    if (angles != null) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        double dist = oNodeBounds.getMaxX() - oNodeBounds.getCenterX();
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getCenterX() + dist * Math.cos(angles[0]), oNodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                        oTrans.transform(pointCoords[1], pointCoords[1]);
                    } else if (ni.getProto() == Artwork.tech().circleNode || ni.getProto() == Artwork.tech().thickCircleNode || ni.getProto() == Artwork.tech().filledCircleNode) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getCenterY());
                    } else {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getMinX(), oNodeBounds.getMinY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getMaxY());
                    }
                }
                if (newCount != trueCount) {
                    this.error.markError(ni, np, "Main example of layer " + Info.getSampleName(ne.studySample.layer) + " has " + trueCount + " points but this has " + newCount);
                    return null;
                }
                for (int i7 = 0; i7 < trueCount; ++i7) {
                    if (!DBMath.areEquals(pointLeftDist[i7], pointCoords[i7].getX() - ne.lx)) {
                        int n4 = i7;
                        pointFactor[n4] = pointFactor[n4] & 0xFFFFFFFE;
                    }
                    if (!DBMath.areEquals(pointRightDist[i7], ne.hx - pointCoords[i7].getX())) {
                        int n5 = i7;
                        pointFactor[n5] = pointFactor[n5] & 0xFFFFFFFD;
                    }
                    if (!DBMath.areEquals(pointBottomDist[i7], pointCoords[i7].getY() - ne.ly)) {
                        int n6 = i7;
                        pointFactor[n6] = pointFactor[n6] & 0xFFFFFFF7;
                    }
                    if (!DBMath.areEquals(pointTopDist[i7], ne.hy - pointCoords[i7].getY())) {
                        int n7 = i7;
                        pointFactor[n7] = pointFactor[n7] & 0xFFFFFFFB;
                    }
                    if (!DBMath.areEquals(centerXDist[i7], pointCoords[i7].getX() - (ne.lx + ne.hx) / 2.0)) {
                        int n8 = i7;
                        pointFactor[n8] = pointFactor[n8] & 0xFFFFFFEF;
                    }
                    if (!DBMath.areEquals(centerYDist[i7], pointCoords[i7].getY() - (ne.ly + ne.hy) / 2.0)) {
                        int n9 = i7;
                        pointFactor[n9] = pointFactor[n9] & 0xFFFFFFDF;
                    }
                    double r = 0.0;
                    if (ne.hx != ne.lx) {
                        r = (pointCoords[i7].getX() - (ne.lx + ne.hx) / 2.0) / (ne.hx - ne.lx);
                    }
                    if (!DBMath.areEquals(r, pointXRatio[i7])) {
                        int n10 = i7;
                        pointFactor[n10] = pointFactor[n10] & 0xFFFFFFBF;
                    }
                    if (DBMath.areEquals(r = ne.hy == ne.ly ? 0.0 : (pointCoords[i7].getY() - (ne.ly + ne.hy) / 2.0) / (ne.hy - ne.ly), pointYRatio[i7])) continue;
                    int n11 = i7;
                    pointFactor[n11] = pointFactor[n11] & 0xFFFFFF7F;
                }
                if (ns.layer != Generic.tech().portNode) continue;
                Variable var = ns.node.getVar(Info.PORTANGLE_KEY);
                Variable var2 = ni.getVar(Info.PORTANGLE_KEY);
                if (var == null && var2 != null) {
                    System.out.println("Warning: moving port angle to main example of " + String.valueOf(np));
                    ns.node.newVar(Info.PORTANGLE_KEY, var2.getObject(), ep);
                }
                var = ns.node.getVar(Info.PORTRANGE_KEY);
                var2 = ni.getVar(Info.PORTRANGE_KEY);
                if (var == null && var2 != null) {
                    System.out.println("Warning: moving port range to main example of " + String.valueOf(np));
                    ns.node.newVar(Info.PORTRANGE_KEY, var2.getObject(), ep);
                }
                var = ns.node.getVar(Info.CONNECTION_KEY);
                var2 = ni.getVar(Info.CONNECTION_KEY);
                if (var != null || var2 == null) continue;
                System.out.println("Warning: moving port connections to main example of " + String.valueOf(np));
                ns.node.newVar(Info.CONNECTION_KEY, var2.getObject(), ep);
            }
            if (ns.layer == null) {
                for (int i8 = 0; i8 < trueCount; ++i8) {
                    if ((pointFactor[i8] & 3) != 0 && (pointFactor[i8] & 0xC) != 0) continue;
                    this.error.markError(ns.node, np, "Highlight must be constant distance from edge");
                    return null;
                }
            }
            if ((newRule = this.stretchPoints(pointList, pointFactor, ns, np, neList, neList.get(0))) == null) {
                return null;
            }
            ns.msg = Info.getValueOnNode(ns.node);
            if (ns.msg != null && ns.msg.length() == 0) {
                ns.msg = null;
            }
            ns.values = newRule;
            if (ns.layer == null || ns.layer == Generic.tech().portNode) continue;
            NodeInfo.LayerDetails nild = new NodeInfo.LayerDetails();
            nodeLayersList.add(nild);
            nild.layer = giLayer;
            nild.ns = ns;
            nild.style = this.getStyle(ns.node);
            nild.representation = 0;
            nild.values = this.fixValues(np, ns.values);
            nild.inNodes = null;
            if (nild.values.length == 2 && (nild.style == Poly.Type.CROSSED || nild.style == Poly.Type.FILLED || nild.style == Poly.Type.CLOSED)) {
                nild.representation = 1;
            }
            if (variations.size() <= 0) continue;
            nild.inNodes = new BitSet();
            nild.inNodes.set(0);
            int variationIndex = 1;
            for (Example variation : variations) {
                Sample namedSample = null;
                for (Sample s : variation.samples) {
                    if (s.node.getNameKey().isTempname()) continue;
                    namedSample = s;
                    break;
                }
                Sample mainSample = null;
                for (Sample s : neList.get((int)0).samples) {
                    if (s.layer != namedSample.layer) continue;
                    mainSample = s;
                    break;
                }
                double lX = neList.get((int)0).lx - mainSample.xPos + namedSample.xPos;
                double hX = neList.get((int)0).hx - mainSample.xPos + namedSample.xPos;
                double lY = neList.get((int)0).ly - mainSample.yPos + namedSample.yPos;
                double hY = neList.get((int)0).hy - mainSample.yPos + namedSample.yPos;
                Sample samp = null;
                for (Sample s : variation.samples) {
                    if (s.layer != ns.layer) continue;
                    samp = s;
                    break;
                }
                if (samp != null) {
                    NodeInfo.LayerDetails variationLayer = new NodeInfo.LayerDetails();
                    nodeLayersList.add(variationLayer);
                    variationLayer.layer = giLayer;
                    variationLayer.ns = samp;
                    variationLayer.style = this.getStyle(samp.node);
                    Rectangle2D variationBounds = this.getBoundingBox(samp.node);
                    Technology.TechPoint[] variationRule = new Technology.TechPoint[2];
                    EdgeH horiz = EdgeH.fromLeft(variationBounds.getMinX() - lX);
                    EdgeV vert = EdgeV.fromBottom(variationBounds.getMinY() - lY);
                    variationRule[0] = new Technology.TechPoint(horiz, vert);
                    horiz = EdgeH.fromRight(hX - variationBounds.getMaxX());
                    vert = EdgeV.fromTop(hY - variationBounds.getMaxY());
                    variationRule[1] = new Technology.TechPoint(horiz, vert);
                    variationLayer.values = this.fixValues(np, variationRule);
                    variationLayer.representation = 1;
                    variationLayer.inNodes = new BitSet();
                    variationLayer.inNodes.set(variationIndex);
                }
                ++variationIndex;
            }
        }
        NodeInfo.LayerDetails[] nodeLayers = new NodeInfo.LayerDetails[nodeLayersList.size()];
        for (int i9 = 0; i9 < nodeLayersList.size(); ++i9) {
            nodeLayers[i9] = (NodeInfo.LayerDetails)nodeLayersList.get(i9);
        }
        return nodeLayers;
    }

    private NodeInfo.LayerDetails[] makeNodeScaledUniformly(List<Example> neList, Cell np, LayerInfo[] lis, Example variation, NodeInfo.LayerDetails[] variationDetails) {
        ArrayList<NodeInfo.LayerDetails> nodeLayers = new ArrayList<NodeInfo.LayerDetails>();
        Example firstEx = neList.get(0);
        for (Sample ns : firstEx.samples) {
            if (ns.layer != null && ns.layer != Generic.tech().portNode) {
                LayerInfo cutLayer = null;
                String cutLayerName = ns.layer.getName().substring(6);
                for (int i2 = 0; i2 < lis.length; ++i2) {
                    if (!cutLayerName.equals(lis[i2].name) || !lis[i2].fun.isContact()) continue;
                    cutLayer = lis[i2];
                    break;
                }
                if (cutLayer != null) {
                    boolean copied = false;
                    for (int i3 = 0; i3 < variationDetails.length; ++i3) {
                        if (variationDetails[i3].layer != cutLayer || !variationDetails[i3].multiCut) continue;
                        nodeLayers.add(variationDetails[i3]);
                        copied = true;
                        break;
                    }
                    if (copied) continue;
                }
            }
            Sample samp = ns;
            if (variation != null) {
                for (Sample s : variation.samples) {
                    if (s.layer != ns.layer) continue;
                    samp = s;
                    break;
                }
            }
            Rectangle2D nodeBounds = this.getBoundingBox(samp.node);
            FixpTransform trans = samp.node.rotateOut();
            Point2D[] pointList = null;
            int[] pointFactor = null;
            EPoint[] points = null;
            if (samp.node.getProto() == Artwork.tech().filledPolygonNode || samp.node.getProto() == Artwork.tech().closedPolygonNode || samp.node.getProto() == Artwork.tech().openedPolygonNode || samp.node.getProto() == Artwork.tech().openedDottedPolygonNode || samp.node.getProto() == Artwork.tech().openedDashedPolygonNode || samp.node.getProto() == Artwork.tech().openedThickerPolygonNode) {
                points = samp.node.getTrace();
            }
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i4 = 0; i4 < points.length; ++i4) {
                    pointList[i4] = new Point2D.Double(nodeBounds.getCenterX() + ((Point2D)points[i4]).getX(), nodeBounds.getCenterY() + ((Point2D)points[i4]).getY());
                    trans.transform(pointList[i4], pointList[i4]);
                    pointFactor[i4] = 192;
                }
            } else {
                double[] angles = null;
                if ((samp.node.getProto() == Artwork.tech().circleNode || samp.node.getProto() == Artwork.tech().thickCircleNode) && (angles = samp.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    pointFactor[0] = 48;
                    pointFactor[1] = 192;
                    pointFactor[2] = 192;
                } else if (samp.node.getProto() == Artwork.tech().circleNode || samp.node.getProto() == Artwork.tech().thickCircleNode || samp.node.getProto() == Artwork.tech().filledCircleNode) {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    pointFactor[0] = 48;
                    pointFactor[1] = 34;
                } else {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    pointFactor[0] = 9;
                    pointFactor[1] = 6;
                }
            }
            Technology.TechPoint[] newRule = this.stretchPoints(pointList, pointFactor, samp, np, neList, samp.parent);
            if (newRule == null) {
                return null;
            }
            samp.msg = Info.getValueOnNode(samp.node);
            if (samp.msg != null && samp.msg.length() == 0) {
                samp.msg = null;
            }
            samp.values = newRule;
            if (samp.layer == null || samp.layer == Generic.tech().portNode) continue;
            LayerInfo layer = null;
            String desiredLayer = samp.layer.getName().substring(6);
            for (int i5 = 0; i5 < lis.length; ++i5) {
                if (!desiredLayer.equals(lis[i5].name)) continue;
                layer = lis[i5];
                break;
            }
            if (layer == null) {
                this.error.markError(samp.node, np, "Unknown layer: " + desiredLayer);
                return null;
            }
            NodeInfo.LayerDetails nld = new NodeInfo.LayerDetails();
            nodeLayers.add(nld);
            nld.layer = layer;
            nld.ns = samp;
            nld.style = this.getStyle(samp.node);
            nld.representation = 0;
            nld.values = this.fixValues(np, samp.values);
            if (nld.values.length != 2 || nld.style != Poly.Type.CROSSED && nld.style != Poly.Type.FILLED && nld.style != Poly.Type.CLOSED) continue;
            nld.representation = 1;
        }
        NodeInfo.LayerDetails[] nodeLayerArray = new NodeInfo.LayerDetails[nodeLayers.size()];
        for (int i6 = 0; i6 < nodeLayers.size(); ++i6) {
            nodeLayerArray[i6] = (NodeInfo.LayerDetails)nodeLayers.get(i6);
        }
        return nodeLayerArray;
    }

    private NodeInfo.LayerDetails getMultiCutRule(Sample ns, List<Example> neList, Cell np) {
        Example firstEx = neList.get(0);
        Sample hs = this.needHighlightLayer(firstEx, np);
        if (hs == null) {
            return null;
        }
        ERectangle highlightBounds = hs.node.getBounds();
        ERectangle nodeBounds = ns.node.getBounds();
        double multiXS = DBMath.round(((RectangularShape)nodeBounds).getWidth());
        double multiYS = DBMath.round(((RectangularShape)nodeBounds).getHeight());
        double leftIndent = DBMath.round(((RectangularShape)nodeBounds).getMinX() - ((RectangularShape)highlightBounds).getMinX());
        double rightIndent = DBMath.round(((RectangularShape)highlightBounds).getMaxX() - ((RectangularShape)nodeBounds).getMaxX());
        double topIndent = DBMath.round(((RectangularShape)highlightBounds).getMaxY() - ((RectangularShape)nodeBounds).getMaxY());
        double bottomIndent = DBMath.round(((RectangularShape)nodeBounds).getMinY() - ((RectangularShape)highlightBounds).getMinY());
        double realIndentX = ((RectangularShape)nodeBounds).getMinX() - firstEx.lx + multiXS / 2.0;
        double realIndentY = ((RectangularShape)nodeBounds).getMinY() - firstEx.ly + multiYS / 2.0;
        if (rightIndent != leftIndent || bottomIndent != leftIndent || topIndent != leftIndent) {
            this.error.markError(ns.node, np, "Multiple contact cuts must be indented uniformly (left=" + leftIndent + ", right=" + rightIndent + ", top=" + topIndent + ", bottom=" + bottomIndent + ")");
            return null;
        }
        double multiIndent = leftIndent;
        double xSep = -1.0;
        double ySep = -1.0;
        for (int n2 = 1; n2 < neList.size(); ++n2) {
            double sepY;
            double sepX;
            ERectangle lastNodeBounds;
            ERectangle thisNodeBounds;
            int i2;
            Example ne = neList.get(n2);
            int total = 0;
            for (Sample nso : ne.samples) {
                if (nso.assoc != ns) continue;
                ERectangle oNodeBounds = nso.node.getBounds();
                if (multiXS != ((RectangularShape)oNodeBounds).getWidth() || multiYS != ((RectangularShape)oNodeBounds).getHeight()) {
                    this.error.markError(nso.node, np, "Multiple contact cuts must not differ in size");
                    return null;
                }
                ++total;
            }
            Sample[] nsList = new Sample[total];
            int fill = 0;
            for (Sample nso : ne.samples) {
                if (nso.assoc != ns) continue;
                nsList[fill++] = nso;
            }
            for (i2 = 1; i2 < total; ++i2) {
                thisNodeBounds = nsList[i2].node.getBounds();
                lastNodeBounds = nsList[i2 - 1].node.getBounds();
                sepX = DBMath.round(Math.abs(((RectangularShape)lastNodeBounds).getCenterX() - ((RectangularShape)thisNodeBounds).getCenterX()));
                sepY = DBMath.round(Math.abs(((RectangularShape)lastNodeBounds).getCenterY() - ((RectangularShape)thisNodeBounds).getCenterY()));
                if (sepX < multiXS && sepY < multiYS) {
                    this.error.markError(nsList[i2].node, np, "Multiple contact cuts must not overlap");
                    return null;
                }
                if (sepX >= multiXS) {
                    if (xSep < 0.0) {
                        xSep = sepX;
                    } else if (xSep > sepX) {
                        xSep = sepX;
                    }
                }
                if (!(sepY >= multiYS)) continue;
                if (ySep < 0.0) {
                    ySep = sepY;
                    continue;
                }
                if (!(ySep > sepY)) continue;
                ySep = sepY;
            }
            for (i2 = 1; i2 < total; ++i2) {
                thisNodeBounds = nsList[i2].node.getBounds();
                lastNodeBounds = nsList[i2 - 1].node.getBounds();
                sepX = Math.abs(((RectangularShape)lastNodeBounds).getCenterX() - ((RectangularShape)thisNodeBounds).getCenterX());
                sepY = Math.abs(((RectangularShape)lastNodeBounds).getCenterY() - ((RectangularShape)thisNodeBounds).getCenterY());
                if (sepX / xSep * xSep != sepX) {
                    this.error.markError(nsList[i2].node, np, "Multiple contact cut X spacing must be uniform");
                    return null;
                }
                if (sepY / ySep * ySep == sepY) continue;
                this.error.markError(nsList[i2].node, np, "Multiple contact cut Y spacing must be uniform");
                return null;
            }
        }
        double multiSepX = xSep - multiXS;
        double multiSepY = ySep - multiYS;
        if (multiSepX != multiSepY) {
            this.error.markError(null, np, "Multiple contact cut X and Y spacing must be the same (X=" + multiSepX + ", Y=" + multiSepY + ")");
            return null;
        }
        ns.values = new Technology.TechPoint[2];
        ns.values[0] = new Technology.TechPoint(EdgeH.fromLeft(realIndentX), EdgeV.fromBottom(realIndentY));
        ns.values[1] = new Technology.TechPoint(EdgeH.fromRight(realIndentX), EdgeV.fromTop(realIndentY));
        NodeInfo.LayerDetails multiDetails = new NodeInfo.LayerDetails();
        multiDetails.style = this.getStyle(ns.node);
        multiDetails.representation = 0;
        if (multiDetails.style == Poly.Type.CROSSED || multiDetails.style == Poly.Type.FILLED || multiDetails.style == Poly.Type.CLOSED) {
            multiDetails.representation = 1;
        }
        multiDetails.values = ns.values;
        multiDetails.ns = ns;
        multiDetails.multiCut = true;
        multiDetails.representation = 3;
        multiDetails.multiXS = multiXS;
        multiDetails.multiYS = multiYS;
        multiDetails.multiIndent = multiIndent;
        multiDetails.multiSep = multiSepX;
        multiDetails.multiSep2D = multiSepX;
        return multiDetails;
    }

    private Technology.TechPoint[] stretchPoints(Point2D[] pts, int[] factor, Sample ns, Cell np, List<Example> neList, Example firstEx) {
        Technology.TechPoint[] newRule = new Technology.TechPoint[pts.length];
        for (int i2 = 0; i2 < pts.length; ++i2) {
            EdgeH horiz = null;
            if ((factor[i2] & 1) != 0) {
                horiz = EdgeH.fromLeft(pts[i2].getX() - firstEx.lx);
            } else if ((factor[i2] & 2) != 0) {
                horiz = EdgeH.fromRight(firstEx.hx - pts[i2].getX());
            } else if ((factor[i2] & 0x10) != 0) {
                horiz = EdgeH.fromCenter(pts[i2].getX() - (firstEx.lx + firstEx.hx) / 2.0);
            } else if ((factor[i2] & 0x40) != 0) {
                horiz = firstEx.hx == firstEx.lx ? EdgeH.makeCenter() : new EdgeH((pts[i2].getX() - (firstEx.lx + firstEx.hx) / 2.0) / (firstEx.hx - firstEx.lx), 0.0);
            } else {
                this.error.markStretchProblem(neList, ns, np, pts[i2].getX(), true);
                return null;
            }
            EdgeV vert = null;
            if ((factor[i2] & 8) != 0) {
                vert = EdgeV.fromBottom(pts[i2].getY() - firstEx.ly);
            } else if ((factor[i2] & 4) != 0) {
                vert = EdgeV.fromTop(firstEx.hy - pts[i2].getY());
            } else if ((factor[i2] & 0x20) != 0) {
                vert = EdgeV.fromCenter(pts[i2].getY() - (firstEx.ly + firstEx.hy) / 2.0);
            } else if ((factor[i2] & 0x80) != 0) {
                vert = firstEx.hy == firstEx.ly ? EdgeV.makeCenter() : new EdgeV((pts[i2].getY() - (firstEx.ly + firstEx.hy) / 2.0) / (firstEx.hy - firstEx.ly), 0.0);
            } else {
                this.error.markStretchProblem(neList, ns, np, pts[i2].getY(), false);
                return null;
            }
            newRule[i2] = new Technology.TechPoint(horiz, vert);
        }
        return newRule;
    }

    private Technology.TechPoint[] fixValues(NodeProto np, Technology.TechPoint[] currentList) {
        EdgeH h1 = null;
        EdgeH h2 = null;
        EdgeH h3 = null;
        EdgeV v1 = null;
        EdgeV v2 = null;
        EdgeV v3 = null;
        for (int p = 0; p < currentList.length; ++p) {
            EdgeH h4 = currentList[p].getX();
            if (h4.equals(h1) || h4.equals(h2) || h4.equals(h3)) continue;
            if (h1 == null) {
                h1 = h4;
            } else if (h2 == null) {
                h2 = h4;
            } else {
                h3 = h4;
            }
            EdgeV v = currentList[p].getY();
            if (v.equals(v1) || v.equals(v2) || v.equals(v3)) continue;
            if (v1 == null) {
                v1 = v;
                continue;
            }
            if (v2 == null) {
                v2 = v;
                continue;
            }
            v3 = v;
        }
        if (h1 != null && h2 != null && h3 == null && v1 != null && v2 != null && v3 == null) {
            currentList = new Technology.TechPoint[]{new Technology.TechPoint(h1, v1), new Technology.TechPoint(h2, v2)};
        }
        return currentList;
    }

    private boolean associateExamples(List<Example> neList, Cell np) {
        if (neList.size() <= 1) {
            return false;
        }
        Example firstEx = neList.get(0);
        for (int n2 = 1; n2 < neList.size(); ++n2) {
            Example ne = neList.get(n2);
            for (Sample ns : ne.samples) {
                ns.assoc = null;
            }
            for (Sample ns : ne.samples) {
                if (ns.assoc != null) continue;
                if (ns.layer == Generic.tech().cellCenterNode) {
                    this.error.markError(ns.node, np, "Grab point should only be in main example");
                    return true;
                }
                int total = 0;
                Sample nsFound = null;
                for (Sample nsList2 : firstEx.samples) {
                    if (nsList2.layer != ns.layer) continue;
                    ++total;
                    nsFound = nsList2;
                }
                if (total == 0) {
                    this.error.markError(ns.node, np, "Layer " + Info.getSampleName(ns.layer) + " not found in main example");
                    return true;
                }
                if (total == 1) {
                    ns.assoc = nsFound;
                    continue;
                }
                if (ns.layer == Generic.tech().portNode) {
                    String name = Info.getPortName(ns.node);
                    if (name == null) {
                        this.error.markError(ns.node, np, "Port does not have a name");
                        return true;
                    }
                    boolean found = false;
                    for (Sample sample : firstEx.samples) {
                        if (sample.layer != Generic.tech().portNode) continue;
                        String otherName = Info.getPortName(sample.node);
                        if (otherName == null) {
                            this.error.markError(sample.node, np, "Port does not have a name");
                            return true;
                        }
                        if (!name.equalsIgnoreCase(otherName)) continue;
                        ns.assoc = sample;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.error.markError(null, np, "Could not find port " + name + " in all examples");
                    return true;
                }
                int i2 = 0;
                for (Sample sample : ne.samples) {
                    if (sample.layer != ns.layer) continue;
                    ++i2;
                }
                if (total != i2) {
                    this.error.markError(ns.node, np, "Layer " + Info.getSampleName(ns.layer) + " found " + total + " times in main example, " + i2 + " in others");
                    return true;
                }
                ArrayList<Sample> mainList = new ArrayList<Sample>();
                i2 = 0;
                for (Sample sample : firstEx.samples) {
                    if (sample.layer != ns.layer) continue;
                    mainList.add(sample);
                }
                ArrayList<Sample> arrayList = new ArrayList<Sample>();
                i2 = 0;
                for (Sample nsList5 : ne.samples) {
                    if (nsList5.layer != ns.layer) continue;
                    arrayList.add(nsList5);
                }
                Collections.sort(mainList, new SampleCoordAscending());
                Collections.sort(arrayList, new SampleCoordAscending());
                for (i2 = 1; i2 < total; ++i2) {
                    Sample sample = (Sample)arrayList.get(i2);
                    Sample lastSample = (Sample)arrayList.get(i2 - 1);
                    Sample thisMainSample = (Sample)mainList.get(i2);
                    Sample lastMainSample = (Sample)mainList.get(i2 - 1);
                    if (sample.xPos == lastSample.xPos && sample.yPos == lastSample.yPos && sample.node.getProto() == lastSample.node.getProto() || thisMainSample.xPos == lastMainSample.xPos && thisMainSample.yPos == lastMainSample.yPos && thisMainSample.node.getProto() == lastMainSample.node.getProto()) break;
                }
                if (i2 >= total) {
                    for (i2 = 0; i2 < total; ++i2) {
                        Sample sample = (Sample)arrayList.get(i2);
                        sample.assoc = (Sample)mainList.get(i2);
                    }
                    continue;
                }
                Sample sample = (Sample)arrayList.get(i2);
                this.error.markError(sample.node, np, "Sample " + Info.getSampleName(sample.layer) + " is unassociated");
                return true;
            }
            for (Sample nsList : firstEx.samples) {
                nsList.assoc = null;
            }
            Iterator<Sample> iterator = ne.samples.iterator();
            while (iterator.hasNext()) {
                Sample ns;
                ns.assoc.assoc = ns = iterator.next();
            }
            for (Sample nsList : firstEx.samples) {
                if (nsList.assoc != null || nsList.layer == Generic.tech().cellCenterNode) continue;
                this.error.markError(nsList.node, np, "Layer " + Info.getSampleName(nsList.layer) + " found in main example, but not others");
                return true;
            }
        }
        return false;
    }

    private Poly.Type getStyle(NodeInst ni) {
        Variable var;
        Poly.Type sty = null;
        if (ni.getProto() == Artwork.tech().filledBoxNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech().boxNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech().crossedBoxNode) {
            sty = Poly.Type.CROSSED;
        } else if (ni.getProto() == Artwork.tech().filledPolygonNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech().closedPolygonNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech().openedPolygonNode) {
            sty = Poly.Type.OPENED;
        } else if (ni.getProto() == Artwork.tech().openedDottedPolygonNode) {
            sty = Poly.Type.OPENEDT1;
        } else if (ni.getProto() == Artwork.tech().openedDashedPolygonNode) {
            sty = Poly.Type.OPENEDT2;
        } else if (ni.getProto() == Artwork.tech().openedThickerPolygonNode) {
            sty = Poly.Type.OPENEDT3;
        } else if (ni.getProto() == Artwork.tech().filledCircleNode) {
            sty = Poly.Type.DISC;
        } else if (ni.getProto() == Artwork.tech().circleNode) {
            sty = Poly.Type.CIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.CIRCLEARC;
            }
        } else if (ni.getProto() == Artwork.tech().thickCircleNode) {
            sty = Poly.Type.THICKCIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.THICKCIRCLEARC;
            }
        } else if (ni.getProto() == Generic.tech().invisiblePinNode && (var = ni.getVar(Artwork.ART_MESSAGE)) != null) {
            AbstractTextDescriptor.Position pos = var.getTextDescriptor().getPos();
            if (pos == AbstractTextDescriptor.Position.BOXED) {
                sty = Poly.Type.TEXTBOX;
            } else if (pos == AbstractTextDescriptor.Position.CENT) {
                sty = Poly.Type.TEXTCENT;
            } else if (pos == AbstractTextDescriptor.Position.UP) {
                sty = Poly.Type.TEXTBOT;
            } else if (pos == AbstractTextDescriptor.Position.DOWN) {
                sty = Poly.Type.TEXTTOP;
            } else if (pos == AbstractTextDescriptor.Position.LEFT) {
                sty = Poly.Type.TEXTRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.RIGHT) {
                sty = Poly.Type.TEXTLEFT;
            } else if (pos == AbstractTextDescriptor.Position.UPLEFT) {
                sty = Poly.Type.TEXTBOTRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.UPRIGHT) {
                sty = Poly.Type.TEXTBOTLEFT;
            } else if (pos == AbstractTextDescriptor.Position.DOWNLEFT) {
                sty = Poly.Type.TEXTTOPRIGHT;
            } else if (pos == AbstractTextDescriptor.Position.DOWNRIGHT) {
                sty = Poly.Type.TEXTTOPLEFT;
            }
        }
        if (sty == null) {
            System.out.println("Warning: Cannot determine style to use for " + ni.describe(false) + " node in " + String.valueOf(ni.getParent()) + ", assuming FILLED");
            sty = Poly.Type.FILLED;
        }
        return sty;
    }

    private Rectangle2D getBoundingBox(NodeInst ni) {
        FixpRectangle bounds = ni.getBaseShape().getBounds2D();
        ((Rectangle2D)bounds).setRect(DBMath.round(((RectangularShape)bounds).getMinX()), DBMath.round(((RectangularShape)bounds).getMinY()), DBMath.round(((RectangularShape)bounds).getWidth()), DBMath.round(((RectangularShape)bounds).getHeight()));
        return bounds;
    }

    private Sample needHighlightLayer(Example neList, Cell np) {
        for (Sample ns : neList.samples) {
            if (ns.layer != null) continue;
            return ns;
        }
        this.error.markError(null, np, "No highlight layer on contact");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Xml.Technology makeXml(String newTechName, GeneralInfo gi, LayerInfo[] lList, NodeInfo[] nList, ArcInfo[] aList) {
        void var10_19;
        Xml.Technology t = new Xml.Technology();
        t.techName = newTechName;
        t.shortTechName = gi.shortName;
        t.description = gi.description;
        t.maxNumMetals = t.defaultNumMetals = gi.defaultNumMetals;
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = gi.scale;
        t.scaleRelevant = gi.scaleRelevant;
        t.resolutionValue = gi.resolution;
        t.defaultFoundry = gi.defaultFoundry;
        t.minResistance = gi.minRes;
        t.minCapacitance = gi.minCap;
        if (gi.transparentColors != null) {
            for (int i2 = 0; i2 < gi.transparentColors.length; ++i2) {
                t.transparentLayers.add(gi.transparentColors[i2]);
            }
        }
        for (LayerInfo layerInfo : lList) {
            Xml.Layer layer = new Xml.Layer();
            layer.name = layerInfo.name;
            layer.function = layerInfo.fun;
            layer.extraFunction = layerInfo.funExtra;
            layer.desc = layerInfo.desc;
            layer.thick3D = layerInfo.thick3d;
            layer.height3D = layerInfo.height3d;
            layer.cif = layerInfo.cif;
            layer.resistance = layerInfo.spiRes;
            layer.capacitance = layerInfo.spiCap;
            layer.edgeCapacitance = layerInfo.spiECap;
            layer.inductanceAreaFactor = layerInfo.inductanceAreaFactor;
            layer.inductanceLengthFactor = layerInfo.inductanceLengthFactor;
            if (layerInfo.pureLayerNode != null) {
                layer.pureLayerNode = new Xml.PureLayerNode();
                layer.pureLayerNode.name = layerInfo.pureLayerNode.name;
                layer.pureLayerNode.style = layerInfo.pureLayerNode.nodeLayers[0].style;
                layer.pureLayerNode.port = layerInfo.pureLayerNode.nodePortDetails[0].name;
                layer.pureLayerNode.size.addLambda(DBMath.round(layerInfo.pureLayerNode.xSize));
                for (ArcInfo a2 : layerInfo.pureLayerNode.nodePortDetails[0].connections) {
                    layer.pureLayerNode.portArcs.add(a2.name);
                }
            }
            t.layers.add(layer);
        }
        for (Info info : aList) {
            Xml.ArcProto ap = new Xml.ArcProto();
            ap.name = ((ArcInfo)info).name;
            ap.function = ((ArcInfo)info).func;
            ap.wipable = ((ArcInfo)info).wipes;
            ap.curvable = ((ArcInfo)info).curvable;
            ap.special = ((ArcInfo)info).special;
            ap.notUsed = ((ArcInfo)info).notUsed;
            ap.skipSizeInPalette = ((ArcInfo)info).skipSizeInPalette;
            ap.extended = !((ArcInfo)info).noExtend;
            ap.fixedAngle = ((ArcInfo)info).fixAng;
            ap.angleIncrement = ((ArcInfo)info).angInc;
            ap.antennaRatio = ((ArcInfo)info).antennaRatio;
            for (ArcInfo.LayerDetails al : ((ArcInfo)info).arcDetails) {
                Xml.ArcLayer l2 = new Xml.ArcLayer();
                l2.layer = al.layer.name;
                l2.style = al.style == Poly.Type.FILLED ? Poly.Type.FILLED : Poly.Type.CLOSED;
                l2.extend.addLambda(DBMath.round(al.width / 2.0));
                ap.arcLayers.add(l2);
            }
            t.arcs.add(ap);
        }
        for (Info info : nList) {
            if (((NodeInfo)info).func == PrimitiveNode.Function.NODE && ((NodeInfo)info).nodeLayers[0].layer.pureLayerNode == info) continue;
            Xml.PrimitiveNodeGroup png = new Xml.PrimitiveNodeGroup();
            if (((NodeInfo)info).primitiveNodeGroupNames == null) {
                Xml.PrimitiveNode n2 = new Xml.PrimitiveNode();
                n2.name = ((NodeInfo)info).name;
                n2.function = ((NodeInfo)info).func;
                n2.lowVt = ((NodeInfo)info).lowVt;
                n2.highVt = ((NodeInfo)info).highVt;
                n2.nativeBit = ((NodeInfo)info).nativeBit;
                n2.od18 = ((NodeInfo)info).od18;
                n2.od25 = ((NodeInfo)info).od25;
                n2.od33 = ((NodeInfo)info).od33;
                n2.curvePin = ((NodeInfo)info).curvePin;
                png.nodes.add(n2);
            } else {
                for (String s : ((NodeInfo)info).primitiveNodeGroupNames) {
                    Xml.PrimitiveNode n3 = new Xml.PrimitiveNode();
                    n3.name = s;
                    n3.function = ((NodeInfo)info).func;
                    n3.lowVt = ((NodeInfo)info).lowVt;
                    n3.highVt = ((NodeInfo)info).highVt;
                    n3.nativeBit = ((NodeInfo)info).nativeBit;
                    n3.od18 = ((NodeInfo)info).od18;
                    n3.od25 = ((NodeInfo)info).od25;
                    n3.od33 = ((NodeInfo)info).od33;
                    n3.curvePin = ((NodeInfo)info).curvePin;
                    png.nodes.add(n3);
                }
            }
            png.shrinkArcs = ((NodeInfo)info).arcsShrink;
            png.partialCircle = ((NodeInfo)info).partialCircle;
            png.square = ((NodeInfo)info).square;
            png.canBeZeroSize = ((NodeInfo)info).canBeZeroSize;
            png.wipes = ((NodeInfo)info).wipes;
            png.lockable = ((NodeInfo)info).lockable;
            png.edgeSelect = ((NodeInfo)info).edgeSelect;
            png.skipSizeInPalette = ((NodeInfo)info).skipSizeInPalette;
            png.notUsed = ((NodeInfo)info).notUsed;
            EPoint minFullSize = EPoint.fromLambda(0.5 * ((NodeInfo)info).xSize, 0.5 * ((NodeInfo)info).ySize);
            if (((NodeInfo)info).spiceTemplate != null && !((NodeInfo)info).spiceTemplate.equals("")) {
                png.spiceTemplate = ((NodeInfo)info).spiceTemplate;
            }
            for (int j2 = 0; j2 < ((NodeInfo)info).nodeLayers.length; ++j2) {
                NodeInfo.LayerDetails nl = ((NodeInfo)info).nodeLayers[j2];
                png.nodeLayers.add(this.makeNodeLayerDetails(nl, ((NodeInfo)info).serp, minFullSize));
            }
            for (int j2 = 0; j2 < ((NodeInfo)info).nodePortDetails.length; ++j2) {
                NodeInfo.PortDetails pd = ((NodeInfo)info).nodePortDetails[j2];
                Xml.PrimitivePort pp = new Xml.PrimitivePort();
                pp.name = pd.name;
                pp.portAngle = pd.angle;
                pp.portRange = pd.range;
                pp.portTopology = pd.netIndex;
                EdgeH left = pd.values[0].getX();
                EdgeH right = pd.values[1].getX();
                EdgeV bottom = pd.values[0].getY();
                EdgeV top = pd.values[1].getY();
                pp.lx.k = left.getMultiplier() * 2.0;
                pp.lx.addLambda(left.getAdder().getLambda() + minFullSize.getLambdaX() * left.getMultiplier() * 2.0);
                pp.hx.k = right.getMultiplier() * 2.0;
                pp.hx.addLambda(right.getAdder().getLambda() + minFullSize.getLambdaX() * right.getMultiplier() * 2.0);
                pp.ly.k = bottom.getMultiplier() * 2.0;
                pp.ly.addLambda(bottom.getAdder().getLambda() + minFullSize.getLambdaY() * bottom.getMultiplier() * 2.0);
                pp.hy.k = top.getMultiplier() * 2.0;
                pp.hy.addLambda(top.getAdder().getLambda() + minFullSize.getLambdaY() * top.getMultiplier() * 2.0);
                for (ArcInfo a3 : pd.connections) {
                    pp.portArcs.add(a3.name);
                }
                png.ports.add(pp);
            }
            png.specialType = ((NodeInfo)info).specialType;
            if (png.specialType == 1) {
                png.specialValues = new double[6];
                for (int i3 = 0; i3 < 6; ++i3) {
                    png.specialValues[i3] = ((NodeInfo)info).specialValues[i3];
                }
            }
            if (((NodeInfo)info).nodeSizeRule != null) {
                png.nodeSizeRule = new Xml.NodeSizeRule();
                png.nodeSizeRule.width = ((NodeInfo)info).nodeSizeRule.getWidth();
                png.nodeSizeRule.height = ((NodeInfo)info).nodeSizeRule.getHeight();
                png.nodeSizeRule.rule = ((NodeInfo)info).nodeSizeRule.getRuleName();
            }
            ERectangle base = this.calcBaseRectangle((NodeInfo)info, png.nodeLayers);
            png.baseLX.value = base.getLambdaMinX();
            png.baseHX.value = base.getLambdaMaxX();
            png.baseLY.value = base.getLambdaMinY();
            png.baseHY.value = base.getLambdaMaxY();
            t.nodeGroups.add(png);
        }
        this.addSpiceHeader(t, 1, gi.spiceLevel1Header);
        this.addSpiceHeader(t, 2, gi.spiceLevel2Header);
        this.addSpiceHeader(t, 3, gi.spiceLevel3Header);
        t.menuPalette = gi.menuPalette;
        Xml.Foundry foundry = new Xml.Foundry();
        foundry.name = gi.defaultFoundry;
        LayerInfo[] layerInfoArray = lList;
        int n2 = layerInfoArray.length;
        boolean bl = false;
        while (var10_19 < n2) {
            LayerInfo li = layerInfoArray[var10_19];
            if (li.gds != null && li.gds.length() > 0) {
                foundry.layerGds.put(li.name, li.gds);
            }
            ++var10_19;
        }
        if (gi.conDist != null && gi.unConDist != null) {
            void var10_21;
            int layerTotal = lList.length;
            int ruleIndex = 0;
            boolean bl2 = false;
            while (var10_21 < layerTotal) {
                LayerInfo l1 = lList[var10_21];
                for (void i2 = var10_21; i2 < layerTotal; ++i2) {
                    LayerInfo l2 = lList[i2];
                    double conSpa = gi.conDist[ruleIndex];
                    double uConSpa = gi.unConDist[ruleIndex];
                    if (conSpa > -1.0) {
                        foundry.rules.add(this.makeDesignRule("C" + ruleIndex, l1, l2, DRCTemplate.DRCRuleType.CONSPA, conSpa));
                    }
                    if (uConSpa > -1.0) {
                        foundry.rules.add(this.makeDesignRule("U" + ruleIndex, l1, l2, DRCTemplate.DRCRuleType.UCONSPA, uConSpa));
                    }
                    ++ruleIndex;
                }
                ++var10_21;
            }
        }
        t.foundries.add(foundry);
        return t;
    }

    private ERectangle calcBaseRectangle(NodeInfo ni, List<Xml.NodeLayer> nodeLayers) {
        long ly;
        long hy;
        long lx;
        long hx;
        SizeOffset so = ni.so;
        PrimitiveNode.NodeSizeRule nodeSizeRule = ni.nodeSizeRule;
        if (nodeSizeRule != null) {
            hx = DBMath.lambdaToGrid(0.5 * nodeSizeRule.getWidth());
            lx = -hx;
            hy = DBMath.lambdaToGrid(0.5 * nodeSizeRule.getHeight());
            ly = -hy;
        } else {
            lx = Long.MAX_VALUE;
            hx = Long.MIN_VALUE;
            ly = Long.MAX_VALUE;
            hy = Long.MIN_VALUE;
            for (int i2 = 0; i2 < nodeLayers.size(); ++i2) {
                long y;
                long x;
                Xml.NodeLayer nl = nodeLayers.get(i2);
                if (nl.representation == 1 || nl.representation == 3) {
                    x = DBMath.lambdaToGrid(nl.lx.value);
                    lx = Math.min(lx, x);
                    hx = Math.max(hx, x);
                    x = DBMath.lambdaToGrid(nl.hx.value);
                    lx = Math.min(lx, x);
                    hx = Math.max(hx, x);
                    y = DBMath.lambdaToGrid(nl.ly.value);
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                    y = DBMath.lambdaToGrid(nl.hy.value);
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                    continue;
                }
                if (nl.style == Poly.Type.DISC || nl.style == Poly.Type.CIRCLE) {
                    long v = nl.techPoints.get(1).getX().getAdder().getGrid();
                    lx = Math.min(lx, -v);
                    hx = Math.max(hx, v);
                    ly = Math.min(ly, -v);
                    hy = Math.max(hy, v);
                    continue;
                }
                for (Technology.TechPoint p : nl.techPoints) {
                    x = p.getX().getAdder().getGrid();
                    lx = Math.min(lx, x);
                    hx = Math.max(hx, x);
                    y = p.getY().getAdder().getGrid();
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                }
            }
        }
        if (so != null) {
            lx += so.getLowXGridOffset();
            hx -= so.getHighXGridOffset();
            ly += so.getLowYGridOffset();
            hy -= so.getHighYGridOffset();
        }
        return ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
    }

    private Xml.NodeLayer makeNodeLayerDetails(NodeInfo.LayerDetails nl, boolean isSerp, EPoint correction) {
        Xml.NodeLayer nld = new Xml.NodeLayer();
        nld.layer = nl.layer.name;
        nld.style = nl.style;
        nld.portNum = nl.portIndex;
        nld.inLayers = nl.inLayers;
        nld.inElectricalLayers = nl.inElectricalLayers;
        nld.representation = nl.representation;
        Technology.TechPoint[] points = nl.values;
        if (nld.representation == 1 || nld.representation == 3) {
            nld.lx.k = points[0].getX().getMultiplier() * 2.0;
            nld.lx.addLambda(DBMath.round(points[0].getX().getAdder().getLambda() + correction.getLambdaX() * points[0].getX().getMultiplier() * 2.0));
            nld.hx.k = points[1].getX().getMultiplier() * 2.0;
            nld.hx.addLambda(DBMath.round(points[1].getX().getAdder().getLambda() + correction.getLambdaX() * points[1].getX().getMultiplier() * 2.0));
            nld.ly.k = points[0].getY().getMultiplier() * 2.0;
            nld.ly.addLambda(DBMath.round(points[0].getY().getAdder().getLambda() + correction.getLambdaY() * points[0].getY().getMultiplier() * 2.0));
            nld.hy.k = points[1].getY().getMultiplier() * 2.0;
            nld.hy.addLambda(DBMath.round(points[1].getY().getAdder().getLambda() + correction.getLambdaY() * points[1].getY().getMultiplier() * 2.0));
        } else {
            for (Technology.TechPoint p : points) {
                nld.techPoints.add(this.correction(p, correction));
            }
        }
        nld.sizex = DBMath.round(nl.multiXS);
        nld.sizey = DBMath.round(nl.multiYS);
        nld.sep1d = DBMath.round(nl.multiSep);
        nld.sep2d = DBMath.round(nl.multiSep2D);
        if (isSerp) {
            nld.lWidth = DBMath.round(nl.lWidth);
            nld.rWidth = DBMath.round(nl.rWidth);
            nld.tExtent = DBMath.round(nl.extendT);
            nld.bExtent = DBMath.round(nl.extendB);
        }
        nld.inNodes = nl.inNodes;
        return nld;
    }

    private Technology.TechPoint correction(Technology.TechPoint p, EPoint correction) {
        EdgeH h2 = p.getX();
        EdgeV v = p.getY();
        h2 = new EdgeH(h2.getMultiplier(), h2.getAdder().getLambda() + correction.getLambdaX() * h2.getMultiplier() * 2.0);
        v = new EdgeV(v.getMultiplier(), v.getAdder().getLambda() + correction.getLambdaY() * v.getMultiplier() * 2.0);
        return new Technology.TechPoint(h2, v);
    }

    private void addSpiceHeader(Xml.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml.SpiceHeader spiceHeader = new Xml.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    private DRCTemplate makeDesignRule(String ruleName, LayerInfo l1, LayerInfo l2, DRCTemplate.DRCRuleType type, double value) {
        return new DRCTemplate(ruleName, DRCTemplate.DRCMode.ALL.mode(), type, l1.name, l2.name, new double[]{value}, null, null);
    }

    private static class GenerateTechnology
    extends EDialog {
        private JLabel lab2;
        private JLabel lab3;
        private JTextField renameName;
        private JTextField newName;
        private JCheckBox alsoXML;

        private GenerateTechnology() {
            super((Frame)null, true);
            this.initComponents();
            this.nameChanged();
            this.setVisible(true);
        }

        @Override
        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                new TechFromLibJob(Library.getCurrent(), this.newName.getText(), this.alsoXML.isSelected());
            }
            this.dispose();
        }

        private void nameChanged() {
            String techName = this.newName.getText();
            if (Technology.findTechnology(techName) != null) {
                this.lab2.setEnabled(true);
                this.lab3.setEnabled(true);
                this.renameName.setEnabled(true);
                this.renameName.setEditable(true);
            } else {
                this.lab2.setEnabled(false);
                this.lab3.setEnabled(false);
                this.renameName.setEnabled(false);
                this.renameName.setEditable(false);
            }
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Convert Library to Technology");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Creating new technology:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.newName = new JTextField(Library.getCurrent().getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.newName, gbc);
            this.newName.getDocument().addDocumentListener(new TechNameDocumentListener());
            this.lab2 = new JLabel("Already a technology with this name");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab2, gbc);
            this.lab3 = new JLabel("Rename existing technology to:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab3, gbc);
            this.renameName = new JTextField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.renameName, gbc);
            this.alsoXML = new JCheckBox("Also write XML code");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.alsoXML, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.exit(true);
                }
            });
            this.pack();
        }

        private class TechNameDocumentListener
        implements DocumentListener {
            private TechNameDocumentListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
                GenerateTechnology.this.nameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                GenerateTechnology.this.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                GenerateTechnology.this.nameChanged();
            }
        }
    }

    private static class SamplesByLayerOrder
    implements Comparator<Sample> {
        private LayerInfo[] lList;

        SamplesByLayerOrder(LayerInfo[] lList) {
            this.lList = lList;
        }

        @Override
        public int compare(Sample s1, Sample s2) {
            int i1 = -1;
            if (s1.layer != null && s1.layer != Generic.tech().portNode) {
                String s1Name = s1.layer.getName().substring(6);
                for (int i2 = 0; i2 < this.lList.length; ++i2) {
                    if (!this.lList[i2].name.equals(s1Name)) continue;
                    i1 = i2;
                    break;
                }
            }
            int i2 = -1;
            if (s2.layer != null && s2.layer != Generic.tech().portNode) {
                String s2Name = s2.layer.getName().substring(6);
                for (int i3 = 0; i3 < this.lList.length; ++i3) {
                    if (!this.lList[i3].name.equals(s2Name)) continue;
                    i2 = i3;
                    break;
                }
            }
            return i1 - i2;
        }
    }

    private static class PortsByAngleAndName
    implements Comparator<NodeInfo.PortDetails> {
        private PortsByAngleAndName() {
        }

        @Override
        public int compare(NodeInfo.PortDetails s1, NodeInfo.PortDetails s2) {
            if (s1.angle != s2.angle) {
                return s1.angle - s2.angle;
            }
            return s1.name.compareTo(s2.name);
        }
    }

    private static class SampleCoordAscending
    implements Comparator<Sample> {
        private SampleCoordAscending() {
        }

        @Override
        public int compare(Sample s1, Sample s2) {
            if (s1.xPos != s2.xPos) {
                return (int)(s1.xPos - s2.xPos);
            }
            if (s1.yPos != s2.yPos) {
                return (int)(s1.yPos - s2.yPos);
            }
            return s1.node.getName().compareTo(s2.node.getName());
        }
    }

    private static class TechFromLibJob
    extends Job {
        private Library techLib;
        private String newName;
        private String fileName;
        private TechConversionResult tcr;

        private TechFromLibJob(Library techLib, String newName, boolean alsoXML) {
            super("Make Technology from Technology Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.techLib = techLib;
            this.newName = newName;
            if (alsoXML) {
                this.fileName = OpenFile.chooseOutputFile(FileType.XML, "File for Technology's XML Code", newName + ".xml");
            }
            this.startJob();
        }

        @Override
        public boolean doIt() {
            LibToTech ltt = new LibToTech();
            this.tcr = new TechConversionResult();
            ltt.makeTech(this.techLib, this.newName, this.fileName, this.tcr, this.getEditingPreferences());
            this.fieldVariableChanged("tcr");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.tcr.failed()) {
                this.tcr.showError();
                System.out.println("Failed to convert the library to a technology");
            }
        }
    }
}

