/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.tecEdit.TechConversionResult;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Example
implements Serializable {
    List<Sample> samples = new ArrayList<Sample>();
    Sample studySample;
    double lx;
    double hx;
    double ly;
    double hy;

    public static List<Example> getExamples(Cell np, boolean isNode, TechConversionResult tcr, List<Example> variations) {
        HashMap<NodeInst, Object> nodeExamples = new HashMap<NodeInst, Object>();
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            int funct = Manipulate.getOptionOnNode(ni);
            if (funct == 8 || funct == 18 || funct == 19) continue;
            nodeExamples.put(ni, 0);
        }
        ArrayList<Example> neList = new ArrayList<Example>();
        Iterator<NodeInst> it2 = np.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = it2.next();
            if (nodeExamples.get(ni) != null) continue;
            Example ne = new Example();
            neList.add(ne);
            Poly poly = new Poly(ni.getAnchorCenterX(), ni.getAnchorCenterY(), ni.getLambdaBaseXSize(), ni.getLambdaBaseYSize());
            poly.transform(ni.rotateOut());
            FixpRectangle soFar = poly.getBounds2D();
            boolean gotBBox = false;
            boolean foundOne = true;
            int hCount = 0;
            while (foundOne) {
                Geometric geom;
                foundOne = false;
                ArrayList<NodeInst> sortedNodes = new ArrayList<NodeInst>();
                Iterator<Geometric> oIt = np.searchIterator(soFar);
                while (oIt.hasNext() && (geom = oIt.next()) != null) {
                    if (!(geom instanceof NodeInst)) continue;
                    sortedNodes.add((NodeInst)geom);
                }
                for (NodeInst otherNi : sortedNodes) {
                    Poly oPoly = new Poly(otherNi.getAnchorCenterX(), otherNi.getAnchorCenterY(), otherNi.getLambdaBaseXSize(), otherNi.getLambdaBaseYSize());
                    oPoly.transform(otherNi.rotateOut());
                    FixpRectangle otherRect = oPoly.getBounds2D();
                    if (!DBMath.rectsIntersect(otherRect, soFar)) continue;
                    Object otherAssn = nodeExamples.get(otherNi);
                    if (otherAssn != null) {
                        if (otherAssn instanceof Integer || (Example)otherAssn == ne) continue;
                        String error = "Examples are too close.  Found " + neList.size() + " examples at:";
                        for (Example nee : neList) {
                            error = error + " [" + TextUtils.formatDistance(nee.lx) + "<=X<=" + TextUtils.formatDistance(nee.hx) + " and " + TextUtils.formatDistance(nee.ly) + "<=Y<=" + TextUtils.formatDistance(nee.hy) + "]";
                        }
                        tcr.markError(otherNi, np, error);
                        return null;
                    }
                    nodeExamples.put(otherNi, ne);
                    Sample ns = new Sample();
                    ns.node = otherNi;
                    ns.values = null;
                    ns.msg = null;
                    ns.parent = ne;
                    ne.samples.add(ns);
                    ns.assoc = null;
                    ns.xPos = ((RectangularShape)otherRect).getCenterX();
                    ns.yPos = ((RectangularShape)otherRect).getCenterY();
                    int funct = Manipulate.getOptionOnNode(otherNi);
                    switch (funct) {
                        case 18: {
                            if (!isNode) {
                                tcr.markError(otherNi, np, "Ports can only exist in nodes");
                                return null;
                            }
                            ns.layer = Generic.tech().portNode;
                            break;
                        }
                        case 26: {
                            if (!isNode) {
                                tcr.markError(otherNi, np, "Grab points can only exist in nodes");
                                return null;
                            }
                            ns.layer = Generic.tech().cellCenterNode;
                            break;
                        }
                        case 19: {
                            ++hCount;
                            break;
                        }
                        default: {
                            ns.layer = Manipulate.getLayerCell(otherNi);
                            if (ns.layer != null) break;
                            Manipulate.getLayerCell(otherNi);
                            tcr.markError(otherNi, np, "Node has no layer information");
                            return null;
                        }
                    }
                    if (!Generic.isCellCenter(otherNi)) {
                        if (!gotBBox) {
                            ne.lx = ((RectangularShape)otherRect).getMinX();
                            ne.hx = ((RectangularShape)otherRect).getMaxX();
                            ne.ly = ((RectangularShape)otherRect).getMinY();
                            ne.hy = ((RectangularShape)otherRect).getMaxY();
                            gotBBox = true;
                        } else {
                            if (((RectangularShape)otherRect).getMinX() < ne.lx) {
                                ne.lx = ((RectangularShape)otherRect).getMinX();
                            }
                            if (((RectangularShape)otherRect).getMaxX() > ne.hx) {
                                ne.hx = ((RectangularShape)otherRect).getMaxX();
                            }
                            if (((RectangularShape)otherRect).getMinY() < ne.ly) {
                                ne.ly = ((RectangularShape)otherRect).getMinY();
                            }
                            if (((RectangularShape)otherRect).getMaxY() > ne.hy) {
                                ne.hy = ((RectangularShape)otherRect).getMaxY();
                            }
                        }
                        ((Rectangle2D)soFar).setRect(ne.lx, ne.ly, ne.hx - ne.lx, ne.hy - ne.ly);
                    }
                    foundOne = true;
                }
            }
            if (hCount == 0) {
                tcr.markError(null, np, "No highlight layer found");
                return null;
            }
            if (hCount == true) continue;
            tcr.markError(null, np, "Too many highlight layers found: " + hCount);
            return null;
        }
        if (neList == null) {
            tcr.markError(null, np, "No examples found");
            return neList;
        }
        if (variations != null) {
            block11: for (int i2 = 0; i2 < neList.size(); ++i2) {
                Example e2 = (Example)neList.get(i2);
                for (Sample s : e2.samples) {
                    if (s.node.getNameKey().isTempname()) continue;
                    variations.add(e2);
                    neList.remove(i2);
                    --i2;
                    continue block11;
                }
            }
            if (neList.size() == 0 && variations.size() > 0) {
                tcr.markError(null, np, "All examples have text on them...text should be used only in variations");
                return neList;
            }
        }
        double sizeX = 0.0;
        double sizeY = 0.0;
        double locX = 0.0;
        double locY = 0.0;
        Example bestNe = null;
        for (Example ne : neList) {
            double newSize = ne.hx - ne.lx;
            if (bestNe != null && (newSize > sizeX * sizeY || (newSize *= ne.hy - ne.ly) == sizeX * sizeY && (ne.lx + ne.hx) / 2.0 >= locX && (ne.ly + ne.hy) / 2.0 <= locY)) continue;
            sizeX = ne.hx - ne.lx;
            sizeY = ne.hy - ne.ly;
            locX = (ne.lx + ne.hx) / 2.0;
            locY = (ne.ly + ne.hy) / 2.0;
            bestNe = ne;
        }
        if (bestNe != null && bestNe != neList) {
            neList.remove(bestNe);
            neList.add(0, bestNe);
        }
        return neList;
    }
}

