/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.tool.user.redisplay.ERaster;

public class TransparentRaster
implements ERaster {
    final int[] layerBitMap;
    final int intsPerRow;

    TransparentRaster(int intsPerRow, int[] layerBitMap) {
        this.layerBitMap = layerBitMap;
        this.intsPerRow = intsPerRow;
    }

    public TransparentRaster(int numIntsPerRow, int height) {
        this.intsPerRow = numIntsPerRow;
        this.layerBitMap = new int[height * numIntsPerRow];
    }

    @Override
    public void fillBox(int lX, int hX, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            for (int y = lY; y < hY; ++y) {
                int n2 = lIndex;
                this.layerBitMap[n2] = this.layerBitMap[n2] | mask;
                lIndex += this.intsPerRow;
            }
        } else {
            int lMask = -(1 << (lX & 0x1F));
            int hMask = (2 << (hX & 0x1F)) - 1;
            for (int y = lY; y <= hY; ++y) {
                int n3 = lIndex;
                this.layerBitMap[n3] = this.layerBitMap[n3] | lMask;
                for (int index = lIndex + 1; index < hIndex; ++index) {
                    this.layerBitMap[index] = -1;
                }
                int n4 = hIndex;
                this.layerBitMap[n4] = this.layerBitMap[n4] | hMask;
                lIndex += this.intsPerRow;
                hIndex += this.intsPerRow;
            }
        }
    }

    public void eraseBox(int lX, int hX, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            mask ^= 0xFFFFFFFF;
            for (int y = lY; y < hY; ++y) {
                int n2 = lIndex;
                this.layerBitMap[n2] = this.layerBitMap[n2] & mask;
                lIndex += this.intsPerRow;
            }
        } else {
            int lMask = -(1 << (lX & 0x1F));
            int hMask = (2 << (hX & 0x1F)) - 1;
            lMask ^= 0xFFFFFFFF;
            hMask ^= 0xFFFFFFFF;
            for (int y = lY; y <= hY; ++y) {
                int n3 = lIndex;
                this.layerBitMap[n3] = this.layerBitMap[n3] & lMask;
                for (int index = lIndex + 1; index < hIndex; ++index) {
                    this.layerBitMap[index] = 0;
                }
                int n4 = hIndex;
                this.layerBitMap[n4] = this.layerBitMap[n4] & hMask;
                lIndex += this.intsPerRow;
                hIndex += this.intsPerRow;
            }
        }
    }

    public void eraseAll() {
        for (int i2 = 0; i2 < this.layerBitMap.length; ++i2) {
            this.layerBitMap[i2] = 0;
        }
    }

    @Override
    public void fillHorLine(int y, int lX, int hX) {
        int baseIndex = y * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int n2 = lIndex;
            this.layerBitMap[n2] = this.layerBitMap[n2] | (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
        } else {
            int n3 = lIndex++;
            this.layerBitMap[n3] = this.layerBitMap[n3] | -(1 << (lX & 0x1F));
            while (lIndex < hIndex) {
                int n4 = lIndex++;
                this.layerBitMap[n4] = this.layerBitMap[n4] | 0xFFFFFFFF;
            }
            int n5 = hIndex;
            this.layerBitMap[n5] = this.layerBitMap[n5] | (2 << (hX & 0x1F)) - 1;
        }
    }

    @Override
    public void fillVerLine(int x, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow + (x >> 5);
        int mask = 1 << (x & 0x1F);
        for (int y = lY; y <= hY; ++y) {
            int n2 = baseIndex;
            this.layerBitMap[n2] = this.layerBitMap[n2] | mask;
            baseIndex += this.intsPerRow;
        }
    }

    @Override
    public void fillPoint(int x, int y) {
        int n2 = y * this.intsPerRow + (x >> 5);
        this.layerBitMap[n2] = this.layerBitMap[n2] | 1 << (x & 0x1F);
    }

    @Override
    public void drawHorLine(int y, int lX, int hX) {
        int baseIndex = y * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int n2 = lIndex;
            this.layerBitMap[n2] = this.layerBitMap[n2] | (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
        } else {
            int n3 = lIndex++;
            this.layerBitMap[n3] = this.layerBitMap[n3] | -(1 << (lX & 0x1F));
            while (lIndex < hIndex) {
                int n4 = lIndex++;
                this.layerBitMap[n4] = this.layerBitMap[n4] | 0xFFFFFFFF;
            }
            int n5 = hIndex;
            this.layerBitMap[n5] = this.layerBitMap[n5] | (2 << (hX & 0x1F)) - 1;
        }
    }

    @Override
    public void drawVerLine(int x, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow + (x >> 5);
        int mask = 1 << (x & 0x1F);
        for (int y = lY; y <= hY; ++y) {
            int n2 = baseIndex;
            this.layerBitMap[n2] = this.layerBitMap[n2] | mask;
            baseIndex += this.intsPerRow;
        }
    }

    @Override
    public void drawPoint(int x, int y) {
        int n2 = y * this.intsPerRow + (x >> 5);
        this.layerBitMap[n2] = this.layerBitMap[n2] | 1 << (x & 0x1F);
    }

    @Override
    public EGraphics.Outline getOutline() {
        return null;
    }

    @Override
    public void copyBits(TransparentRaster src, int minSrcX, int maxSrcX, int minSrcY, int maxSrcY, int dx, int dy) {
        int[] srcLayerBitMap = src.layerBitMap;
        int minDestX = minSrcX + dx;
        int maxDestX = maxSrcX + dx;
        int minDestY = minSrcY + dy;
        int leftShift = dx & 0x1F;
        int rightShift = 32 - leftShift;
        int srcBaseIndex = minSrcY * src.intsPerRow + (minSrcX >> 5);
        int destBaseIndex = minDestY * this.intsPerRow + (minDestX >> 5);
        int numDestInts = (maxDestX >> 5) - (minDestX >> 5);
        if (numDestInts == 0) {
            int destMask = (2 << (maxDestX & 0x1F)) - (1 << (minDestX & 0x1F));
            if (minSrcX >> 5 != maxSrcX >> 5) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int s0 = srcLayerBitMap[srcBaseIndex];
                    int s1 = srcLayerBitMap[srcBaseIndex + 1];
                    int v = (s0 >>> rightShift | s1 << leftShift) & destMask;
                    if (v != 0) {
                        int n2 = destBaseIndex;
                        this.layerBitMap[n2] = this.layerBitMap[n2] | v;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            } else if ((minDestX & 0x1F) >= (minSrcX & 0x1F)) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int s = srcLayerBitMap[srcBaseIndex];
                    int v = s << leftShift & destMask;
                    if (v != 0) {
                        int n3 = destBaseIndex;
                        this.layerBitMap[n3] = this.layerBitMap[n3] | v;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            } else {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int s = srcLayerBitMap[srcBaseIndex];
                    int v = s >>> rightShift & destMask;
                    if (v != 0) {
                        int n4 = destBaseIndex;
                        this.layerBitMap[n4] = this.layerBitMap[n4] | v;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            }
        } else {
            int minDestMask = -(1 << (minDestX & 0x1F));
            int maxDestMask = (2 << (maxDestX & 0x1F)) - 1;
            int srcIncr = src.intsPerRow - (maxSrcX >> 5) + (minSrcX >> 5) - 1;
            if (leftShift == 0) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int vf;
                    int v0;
                    assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                    assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                    if ((v0 = srcLayerBitMap[srcBaseIndex++] & minDestMask) != 0) {
                        int n5 = destBaseIndex;
                        this.layerBitMap[n5] = this.layerBitMap[n5] | v0;
                    }
                    ++destBaseIndex;
                    for (int i2 = 1; i2 < numDestInts; ++i2) {
                        int v;
                        if ((v = srcLayerBitMap[srcBaseIndex++]) != 0) {
                            int n6 = destBaseIndex;
                            this.layerBitMap[n6] = this.layerBitMap[n6] | v;
                        }
                        ++destBaseIndex;
                    }
                    if ((vf = srcLayerBitMap[srcBaseIndex++] & maxDestMask) != 0) {
                        int n7 = destBaseIndex;
                        this.layerBitMap[n7] = this.layerBitMap[n7] | vf;
                    }
                    srcBaseIndex += srcIncr;
                    destBaseIndex += this.intsPerRow - numDestInts;
                }
            } else if (numDestInts == 2 && minSrcX >> 5 == maxSrcX >> 5) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int vf;
                    assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                    assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                    int s = srcLayerBitMap[srcBaseIndex];
                    int v0 = s << leftShift & minDestMask;
                    if (v0 != 0) {
                        int n8 = destBaseIndex;
                        this.layerBitMap[n8] = this.layerBitMap[n8] | v0;
                    }
                    if ((vf = s >>> rightShift & maxDestMask) != 0) {
                        int n9 = destBaseIndex + 1;
                        this.layerBitMap[n9] = this.layerBitMap[n9] | vf;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            } else {
                boolean minSrcPair = leftShift > (minDestX & 0x1F);
                boolean maxSrcPair = leftShift <= (maxDestX & 0x1F);
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int b0;
                    int v0;
                    assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                    assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                    int s = minSrcPair ? srcLayerBitMap[srcBaseIndex++] : 0;
                    if ((v0 = (s >>> rightShift | (b0 = srcLayerBitMap[srcBaseIndex++]) << leftShift) & minDestMask) != 0) {
                        int n10 = destBaseIndex;
                        this.layerBitMap[n10] = this.layerBitMap[n10] | v0;
                    }
                    ++destBaseIndex;
                    s = b0;
                    for (int i3 = 1; i3 < numDestInts; ++i3) {
                        int b2;
                        int v;
                        if ((v = s >>> rightShift | (b2 = srcLayerBitMap[srcBaseIndex++]) << leftShift) != 0) {
                            int n11 = destBaseIndex;
                            this.layerBitMap[n11] = this.layerBitMap[n11] | v;
                        }
                        ++destBaseIndex;
                        s = b2;
                    }
                    int bf = maxSrcPair ? srcLayerBitMap[srcBaseIndex++] : 0;
                    int vf = (s >>> rightShift | bf << leftShift) & maxDestMask;
                    if (vf != 0) {
                        int n12 = destBaseIndex;
                        this.layerBitMap[n12] = this.layerBitMap[n12] | vf;
                    }
                    srcBaseIndex += srcIncr;
                    destBaseIndex += this.intsPerRow - numDestInts;
                }
            }
        }
    }
}

