/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.tool.ncc.result.equivalence.Equivalence;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.HighlightTools;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class HighlightEquivalent {
    private static void prln(String s) {
        System.out.println(s);
    }

    private void highlightEquivalentNet(Network n2, Equivalence e2, CellContext cc) {
        HighlightEquivalent.prln("Finding equivalent of Network: " + n2.describe(false));
        HierarchyEnumerator.NetNameProxy eqProx = e2.findEquivalentNetShortingResistors(cc.context, n2);
        if (eqProx == null) {
            HighlightEquivalent.prln("Can't find an equivalent network.");
            return;
        }
        VarContext eqCtxt = eqProx.getContext();
        Cell eqCell = eqProx.leafCell();
        Highlighter h2 = HighlightTools.getHighlighter(eqCell, eqCtxt);
        HighlightTools.highlightNetNamed(h2, eqCell, eqProx.leafName());
    }

    private Network selectNet(Set<Network> netSet) {
        ArrayList<Network> nets = new ArrayList<Network>(netSet);
        if (nets.size() == 1) {
            return (Network)nets.get(0);
        }
        HashMap<String, Network> nameToNet = new HashMap<String, Network>();
        Object[] names = new String[nets.size()];
        int i2 = 0;
        for (Network n2 : nets) {
            String netNm = n2.getName();
            nameToNet.put(netNm, n2);
            names[i2++] = netNm;
        }
        Arrays.sort(names, new NameCompare());
        String name = (String)JOptionPane.showInputDialog(null, "Select the Network you want to find the match of", "Select Network:", -1, null, names, names[0]);
        if (name == null) {
            return null;
        }
        return (Network)nameToNet.get(name);
    }

    private void highlightEquivOfNet(Set<Network> nets, Equivalence e2, CellContext cc) {
        Network n2 = this.selectNet(nets);
        if (n2 == null) {
            return;
        }
        this.highlightEquivalentNet(n2, e2, cc);
    }

    private List<Nodable> findNodablesFrom(NodeInst ni) {
        ArrayList<Nodable> nodables = new ArrayList<Nodable>();
        Cell c2 = ni.getParent();
        Iterator<Nodable> it = c2.getNetlist(NccNetlist.SHORT_RESISTORS).getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (no.getNodeInst() != ni) continue;
            nodables.add(no);
        }
        return nodables;
    }

    private Nodable selectNodable(List<Nodable> nodes) {
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        HashMap<String, Nodable> nameToNode = new HashMap<String, Nodable>();
        Object[] names = new String[nodes.size()];
        int i2 = 0;
        for (Nodable n2 : nodes) {
            String nodeNm = n2.getName();
            nameToNode.put(nodeNm, n2);
            names[i2++] = nodeNm;
        }
        Arrays.sort(names, new NameCompare());
        String name = (String)JOptionPane.showInputDialog(null, "Select the Instance you want to find the match of", "Select Instance:", -1, null, names, names[0]);
        if (name == null) {
            return null;
        }
        return (Nodable)nameToNode.get(name);
    }

    private void highlightEquivOfNodeInst(NodeInst ni, Equivalence e2, CellContext cc) {
        HighlightEquivalent.prln("Find the equivalent of NodeInst: " + ni.describe(false));
        List<Nodable> nodables = this.findNodablesFrom(ni);
        Job.error(nodables.size() == 0, "No Nodable for NodeInst?");
        Nodable node = this.selectNodable(nodables);
        if (node == null) {
            return;
        }
        HierarchyEnumerator.NodableNameProxy eqProx = e2.findEquivalentNode(cc.context, node);
        if (eqProx == null) {
            HighlightEquivalent.prln(" No equivalent Node found.");
            return;
        }
        Nodable eqNo = eqProx.getNodable();
        NodeInst eqNi = eqNo instanceof NodeInst ? (NodeInst)eqNo : eqNo.getNodeInst();
        Cell eqCell = eqProx.leafCell();
        VarContext eqCtxt = eqProx.getContext();
        Highlighter h2 = HighlightTools.getHighlighter(eqCell, eqCtxt);
        h2.addElectricObject(eqNi, eqCell);
    }

    private void highlightEquivOfGeometric(List<Geometric> geoms, Equivalence e2, CellContext cc) {
        Geometric g2 = geoms.iterator().next();
        if (!(g2 instanceof NodeInst)) {
            HighlightEquivalent.prln("Highlighted object is not a nodeInst: ");
            g2.getInfo();
            return;
        }
        this.highlightEquivOfNodeInst((NodeInst)g2, e2, cc);
    }

    private void highlight1() {
        NccResults results = NccJob.getLastNccResults();
        if (results == null) {
            HighlightEquivalent.prln("No saved NCC results.  Please run NCC first.");
            return;
        }
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.needCurrentEditWindow_();
        if (wnd == null) {
            HighlightEquivalent.prln("No current Window");
            return;
        }
        CellContext cc = NccUtils.getCellContext(wnd);
        NccResult r = results.getResultFromRootCells();
        Equivalence e2 = r.getEquivalence();
        List<Geometric> geoms = wnd.getHighlightedEObjs(true, false);
        if (geoms.size() > 0) {
            this.highlightEquivOfGeometric(geoms, e2, cc);
            return;
        }
        Set<Network> nets = wnd.getHighlightedNetworks();
        if (nets.size() > 0) {
            this.highlightEquivOfNet(nets, e2, cc);
            return;
        }
        HighlightEquivalent.prln("No arc or node is selected");
    }

    private HighlightEquivalent() {
        this.highlight1();
    }

    public static void highlight() {
        new HighlightEquivalent();
    }

    private static class NameCompare
    implements Comparator<String> {
        private NameCompare() {
        }

        @Override
        public int compare(String nm1, String nm2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(nm1, nm2);
        }
    }
}

