/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public abstract class EMenuItem
implements ActionListener {
    public static final EMenuItem[] NULL_ARRAY = new EMenuItem[0];
    private static final int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    public static final EMenuItem SEPARATOR = new EMenuItem("---------------"){

        @Override
        void registerTree(EMenuBar menuBar, int[] parentPath, int indexInParent) {
        }

        @Override
        public JMenuItem genMenu() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException();
        }
    };
    private static EMenuItem lastActivated = null;
    private final String text;
    private final Icon icon;
    private final int mnemonicsPos;
    private KeyStroke[] accelerators;
    EMenuBar menuBar;
    int[] path;

    EMenuItem(String text, KeyStroke[] accelerators, boolean useMnemonics, Icon icon) {
        int mnemonicsPos = text.indexOf(95);
        if (mnemonicsPos == text.length() - 1 || !useMnemonics) {
            mnemonicsPos = -1;
        }
        this.mnemonicsPos = mnemonicsPos;
        String string = this.text = mnemonicsPos >= 0 ? text.substring(0, mnemonicsPos) + text.substring(mnemonicsPos + 1) : text;
        if (accelerators == null) {
            accelerators = new KeyStroke[]{};
        }
        this.accelerators = accelerators;
        this.icon = icon;
    }

    EMenuItem(String text, KeyStroke[] accelerators, boolean useMnemonics) {
        this(text, accelerators, useMnemonics, null);
    }

    EMenuItem(String text, KeyStroke[] accelerators) {
        this(text, accelerators, true);
    }

    EMenuItem(String text, KeyStroke accelerator, KeyStroke accelerator2) {
        this(text, new KeyStroke[]{accelerator, accelerator2});
    }

    public EMenuItem(String text, KeyStroke accelerator) {
        this(text, new KeyStroke[]{accelerator});
    }

    public EMenuItem(String text) {
        this(text, new KeyStroke[0]);
    }

    public EMenuItem(String text, Icon icon) {
        this(text, new KeyStroke[0], true, icon);
    }

    public EMenuItem(String text, char acceleratorChar) {
        this(text, EMenuItem.shortcut(acceleratorChar));
    }

    EMenuItem(String text, char acceleratorChar, int keyCode) {
        this(text, new KeyStroke[]{EMenuItem.shortcut(acceleratorChar), EMenuItem.shortcut(keyCode)});
    }

    EMenuItem(String text, int[] keyCodes) {
        this(text, EMenuItem.shortcut(keyCodes));
    }

    public static KeyStroke[] shortcut(int[] keyCode) {
        KeyStroke[] strokes = new KeyStroke[keyCode.length];
        for (int i2 = 0; i2 < keyCode.length; ++i2) {
            strokes[i2] = EMenuItem.shortcut(keyCode[i2]);
        }
        return strokes;
    }

    public static KeyStroke shortcut(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, buckyBit);
    }

    public static void repeatLastCommand() {
        if (lastActivated != null) {
            lastActivated.run();
        }
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        Object s = this.text;
        if (this.getAccelerator() != null) {
            s = (String)s + "(" + KeyStrokePair.keyStrokeToString(this.getAccelerator()) + ")";
        }
        return s;
    }

    KeyStroke getAccelerator() {
        if (this.accelerators.length > 0) {
            return this.accelerators[0];
        }
        return null;
    }

    KeyStroke[] getAccelerators() {
        return this.accelerators;
    }

    void setAccelerator(KeyStroke accelerator) {
        if (this.getAccelerator() == accelerator) {
            return;
        }
        if (this.accelerators.length < 1) {
            this.accelerators = new KeyStroke[1];
        }
        this.accelerators[0] = accelerator;
        for (EMenuBar.Instance menuBarInstance : TopLevel.getMenuBars()) {
            JMenuItem item;
            if (menuBarInstance == null || (item = menuBarInstance.findMenuItem(this.path)) == null) continue;
            item.setAccelerator(accelerator);
        }
    }

    public String toString() {
        return this.text;
    }

    public String getDescription() {
        return this.path != null ? this.menuBar.getDescription(this.path) : this.text;
    }

    public int[] getPath() {
        return this.path;
    }

    void registerTree(EMenuBar menuBar, int[] parentPath, int indexInParent) {
        if (this.menuBar != null || this.path != null) {
            throw new IllegalStateException("EMenuItem " + String.valueOf(this) + " referenced twice");
        }
        this.menuBar = menuBar;
        this.path = new int[parentPath.length + 1];
        System.arraycopy(parentPath, 0, this.path, 0, parentPath.length);
        this.path[parentPath.length] = indexInParent;
        this.registerItem();
    }

    protected void registerItem() {
        this.menuBar.registerKeyBindings(this);
    }

    protected void registerUpdatable() {
        this.menuBar.registerUpdatable(this);
    }

    JMenuItem genMenu() {
        JMenuItem item = this.createMenuItem();
        item.setText(this.text);
        if (this.mnemonicsPos >= 0) {
            item.setMnemonic(this.text.charAt(this.mnemonicsPos));
            item.setDisplayedMnemonicIndex(this.mnemonicsPos);
        }
        if (this.getAccelerator() != null) {
            item.setAccelerator(this.getAccelerator());
        }
        item.addActionListener(this);
        this.updateMenuItem(item);
        return item;
    }

    protected JMenuItem createMenuItem() {
        return this.icon == null ? new JMenuItem() : new JMenuItem(this.icon);
    }

    protected void updateMenuItem(JMenuItem item) {
        item.setEnabled(this.isEnabled());
        item.setSelected(this.isSelected());
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSelected() {
        return false;
    }

    public char getMnemonicChar() {
        if (this.mnemonicsPos < 0) {
            return '\u0000';
        }
        return this.text.charAt(this.mnemonicsPos);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        UserInterfaceMain.userCommandIssued();
        ActivityLogger.logMenuActivated(this.getDescription());
        if (!this.text.startsWith("Repeat Last")) {
            lastActivated = this;
        }
        this.run();
        this.updateButtons();
    }

    public abstract void run();

    protected void updateButtons() {
        this.menuBar.updateAllButtons();
    }

    void updateJMenuItems() {
        for (EMenuBar.Instance menuBarInstance : TopLevel.getMenuBars()) {
            this.updateMenuItem(menuBarInstance.findMenuItem(this.path));
        }
    }

    public static abstract class CheckBox
    extends EMenuItem {
        public CheckBox(String text) {
            super(text);
        }

        @Override
        public void run() {
            this.setSelected(!this.isSelected());
        }

        public abstract void setSelected(boolean var1);

        @Override
        protected JMenuItem createMenuItem() {
            return new JCheckBoxMenuItem();
        }

        @Override
        protected void registerItem() {
            super.registerItem();
            this.registerUpdatable();
        }
    }
}

