/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ParasiticTab
extends PreferencePanel {
    private JList layerList;
    private DefaultListModel layerListModel;
    private boolean changing;
    private JCheckBox backannotateLayout;
    private JTextField capacitance;
    private JTextField edgeCapacitance;
    private ButtonGroup exemptedNetsGroup;
    private JCheckBox extractC;
    private JRadioButton extractExemptedNets;
    private JCheckBox extractPowerGround;
    private JCheckBox extractR;
    private JTextField gateLengthSubtraction;
    private JPanel globalValues;
    private JRadioButton ignoreExemptedNets;
    private JCheckBox includeGate;
    private JCheckBox includeGround;
    private JTextField inductanceAreaFactor;
    private JTextField inductanceLengthFactor;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel maxDist;
    private JTextField maxDistValue;
    private JTextField maxSeriesResistance;
    private JTextField minCapacitance;
    private JTextField minResistance;
    private JPanel parasiticPanel;
    private JPanel projectPreferences;
    private JTextField resistance;
    private JPanel simpleParasiticOptions;
    private JScrollPane spiceLayer;
    private JComboBox techSelection;
    private JPanel techValues;
    private JCheckBox useExemptedNetsFile;
    private JPanel userPreferences;
    private JCheckBox verboseNaming;

    public ParasiticTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.resistance);
        EDialog.makeTextFieldSelectAllOnTab(this.capacitance);
        EDialog.makeTextFieldSelectAllOnTab(this.edgeCapacitance);
        EDialog.makeTextFieldSelectAllOnTab(this.inductanceAreaFactor);
        EDialog.makeTextFieldSelectAllOnTab(this.inductanceLengthFactor);
        EDialog.makeTextFieldSelectAllOnTab(this.minResistance);
        EDialog.makeTextFieldSelectAllOnTab(this.minCapacitance);
        EDialog.makeTextFieldSelectAllOnTab(this.maxSeriesResistance);
        EDialog.makeTextFieldSelectAllOnTab(this.gateLengthSubtraction);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.userPreferences;
    }

    @Override
    public JPanel getProjectPreferencesPanel() {
        return this.projectPreferences;
    }

    @Override
    public String getName() {
        return "Parasitic";
    }

    @Override
    public void init() {
        this.verboseNaming.setSelected(SimulationTool.isParasiticsUseVerboseNaming());
        this.backannotateLayout.setSelected(SimulationTool.isParasiticsBackAnnotateLayout());
        this.extractPowerGround.setSelected(SimulationTool.isParasiticsExtractPowerGround());
        this.extractPowerGround.setEnabled(false);
        this.useExemptedNetsFile.setSelected(SimulationTool.isParasiticsUseExemptedNetsFile());
        this.ignoreExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.extractExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.ignoreExemptedNets.setSelected(SimulationTool.isParasiticsIgnoreExemptedNets());
        this.extractExemptedNets.setSelected(!SimulationTool.isParasiticsIgnoreExemptedNets());
        this.extractR.setSelected(SimulationTool.isParasiticsExtractsR());
        this.extractC.setSelected(SimulationTool.isParasiticsExtractsC());
        this.maxDistValue.setText(TextUtils.formatDistance(ParasiticTool.getMaxDistance()));
        this.parasiticPanel.setVisible(false);
        this.changing = false;
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(0);
        this.spiceLayer.setViewportView(this.layerList);
        this.layerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ParasiticTab.this.layerListClick();
            }
        });
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.techSelection.addItem(tech.getTechName());
        }
        this.techSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.techChanged();
            }
        });
        this.techSelection.setSelectedItem(Technology.getCurrent().getTechName());
        ParasiticLayerDocumentListener updateLayerParasitics = new ParasiticLayerDocumentListener();
        this.resistance.getDocument().addDocumentListener(updateLayerParasitics);
        this.capacitance.getDocument().addDocumentListener(updateLayerParasitics);
        this.edgeCapacitance.getDocument().addDocumentListener(updateLayerParasitics);
        this.inductanceAreaFactor.getDocument().addDocumentListener(updateLayerParasitics);
        this.inductanceLengthFactor.getDocument().addDocumentListener(updateLayerParasitics);
        ParasiticTechDocumentListener updateTechnologyGlobals = new ParasiticTechDocumentListener();
        this.minResistance.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.minCapacitance.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.maxSeriesResistance.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.gateLengthSubtraction.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.includeGate.addActionListener(updateTechnologyGlobals);
        this.includeGround.addActionListener(updateTechnologyGlobals);
    }

    @Override
    public void term() {
        ParasiticTool.setMaxDistance(TextUtils.atofDistance(this.maxDistValue.getText()));
        boolean b2 = this.verboseNaming.isSelected();
        if (b2 != SimulationTool.isParasiticsUseVerboseNaming()) {
            SimulationTool.setParasiticsUseVerboseNaming(b2);
        }
        if ((b2 = this.backannotateLayout.isSelected()) != SimulationTool.isParasiticsBackAnnotateLayout()) {
            SimulationTool.setParasiticsBackAnnotateLayout(b2);
        }
        if ((b2 = this.extractPowerGround.isSelected()) != SimulationTool.isParasiticsExtractPowerGround()) {
            SimulationTool.setParasiticsExtractPowerGround(b2);
        }
        if ((b2 = this.useExemptedNetsFile.isSelected()) != SimulationTool.isParasiticsUseExemptedNetsFile()) {
            SimulationTool.setParasiticsUseExemptedNetsFile(b2);
        }
        if ((b2 = this.extractR.isSelected()) != SimulationTool.isParasiticsExtractsR()) {
            SimulationTool.setParasiticsExtractsR(b2);
        }
        if ((b2 = this.extractC.isSelected()) != SimulationTool.isParasiticsExtractsC()) {
            SimulationTool.setParasiticsExtractsC(b2);
        }
        if ((b2 = this.ignoreExemptedNets.isSelected()) != SimulationTool.isParasiticsIgnoreExemptedNets()) {
            SimulationTool.setParasiticsIgnoreExemptedNets(b2);
        }
    }

    @Override
    public void refresh() {
        this.techChanged();
    }

    @Override
    public void reset() {
        String techName;
        Technology tech;
        if (SimulationTool.isFactoryParasiticsUseVerboseNaming() != SimulationTool.isParasiticsUseVerboseNaming()) {
            SimulationTool.setParasiticsUseVerboseNaming(SimulationTool.isFactoryParasiticsUseVerboseNaming());
        }
        if (SimulationTool.isFactoryParasiticsBackAnnotateLayout() != SimulationTool.isParasiticsBackAnnotateLayout()) {
            SimulationTool.setParasiticsBackAnnotateLayout(SimulationTool.isFactoryParasiticsBackAnnotateLayout());
        }
        if (SimulationTool.isFactoryParasiticsExtractPowerGround() != SimulationTool.isParasiticsExtractPowerGround()) {
            SimulationTool.setParasiticsExtractPowerGround(SimulationTool.isFactoryParasiticsExtractPowerGround());
        }
        if (SimulationTool.isFactoryParasiticsUseExemptedNetsFile() != SimulationTool.isParasiticsUseExemptedNetsFile()) {
            SimulationTool.setParasiticsUseExemptedNetsFile(SimulationTool.isFactoryParasiticsUseExemptedNetsFile());
        }
        if (SimulationTool.isFactoryParasiticsIgnoreExemptedNets() != SimulationTool.isParasiticsIgnoreExemptedNets()) {
            SimulationTool.setParasiticsIgnoreExemptedNets(SimulationTool.isFactoryParasiticsIgnoreExemptedNets());
        }
        if (SimulationTool.isFactoryParasiticsExtractsR() != SimulationTool.isParasiticsExtractsR()) {
            SimulationTool.setParasiticsExtractsR(SimulationTool.isFactoryParasiticsExtractsR());
        }
        if (SimulationTool.isFactoryParasiticsExtractsC() != SimulationTool.isParasiticsExtractsC()) {
            SimulationTool.setParasiticsExtractsC(SimulationTool.isFactoryParasiticsExtractsC());
        }
        if (ParasiticTool.getFactoryMaxDistance() != ParasiticTool.getMaxDistance()) {
            ParasiticTool.setMaxDistance(ParasiticTool.getFactoryMaxDistance());
        }
        if ((tech = Technology.findTechnology(techName = (String)this.techSelection.getSelectedItem())) != null) {
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                this.setDouble(layer.getResistanceSetting(), (Double)layer.getResistanceSetting().getFactoryValue());
                this.setDouble(layer.getCapacitanceSetting(), (Double)layer.getCapacitanceSetting().getFactoryValue());
                this.setDouble(layer.getEdgeCapacitanceSetting(), (Double)layer.getEdgeCapacitanceSetting().getFactoryValue());
                this.setDouble(layer.getInductanceAreaFactorSetting(), (Double)layer.getInductanceAreaFactorSetting().getFactoryValue());
                this.setDouble(layer.getInductanceLengthFactorSetting(), (Double)layer.getInductanceLengthFactorSetting().getFactoryValue());
            }
            this.setDouble(tech.getMinResistanceSetting(), (Double)tech.getMinResistanceSetting().getFactoryValue());
            this.setDouble(tech.getMinCapacitanceSetting(), (Double)tech.getMinCapacitanceSetting().getFactoryValue());
            this.setDouble(tech.getMaxSeriesResistanceSetting(), (Double)tech.getMaxSeriesResistanceSetting().getFactoryValue());
            this.setBoolean(tech.getGateIncludedSetting(), (Boolean)tech.getGateIncludedSetting().getFactoryValue());
            this.setBoolean(tech.getGroundNetIncludedSetting(), (Boolean)tech.getGroundNetIncludedSetting().getFactoryValue());
            this.setDouble(tech.getGateLengthSubtractionSetting(), (Double)tech.getGateLengthSubtractionSetting().getFactoryValue());
        }
    }

    private void techChanged() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        this.minResistance.setText(this.getFormattedDouble(tech.getMinResistanceSetting()));
        this.minCapacitance.setText(this.getFormattedDouble(tech.getMinCapacitanceSetting()));
        this.gateLengthSubtraction.setText(TextUtils.formatDistance(this.getDouble(tech.getGateLengthSubtractionSetting())));
        this.maxSeriesResistance.setText(this.getFormattedDouble(tech.getMaxSeriesResistanceSetting()));
        this.includeGate.setSelected(this.getBoolean(tech.getGateIncludedSetting()));
        this.includeGround.setSelected(this.getBoolean(tech.getGroundNetIncludedSetting()));
        this.layerListModel.clear();
        List<Layer> list = this.curTech.getLayersSortedByUserPreference();
        for (Layer layer : list) {
            this.layerListModel.addElement(layer.getName());
        }
        this.layerList.setSelectedIndex(0);
        this.layerListClick();
        this.changing = false;
    }

    private void layerListClick() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        String layerName = (String)this.layerList.getSelectedValue();
        Layer layer = tech.findLayer(layerName);
        if (layer != null) {
            this.resistance.setText(this.getFormattedDouble(layer.getResistanceSetting()));
            this.capacitance.setText(this.getFormattedDouble(layer.getCapacitanceSetting()));
            this.edgeCapacitance.setText(this.getFormattedDouble(layer.getEdgeCapacitanceSetting()));
            this.inductanceAreaFactor.setText(this.getFormattedDouble(layer.getInductanceAreaFactorSetting()));
            this.inductanceLengthFactor.setText(this.getFormattedDouble(layer.getInductanceLengthFactorSetting()));
        }
        this.changing = false;
    }

    private void initComponents() {
        this.exemptedNetsGroup = new ButtonGroup();
        this.userPreferences = new JPanel();
        this.parasiticPanel = new JPanel();
        this.maxDist = new JLabel();
        this.maxDistValue = new JTextField();
        this.simpleParasiticOptions = new JPanel();
        this.verboseNaming = new JCheckBox();
        this.backannotateLayout = new JCheckBox();
        this.extractPowerGround = new JCheckBox();
        this.useExemptedNetsFile = new JCheckBox();
        this.ignoreExemptedNets = new JRadioButton();
        this.extractExemptedNets = new JRadioButton();
        this.extractR = new JCheckBox();
        this.extractC = new JCheckBox();
        this.projectPreferences = new JPanel();
        this.techValues = new JPanel();
        this.spiceLayer = new JScrollPane();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel2 = new JLabel();
        this.resistance = new JTextField();
        this.jLabel12 = new JLabel();
        this.capacitance = new JTextField();
        this.edgeCapacitance = new JTextField();
        this.globalValues = new JPanel();
        this.jLabel20 = new JLabel();
        this.minResistance = new JTextField();
        this.jLabel21 = new JLabel();
        this.minCapacitance = new JTextField();
        this.jLabel5 = new JLabel();
        this.gateLengthSubtraction = new JTextField();
        this.includeGate = new JCheckBox();
        this.includeGround = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.maxSeriesResistance = new JTextField();
        this.jLabel4 = new JLabel();
        this.inductanceAreaFactor = new JTextField();
        this.jLabel6 = new JLabel();
        this.inductanceLengthFactor = new JTextField();
        this.jLabel3 = new JLabel();
        this.techSelection = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.userPreferences.setLayout(new GridBagLayout());
        this.parasiticPanel.setBorder(BorderFactory.createTitledBorder("Coupling Parasitics"));
        this.parasiticPanel.setEnabled(false);
        this.parasiticPanel.setLayout(new GridBagLayout());
        this.maxDist.setText("Maximum distance (lambda)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDist, gridBagConstraints);
        this.maxDistValue.setColumns(6);
        this.maxDistValue.setText("20");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDistValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.userPreferences.add((Component)this.parasiticPanel, gridBagConstraints);
        this.simpleParasiticOptions.setBorder(BorderFactory.createTitledBorder("Simple Parasitics"));
        this.simpleParasiticOptions.setLayout(new GridBagLayout());
        this.verboseNaming.setText("Use Verbose Naming");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.verboseNaming, gridBagConstraints);
        this.backannotateLayout.setText("Back-Annotate Layout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.backannotateLayout, gridBagConstraints);
        this.extractPowerGround.setText("Extract Power/Ground");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractPowerGround, gridBagConstraints);
        this.useExemptedNetsFile.setText("Use exemptedNets.txt file");
        this.useExemptedNetsFile.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ParasiticTab.this.useExemptedNetsFileStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.useExemptedNetsFile, gridBagConstraints);
        this.exemptedNetsGroup.add(this.ignoreExemptedNets);
        this.ignoreExemptedNets.setText("Extract all but exempted nets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.simpleParasiticOptions.add((Component)this.ignoreExemptedNets, gridBagConstraints);
        this.exemptedNetsGroup.add(this.extractExemptedNets);
        this.extractExemptedNets.setText("Extract only exempted nets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.simpleParasiticOptions.add((Component)this.extractExemptedNets, gridBagConstraints);
        this.extractR.setText("Extract R");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractR, gridBagConstraints);
        this.extractC.setText("Extract C");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractC, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.userPreferences.add((Component)this.simpleParasiticOptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.userPreferences, gridBagConstraints);
        this.projectPreferences.setLayout(new GridBagLayout());
        this.techValues.setBorder(BorderFactory.createTitledBorder("Individual Layers"));
        this.techValues.setLayout(new GridBagLayout());
        this.spiceLayer.setMinimumSize(new Dimension(200, 50));
        this.spiceLayer.setPreferredSize(new Dimension(200, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.spiceLayer, gridBagConstraints);
        this.jLabel7.setText("Layer:");
        this.jLabel7.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.techValues.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel11.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel2.setText("Perimeter Cap (fF/um):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel2, gridBagConstraints);
        this.resistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.resistance, gridBagConstraints);
        this.jLabel12.setText("Area Cap (fF/um^2):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel12, gridBagConstraints);
        this.capacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.capacitance, gridBagConstraints);
        this.edgeCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.edgeCapacitance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.projectPreferences.add((Component)this.techValues, gridBagConstraints);
        this.globalValues.setBorder(BorderFactory.createTitledBorder("For All Layers"));
        this.globalValues.setLayout(new GridBagLayout());
        this.jLabel20.setText("Min. Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.jLabel20, gridBagConstraints);
        this.minResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.minResistance, gridBagConstraints);
        this.jLabel21.setText("Min. Capacitance (fF):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.jLabel21, gridBagConstraints);
        this.minCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.minCapacitance, gridBagConstraints);
        this.jLabel5.setText("Gate Length Shrink (Subtraction) um:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel5, gridBagConstraints);
        this.gateLengthSubtraction.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.gateLengthSubtraction, gridBagConstraints);
        this.includeGate.setText("Include Gate In Resistance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.includeGate, gridBagConstraints);
        this.includeGround.setText("Include Ground Network");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.includeGround, gridBagConstraints);
        this.jLabel1.setText("Max. Series Resistance: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel1, gridBagConstraints);
        this.maxSeriesResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.maxSeriesResistance, gridBagConstraints);
        this.jLabel4.setText("Inductance Area Factor: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel4, gridBagConstraints);
        this.inductanceAreaFactor.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.inductanceAreaFactor, gridBagConstraints);
        this.jLabel6.setText("Inductance Length Factor: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel6, gridBagConstraints);
        this.inductanceLengthFactor.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.inductanceLengthFactor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.projectPreferences.add((Component)this.globalValues, gridBagConstraints);
        this.jLabel3.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectPreferences.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectPreferences.add((Component)this.techSelection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.projectPreferences, gridBagConstraints);
        this.pack();
    }

    private void useExemptedNetsFileStateChanged(ChangeEvent evt) {
        this.ignoreExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.extractExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
    }

    private class ParasiticLayerDocumentListener
    implements DocumentListener {
        private ParasiticLayerDocumentListener() {
        }

        private void change() {
            if (ParasiticTab.this.changing) {
                return;
            }
            String techName = (String)ParasiticTab.this.techSelection.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech == null) {
                return;
            }
            String layerName = (String)ParasiticTab.this.layerList.getSelectedValue();
            Layer layer = tech.findLayer(layerName);
            if (layer == null) {
                return;
            }
            ParasiticTab.this.setDouble(layer.getResistanceSetting(), TextUtils.atof(ParasiticTab.this.resistance.getText()));
            ParasiticTab.this.setDouble(layer.getCapacitanceSetting(), TextUtils.atof(ParasiticTab.this.capacitance.getText()));
            ParasiticTab.this.setDouble(layer.getEdgeCapacitanceSetting(), TextUtils.atof(ParasiticTab.this.edgeCapacitance.getText()));
            ParasiticTab.this.setDouble(layer.getInductanceAreaFactorSetting(), TextUtils.atof(ParasiticTab.this.inductanceAreaFactor.getText()));
            ParasiticTab.this.setDouble(layer.getInductanceLengthFactorSetting(), TextUtils.atof(ParasiticTab.this.inductanceLengthFactor.getText()));
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            this.change();
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.change();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.change();
        }
    }

    private class ParasiticTechDocumentListener
    implements ActionListener,
    DocumentListener {
        private ParasiticTechDocumentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.updateTechnologyGlobals();
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            this.updateTechnologyGlobals();
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.updateTechnologyGlobals();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.updateTechnologyGlobals();
        }

        private void updateTechnologyGlobals() {
            if (ParasiticTab.this.changing) {
                return;
            }
            String techName = (String)ParasiticTab.this.techSelection.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech == null) {
                return;
            }
            ParasiticTab.this.setDouble(tech.getMinResistanceSetting(), TextUtils.atof(ParasiticTab.this.minResistance.getText()));
            ParasiticTab.this.setDouble(tech.getMinCapacitanceSetting(), TextUtils.atof(ParasiticTab.this.minCapacitance.getText()));
            ParasiticTab.this.setDouble(tech.getMaxSeriesResistanceSetting(), TextUtils.atof(ParasiticTab.this.maxSeriesResistance.getText()));
            ParasiticTab.this.setBoolean(tech.getGateIncludedSetting(), ParasiticTab.this.includeGate.isSelected());
            ParasiticTab.this.setBoolean(tech.getGroundNetIncludedSetting(), ParasiticTab.this.includeGround.isSelected());
            ParasiticTab.this.setDouble(tech.getGateLengthSubtractionSetting(), TextUtils.atofDistance(ParasiticTab.this.gateLengthSubtraction.getText()));
        }
    }
}

