/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class DXFTab
extends PreferencePanel {
    private TextUtils.UnitScale[] scales;
    private Setting artworkDXFLayerSetting = Artwork.tech().findLayer("Graphics").getDXFLayerSetting();
    private Setting dxfScaleSetting = IOTool.getDXFScaleSetting();
    private JCheckBox dxfInputFlattensHierarchy;
    private JCheckBox dxfInputReadsAllLayers;
    private JTextField dxfLayerName;
    private JComboBox dxfScale;
    private JLabel header;
    private JLabel jLabel1;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel preferences;
    private JPanel projectSettings;

    public DXFTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.dxfLayerName);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.preferences;
    }

    @Override
    public JPanel getProjectPreferencesPanel() {
        return this.projectSettings;
    }

    @Override
    public String getName() {
        return "DXF";
    }

    @Override
    public void init() {
        this.dxfInputFlattensHierarchy.setSelected(IOTool.isDXFInputFlattensHierarchy());
        this.dxfInputReadsAllLayers.setSelected(IOTool.isDXFInputReadsAllLayers());
        this.dxfLayerName.setText(this.getString(this.artworkDXFLayerSetting));
        this.scales = TextUtils.UnitScale.getUnitScales();
        for (int i2 = 0; i2 < this.scales.length; ++i2) {
            this.dxfScale.addItem(this.scales[i2].getName() + "Meter");
        }
        this.dxfScale.setSelectedItem(TextUtils.UnitScale.findFromIndex(this.getInt(this.dxfScaleSetting)).getName() + "Meter");
    }

    @Override
    public void term() {
        boolean currentValue = this.dxfInputFlattensHierarchy.isSelected();
        if (currentValue != IOTool.isDXFInputFlattensHierarchy()) {
            IOTool.setDXFInputFlattensHierarchy(currentValue);
        }
        if ((currentValue = this.dxfInputReadsAllLayers.isSelected()) != IOTool.isDXFInputReadsAllLayers()) {
            IOTool.setDXFInputReadsAllLayers(currentValue);
        }
        this.setString(this.artworkDXFLayerSetting, this.dxfLayerName.getText());
        this.setInt(this.dxfScaleSetting, this.scales[this.dxfScale.getSelectedIndex()].getIndex());
    }

    @Override
    public void reset() {
        if (IOTool.isFactoryDXFInputFlattensHierarchy() != IOTool.isDXFInputFlattensHierarchy()) {
            IOTool.setDXFInputFlattensHierarchy(IOTool.isFactoryDXFInputFlattensHierarchy());
        }
        if (IOTool.isFactoryDXFInputReadsAllLayers() != IOTool.isDXFInputReadsAllLayers()) {
            IOTool.setDXFInputReadsAllLayers(IOTool.isFactoryDXFInputReadsAllLayers());
        }
        this.setString(this.artworkDXFLayerSetting, (String)this.artworkDXFLayerSetting.getFactoryValue());
        this.setInt(this.dxfScaleSetting, (Integer)this.dxfScaleSetting.getFactoryValue());
    }

    private void initComponents() {
        this.preferences = new JPanel();
        this.dxfInputReadsAllLayers = new JCheckBox();
        this.dxfInputFlattensHierarchy = new JCheckBox();
        this.projectSettings = new JPanel();
        this.dxfLayerName = new JTextField();
        this.jLabel17 = new JLabel();
        this.dxfScale = new JComboBox();
        this.header = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DXFTab.this.closeDialog(evt);
            }
        });
        this.preferences.setLayout(new GridBagLayout());
        this.dxfInputReadsAllLayers.setText("Input reads all layers");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.preferences.add((Component)this.dxfInputReadsAllLayers, gridBagConstraints);
        this.dxfInputFlattensHierarchy.setText("Input flattens hierarchy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.preferences.add((Component)this.dxfInputFlattensHierarchy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.preferences, gridBagConstraints);
        this.projectSettings.setLayout(new GridBagLayout());
        this.dxfLayerName.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.dxfLayerName, gridBagConstraints);
        this.jLabel17.setText("DXF Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.jLabel17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.dxfScale, gridBagConstraints);
        this.header.setText("DXF Input will accpt all of these layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.projectSettings.add((Component)this.header, gridBagConstraints);
        this.jLabel1.setText("DXF Output will use the first layer in the list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.projectSettings.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel2.setText(" (separate layer names with a comma)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 4);
        this.projectSettings.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.projectSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

