/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.KeyBindingManager;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SelectObject
extends EModelessDialog
implements DatabaseChangeListener {
    private static SelectObject theDialog = null;
    private static final int NODES = 1;
    private static final int ARCS = 2;
    private static final int EXPORTS = 3;
    private static final int NETS = 4;
    private static int what = 1;
    private Cell cell;
    private JList list;
    private DefaultListModel model;
    private List<Object> associatedThings;
    private JRadioButton arcs;
    private JButton done;
    private JRadioButton exports;
    private JButton findText;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JRadioButton networks;
    private JRadioButton nodes;
    private JScrollPane objectPane;
    private JCheckBox regExp;
    private JTextField searchText;
    private ButtonGroup whatGroup;

    public static void selectObjectDialog(Cell thisCell, boolean updateOnlyIfVisible) {
        if (theDialog == null) {
            if (updateOnlyIfVisible) {
                return;
            }
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new SelectObject(jf);
        }
        if (updateOnlyIfVisible && !theDialog.isVisible()) {
            return;
        }
        theDialog.setVisible(true);
        theDialog.buttonClicked(thisCell);
        theDialog.toFront();
    }

    private SelectObject(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        UserInterfaceMain.addDatabaseChangeListener(this);
        switch (what) {
            case 1: {
                this.nodes.setSelected(true);
                break;
            }
            case 2: {
                this.arcs.setSelected(true);
                break;
            }
            case 3: {
                this.exports.setSelected(true);
                break;
            }
            case 4: {
                this.networks.setSelected(true);
            }
        }
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(2);
        this.objectPane.setViewportView(this.list);
        this.associatedThings = new ArrayList<Object>();
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SelectObject.this.listClicked();
            }
        });
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.closeDialog(null);
            }
        });
        this.nodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.arcs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.exports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.networks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.searchText.getDocument().addDocumentListener(new SelecdtObjectDocumentListener(this));
        TopLevel top = TopLevel.getCurrentJFrame();
        if (top != null && top.getTheMenuBar() != null) {
            KeyBindingManager.KeyMaps km = top.getEMenuBar().getKeyMaps();
            InputMap im = km.getInputMap();
            ActionMap am = km.getActionMap();
            this.getRootPane().getInputMap().setParent(im);
            this.getRootPane().getActionMap().setParent(am);
            this.findText.getInputMap().setParent(im);
            this.findText.getActionMap().setParent(am);
            this.list.getInputMap().setParent(im);
            this.list.getActionMap().setParent(am);
        }
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.closeDialog(null);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e2) {
        if (!this.isVisible()) {
            return;
        }
        this.buttonClicked(null);
    }

    private void listClicked() {
        if (this.cell == null) {
            System.out.println("There is no current cell for this operation.");
            return;
        }
        Netlist netlist = this.cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted selection (network information unavailable).  Please try again");
            return;
        }
        int[] si = this.list.getSelectedIndices();
        if (si.length <= 0) {
            return;
        }
        boolean unselected = true;
        HashSet<Highlighter> finishThese = new HashSet<Highlighter>();
        Iterator<WindowFrame> wIt = WindowFrame.getWindows();
        while (wIt.hasNext()) {
            Highlighter highlighter;
            WindowFrame wf = wIt.next();
            WindowContent wc = wf.getContent();
            if (wc == null || wc.getCell() != this.cell || (highlighter = wc.getHighlighter()) == null) continue;
            if (unselected) {
                unselected = false;
                highlighter.clear();
                for (int i2 = 0; i2 < si.length; ++i2) {
                    int index = si[i2];
                    Object obj = this.associatedThings.get(index);
                    if (this.nodes.isSelected()) {
                        NodeInst ni = (NodeInst)obj;
                        highlighter.addElectricObject(ni, this.cell);
                        continue;
                    }
                    if (this.arcs.isSelected()) {
                        ArcInst ai = (ArcInst)obj;
                        highlighter.addElectricObject(ai, this.cell);
                        continue;
                    }
                    if (this.exports.isSelected()) {
                        Export pp = (Export)obj;
                        highlighter.addText(pp, this.cell, Export.EXPORT_NAME);
                        continue;
                    }
                    Network net = (Network)obj;
                    highlighter.addNetwork(net, this.cell);
                }
            }
            highlighter.ensureHighlightingSeen(wf);
            finishThese.add(highlighter);
        }
        for (Highlighter highlighter : finishThese) {
            highlighter.finished();
        }
    }

    private void buttonClicked(Cell thisCell) {
        this.model.clear();
        this.associatedThings.clear();
        Cell cell = this.cell = thisCell != null ? thisCell : WindowFrame.getCurrentCell();
        if (this.cell == null) {
            return;
        }
        ArrayList<Pair> allNames = new ArrayList<Pair>();
        if (this.nodes.isSelected()) {
            what = 1;
            it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                allNames.add(new Pair(ni.getName(), ni));
            }
        } else if (this.arcs.isSelected()) {
            what = 2;
            it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                allNames.add(new Pair(ai.getName(), ai));
            }
        } else if (this.exports.isSelected()) {
            what = 3;
            it = this.cell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                allNames.add(new Pair(pp.getName(), pp));
            }
        } else {
            what = 4;
            Netlist netlist = this.cell.getNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted selection (network information unavailable).  Please try again");
                return;
            }
            Iterator<Network> it = netlist.getNetworks();
            while (it.hasNext()) {
                Network net = it.next();
                String netName = net.describe(false);
                if (netName.length() == 0) continue;
                allNames.add(new Pair(netName, net));
            }
        }
        Collections.sort(allNames);
        for (Pair p : allNames) {
            this.model.addElement(p.pairName);
            this.associatedThings.add(p.pairObj);
        }
    }

    private void searchTextChanged(String currentSearchText, int limit) {
        int i2;
        if (currentSearchText.length() == 0) {
            return;
        }
        ArrayList<Integer> selected = new ArrayList<Integer>();
        int flags = 66;
        if (this.regExp.isSelected()) {
            Pattern p = null;
            try {
                p = Pattern.compile(currentSearchText, flags);
                if (currentSearchText.length() == 0) {
                    return;
                }
                for (i2 = 0; i2 < this.model.size(); ++i2) {
                    String s = (String)this.model.get(i2);
                    Matcher m2 = p.matcher(s);
                    if (!m2.find()) continue;
                    selected.add(i2);
                }
            }
            catch (PatternSyntaxException e2) {
                System.out.println("Invalid regular expression, using straight search");
            }
        }
        for (int i3 = 0; i3 < this.model.size(); ++i3) {
            String s = (String)this.model.get(i3);
            if (s.indexOf(currentSearchText) < 0) continue;
            selected.add(i3);
        }
        if (selected.size() > limit) {
            if (limit == 1) {
                while (selected.size() > 1) {
                    selected.remove(selected.size() - 1);
                }
            } else {
                String msg = selected.size() + " items selected. Please confirm potential time consuming display operation";
                Object[] options = new String[]{"Display", "Cancel"};
                int ret = FileMenu.showFileMenuOptionDialog(TopLevel.getCurrentJFrame(), msg, "Show Large Number of Items", -1, 2, null, options, options[0], null);
                if (ret != 0) {
                    return;
                }
            }
        }
        if (selected.size() > 0) {
            int[] indices = new int[selected.size()];
            i2 = 0;
            for (Integer iO : selected) {
                indices[i2++] = iO;
            }
            this.list.setSelectedIndices(indices);
            if (limit == 1) {
                this.list.ensureIndexIsVisible((Integer)selected.get(0));
            }
        }
        this.listClicked();
    }

    private void initComponents() {
        this.whatGroup = new ButtonGroup();
        this.done = new JButton();
        this.objectPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.searchText = new JTextField();
        this.findText = new JButton();
        this.jPanel1 = new JPanel();
        this.nodes = new JRadioButton();
        this.exports = new JRadioButton();
        this.arcs = new JRadioButton();
        this.networks = new JRadioButton();
        this.regExp = new JCheckBox();
        this.setTitle("Select Object");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SelectObject.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.done.setText("Done");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.objectPane.setMinimumSize(new Dimension(200, 200));
        this.objectPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.objectPane, gridBagConstraints);
        this.jLabel1.setText("Search:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.searchText.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.searchText, gridBagConstraints);
        this.findText.setText("Find");
        this.findText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.findTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.findText, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.whatGroup.add(this.nodes);
        this.nodes.setText("Nodes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.nodes, gridBagConstraints);
        this.whatGroup.add(this.exports);
        this.exports.setText("Exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.exports, gridBagConstraints);
        this.whatGroup.add(this.arcs);
        this.arcs.setText("Arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.arcs, gridBagConstraints);
        this.whatGroup.add(this.networks);
        this.networks.setText("Networks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.networks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.regExp.setText("Use regular expressions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.regExp, gridBagConstraints);
        this.pack();
    }

    private void findTextActionPerformed(ActionEvent evt) {
        String search = this.searchText.getText();
        this.searchTextChanged(search, 1000);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class SelecdtObjectDocumentListener
    implements DocumentListener {
        SelectObject dialog;

        SelecdtObjectDocumentListener(SelectObject dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            this.dialog.searchTextChanged(SelectObject.this.searchText.getText(), 1);
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.dialog.searchTextChanged(SelectObject.this.searchText.getText(), 1);
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.dialog.searchTextChanged(SelectObject.this.searchText.getText(), 1);
        }
    }

    private static class Pair
    implements Comparable<Pair> {
        String pairName;
        Object pairObj;

        Pair(String name, Object obj) {
            this.pairName = name;
            this.pairObj = obj;
        }

        @Override
        public int compareTo(Pair o2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(this.pairName, o2.pairName);
        }
    }
}

