/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.FillGenJob;
import com.sun.electric.tool.generator.layout.fill.FillGeneratorTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RectangularShape;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FillGenDialog
extends EDialog {
    private JCheckBox[] tiledCells;
    private List<FillGenButton> metalOptions = new ArrayList<FillGenButton>();
    private Technology tech;
    private JButton cancelButton;
    private JPanel floorplanPanel;
    private JLabel gndSpaceLabel;
    private JLabel gndWidthLabel;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox10;
    private JCheckBox jCheckBox11;
    private JCheckBox jCheckBox12;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JCheckBox jCheckBox9;
    private JComboBox jComboBox1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JPanel masterDimPanel;
    private JPanel metalPanel;
    private JButton okButton;
    private JPanel otherMasterPanel;
    private JRadioButton templateButton;
    private JPanel templatePanel;
    private JPanel tilingPanel;
    private ButtonGroup topGroup;
    private JLabel vddSpaceLabel;
    private JLabel vddWidthLabel;

    public FillGenDialog(Technology tech, Frame parent) {
        super(parent, true);
        this.tech = tech;
        this.initComponents();
        this.templateButton.setSelected(true);
        this.topGroup.add(this.templateButton);
        assert (tech != null);
        this.setTitle("Fill Cell Generator for '" + tech.getTechName() + "'");
        int numMetals = tech.getNumMetals();
        String[] units = new String[]{"lambda", "tracks"};
        for (int i2 = 0; i2 < numMetals; ++i2) {
            JComboBox<String> combox;
            JTextField text;
            int metal = i2 + 1;
            Layer metalLayer = tech.findLayer("Metal-" + metal);
            DRCTemplate rule = DRC.getSpacingRule(metalLayer, null, metalLayer, null, false, -1, 0.0, 0.0);
            FillGenButton button = new FillGenButton(metal);
            this.metalOptions.add(button);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = metal;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.metalPanel.add((Component)button, gridBagConstraints);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FillGenDialog.this.metalOptionActionPerformed(evt);
                }
            });
            button.setSelected(false);
            button.vddSpace = text = new JTextField();
            text.setColumns(4);
            text.setHorizontalAlignment(11);
            if (rule != null) {
                text.setText(TextUtils.formatDistance(rule.getValue(0)));
            }
            text.setMinimumSize(new Dimension(40, 21));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = metal;
            this.metalPanel.add((Component)text, gridBagConstraints);
            button.vddUnit = combox = new JComboBox<String>();
            combox.setModel(new DefaultComboBoxModel<String>(units));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = metal;
            this.metalPanel.add(combox, gridBagConstraints);
            button.gndSpace = text = new JTextField();
            text.setColumns(4);
            text.setHorizontalAlignment(11);
            text.setText(TextUtils.formatDistance(rule.getValue(0)));
            text.setMinimumSize(new Dimension(40, 21));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = metal;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.metalPanel.add((Component)text, gridBagConstraints);
            button.gndUnit = combox = new JComboBox();
            combox.setModel(new DefaultComboBoxModel<String>(units));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = metal;
            this.metalPanel.add(combox, gridBagConstraints);
            rule = DRC.getMinValue(metalLayer, DRCTemplate.DRCRuleType.MINWID);
            button.vddWidth = text = new JTextField();
            text.setColumns(4);
            text.setHorizontalAlignment(11);
            text.setText(TextUtils.formatDistance(rule.getValue(0)));
            text.setMinimumSize(new Dimension(40, 21));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = metal;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.metalPanel.add((Component)text, gridBagConstraints);
            button.vddWUnit = combox = new JComboBox();
            combox.setModel(new DefaultComboBoxModel<String>(units));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridy = metal;
            this.metalPanel.add(combox, gridBagConstraints);
            button.gndWidth = text = new JTextField();
            text.setColumns(4);
            text.setHorizontalAlignment(11);
            text.setText(TextUtils.formatDistance(rule.getValue(0)));
            text.setMinimumSize(new Dimension(40, 21));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 7;
            gridBagConstraints.gridy = metal;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.metalPanel.add((Component)text, gridBagConstraints);
            button.gndWUnit = combox = new JComboBox();
            combox.setModel(new DefaultComboBoxModel<String>(units));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 8;
            gridBagConstraints.gridy = metal;
            this.metalPanel.add(combox, gridBagConstraints);
        }
        this.tiledCells = new JCheckBox[12];
        this.tiledCells[0] = this.jCheckBox1;
        this.tiledCells[1] = this.jCheckBox2;
        this.tiledCells[2] = this.jCheckBox3;
        this.tiledCells[3] = this.jCheckBox4;
        this.tiledCells[4] = this.jCheckBox5;
        this.tiledCells[5] = this.jCheckBox6;
        this.tiledCells[6] = this.jCheckBox7;
        this.tiledCells[7] = this.jCheckBox8;
        this.tiledCells[8] = this.jCheckBox9;
        this.tiledCells[9] = this.jCheckBox10;
        this.tiledCells[10] = this.jCheckBox11;
        this.tiledCells[11] = this.jCheckBox12;
        try {
            Class<?> extraPanelClass = Class.forName("com.sun.electric.plugins.generator.FillCelllGenPanel");
            Constructor<?> instance = extraPanelClass.getDeclaredConstructor(FillGenDialog.class, JPanel.class, ButtonGroup.class, JButton.class, JRadioButton.class);
            instance.newInstance(this, this.floorplanPanel, this.topGroup, this.okButton, this.templateButton);
        }
        catch (Exception e2) {
            TextUtils.recordMissingComponent("Fill Cell Generator dialog");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FillGenDialog.this.okButtonActionPerformed();
                }
            });
            this.optionActionPerformed();
        }
        this.finishInitialization();
        this.setVisible(true);
    }

    private void initComponents() {
        this.topGroup = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.floorplanPanel = new JPanel();
        this.metalPanel = new JPanel();
        this.vddSpaceLabel = new JLabel();
        this.vddWidthLabel = new JLabel();
        this.gndSpaceLabel = new JLabel();
        this.gndWidthLabel = new JLabel();
        this.templatePanel = new JPanel();
        this.masterDimPanel = new JPanel();
        this.jTextField2 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.otherMasterPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.templateButton = new JRadioButton();
        this.tilingPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jCheckBox9 = new JCheckBox();
        this.jCheckBox10 = new JCheckBox();
        this.jCheckBox11 = new JCheckBox();
        this.jCheckBox12 = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Fill Cell Generator");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                FillGenDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setMaximumSize(new Dimension(327670, 327670));
        this.jTabbedPane1.setMinimumSize(new Dimension(600, 500));
        this.jTabbedPane1.setPreferredSize(new Dimension(635, 500));
        this.floorplanPanel.setMinimumSize(new Dimension(550, 300));
        this.floorplanPanel.setPreferredSize(new Dimension(630, 350));
        this.floorplanPanel.setLayout(new GridBagLayout());
        this.metalPanel.setBorder(BorderFactory.createTitledBorder("Reserved Space"));
        this.metalPanel.setLayout(new GridBagLayout());
        this.vddSpaceLabel.setText("Vdd Space");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.metalPanel.add((Component)this.vddSpaceLabel, gridBagConstraints);
        this.vddWidthLabel.setText("Vdd Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.metalPanel.add((Component)this.vddWidthLabel, gridBagConstraints);
        this.gndSpaceLabel.setText("Gnd Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.metalPanel.add((Component)this.gndSpaceLabel, gridBagConstraints);
        this.gndWidthLabel.setText("Gnd Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.metalPanel.add((Component)this.gndWidthLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.floorplanPanel.add((Component)this.metalPanel, gridBagConstraints);
        this.templatePanel.setBorder(BorderFactory.createTitledBorder("Master Cell"));
        this.templatePanel.setLayout(new GridBagLayout());
        this.masterDimPanel.setLayout(new GridBagLayout());
        this.jTextField2.setColumns(8);
        this.jTextField2.setHorizontalAlignment(11);
        this.jTextField2.setText("128");
        this.jTextField2.setMinimumSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.masterDimPanel.add((Component)this.jTextField2, gridBagConstraints);
        this.jTextField1.setColumns(8);
        this.jTextField1.setHorizontalAlignment(11);
        this.jTextField1.setText("245");
        this.jTextField1.setMinimumSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.masterDimPanel.add((Component)this.jTextField1, gridBagConstraints);
        this.jLabel3.setText("Width (lambda)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.masterDimPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel5.setText("Height (lambda)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.masterDimPanel.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        this.templatePanel.add((Component)this.masterDimPanel, gridBagConstraints);
        this.otherMasterPanel.setLayout(new GridBagLayout());
        this.jLabel6.setText("Even layer orientation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.otherMasterPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"horiz", "vert"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.otherMasterPanel.add((Component)this.jComboBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.templatePanel.add((Component)this.otherMasterPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 11;
        this.floorplanPanel.add((Component)this.templatePanel, gridBagConstraints);
        this.templateButton.setText("Template Fill");
        this.templateButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.templateButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.floorplanPanel.add((Component)this.templateButton, gridBagConstraints);
        this.jTabbedPane1.addTab("Floorplan", this.floorplanPanel);
        this.tilingPanel.setLayout(new GridBagLayout());
        this.jLabel2.setFont(new Font("MS Sans Serif", 1, 14));
        this.jLabel2.setText("Which tiled cells to generate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.tilingPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jCheckBox1.setText("2 x 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.tilingPanel.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox2.setText("3 x 3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.tilingPanel.add((Component)this.jCheckBox2, gridBagConstraints);
        this.jCheckBox3.setText("4 x 4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.tilingPanel.add((Component)this.jCheckBox3, gridBagConstraints);
        this.jCheckBox4.setText("5 x 5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.tilingPanel.add((Component)this.jCheckBox4, gridBagConstraints);
        this.jCheckBox5.setText("6 x 6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.tilingPanel.add((Component)this.jCheckBox5, gridBagConstraints);
        this.jCheckBox6.setText("7 x 7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.tilingPanel.add((Component)this.jCheckBox6, gridBagConstraints);
        this.jCheckBox7.setText("8 x 8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.tilingPanel.add((Component)this.jCheckBox7, gridBagConstraints);
        this.jCheckBox8.setText("9 x 9");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.tilingPanel.add((Component)this.jCheckBox8, gridBagConstraints);
        this.jCheckBox9.setText("10 x 10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.tilingPanel.add((Component)this.jCheckBox9, gridBagConstraints);
        this.jCheckBox10.setText("11 x 11");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.tilingPanel.add((Component)this.jCheckBox10, gridBagConstraints);
        this.jCheckBox11.setText("12 x 12");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.tilingPanel.add((Component)this.jCheckBox11, gridBagConstraints);
        this.jCheckBox12.setText("13 x 13");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.tilingPanel.add((Component)this.jCheckBox12, gridBagConstraints);
        this.jTabbedPane1.addTab("Tiling", this.tilingPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.okButton.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillGenDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.pack();
    }

    private void metalOptionActionPerformed(ActionEvent evt) {
        FillGenButton b2 = (FillGenButton)evt.getSource();
        this.setMetalOption(b2, false);
    }

    private void setMetalOption(FillGenButton b2, boolean flatSelected) {
        boolean option = b2.isSelected();
        b2.vddSpace.setEnabled(option);
        b2.vddUnit.setEnabled(option);
        b2.gndSpace.setEnabled(option);
        b2.gndUnit.setEnabled(option);
        boolean value = option && !this.templateButton.isSelected();
        b2.vddWidth.setEnabled(value);
        b2.vddWUnit.setEnabled(value);
        b2.gndWidth.setEnabled(value);
        b2.gndWUnit.setEnabled(value);
    }

    private void setMetalOptions(boolean flatSelected) {
        for (FillGenButton b2 : this.metalOptions) {
            this.setMetalOption(b2, flatSelected);
        }
    }

    public void generalSetup(boolean flatSelected, boolean createMaster) {
        boolean value = !flatSelected && createMaster || this.templateButton.isSelected();
        FillGenDialog.setEnabledInHierarchy(this.masterDimPanel, value);
        value = value || flatSelected;
        FillGenDialog.setEnabledInHierarchy(this.metalPanel, value);
        this.setMetalOptions(flatSelected);
        FillGenDialog.setEnabledInHierarchy(this.otherMasterPanel, value);
    }

    private void optionActionPerformed() {
        this.optionAction(false, false, false);
    }

    public void optionAction(boolean flatSelected, boolean createMaster, boolean isCellSelected) {
        FillGenDialog.setEnabledInHierarchy(this.tilingPanel, !isCellSelected);
        this.generalSetup(flatSelected, createMaster);
    }

    private static void setEnabledInHierarchy(Container c2, boolean value) {
        c2.setEnabled(value);
        for (int i2 = 0; i2 < c2.getComponentCount(); ++i2) {
            Component co = c2.getComponent(i2);
            co.setEnabled(value);
            if (!(co instanceof Container)) continue;
            FillGenDialog.setEnabledInHierarchy((Container)co, value);
        }
    }

    private void okButtonActionPerformed() {
        FillGenConfig config = this.okButtonClick(false, false, false, false, 0.0, FillGenConfig.FillGenType.INTERNAL, -1);
        if (config != null) {
            new FillGenJob(Job.getUserInterface().getCurrentCell(), config, false, new LayerCoverageTool.LayerCoveragePreferences(false));
        }
    }

    public FillGenConfig okButtonClick(boolean isFlatSelected, boolean createMaster, boolean binary, boolean around, double gap, FillGenConfig.FillGenType genType, int level) {
        boolean hierarchy = !isFlatSelected;
        boolean useMaster = hierarchy && !createMaster;
        boolean even = this.jComboBox1.getModel().getSelectedItem().equals("horiz");
        FillGeneratorTool.Units LAMBDA = FillGeneratorTool.LAMBDA;
        FillGeneratorTool.Units TRACKS = FillGeneratorTool.TRACKS;
        int firstMetal = -1;
        int lastMetal = -1;
        double vddReserve = 0.0;
        double gndReserve = 0.0;
        double vddWidth = 0.0;
        double gndWidth = 0.0;
        for (FillGenButton b2 : this.metalOptions) {
            if (!b2.isSelected()) continue;
            double vddS = TextUtils.atofDistance(b2.vddSpace.getText());
            double gndS = TextUtils.atofDistance(b2.gndSpace.getText());
            double vddW = TextUtils.atofDistance(b2.vddWidth.getText());
            double gndW = TextUtils.atofDistance(b2.gndWidth.getText());
            if (firstMetal == -1) {
                firstMetal = b2.metal;
            }
            lastMetal = b2.metal;
            if (vddS > vddReserve) {
                vddReserve = vddS;
            }
            if (gndS > gndReserve) {
                gndReserve = gndS;
            }
            if (vddW > vddWidth) {
                vddWidth = vddW;
            }
            if (!(gndW > gndWidth)) continue;
            gndWidth = gndW;
        }
        if (!useMaster && vddReserve == 0.0 && gndReserve == 0.0) {
            System.out.println("Nothing reserve");
            return null;
        }
        double drcSpacingRule = DRC.getWorstSpacingDistance(this.tech, lastMetal);
        double width = TextUtils.atofDistance(this.jTextField1.getText());
        double height = TextUtils.atofDistance(this.jTextField2.getText());
        FillGeneratorTool.FillTypeEnum type = FillGeneratorTool.FillTypeEnum.TEMPLATE;
        Cell cellToFill = Job.getUserInterface().getCurrentCell();
        if (!this.templateButton.isSelected()) {
            if (cellToFill == null) {
                System.out.println("No cell to fill");
                return null;
            }
            type = FillGeneratorTool.FillTypeEnum.CELL;
            ERectangle bnd = cellToFill.getBounds();
            width = ((RectangularShape)bnd).getWidth();
            height = ((RectangularShape)bnd).getHeight();
        }
        ArrayList<Integer> items = new ArrayList<Integer>(12);
        for (int i2 = 0; i2 < this.tiledCells.length; ++i2) {
            if (!this.tiledCells[i2].getModel().isSelected()) continue;
            items.add(i2 + 2);
        }
        int[] cells = null;
        if (items.size() > 0) {
            cells = new int[items.size()];
            for (int i3 = 0; i3 < items.size(); ++i3) {
                cells[i3] = (Integer)items.get(i3);
            }
        }
        boolean withWidth = false;
        FillGenConfig config = new FillGenConfig(this.tech, type, "autoFillLib", FillGeneratorTool.PERIMETER, firstMetal, lastMetal, width, height, even, cells, hierarchy, 0.1, drcSpacingRule, binary, useMaster, around, gap, genType, level);
        if (!this.templateButton.isSelected()) {
            ERectangle bnd = cellToFill.getBounds();
            double minSize = vddReserve + gndReserve + 2.0 * drcSpacingRule + 2.0 * gndReserve + 2.0 * vddReserve;
            minSize = vddReserve + gndReserve + 2.0 * drcSpacingRule + 2.0 * vddWidth + 2.0 * gndWidth;
            withWidth = true;
            config.setTargetValues(((RectangularShape)bnd).getWidth(), ((RectangularShape)bnd).getHeight(), minSize, minSize);
        }
        boolean metalW = isFlatSelected || withWidth;
        for (FillGenButton b3 : this.metalOptions) {
            if (!b3.isSelected()) continue;
            double vddVal = TextUtils.atofDistance(b3.vddSpace.getText());
            double gndVal = TextUtils.atofDistance(b3.gndSpace.getText());
            FillGeneratorTool.Units vddU = TRACKS;
            if (b3.vddUnit.getModel().getSelectedItem().equals("lambda")) {
                vddU = LAMBDA;
            }
            FillGeneratorTool.Units gndU = TRACKS;
            if (b3.gndUnit.getModel().getSelectedItem().equals("lambda")) {
                gndU = LAMBDA;
            }
            FillGenConfig.ReserveConfig c2 = config.reserveSpaceOnLayer(this.tech, b3.metal, vddVal, vddU, gndVal, gndU);
            if (!metalW) continue;
            vddU = TRACKS;
            if (b3.vddUnit.getModel().getSelectedItem().equals("lambda")) {
                vddU = LAMBDA;
            }
            gndU = TRACKS;
            if (b3.gndUnit.getModel().getSelectedItem().equals("lambda")) {
                gndU = LAMBDA;
            }
            vddVal = TextUtils.atofDistance(b3.vddWidth.getText());
            gndVal = TextUtils.atofDistance(b3.gndWidth.getText());
            c2.reserveWidthOnLayer(vddVal, vddU, gndVal, gndU);
        }
        this.setVisible(false);
        return config;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    public static void main(String[] args) {
        new FillGenDialog(null, new JFrame());
    }

    public static void openFillGeneratorDialog(Technology tech) {
        new FillGenDialog(tech, TopLevel.getCurrentJFrame());
    }

    private static class FillGenButton
    extends JCheckBox {
        JTextField vddSpace;
        JTextField vddWidth;
        JTextField gndSpace;
        JTextField gndWidth;
        JComboBox vddUnit;
        JComboBox vddWUnit;
        JComboBox gndUnit;
        JComboBox gndWUnit;
        int metal;

        FillGenButton(int metal) {
            super("Metal " + metal);
            this.metal = metal;
        }
    }
}

