/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableInteger;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public final class ExportChanges {
    public static void describeExports(boolean summarize) {
        new DescribeExports(summarize);
    }

    private static String addPossibleArcConnections(String infstr, Set<ArcProto> arcsSeen) {
        ArcProto ap;
        Iterator<ArcProto> aIt;
        Technology tech;
        int i2 = 0;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = it.next();
            aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ap = aIt.next();
                if (arcsSeen.contains(ap)) continue;
                ++i2;
            }
        }
        if (i2 == 0) {
            infstr = (String)infstr + " EVERYTHING";
        } else {
            i2 = 0;
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                tech = it.next();
                if (tech == Generic.tech()) continue;
                aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    ap = aIt.next();
                    if (!arcsSeen.contains(ap)) continue;
                    if (i2 != 0) {
                        infstr = (String)infstr + ",";
                    }
                    ++i2;
                    infstr = (String)infstr + " " + ap.getName();
                }
            }
        }
        return infstr;
    }

    public static void reExportAll() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Geometric> allNodes = new ArrayList<Geometric>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            allNodes.add(it.next());
        }
        new ReExportNodes(cell, allNodes, false, true, false, true, User.isIncrementRightmostIndex());
    }

    public static void reExportSelected(boolean wiredPorts, boolean unwiredPorts) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        List<Geometric> nodeInsts = MenuCommands.getSelectedObjects(true, false);
        if (nodeInsts.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Please select one or objects to re-export", "Re-export failed", 0);
            return;
        }
        new ReExportNodes(cell, nodeInsts, wiredPorts, unwiredPorts, false, true, User.isIncrementRightmostIndex());
    }

    public static void reExportSelectedPort() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Highlight high = highlighter.getOneHighlight();
        if (high == null || !high.isHighlightEOBJ() || !(high.getElectricObject() instanceof PortInst)) {
            System.out.println("Must first select a single node and its port");
            return;
        }
        PortInst pi = (PortInst)high.getElectricObject();
        PortProto pp = pi.getPortProto();
        NodeInst ni = pi.getNodeInst();
        ArrayList<PortInst> queuedExports = new ArrayList<PortInst>();
        Cell cell = ni.getParent();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst oNi = it.next();
            if (oNi.getProto() != ni.getProto()) continue;
            boolean unexported = true;
            Iterator<Export> eIt = oNi.getExports();
            while (eIt.hasNext()) {
                Export e2 = eIt.next();
                if (e2.getOriginalPort().getPortProto() != pp) continue;
                unexported = false;
                break;
            }
            if (!unexported) continue;
            PortInst oPi = oNi.findPortInstFromEquivalentProto(pp);
            queuedExports.add(oPi);
        }
        new ReExportPorts(cell, queuedExports, true, false, true, false, User.isIncrementRightmostIndex(), null);
    }

    public static void reExportPowerAndGround() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Geometric> allNodes = new ArrayList<Geometric>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            allNodes.add(it.next());
        }
        new ReExportNodes(cell, allNodes, false, true, true, true, User.isIncrementRightmostIndex());
    }

    public static int reExportNodes(Cell cell, List<Geometric> nodeInsts, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean ignorePrimitives, boolean fromRight, EditingPreferences ep) {
        int total = 0;
        for (Geometric geom : nodeInsts) {
            NodeInst ni = (NodeInst)geom;
            if (ignorePrimitives && !ni.isCellInstance() || ni.isIconOfParent()) continue;
            ArrayList<PortInst> portInstsToExport = new ArrayList<PortInst>();
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                boolean found = false;
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export pp = eIt.next();
                    if (pp.getOriginalPort() != pi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                portInstsToExport.add(pi);
            }
            total += ExportChanges.reExportPorts(cell, portInstsToExport, true, wiredPorts, unwiredPorts, onlyPowerGround, fromRight, null, ep);
        }
        return total;
    }

    public static void reExportHighlighted(boolean deep, boolean wiredPorts, boolean unwiredPorts) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Rectangle2D bounds = wnd.getHighlighter().getHighlightedArea(null);
        if (bounds == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must select area before re-exporting the highlighted area", "Re-export failed", 0);
            return;
        }
        ERectangle eBounds = ERectangle.fromLambda(bounds);
        new ReExportHighlighted(cell, eBounds, deep, wiredPorts, unwiredPorts, User.isIncrementRightmostIndex());
    }

    private static void reExportInBounds(Cell cell, Rectangle2D bounds, boolean deep, boolean wiredPorts, boolean unwiredPorts, boolean topLevel, boolean fromRight, EditingPreferences ep) {
        ArrayList<PortInst> queuedExports = new ArrayList<PortInst>();
        Iterator<Object> it = cell.getNodes();
        while (it.hasNext()) {
            ERectangle cellBounds;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || !bounds.intersects(cellBounds = ni.getBounds())) continue;
            if (deep) {
                FixpTransform goIn = ni.transformIn();
                Rectangle2D.Double boundsInside = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                DBMath.transformRect(boundsInside, goIn);
                ExportChanges.reExportInBounds((Cell)ni.getProto(), boundsInside, deep, wiredPorts, unwiredPorts, false, fromRight, ep);
            }
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                Poly portPoly = pi.getPoly();
                if (!bounds.contains(portPoly.getCenterX(), portPoly.getCenterY())) continue;
                queuedExports.add(pi);
            }
        }
        it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            PortInst pi = pp.getOriginalPort();
            queuedExports.remove(pi);
        }
        if (queuedExports.size() == 0) {
            if (topLevel) {
                System.out.println("No ports in area to export");
            }
            return;
        }
        int num = ExportChanges.reExportPorts(cell, queuedExports, true, wiredPorts, unwiredPorts, false, fromRight, null, ep);
        System.out.println(num + " ports exported.");
    }

    public static int reExportPorts(Cell cell, List<PortInst> portInsts, boolean sort, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean fromRight, Map<PortInst, Export> originalExports, EditingPreferences ep) {
        PortInst pi;
        int errorCode;
        EDatabase.serverDatabase().checkChanging();
        ArrayList<PortInst> portInstsFiltered = new ArrayList<PortInst>();
        for (PortInst pi2 : portInsts) {
            PortProto pp;
            if (!pi2.hasConnections() ? !unwiredPorts : !wiredPorts) continue;
            if (onlyPowerGround && !(pp = pi2.getPortProto()).isPower() && !pp.isGround()) continue;
            NodeInst ni = pi2.getNodeInst();
            Iterator<Export> exit = ni.getExports();
            while (exit.hasNext()) {
                Export e2 = exit.next();
                if (e2.getOriginalPort() != pi2) continue;
            }
            portInstsFiltered.add(pi2);
        }
        if (sort) {
            Collections.sort(portInstsFiltered, new PortInstsSortedByBusIndex());
        }
        HashSet<String> already = new HashSet<String>();
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            Export e3 = (Export)it.next();
            already.add(e3.getNameKey().toString());
        }
        HashMap<String, MutableInteger> nextPlainIndex = new HashMap<String, MutableInteger>();
        int total = 0;
        Iterator iterator = portInstsFiltered.iterator();
        while (iterator.hasNext() && (errorCode = CircuitChangeJobs.cantEdit(cell, (pi = (PortInst)iterator.next()).getNodeInst(), true, true, true)) >= 0) {
            int busWidth;
            if (errorCode > 0) continue;
            Name protoName = pi.getPortProto().getNameKey();
            PortCharacteristic pc = pi.getPortProto().getCharacteristic();
            Export refExport = null;
            if (originalExports != null && (refExport = originalExports.get(pi)) != null) {
                protoName = refExport.getNameKey();
                pc = refExport.getCharacteristic();
            }
            if ((busWidth = pi.getNodeInst().getNameKey().busWidth()) > 1) {
                protoName = NetworkTool.isBusAscending() ? Name.findName(protoName.toString() + "[0:" + (busWidth - 1) + "]") : Name.findName(protoName.toString() + "[" + (busWidth - 1) + ":0]");
            }
            String protoNameString = protoName.toString();
            Export newPp = Export.newInst(cell, pi, protoNameString = ElectricObject.uniqueObjectName(protoNameString, cell, Export.class, already, nextPlainIndex, false, fromRight), ep, pc);
            if (newPp == null) continue;
            System.out.println("Exported port " + protoNameString + " from port " + pi.getPortProto().getName() + " of node " + pi.getNodeInst().describe(false) + " in cell " + cell.describe(false));
            if (pi.getPortProto() instanceof Export) {
                newPp.copyTextDescriptorFrom((Export)pi.getPortProto(), Export.EXPORT_NAME);
                newPp.copyVarsFrom((Export)pi.getPortProto());
            }
            if (refExport != null) {
                newPp.copyTextDescriptorFrom(refExport, Export.EXPORT_NAME);
                newPp.copyVarsFrom(refExport);
                newPp.setCharacteristic(refExport.getCharacteristic());
            }
            ++total;
            already.add(newPp.getNameKey().toString());
        }
        return total;
    }

    public static PortInst getNewPortFromReferenceExport(NodeInst newNi, Export referenceExport) {
        PortInst origPi = referenceExport.getOriginalPort();
        PortInst newPi = newNi.findPortInstFromEquivalentProto(origPi.getPortProto());
        return newPi;
    }

    private static List<Export> getSelectedExports() {
        ArrayList<Export> selectedExports = new ArrayList<Export>();
        EditWindow wnd = EditWindow.getCurrent();
        List<DisplayedText> dts = wnd.getHighlighter().getHighlightedText(true);
        for (DisplayedText dt : dts) {
            if (!(dt.getElectricObject() instanceof Export)) continue;
            Export pp = (Export)dt.getElectricObject();
            selectedExports.add(pp);
        }
        return selectedExports;
    }

    public static void deleteExport() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        List<Export> exportsToDelete = ExportChanges.getSelectedExports();
        if (exportsToDelete.size() == 0) {
            System.out.println("There are no selected exports to delete");
            return;
        }
        ExportChanges.deleteExports(cell, exportsToDelete);
    }

    public static void exportConnectionList() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        List<Export> exportsToExamine = ExportChanges.getSelectedExports();
        if (exportsToExamine.size() == 0) {
            System.out.println("There are no selected exports to examine");
            return;
        }
        for (Export e2 : exportsToExamine) {
            HashSet<ArcInst> arcsOnExport = new HashSet<ArcInst>();
            ExportChanges.climbUpHierarchy(cell, e2, arcsOnExport);
            if (arcsOnExport.size() == 0) {
                System.out.println("Export " + e2.getName() + " has no arcs on it anywhere up the hierarchy");
                continue;
            }
            System.out.println("Export " + e2.getName() + " has these arcs on it:");
            for (ArcInst ai : arcsOnExport) {
                System.out.println("  Arc " + ai.describe(false) + " in cell " + ai.getParent().describe(false));
            }
        }
    }

    private static void climbUpHierarchy(Cell cell, Export e2, Set<ArcInst> arcsOnExport) {
        Iterator<NodeInst> it = cell.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            PortInst pi = ni.findPortInstFromProto(e2);
            Iterator<Connection> cIt = pi.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                arcsOnExport.add(con.getArc());
            }
            Iterator<Export> eIt = pi.getExports();
            while (eIt.hasNext()) {
                Export furtherUp = eIt.next();
                ExportChanges.climbUpHierarchy(ni.getParent(), furtherUp, arcsOnExport);
            }
        }
    }

    public static void deleteExportsOnSelected() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        EditWindow wnd = EditWindow.getCurrent();
        List<Geometric> highs = wnd.getHighlighter().getHighlightedEObjs(true, false);
        for (Geometric geom : highs) {
            NodeInst ni = (NodeInst)geom;
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                exportsToDelete.add(eIt.next());
            }
        }
        if (exportsToDelete.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There are no exports on the highlighted objects", "Re-export failed", 0);
            return;
        }
        ExportChanges.deleteExports(cell, exportsToDelete);
    }

    public static void deleteExportsInArea() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        EditWindow wnd = EditWindow.getCurrent();
        Rectangle2D bounds = wnd.getHighlighter().getHighlightedArea(null);
        if (bounds == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must select something before deleting the highlighted exports", "Export delete failed", 0);
            return;
        }
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e2 = eIt.next();
                PortInst pi = e2.getOriginalPort();
                Poly poly = pi.getPoly();
                if (!bounds.contains(poly.getCenterX(), poly.getCenterY())) continue;
                exportsToDelete.add(e2);
            }
        }
        if (exportsToDelete.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There are no exports in the highlighted area", "Re-export failed", 0);
            return;
        }
        ExportChanges.deleteExports(cell, exportsToDelete);
    }

    public static void deleteExports(Cell cell, List<Export> exportsToDelete) {
        Export e2;
        int errorCode;
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, false) != 0) {
            return;
        }
        HashSet<Export> exportsConfirmed = new HashSet<Export>();
        Iterator<Export> iterator = exportsToDelete.iterator();
        while (iterator.hasNext() && (errorCode = CircuitChangeJobs.cantEdit(cell, (e2 = iterator.next()).getOriginalPort().getNodeInst(), true, true, false)) >= 0) {
            if (errorCode > 0) continue;
            exportsConfirmed.add(e2);
        }
        if (exportsConfirmed.isEmpty()) {
            System.out.println("No exports deleted");
            return;
        }
        new DeleteExports(cell, exportsConfirmed);
    }

    public static void moveExport() {
        Export source = null;
        PortInst dest = null;
        EditWindow wnd = EditWindow.getCurrent();
        for (Highlight h2 : wnd.getHighlighter().getHighlights()) {
            boolean used = false;
            if (h2.isHighlightEOBJ()) {
                if (h2.getElectricObject() instanceof PortInst) {
                    if (dest != null) {
                        System.out.println("Must select only one node-port as a destination of the move");
                        return;
                    }
                    dest = (PortInst)h2.getElectricObject();
                    used = true;
                }
            } else if (h2.isHighlightText() && h2.getVarKey() == Export.EXPORT_NAME && h2.getElectricObject() instanceof Export) {
                source = (Export)h2.getElectricObject();
                used = true;
            }
            if (used) continue;
            System.out.println("Moving exports: select one export to move, and one node-port as its destination");
            return;
        }
        if (source == null || dest == null) {
            System.out.println("First select one export to move, and one node-port as its destination");
            return;
        }
        new MoveExport(source, dest);
    }

    public static void renameExport() {
        EditWindow wnd = EditWindow.getCurrent();
        Highlight h2 = wnd.getHighlighter().getOneHighlight();
        if (h2 == null || h2.getVarKey() != Export.EXPORT_NAME || !(h2.getElectricObject() instanceof Export)) {
            System.out.println("Must select an export name before renaming it");
            return;
        }
        Export pp = (Export)h2.getElectricObject();
        String response = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Rename export", pp.getName());
        if (response == null) {
            return;
        }
        new RenameExport(pp, response);
    }

    public static void showExports(List<Export> exports) {
        ExportChanges.showPortsAndExports(null, exports);
    }

    public static void showPorts(List<PortInst> ports) {
        if (ports == null) {
            ports = new ArrayList<PortInst>();
            EditWindow wnd = EditWindow.getCurrent();
            List<Geometric> nodes = wnd.getHighlighter().getHighlightedEObjs(true, false);
            if (nodes == null || nodes.size() == 0) {
                System.out.println("No nodes are highlighted");
                return;
            }
            for (Geometric geom : nodes) {
                NodeInst ni = (NodeInst)geom;
                Iterator<PortInst> it = ni.getPortInsts();
                while (it.hasNext()) {
                    ports.add(it.next());
                }
            }
        }
        ExportChanges.showPortsAndExports(ports, null);
    }

    private static void showPortsAndExports(List<PortInst> ports, List<Export> exports) {
        double shift;
        int i2;
        int botSideCount;
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
            return;
        }
        int total = cell.getNumPorts();
        if (ports != null) {
            total = ports.size();
        }
        Rectangle2D displayable = wnd.displayableBounds();
        ShownPorts[] portList = new ShownPorts[total];
        total = 0;
        int ignored = 0;
        if (ports == null) {
            if (exports == null) {
                exports = new ArrayList<Export>();
                Iterator<Object> it = cell.getPorts();
                while (it.hasNext()) {
                    Export pp = (Export)it.next();
                    exports.add(pp);
                }
            }
            for (Export pp : exports) {
                poly = pp.getPoly();
                ptOut = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                if (((Point2D)ptOut).getX() < displayable.getMinX() || ((Point2D)ptOut).getX() > displayable.getMaxX() || ((Point2D)ptOut).getY() < displayable.getMinY() || ((Point2D)ptOut).getY() > displayable.getMaxY()) {
                    ++ignored;
                    continue;
                }
                portList[total] = new ShownPorts();
                portList[total].loc = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                portList[total].pp = pp;
                ++total;
            }
        } else {
            for (PortInst pi : ports) {
                poly = pi.getPoly();
                ptOut = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                if (((Point2D)ptOut).getX() < displayable.getMinX() || ((Point2D)ptOut).getX() > displayable.getMaxX() || ((Point2D)ptOut).getY() < displayable.getMinY() || ((Point2D)ptOut).getY() > displayable.getMaxY()) {
                    ++ignored;
                    continue;
                }
                portList[total] = new ShownPorts();
                portList[total].loc = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                portList[total].pp = pi.getPortProto();
                ++total;
            }
        }
        int fontSize = EditWindow.getDefaultFontSize();
        ScreenPoint screenOrigin = wnd.databaseToScreen(0.0, 0.0);
        Point2D thPoint = wnd.screenToDatabase(screenOrigin.getX(), screenOrigin.getY() + (long)fontSize);
        double textHeight = Math.abs(thPoint.getY());
        Point2D.Double[] labelLocs = new Point2D.Double[total];
        double digitIndentX = displayable.getWidth() / 20.0;
        double digitIndentY = displayable.getHeight() / 20.0;
        int leftSideCount = botSideCount;
        int topSideCount = botSideCount;
        int numPerSide = (total + 3) / 4;
        int rightSideCount = botSideCount = numPerSide;
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --botSideCount;
        }
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --topSideCount;
        }
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --rightSideCount;
        }
        int fill = 0;
        for (i2 = 0; i2 < leftSideCount; ++i2) {
            labelLocs[fill++] = new Point2D.Double(displayable.getMinX() + digitIndentX, displayable.getHeight() / (double)(leftSideCount + 1) * (double)(i2 + 1) + displayable.getMinY());
        }
        for (i2 = 0; i2 < topSideCount; ++i2) {
            shift = (double)(i2 % 3) * textHeight - textHeight;
            labelLocs[fill++] = new Point2D.Double(displayable.getWidth() / (double)(topSideCount + 1) * (double)(i2 + 1) + displayable.getMinX(), displayable.getMaxY() - digitIndentY - shift);
        }
        for (i2 = 0; i2 < rightSideCount; ++i2) {
            labelLocs[fill++] = new Point2D.Double(displayable.getMaxX() - digitIndentX, displayable.getMaxY() - displayable.getHeight() / (double)(rightSideCount + 1) * (double)(i2 + 1));
        }
        for (i2 = 0; i2 < botSideCount; ++i2) {
            shift = (double)(i2 % 3) * textHeight - textHeight;
            labelLocs[fill++] = new Point2D.Double(displayable.getMaxX() - displayable.getWidth() / (double)(botSideCount + 1) * (double)(i2 + 1), displayable.getMinY() + digitIndentY - shift);
        }
        double x = 0.0;
        double y = 0.0;
        for (int i3 = 0; i3 < total; ++i3) {
            x += portList[i3].loc.getX();
            y += portList[i3].loc.getY();
        }
        Point2D.Double center = new Point2D.Double(x / (double)total, y / (double)total);
        for (int i4 = 0; i4 < total; ++i4) {
            portList[i4].angle = ((Point2D)center).getX() == portList[i4].loc.getX() && ((Point2D)center).getY() == portList[i4].loc.getY() ? 0 : -DBMath.figureAngle(center, portList[i4].loc);
        }
        ArrayList<ShownPorts> portLabels = new ArrayList<ShownPorts>();
        for (int i5 = 0; i5 < total; ++i5) {
            portLabels.add(portList[i5]);
        }
        Collections.sort(portLabels, new SortPortAngle());
        total = 0;
        for (ShownPorts sp : portLabels) {
            portList[total++] = sp;
        }
        double bestDist = 0.0;
        int bestOff = 0;
        for (int i6 = 0; i6 < total; ++i6) {
            double dist = 0.0;
            for (int j2 = 0; j2 < total; ++j2) {
                dist += labelLocs[j2].distance(portList[(j2 + i6) % total].loc);
            }
            if (!(dist < bestDist) && i6 != 0) continue;
            bestOff = i6;
            bestDist = dist;
        }
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.clear();
        if (ports != null && !ports.isEmpty()) {
            PortInst pi = ports.get(0);
            NodeInst ni = pi.getNodeInst();
            highlighter.addElectricObject(ni, cell);
        }
        Font font = wnd.getFont(null);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        LineMetrics lm = font.getLineMetrics("hy", frc);
        double baselineVer = wnd.getTextUnitSize(lm.getDescent());
        double baselineHor = wnd.getTextUnitSize(2.0);
        for (int i7 = 0; i7 < total; ++i7) {
            int index = (bestOff + i7) % total;
            Point2D loc = labelLocs[i7];
            String msg = portList[index].pp.getName();
            ScreenPoint locationLabel = wnd.databaseToScreen(loc.getX(), loc.getY());
            long locationLabelX = locationLabel.getX();
            long locationLabelY = locationLabel.getY();
            ScreenPoint locationPort = wnd.databaseToScreen(portList[index].loc.getX(), portList[index].loc.getY());
            GlyphVector v = font.createGlyphVector(frc, msg);
            Rectangle2D glyphBounds = v.getLogicalBounds();
            long otherX = locationLabelX + (long)((int)glyphBounds.getWidth());
            long otherY = locationLabelY - (long)((int)glyphBounds.getHeight());
            Point2D locOther = wnd.screenToDatabase(otherX, otherY);
            if (otherX > (long)wnd.getSize().width) {
                long offDist = otherX - (long)wnd.getSize().width;
                otherX -= offDist;
                loc = wnd.screenToDatabase(locationLabelX -= offDist, locationLabelY);
            }
            if (Math.abs(locationPort.getX() - locationLabelX) > Math.abs(locationPort.getX() - otherX)) {
                locationLabelX = otherX;
            }
            if (Math.abs(locationPort.getY() - locationLabelY) > Math.abs(locationPort.getY() - otherY)) {
                locationLabelY = otherY;
            }
            Point2D locLineEnd = wnd.screenToDatabase(locationLabelX, locationLabelY);
            highlighter.addMessage(cell, msg, new Point2D.Double(loc.getX() + baselineHor, loc.getY() + baselineVer));
            Point2D.Double odd1 = new Point2D.Double(loc.getX(), locOther.getY());
            Point2D.Double odd2 = new Point2D.Double(locOther.getX(), loc.getY());
            highlighter.addLine(loc, odd1, cell);
            highlighter.addLine(odd1, locOther, cell);
            highlighter.addLine(locOther, odd2, cell);
            highlighter.addLine(odd2, loc, cell);
            highlighter.addLine(locLineEnd, portList[index].loc, cell);
        }
        highlighter.finished();
        System.out.println(total + " exported ports to show");
        if (ignored > 0) {
            System.out.println("Could not display " + ignored + " ports (outside of the window)");
        }
    }

    public static void synchronizeLibrary() {
        Library oLib2;
        List<Library> libs = Library.getVisibleLibraries();
        Library curLib = Library.getCurrent();
        int otherLibraries = libs.size() - 1;
        if (otherLibraries < 1) {
            System.out.println("There must be an other library (not the current one) from which to copy exports.");
            return;
        }
        Object[] libNames = new String[otherLibraries];
        int i2 = 0;
        for (Library oLib2 : libs) {
            if (oLib2 == curLib) continue;
            libNames[i2++] = oLib2.getName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Choose another library from which to copy exports", "Choose a Library", 3, null, libNames, libNames[0]);
        if (chosen == null) {
            return;
        }
        oLib2 = Library.findLibrary(chosen);
        if (oLib2 == null) {
            return;
        }
        new SynchronizeExports(oLib2);
    }

    public static void replaceFromOtherLibrary() {
        Library oLib2;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        List<Library> libs = Library.getVisibleLibraries();
        Library curLib = Library.getCurrent();
        int otherLibraries = libs.size() - 1;
        if (otherLibraries < 1) {
            System.out.println("There must be an other library (not the current one) from which to replace cells.");
            return;
        }
        Object[] libNames = new String[otherLibraries];
        int i2 = 0;
        for (Library oLib2 : libs) {
            if (oLib2 == curLib) continue;
            libNames[i2++] = oLib2.getName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Choose another library from which to replace cell instances", "Choose a Library", 3, null, libNames, libNames[0]);
        if (chosen == null) {
            return;
        }
        oLib2 = Library.findLibrary(chosen);
        if (oLib2 == null) {
            return;
        }
        new ReplaceFromOtherLibrary(curCell, oLib2);
    }

    private static class DescribeExports
    extends Job {
        private Cell cell = WindowFrame.needCurCell();
        private boolean summarize;

        protected DescribeExports(boolean summarize) {
            super("Describe Exports", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.summarize = summarize;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.cell == null) {
                return false;
            }
            Netlist netlist = this.cell.getNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted your query (network information unavailable).  Please try again");
                return false;
            }
            Cell wnp = this.cell.contentsView();
            if (wnp == null) {
                wnp = this.cell.iconView();
            }
            if (wnp == this.cell) {
                wnp = null;
            }
            if (this.cell.getNumPorts() == 0) {
                System.out.println("There are no exports on " + String.valueOf(this.cell));
                return true;
            }
            ArrayList<ExportList> exports = new ArrayList<ExportList>();
            Iterator<PortProto> it = this.cell.getPorts();
            while (it.hasNext()) {
                ExportList el = new ExportList();
                el.pp = (Export)it.next();
                el.equiv = -1;
                el.busList = -1;
                exports.add(el);
            }
            Collections.sort(exports, new ExportSortedByNameAndType());
            int num_found = exports.size();
            if (this.summarize) {
                Export ppJ;
                int blJ;
                int eqJ;
                int j2;
                block1: for (j2 = 0; j2 < num_found; ++j2) {
                    eqJ = ((ExportList)exports.get((int)j2)).equiv;
                    blJ = ((ExportList)exports.get((int)j2)).busList;
                    if (eqJ != -1 || blJ != -1) continue;
                    ppJ = ((ExportList)exports.get((int)j2)).pp;
                    for (int k2 = j2 + 1; k2 < num_found; ++k2) {
                        int eqK = ((ExportList)exports.get((int)k2)).equiv;
                        int blK = ((ExportList)exports.get((int)k2)).busList;
                        if (eqK != -1 || blK != -1) continue;
                        Export ppK = ((ExportList)exports.get((int)k2)).pp;
                        if (ppJ.getCharacteristic() != ppK.getCharacteristic()) continue block1;
                        if (!netlist.sameNetwork(ppJ.getOriginalPort().getNodeInst(), ppJ.getOriginalPort().getPortProto(), ppK.getOriginalPort().getNodeInst(), ppK.getOriginalPort().getPortProto())) continue;
                        ((ExportList)exports.get((int)k2)).equiv = j2;
                        ((ExportList)exports.get((int)j2)).equiv = -2;
                    }
                }
                block3: for (j2 = 0; j2 < num_found; ++j2) {
                    String ptJ;
                    int sqPosJ;
                    eqJ = ((ExportList)exports.get((int)j2)).equiv;
                    blJ = ((ExportList)exports.get((int)j2)).busList;
                    if (eqJ != -1 || blJ != -1 || (sqPosJ = (ptJ = (ppJ = ((ExportList)exports.get((int)j2)).pp).getName()).indexOf(91)) < 0) continue;
                    for (int k3 = j2 + 1; k3 < num_found; ++k3) {
                        int eqK = ((ExportList)exports.get((int)k3)).equiv;
                        int blK = ((ExportList)exports.get((int)k3)).busList;
                        if (eqK != -1 || blK != -1) continue;
                        Export ppK = ((ExportList)exports.get((int)k3)).pp;
                        if (ppJ.getCharacteristic() != ppK.getCharacteristic()) continue block3;
                        String ptK = ppK.getName();
                        int sqPosK = ptK.indexOf(91);
                        if (sqPosJ != sqPosK || !ptJ.substring(0, sqPosJ).equalsIgnoreCase(ptK.substring(0, sqPosK))) continue;
                        ((ExportList)exports.get((int)k3)).busList = j2;
                        ((ExportList)exports.get((int)j2)).busList = -2;
                    }
                }
            }
            System.out.println("----- Exports on " + String.valueOf(this.cell) + ": total " + num_found + " -----");
            HashSet<ArcProto> arcsSeen = new HashSet<ArcProto>();
            for (int j3 = 0; j3 < num_found; ++j3) {
                int m2;
                ExportList el = (ExportList)exports.get(j3);
                Export pp = el.pp;
                if (el.equiv >= 0 || el.busList >= 0) continue;
                Iterator<Technology> it2 = Technology.getTechnologies();
                while (it2.hasNext()) {
                    Technology tech = it2.next();
                    Iterator<ArcProto> aIt = tech.getArcs();
                    while (aIt.hasNext()) {
                        ArcProto ap = aIt.next();
                        arcsSeen.remove(ap);
                    }
                }
                Object infstr = "";
                String activity = pp.getCharacteristic().getFullName();
                for (m2 = j3 + 1; m2 < num_found && ((ExportList)exports.get((int)m2)).equiv != j3; ++m2) {
                }
                double lx = 0.0;
                double hx = 0.0;
                double ly = 0.0;
                double hy = 0.0;
                if (m2 < num_found) {
                    infstr = (String)infstr + activity + " exports ";
                    for (k = j3; k < num_found; ++k) {
                        if (j3 != k && ((ExportList)exports.get((int)k)).equiv != j3) continue;
                        if (j3 != k) {
                            infstr = (String)infstr + ", ";
                        }
                        Export opp = ((ExportList)exports.get((int)k)).pp;
                        infstr = (String)infstr + "'" + opp.getName() + "'";
                        Poly poly = opp.getPoly();
                        bnd = poly.getBounds2D();
                        double lowX = ((RectangularShape)bnd).getMinX();
                        double highX = ((RectangularShape)bnd).getMaxX();
                        lowY = ((RectangularShape)bnd).getMinY();
                        double highY = ((RectangularShape)bnd).getMaxY();
                        if (j3 == k) {
                            lx = lowX;
                            hx = highX;
                            ly = lowY;
                            hy = highY;
                        } else {
                            if (lowX < lx) {
                                lx = lowX;
                            }
                            if (highX > hx) {
                                hx = highX;
                            }
                            if (lowY < ly) {
                                ly = lowY;
                            }
                            if (highY > hy) {
                                hy = highY;
                            }
                        }
                        arcList = opp.getBasePort().getConnections();
                        for (a = 0; a < arcList.length; ++a) {
                            arcsSeen.add(arcList[a]);
                        }
                    }
                    infstr = (String)infstr + " at (" + lx + "<=X<=" + hx + ", " + ly + "<=Y<=" + hy + "), electrically connected to";
                    infstr = ExportChanges.addPossibleArcConnections((String)infstr, arcsSeen);
                } else {
                    for (m2 = j3 + 1; m2 < num_found && ((ExportList)exports.get((int)m2)).busList != j3; ++m2) {
                    }
                    if (m2 < num_found) {
                        for (k = j3; k < num_found; ++k) {
                            if (j3 != k && ((ExportList)exports.get((int)k)).busList != j3) continue;
                            Export opp = ((ExportList)exports.get((int)k)).pp;
                            Poly poly = opp.getPoly();
                            bnd = poly.getBounds2D();
                            double lowX = ((RectangularShape)bnd).getMinX();
                            double highX = ((RectangularShape)bnd).getMaxX();
                            lowY = ((RectangularShape)bnd).getMinY();
                            double highY = ((RectangularShape)bnd).getMaxY();
                            if (j3 == k) {
                                lx = lowX;
                                hx = highX;
                                ly = lowY;
                                hy = highY;
                            } else {
                                if (lowX < lx) {
                                    lx = lowX;
                                }
                                if (highX > hx) {
                                    hx = highX;
                                }
                                if (lowY < ly) {
                                    ly = lowY;
                                }
                                if (highY > hy) {
                                    hy = highY;
                                }
                            }
                            arcList = opp.getBasePort().getConnections();
                            for (a = 0; a < arcList.length; ++a) {
                                arcsSeen.add(arcList[a]);
                            }
                        }
                        ArrayList<Export> sortedBusList = new ArrayList<Export>();
                        sortedBusList.add(((ExportList)exports.get((int)j3)).pp);
                        for (int k4 = j3 + 1; k4 < num_found; ++k4) {
                            ExportList elK = (ExportList)exports.get(k4);
                            if (elK.busList != j3) continue;
                            sortedBusList.add(elK.pp);
                        }
                        Collections.sort(sortedBusList, new ExportSortedByBusIndex());
                        boolean first = true;
                        for (Export ppS : sortedBusList) {
                            String pt1 = ppS.getName();
                            int openPos = pt1.indexOf(91);
                            if (first) {
                                infstr = (String)infstr + activity + " ports '" + pt1.substring(0, openPos) + "[";
                                first = false;
                            } else {
                                infstr = (String)infstr + ",";
                            }
                            int closePos = pt1.lastIndexOf(93);
                            infstr = (String)infstr + pt1.substring(openPos + 1, closePos);
                        }
                        infstr = (String)infstr + "]' at (" + lx + "<=X<=" + hx + ", " + ly + "<=Y<=" + hy + "), same bus, connects to";
                        infstr = ExportChanges.addPossibleArcConnections((String)infstr, arcsSeen);
                    } else {
                        infstr = (String)infstr + activity + " export '" + pp.getName() + "' at ";
                        Poly poly = pp.getPoly();
                        FixpRectangle bnd = poly.getBounds2D();
                        double lowX = ((RectangularShape)bnd).getMinX();
                        double highX = ((RectangularShape)bnd).getMaxX();
                        double lowY = ((RectangularShape)bnd).getMinY();
                        double highY = ((RectangularShape)bnd).getMaxY();
                        infstr = lowX == highX && lowY == highY ? (String)infstr + "(" + lowX + ", " + lowY + ")" : (String)infstr + "(" + lowX + "<=" + highX + ", " + lowY + "<=" + highY + ")";
                        ArcProto[] arcList = pp.getBasePort().getConnections();
                        for (int a2 = 0; a2 < arcList.length; ++a2) {
                            arcsSeen.add(arcList[a2]);
                        }
                        infstr = (String)infstr + " connects to";
                        infstr = ExportChanges.addPossibleArcConnections((String)infstr, arcsSeen);
                        if (wnp != null && pp.findEquivalent(wnp) == null) {
                            infstr = (String)infstr + " *** no equivalent in " + String.valueOf(wnp);
                        }
                    }
                }
                TextUtils.printLongString((String)infstr);
            }
            if (wnp != null) {
                Iterator<PortProto> it3 = wnp.getPorts();
                while (it3.hasNext()) {
                    Export pp = (Export)it3.next();
                    if (pp.findEquivalent(this.cell) != null) continue;
                    System.out.println("*** Export " + pp.getName() + ", found in " + String.valueOf(wnp) + ", is missing here");
                }
            }
            return true;
        }
    }

    private static class ReExportNodes
    extends Job {
        private Cell cell;
        private List<Geometric> nodeInsts;
        private boolean wiredPorts;
        private boolean unwiredPorts;
        private boolean onlyPowerGround;
        private boolean ignorePrimitives;
        private boolean fromRight;

        public ReExportNodes(Cell cell, List<Geometric> nodeInsts, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean ignorePrimitives, boolean fromRight) {
            super("Re-export nodes", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nodeInsts = nodeInsts;
            this.wiredPorts = wiredPorts;
            this.unwiredPorts = unwiredPorts;
            this.onlyPowerGround = onlyPowerGround;
            this.ignorePrimitives = ignorePrimitives;
            this.fromRight = fromRight;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, true, true) != 0) {
                return false;
            }
            int num = ExportChanges.reExportNodes(this.cell, this.nodeInsts, this.wiredPorts, this.unwiredPorts, this.onlyPowerGround, this.ignorePrimitives, this.fromRight, ep);
            System.out.println(num + " ports exported.");
            return true;
        }
    }

    public static class ReExportPorts
    extends Job {
        private Cell cell;
        private List<PortInst> portInsts;
        private boolean sort;
        private boolean wiredPorts;
        private boolean unwiredPorts;
        private boolean onlyPowerGround;
        private boolean fromRight;
        private Map<PortInst, Export> originalExports;

        public ReExportPorts(Cell cell, List<PortInst> portInsts, boolean sort, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean fromRight, Map<PortInst, Export> originalExports) {
            super("Re-export ports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.portInsts = portInsts;
            this.wiredPorts = wiredPorts;
            this.unwiredPorts = unwiredPorts;
            this.onlyPowerGround = onlyPowerGround;
            this.fromRight = fromRight;
            this.sort = sort;
            this.originalExports = originalExports;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, true, true) != 0) {
                return false;
            }
            int num = ExportChanges.reExportPorts(this.cell, this.portInsts, this.sort, this.wiredPorts, this.unwiredPorts, this.onlyPowerGround, this.fromRight, this.originalExports, ep);
            System.out.println(num + " ports exported.");
            return true;
        }
    }

    private static class ReExportHighlighted
    extends Job {
        private Cell cell;
        private ERectangle bounds;
        private boolean deep;
        private boolean wiredPorts;
        private boolean unwiredPorts;
        private boolean fromRight;

        public ReExportHighlighted(Cell cell, ERectangle bounds, boolean deep, boolean wiredPorts, boolean unwiredPorts, boolean fromRight) {
            super("Re-export highlighted", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.bounds = bounds;
            this.deep = deep;
            this.wiredPorts = wiredPorts;
            this.unwiredPorts = unwiredPorts;
            this.fromRight = fromRight;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, true, true) != 0) {
                return false;
            }
            ExportChanges.reExportInBounds(this.cell, this.bounds, this.deep, this.wiredPorts, this.unwiredPorts, true, this.fromRight, ep);
            return true;
        }
    }

    private static class PortInstsSortedByBusIndex
    implements Comparator<PortInst> {
        private PortInstsSortedByBusIndex() {
        }

        @Override
        public int compare(PortInst p1, PortInst p2) {
            String s1 = p1.getPortProto().getName();
            String s2 = p2.getPortProto().getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    private static class DeleteExports
    extends Job {
        private Cell cell;
        private Set<Export> exportsToDelete;

        public DeleteExports(Cell cell, Set<Export> exportsToDelete) {
            super("Delete exports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.exportsToDelete = exportsToDelete;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.cell.killExports(this.exportsToDelete);
            System.out.println(this.exportsToDelete.size() + " exports deleted");
            return true;
        }
    }

    private static class MoveExport
    extends Job {
        private Export source;
        private PortInst dest;

        protected MoveExport(Export source, PortInst dest) {
            super("Move export", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.source = source;
            this.dest = dest;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.source.move(this.dest);
            return true;
        }
    }

    public static class RenameExport
    extends Job {
        private Export pp;
        private String newName;

        public RenameExport(Export pp, String newName) {
            super("Rename Export" + pp.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.newName = newName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.pp.rename(this.newName);
            return true;
        }
    }

    private static class ShownPorts {
        Point2D loc;
        PortProto pp;
        int angle;

        private ShownPorts() {
        }
    }

    private static class SortPortAngle
    implements Comparator<ShownPorts> {
        private SortPortAngle() {
        }

        @Override
        public int compare(ShownPorts s1, ShownPorts s2) {
            return s1.angle - s2.angle;
        }
    }

    private static class SynchronizeExports
    extends Job {
        private Library oLib;

        private SynchronizeExports(Library oLib) {
            super("Synchronize exports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.oLib = oLib;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            int newPorts = 0;
            boolean noCells = false;
            Library curLib = Library.getCurrent();
            Iterator<Cell> cIt = curLib.getCells();
            while (cIt.hasNext()) {
                Cell np = cIt.next();
                Iterator<Cell> oCIt = this.oLib.getCells();
                while (oCIt.hasNext()) {
                    Cell oNp = oCIt.next();
                    if (!np.getName().equals(oNp.getName())) continue;
                    Iterator<PortProto> pIt = oNp.getPorts();
                    while (pIt.hasNext()) {
                        PortInst pi;
                        Export oPp = (Export)pIt.next();
                        Export pp = (Export)np.findPortProto(oPp.getName());
                        if (pp != null) continue;
                        NodeInst oNi = oPp.getOriginalPort().getNodeInst();
                        if (oNi.isCellInstance()) {
                            if (!noCells) {
                                System.out.println("Cannot yet make exports that come from other cell instances (i.e. export " + oPp.getName() + " in " + String.valueOf(oNp) + ")");
                            }
                            noCells = true;
                            continue;
                        }
                        NodeInst ni = NodeInst.makeInstance(oNi.getProto(), ep, (Point2D)oNi.getAnchorCenter(), oNi.getXSize(), oNi.getYSize(), np, oNi.getOrient(), null, oNi.getTechSpecific());
                        if (ni == null || (pp = Export.newInst(np, pi = ni.findPortInstFromEquivalentProto(oPp.getOriginalPort().getPortProto()), oPp.getName(), ep, oPp.getCharacteristic())) == null) continue;
                        pp.copyTextDescriptorFrom(oPp, Export.EXPORT_NAME);
                        pp.copyVarsFrom(oPp);
                        ++newPorts;
                    }
                }
            }
            System.out.println("Created " + newPorts + " new exports in current " + String.valueOf(curLib));
            return true;
        }
    }

    private static class ReplaceFromOtherLibrary
    extends Job {
        private Cell cell;
        private Library oLib;

        private ReplaceFromOtherLibrary(Cell cell, Library oLib) {
            super("Replace Cell Instances From Another Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.oLib = oLib;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            HashMap<NodeInst, Cell> cellsToReplace = new HashMap<NodeInst, Cell>();
            Iterator<NodeInst> it = this.cell.getNodes();
            while (it.hasNext()) {
                Cell newType;
                Cell oldType;
                NodeInst ni = it.next();
                if (!ni.isCellInstance() || ni.getXSize() != 0.0 || ni.getYSize() != 0.0 || (oldType = (Cell)ni.getProto()).getLibrary() == this.oLib) continue;
                Object nameToFind = oldType.getName();
                if (oldType.getView() != View.UNKNOWN) {
                    nameToFind = (String)nameToFind + oldType.getView().getAbbreviationExtension();
                }
                if ((newType = this.oLib.findNodeProto((String)nameToFind)) == null) continue;
                cellsToReplace.put(ni, newType);
            }
            System.out.println("Changing " + cellsToReplace.size() + " cell instances...");
            int replacements = 0;
            for (NodeInst ni : cellsToReplace.keySet()) {
                Cell newType = (Cell)cellsToReplace.get(ni);
                ni.replace(newType, ep, true, true, true);
                ++replacements;
            }
            System.out.println("Changed " + replacements + " cell instances");
            return true;
        }
    }

    public static class ExportsByNumber
    implements Comparator<Export> {
        @Override
        public int compare(Export e1, Export e2) {
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    public static class RenumberNumericExports
    extends Job {
        private List<Export> exports;

        public RenumberNumericExports(List<Export> exports) {
            super("Rename Numeric Exports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.exports = exports;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Collections.sort(this.exports, new ExportsByNumber());
            String lastPureName = "";
            int lastIndex = 0;
            for (Export e2 : this.exports) {
                String pureName;
                int numberPos;
                String name = e2.getName();
                for (numberPos = name.length(); numberPos > 0 && Character.isDigit(name.charAt(numberPos - 1)); --numberPos) {
                }
                int nameEnd = numberPos;
                if (nameEnd > 0 && name.charAt(nameEnd - 1) == '_') {
                    --nameEnd;
                }
                if (!(pureName = name.substring(0, nameEnd)).equals(lastPureName)) {
                    lastIndex = 0;
                }
                lastPureName = pureName;
                Object newName = pureName;
                if (lastIndex > 0) {
                    newName = (String)newName + "_" + lastIndex;
                }
                ++lastIndex;
                if (((String)newName).equals(name)) continue;
                e2.rename((String)newName);
            }
            return true;
        }
    }

    public static class ChangeExportBodyOnly
    extends Job {
        private Export pp;
        private boolean bo;

        public ChangeExportBodyOnly(Export pp, boolean bo) {
            super("Change Export Body-Only " + pp.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.bo = bo;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.pp.setBodyOnly(this.bo);
            return true;
        }
    }

    public static class ChangeExportCharacteristic
    extends Job {
        private Export pp;
        private PortCharacteristic newCh;

        public ChangeExportCharacteristic(Export pp, PortCharacteristic newCh) {
            super("Change Export Characteristics " + pp.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.newCh = newCh;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.pp.setCharacteristic(this.newCh);
            return true;
        }
    }

    public static class FollowExport
    extends Job {
        private Cell cell = WindowFrame.needCurCell();

        public FollowExport() {
            super("Re-export highlighted", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            if (this.cell == null) {
                return;
            }
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int i2;
            List<Export> exportsToFollow = ExportChanges.getSelectedExports();
            if (exportsToFollow.size() == 0) {
                System.out.println("There are no selected exports to follow");
                return false;
            }
            HashMap networksSeen = new HashMap();
            HashMap exportsSeen = new HashMap();
            ArrayList<Export> exportsFollowed = new ArrayList<Export>();
            for (Export e2 : exportsToFollow) {
                exportsFollowed.add(e2);
            }
            for (i2 = 0; i2 < exportsFollowed.size(); ++i2) {
                Export e2;
                e2 = (Export)exportsFollowed.get(i2);
                Cell upperCell = e2.getParent();
                Iterator<NodeInst> nIt = upperCell.getInstancesOf();
                while (nIt.hasNext()) {
                    Netlist nl;
                    Network net;
                    NodeInst ni = nIt.next();
                    Cell higher = ni.getParent();
                    HashSet<Network> netsSeenInCell = (HashSet<Network>)networksSeen.get(higher);
                    if (netsSeenInCell == null) {
                        netsSeenInCell = new HashSet<Network>();
                        networksSeen.put(higher, netsSeenInCell);
                    }
                    if ((net = (nl = higher.getNetlist()).getNetwork(ni, e2, 0)) == null || netsSeenInCell.contains(net)) continue;
                    netsSeenInCell.add(net);
                    Iterator<Export> it = net.getExports();
                    while (it.hasNext()) {
                        Export furtherUp = it.next();
                        HashSet<Export> exportsSeenInCell = (HashSet<Export>)exportsSeen.get(higher);
                        if (exportsSeenInCell == null) {
                            exportsSeenInCell = new HashSet<Export>();
                            exportsSeen.put(higher, exportsSeenInCell);
                        }
                        if (exportsSeenInCell.contains(furtherUp)) continue;
                        exportsSeenInCell.add(furtherUp);
                        exportsFollowed.add(furtherUp);
                    }
                }
                Cell iconCell = upperCell.iconView();
                if (iconCell == null) continue;
                Iterator<NodeInst> nIt2 = iconCell.getInstancesOf();
                while (nIt2.hasNext()) {
                    Netlist nl;
                    Network net;
                    NodeInst ni = nIt2.next();
                    if (ni.isIconOfParent()) continue;
                    Cell higher = ni.getParent();
                    HashSet<Network> netsSeenInCell = (HashSet<Network>)networksSeen.get(higher);
                    if (netsSeenInCell == null) {
                        netsSeenInCell = new HashSet<Network>();
                        networksSeen.put(higher, netsSeenInCell);
                    }
                    if (netsSeenInCell.contains(net = (nl = higher.getNetlist()).getNetwork(ni, e2, 0))) continue;
                    netsSeenInCell.add(net);
                    Iterator<Export> it = net.getExports();
                    while (it.hasNext()) {
                        Export furtherUp = it.next();
                        HashSet<Export> exportsSeenInCell = (HashSet<Export>)exportsSeen.get(higher);
                        if (exportsSeenInCell == null) {
                            exportsSeenInCell = new HashSet<Export>();
                            exportsSeen.put(higher, exportsSeenInCell);
                        }
                        if (exportsSeenInCell.contains(furtherUp)) continue;
                        exportsSeenInCell.add(furtherUp);
                        exportsFollowed.add(furtherUp);
                    }
                }
            }
            if (networksSeen.size() == 0) {
                System.out.println("The selected Exports are not used anywhere");
                return true;
            }
            if (exportsToFollow.size() > 1) {
                System.out.print("The Exports ");
                for (i2 = 0; i2 < exportsToFollow.size(); ++i2) {
                    if (i2 > 0) {
                        System.out.print(",");
                    }
                    System.out.print(" " + exportsToFollow.get(i2).getName());
                }
                System.out.println(" are used:");
            } else {
                System.out.println("The Export " + exportsToFollow.get(0).getName() + " is used:");
            }
            for (Cell c2 : networksSeen.keySet()) {
                Set netsSeenInCell = (Set)networksSeen.get(c2);
                Set exportsSeenInCell = (Set)exportsSeen.get(c2);
                System.out.print("   Cell " + c2.describe(false));
                if (netsSeenInCell.size() > 1) {
                    System.out.print(" networks");
                } else {
                    System.out.print(" network");
                }
                boolean comma = false;
                for (Network n2 : netsSeenInCell) {
                    if (comma) {
                        System.out.print(",");
                    }
                    comma = true;
                    System.out.print(" " + n2.getName());
                }
                System.out.println();
                if (exportsSeenInCell == null) continue;
                System.out.print("      And further exported as");
                comma = false;
                for (Export e3 : exportsSeenInCell) {
                    if (comma) {
                        System.out.print(",");
                    }
                    comma = true;
                    System.out.print(" " + e3.getName());
                }
                System.out.println();
            }
            return true;
        }
    }

    public static class ExportSortedByBusIndex
    implements Comparator<Export> {
        @Override
        public int compare(Export e1, Export e2) {
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    private static class ExportSortedByNameAndType
    implements Comparator<ExportList> {
        private ExportSortedByNameAndType() {
        }

        @Override
        public int compare(ExportList el1, ExportList el2) {
            PortCharacteristic ch2;
            Export e1 = el1.pp;
            Export e2 = el2.pp;
            PortCharacteristic ch1 = e1.getCharacteristic();
            if (ch1 != (ch2 = e2.getCharacteristic())) {
                return ch1.getOrder() - ch2.getOrder();
            }
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    private static class ExportList {
        Export pp;
        int equiv;
        int busList;

        private ExportList() {
        }
    }
}

