/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class Clipboard {
    public static final String CLIPBOARD_LIBRAY_NAME = "Clipboard!!";
    public static final String CLIPBOARD_CELL_NAME = "Clipboard!!;1{}";
    public static final int CLIPBOARD_CELL_INDEX = 0;
    private static double lastDupX = 10.0;
    private static double lastDupY = 10.0;

    private Clipboard() {
    }

    public String toString() {
        return "Clipboard";
    }

    public static void editClipboard() {
        EditWindow wnd = EditWindow.getCurrent();
        wnd.setCell(Clipboard.getClipCell(), VarContext.globalContext, null);
    }

    public static void copy() {
        TextUtils.setTextOnClipboard(null);
        MessagesWindow mw = MessagesWindow.getFocusOwner();
        if (mw != null) {
            mw.copyText(false, false);
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null && wf.getContent() instanceof TextWindow) {
            TextWindow tw = (TextWindow)wf.getContent();
            tw.copy();
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> highlightedGeoms = highlighter.getHighlightedEObjs(true, true);
        List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
        if (highlightedGeoms.size() == 0 && highlightedText.size() == 0) {
            System.out.println("First select objects to copy");
            return;
        }
        Clipboard.copySelectedText(highlightedText);
        FixpTransform inPlace = new FixpTransform();
        Orientation inPlaceOrient = Orientation.IDENT;
        if (wnd.isInPlaceEdit()) {
            List<NodeInst> nodes = wnd.getInPlaceEditNodePath();
            for (NodeInst n2 : nodes) {
                Orientation o2 = n2.getOrient().inverse();
                inPlaceOrient = o2.concatenate(inPlaceOrient);
            }
            FixpTransform justRotation = inPlaceOrient.pureRotate();
            Rectangle2D pasteBounds = Clipboard.getPasteBounds(highlightedGeoms, highlightedText, wnd);
            FixpTransform untranslate = FixpTransform.getTranslateInstance(-pasteBounds.getCenterX(), -pasteBounds.getCenterY());
            FixpTransform retranslate = FixpTransform.getTranslateInstance(pasteBounds.getCenterX(), pasteBounds.getCenterY());
            inPlace.preConcatenate(untranslate);
            inPlace.preConcatenate(justRotation);
            inPlace.preConcatenate(retranslate);
        }
        new CopyObjects(wnd.getCell(), highlightedGeoms, highlightedText, User.getAlignmentToGrid(), inPlace, inPlaceOrient);
    }

    public static void cut() {
        MessagesWindow mw = MessagesWindow.getFocusOwner();
        if (mw != null) {
            mw.copyText(false, true);
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null && wf.getContent() instanceof TextWindow) {
            TextWindow tw = (TextWindow)wf.getContent();
            tw.cut();
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> highlightedGeoms = highlighter.getHighlightedEObjs(true, true);
        List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
        if (highlightedGeoms.size() == 0 && highlightedText.size() == 0) {
            System.out.println("First select objects to cut");
            return;
        }
        highlighter.clear();
        highlighter.finished();
        Clipboard.copySelectedText(highlightedText);
        FixpTransform inPlace = new FixpTransform();
        Orientation inPlaceOrient = Orientation.IDENT;
        if (wnd.isInPlaceEdit()) {
            List<NodeInst> nodes = wnd.getInPlaceEditNodePath();
            for (NodeInst n2 : nodes) {
                Orientation o2 = n2.getOrient().inverse();
                inPlaceOrient = o2.concatenate(inPlaceOrient);
            }
            FixpTransform justRotation = inPlaceOrient.pureRotate();
            Rectangle2D pasteBounds = Clipboard.getPasteBounds(highlightedGeoms, highlightedText, wnd);
            FixpTransform untranslate = FixpTransform.getTranslateInstance(-pasteBounds.getCenterX(), -pasteBounds.getCenterY());
            FixpTransform retranslate = FixpTransform.getTranslateInstance(pasteBounds.getCenterX(), pasteBounds.getCenterY());
            inPlace.preConcatenate(untranslate);
            inPlace.preConcatenate(justRotation);
            inPlace.preConcatenate(retranslate);
        }
        new CutObjects(wnd.getCell(), highlightedGeoms, highlightedText, User.getAlignmentToGrid(), User.isReconstructArcsAndExportsToDeletedCells(), inPlace, inPlaceOrient);
    }

    public static void paste() {
        EditWindow wnd;
        MessagesWindow mw = MessagesWindow.getFocusOwner();
        if (mw != null) {
            mw.pasteText();
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null && wf.getContent() instanceof TextWindow) {
            TextWindow tw = (TextWindow)wf.getContent();
            tw.paste();
            return;
        }
        String extraText = TextUtils.getTextOnClipboard();
        int nTotal = 0;
        int aTotal = 0;
        int vTotal = 0;
        Cell clipCell = Clipboard.getClipCell();
        if (clipCell != null) {
            nTotal = clipCell.getNumNodes();
            aTotal = clipCell.getNumArcs();
            vTotal = clipCell.getNumVariables();
            if (clipCell.getVar(User.FRAME_LAST_CHANGED_BY) != null) {
                --vTotal;
            }
        }
        if ((wnd = EditWindow.needCurrent()) == null) {
            System.out.println("No place to paste");
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell parent = wnd.getCell();
        int total = nTotal + aTotal + vTotal;
        if (total == 0) {
            if (extraText != null) {
                List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
                new PasteSpecialText(highlightedText, extraText, parent);
            } else {
                System.out.println("Nothing in the clipboard to paste");
            }
            return;
        }
        List<Geometric> geoms = highlighter.getHighlightedEObjs(true, true);
        if (geoms.size() > 0) {
            if (nTotal == 2 && aTotal == 1) {
                ArcInst ai = clipCell.getArcs().next();
                NodeInst niHead = ai.getHeadPortInst().getNodeInst();
                NodeInst niTail = ai.getTailPortInst().getNodeInst();
                Iterator<NodeInst> nIt = clipCell.getNodes();
                NodeInst ni1 = nIt.next();
                NodeInst ni2 = nIt.next();
                if (ni1 == niHead && ni2 == niTail || ni1 == niTail && ni2 == niHead) {
                    nTotal = 0;
                }
                total = nTotal + aTotal;
            }
            if (total > 1) {
                System.out.println("Can only paste a single object on top of selected objects");
                return;
            }
            for (Geometric geom : geoms) {
                if (geom instanceof NodeInst && nTotal == 1) {
                    NodeInst ni = (NodeInst)geom;
                    new PasteNodeToNode(ni, clipCell.getNodes().next());
                    continue;
                }
                if (!(geom instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)geom;
                if (aTotal == 1) {
                    new PasteArcToArc(ai, clipCell.getArcs().next());
                    continue;
                }
                new PasteSpecialText(Arrays.asList(new DisplayedText(ai, ArcInst.ARC_NAME)), extraText, parent);
            }
            return;
        }
        ArrayList<Geometric> geomList = new ArrayList<Geometric>();
        Iterator<Geometric> it = clipCell.getNodes();
        while (it.hasNext()) {
            geomList.add(it.next());
        }
        it = clipCell.getArcs();
        while (it.hasNext()) {
            geomList.add(it.next());
        }
        ArrayList<DisplayedText> textList = new ArrayList<DisplayedText>();
        Iterator<Variable> it2 = clipCell.getVariables();
        while (it2.hasNext()) {
            Variable var = it2.next();
            if (!var.isDisplay()) continue;
            textList.add(new DisplayedText(clipCell, var.getKey()));
        }
        if (geomList.size() == 0 && textList.size() == 0) {
            return;
        }
        FixpTransform inPlace = new FixpTransform();
        Orientation inPlaceOrient = Orientation.IDENT;
        if (wnd.isInPlaceEdit()) {
            List<NodeInst> nodes = wnd.getInPlaceEditNodePath();
            for (NodeInst n2 : nodes) {
                Orientation o2 = n2.getOrient();
                inPlaceOrient = inPlaceOrient.concatenate(o2);
            }
            FixpTransform justRotation = inPlaceOrient.pureRotate();
            Rectangle2D pasteBounds = Clipboard.getPasteBounds(geomList, textList, wnd);
            FixpTransform untranslate = FixpTransform.getTranslateInstance(-pasteBounds.getCenterX(), -pasteBounds.getCenterY());
            FixpTransform retranslate = FixpTransform.getTranslateInstance(pasteBounds.getCenterX(), pasteBounds.getCenterY());
            inPlace.preConcatenate(untranslate);
            inPlace.preConcatenate(justRotation);
            inPlace.preConcatenate(retranslate);
        }
        boolean convertSchLay = false;
        if (aTotal == 0 && User.isConvertSchematicLayoutWhenPasting()) {
            convertSchLay = true;
        }
        if (User.isMoveAfterDuplicate()) {
            WindowFrame.ElectricEventListener currentListener = WindowFrame.getListener();
            WindowFrame.setListener(new PasteListener(clipCell, wnd, geomList, textList, currentListener, inPlace, inPlaceOrient, false, convertSchLay));
        } else if (User.isDuplicateInPlace()) {
            new PasteObjects(clipCell, parent, geomList, textList, 0.0, 0.0, User.getAlignmentToGrid(), User.isDupCopiesExports(), User.isIncrementRightmostIndex(), User.isArcsAutoIncremented(), convertSchLay, inPlace, inPlaceOrient);
        } else {
            new PasteObjects(clipCell, parent, geomList, textList, lastDupX, lastDupY, User.getAlignmentToGrid(), User.isDupCopiesExports(), User.isIncrementRightmostIndex(), User.isArcsAutoIncremented(), convertSchLay, inPlace, inPlaceOrient);
        }
    }

    public static void duplicate() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> geomList = highlighter.getHighlightedEObjs(true, true);
        List<DisplayedText> textList = highlighter.getHighlightedText(true);
        if (geomList.size() == 0 && textList.size() == 0) {
            System.out.println("First select objects to duplicate");
            return;
        }
        if (User.isMoveAfterDuplicate()) {
            WindowFrame.ElectricEventListener currentListener = WindowFrame.getListener();
            WindowFrame.setListener(new PasteListener(wnd.getCell(), wnd, geomList, textList, currentListener, null, null, true, false));
        } else if (User.isDuplicateInPlace()) {
            lastDupX = 0.0;
            lastDupY = 0.0;
            new DuplicateObjects(wnd.getCell(), geomList, textList, User.getAlignmentToGrid());
        } else {
            new DuplicateObjects(wnd.getCell(), geomList, textList, User.getAlignmentToGrid());
        }
    }

    private static void copySelectedText(List<DisplayedText> highlightedText) {
        if (highlightedText.size() != 1) {
            return;
        }
        DisplayedText dt = highlightedText.get(0);
        ElectricObject eObj = dt.getElectricObject();
        Variable.Key varKey = dt.getVariableKey();
        String selected = null;
        if (varKey == ArcInst.ARC_NAME) {
            selected = ((ArcInst)eObj).getName();
        } else if (varKey == NodeInst.NODE_NAME || varKey == NodeInst.NODE_PROTO) {
            selected = ((NodeInst)eObj).getName();
        } else if (varKey == Export.EXPORT_NAME) {
            selected = ((Export)eObj).getName();
        } else {
            Variable var = eObj.getParameterOrVariable(varKey);
            if (var == null) {
                return;
            }
            selected = var.describe(-1);
        }
        if (selected == null) {
            return;
        }
        TextUtils.setTextOnClipboard(selected);
    }

    public static void databaseChanged(DatabaseChangeEvent e2) {
    }

    public static CellId getClipCellId() {
        return IdManager.stdIdManager.getCellId(0);
    }

    private static Cell getClipCell() {
        return Job.getUserInterface().getDatabase().getCell(Clipboard.getClipCellId());
    }

    public static void clear() {
        Variable var;
        Cell clipCell = Clipboard.getClipCell();
        if (clipCell == null) {
            return;
        }
        ArrayList<ArcInst> arcsToDelete = new ArrayList<ArcInst>();
        Iterator<ArcInst> it = clipCell.getArcs();
        while (it.hasNext()) {
            arcsToDelete.add(it.next());
        }
        for (ArcInst ai : arcsToDelete) {
            ai.kill();
        }
        HashSet<Export> exportsToDelete = new HashSet<Export>();
        Iterator<Export> it2 = clipCell.getExports();
        while (it2.hasNext()) {
            exportsToDelete.add(it2.next());
        }
        clipCell.killExports(exportsToDelete);
        HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
        Iterator<Serializable> it3 = clipCell.getNodes();
        while (it3.hasNext()) {
            nodesToDelete.add(it3.next());
        }
        clipCell.killNodes(nodesToDelete);
        it3 = clipCell.getParameters();
        while (it3.hasNext()) {
            var = (Variable)it3.next();
            if (clipCell.getCellGroup() == null) continue;
            clipCell.getCellGroup().delParam((Variable.AttrKey)var.getKey());
        }
        it3 = clipCell.getVariables();
        while (it3.hasNext()) {
            var = (Variable)it3.next();
            clipCell.delVar(var.getKey());
        }
    }

    public static NodeInst copyListToCell(Cell toCell, List<Geometric> geomList, List<DisplayedText> textList, List<Geometric> newGeomList, List<DisplayedText> newTextList, Point2D delta, boolean copyExports, boolean fromRight, boolean uniqueArcs, boolean convertSchLay, EDimension alignment, FixpTransform inPlace, Orientation inPlaceOrient, NodeInst.ExpansionState expansionState, List<NodeInst> nodesToExpand, EditingPreferences ep) {
        Iterator<Geometric> internalGeomList;
        ArrayList<NodeInst> theNodes = new ArrayList<NodeInst>();
        ArrayList<ArcInst> theArcs = new ArrayList<ArcInst>();
        if (copyExports) {
            internalGeomList = new ArrayList();
            Iterator<Object> iterator = geomList.iterator();
            while (iterator.hasNext()) {
                Geometric geom = (Geometric)iterator.next();
                internalGeomList.add(geom);
            }
            geomList = internalGeomList;
            for (DisplayedText dt : textList) {
                Export e2;
                NodeInst ni;
                ElectricObject eObj = dt.getElectricObject();
                if (!(eObj instanceof Export) || geomList.contains(ni = (e2 = (Export)eObj).getOriginalPort().getNodeInst())) continue;
                geomList.add(ni);
            }
        }
        internalGeomList = geomList.iterator();
        while (internalGeomList.hasNext()) {
            Geometric geom = (Geometric)internalGeomList.next();
            if (geom instanceof NodeInst && !theNodes.contains(geom)) {
                theNodes.add((NodeInst)geom);
            }
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            theArcs.add(ai);
            NodeInst head = ai.getHeadPortInst().getNodeInst();
            NodeInst tail = ai.getTailPortInst().getNodeInst();
            if (!theNodes.contains(head)) {
                theNodes.add(head);
            }
            if (theNodes.contains(tail)) continue;
            theNodes.add(tail);
        }
        if (theNodes.isEmpty() && textList.isEmpty()) {
            return null;
        }
        for (NodeInst ni : theNodes) {
            Cell niCell;
            if (!ni.isCellInstance() || !Cell.isInstantiationRecursive(niCell = (Cell)ni.getProto(), toCell)) continue;
            System.out.println("Cannot: that would be recursive (" + toCell.describe(false) + " is beneath " + niCell.describe(false) + ")");
            return null;
        }
        DBMath.gridAlign(delta, alignment);
        double dX = delta.getX();
        double dY = delta.getY();
        Collections.sort(theNodes);
        NodeInst lastCreatedNode = null;
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        ArrayList<Export> reExports = new ArrayList<Export>();
        for (NodeInst ni : theNodes) {
            NodeInst newNi;
            Cell otherCell;
            double width = ni.getXSize();
            double height = ni.getYSize();
            if (Generic.isCellCenter(ni) && toCell.alreadyCellCenter()) continue;
            NodeProto makeProto = ni.getProto();
            if (ni.isCellInstance() && convertSchLay && (otherCell = Clipboard.findAlternate((Cell)makeProto, toCell)) != makeProto) {
                makeProto = otherCell;
                width = otherCell.getDefWidth();
                height = otherCell.getDefHeight();
            }
            String name = null;
            if (ni.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ni.getName(), toCell, NodeInst.class, false, fromRight);
            }
            EPoint point = EPoint.fromLambda(ni.getAnchorCenterX() + dX, ni.getAnchorCenterY() + dY);
            Orientation orient = ni.getOrient();
            if (inPlace != null) {
                Point2D.Double dst = new Point2D.Double(0.0, 0.0);
                inPlace.transform(new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), dst);
                point = EPoint.fromLambda(((Point2D)dst).getX() + dX, ((Point2D)dst).getY() + dY);
                orient = orient.concatenate(inPlaceOrient);
            }
            if ((newNi = NodeInst.newInst(makeProto, ep, point, width, height, toCell, orient, name, ni.getTechSpecific())) == null) {
                System.out.println("Cannot create node");
                return lastCreatedNode;
            }
            if (expansionState.isExpanded(ni)) {
                nodesToExpand.add(newNi);
            }
            newNi.copyStateBits(ni);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
            newNi.copyVarsFrom(ni);
            Iterator<Variable> it = ni.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                if (var.getKey() != NodeInst.TRACE) continue;
                newNi.setTraceRelative((EPoint[])var.getObject(), point, Orientation.IDENT);
            }
            newNodes.put(ni, newNi);
            if (newGeomList != null) {
                newGeomList.add(newNi);
            }
            lastCreatedNode = newNi;
            if (!copyExports) continue;
            Iterator<Export> eit = ni.getExports();
            while (eit.hasNext()) {
                Export e3 = eit.next();
                if (makeProto != ni.getProto()) {
                    e3 = e3.findEquivalent((Cell)makeProto);
                }
                if (e3 == null) continue;
                reExports.add(e3);
            }
        }
        if (copyExports) {
            HashMap<PortInst, Export> originalExports = new HashMap<PortInst, Export>();
            Collections.sort(reExports, new ExportChanges.ExportSortedByBusIndex());
            ArrayList<PortInst> reExpThese = new ArrayList<PortInst>();
            for (Export export : reExports) {
                PortInst pi = export.getOriginalPort();
                NodeInst newNi = (NodeInst)newNodes.get(pi.getNodeInst());
                PortInst newPi = newNi.findPortInstFromEquivalentProto(pi.getPortProto());
                reExpThese.add(newPi);
                originalExports.put(newPi, export);
            }
            ExportChanges.reExportPorts(toCell, reExpThese, false, true, true, false, fromRight, originalExports, ep);
        }
        HashMap<ArcInst, ArcInst> newArcs = new HashMap<ArcInst, ArcInst>();
        if (theArcs.size() > 0) {
            Collections.sort(theArcs);
            HashMap<String, String> newArcNames = new HashMap<String, String>();
            FixpTransform fixOffset = null;
            if (inPlaceOrient != null) {
                fixOffset = inPlaceOrient.pureRotate();
            }
            for (ArcInst ai : theArcs) {
                PortInst oldHeadPi = ai.getHeadPortInst();
                NodeInst headNi = (NodeInst)newNodes.get(oldHeadPi.getNodeInst());
                PortInst headPi = headNi.findPortInstFromEquivalentProto(oldHeadPi.getPortProto());
                EPoint headP = oldHeadPi.getCenter();
                double headDX = ai.getHeadLocation().getX() - headP.getX();
                double headDY = ai.getHeadLocation().getY() - headP.getY();
                PortInst oldTailPi = ai.getTailPortInst();
                NodeInst tailNi = (NodeInst)newNodes.get(oldTailPi.getNodeInst());
                PortInst tailPi = tailNi.findPortInstFromEquivalentProto(oldTailPi.getPortProto());
                EPoint tailP = oldTailPi.getCenter();
                double tailDX = ai.getTailLocation().getX() - tailP.getX();
                double tailDY = ai.getTailLocation().getY() - tailP.getY();
                if (fixOffset != null) {
                    Point2D.Double result = new Point2D.Double(0.0, 0.0);
                    fixOffset.transform(new Point2D.Double(headDX, headDY), result);
                    headDX = ((Point2D)result).getX();
                    headDY = ((Point2D)result).getY();
                    fixOffset.transform(new Point2D.Double(tailDX, tailDY), result);
                    tailDX = ((Point2D)result).getX();
                    tailDY = ((Point2D)result).getY();
                }
                String name = null;
                if (ai.isUsernamed()) {
                    name = ai.getName();
                    if (uniqueArcs) {
                        String newName = (String)newArcNames.get(name);
                        if (newName == null) {
                            newName = ElectricObject.uniqueObjectName(name, toCell, ArcInst.class, false, fromRight);
                            newArcNames.put(name, newName);
                        }
                        name = newName;
                    }
                }
                headP = EPoint.fromLambda(headPi.getCenter().getX() + headDX, headPi.getCenter().getY() + headDY);
                tailP = EPoint.fromLambda(tailPi.getCenter().getX() + tailDX, tailPi.getCenter().getY() + tailDY);
                ArcInst newAr = ArcInst.newInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), headPi, tailPi, headP, tailP, name, ai.getAngle());
                if (newAr == null) {
                    System.out.println("Cannot create arc");
                    return lastCreatedNode;
                }
                newAr.copyPropertiesFrom(ai);
                newArcs.put(ai, newAr);
                if (newGeomList == null) continue;
                newGeomList.add(newAr);
            }
        }
        int numDuplicates = 0;
        for (DisplayedText displayedText : textList) {
            ElectricObject eObj = displayedText.getElectricObject();
            if (!(eObj instanceof Cell)) continue;
            Variable.Key varKey = displayedText.getVariableKey();
            Variable var = eObj.getParameterOrVariable(varKey);
            double xP = var.getTextDescriptor().getXOff();
            double yP = var.getTextDescriptor().getYOff();
            if (toCell.getVar(varKey) != null) {
                ++numDuplicates;
            }
            Variable newVar = Variable.newInst(varKey, var.getObject(), var.getTextDescriptor().withOff(xP + dX, yP + dY));
            if (var.getTextDescriptor().isParam()) {
                if (toCell.getCellGroup() != null) {
                    toCell.getCellGroup().addParam(newVar);
                }
            } else {
                toCell.addVar(newVar);
            }
            if (newTextList == null) continue;
            newTextList.add(new DisplayedText(toCell, varKey));
        }
        if (numDuplicates != 0) {
            System.out.println("WARNING: New cell attributes replace old ones");
        }
        return lastCreatedNode;
    }

    private static Cell findAlternate(Cell cell, Cell destination) {
        Cell otherCell;
        View desiredView = destination.getView();
        if (desiredView == View.SCHEMATIC) {
            desiredView = View.ICON;
        }
        if (cell.getView() != desiredView && (otherCell = cell.otherView(desiredView)) != null) {
            return otherCell;
        }
        return cell;
    }

    private static void showCopiedObjects(List<Geometric> newGeomList, List<DisplayedText> newTextList) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd != null) {
            Cell cell = wnd.getCell();
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            for (Geometric geom : newGeomList) {
                NodeInst ni;
                if (geom instanceof NodeInst && (ni = (NodeInst)geom).isInvisiblePinWithText()) {
                    Iterator<Variable> vIt = ni.getVariables();
                    while (vIt.hasNext()) {
                        Variable var = vIt.next();
                        if (!var.isDisplay()) continue;
                        highlighter.addText(ni, cell, var.getKey());
                    }
                    continue;
                }
                highlighter.addElectricObject(geom, cell);
            }
            for (DisplayedText dt : newTextList) {
                highlighter.addText(dt.getElectricObject(), cell, dt.getVariableKey());
            }
            highlighter.finished();
        }
    }

    private static NodeInst pasteNodeToNode(NodeInst destNode, NodeInst srcNode, EditingPreferences ep) {
        if ((destNode = CircuitChangeJobs.replaceNodeInst(destNode, srcNode.getProto(), srcNode.getFunction(), true, false, false, ep)) == null) {
            return null;
        }
        if (!destNode.isCellInstance() && !srcNode.isCellInstance() && srcNode.getProto().getTechnology() == destNode.getProto().getTechnology()) {
            destNode.setPrimitiveFunction(srcNode.getFunction());
        }
        if (!destNode.isCellInstance()) {
            double dX = srcNode.getXSize() - destNode.getXSize();
            double dY = srcNode.getYSize() - destNode.getYSize();
            if (dX != 0.0 || dY != 0.0) {
                destNode.resize(dX, dY);
            }
        }
        Iterator<Variable> it = destNode.getDefinedParameters();
        while (it.hasNext()) {
            Variable destParam = it.next();
            Variable.Key key = destParam.getKey();
            if (srcNode.isDefinedParameter(key)) continue;
            destNode.delParameter(key);
        }
        boolean checkAgain = true;
        block1: while (checkAgain) {
            checkAgain = false;
            Iterator<Variable> it2 = destNode.getVariables();
            while (it2.hasNext()) {
                Variable destVar = it2.next();
                Variable.Key key = destVar.getKey();
                Variable srcVar = srcNode.getVar(key);
                if (srcVar != null) continue;
                destNode.delVar(key);
                checkAgain = true;
                continue block1;
            }
        }
        destNode.copyVarsFrom(srcNode);
        destNode.copyStateBits(srcNode);
        destNode.setExpanded(false);
        destNode.clearLocked();
        return destNode;
    }

    private static ArcInst pasteArcToArc(ArcInst destArc, ArcInst srcArc, EditingPreferences ep) {
        Variable.Key key;
        Iterator<Variable> it;
        if (destArc.getProto() != srcArc.getProto() && (destArc = destArc.replace(srcArc.getProto(), ep)) == null) {
            return null;
        }
        destArc.setLambdaBaseWidth(srcArc.getLambdaBaseWidth());
        boolean checkAgain = true;
        block0: while (checkAgain) {
            checkAgain = false;
            it = destArc.getVariables();
            while (it.hasNext()) {
                Variable destVar = it.next();
                key = destVar.getKey();
                Variable srcVar = srcArc.getVar(key);
                if (srcVar != null) continue;
                destArc.delVar(key);
                checkAgain = true;
                continue block0;
            }
        }
        it = srcArc.getVariables();
        while (it.hasNext()) {
            Variable srcVar = it.next();
            key = srcVar.getKey();
            destArc.newVar(key, srcVar.getObject(), srcVar.getTextDescriptor());
        }
        destArc.copyPropertiesFrom(srcArc);
        return destArc;
    }

    private static Rectangle2D getPasteBounds(List<Geometric> geomList, List<DisplayedText> textList, EditWindow wnd) {
        Rectangle2D bounds;
        Point2D llcorner = null;
        Point2D urcorner = null;
        for (DisplayedText dt : textList) {
            Poly poly = dt.getElectricObject().computeTextPoly(wnd, dt.getVariableKey());
            FixpRectangle bounds2 = poly.getBounds2D();
            if (llcorner == null) {
                llcorner = new Point2D.Double(((RectangularShape)bounds2).getMinX(), ((RectangularShape)bounds2).getMinY());
                urcorner = new Point2D.Double(((RectangularShape)bounds2).getMaxX(), ((RectangularShape)bounds2).getMaxY());
                continue;
            }
            if (((RectangularShape)bounds2).getMinX() < llcorner.getX()) {
                llcorner.setLocation(((RectangularShape)bounds2).getMinX(), llcorner.getY());
            }
            if (((RectangularShape)bounds2).getMinY() < llcorner.getY()) {
                llcorner.setLocation(llcorner.getX(), ((RectangularShape)bounds2).getMinY());
            }
            if (((RectangularShape)bounds2).getMaxX() > urcorner.getX()) {
                urcorner.setLocation(((RectangularShape)bounds2).getMaxX(), urcorner.getY());
            }
            if (!(((RectangularShape)bounds2).getMaxY() > urcorner.getY())) continue;
            urcorner.setLocation(urcorner.getX(), ((RectangularShape)bounds2).getMaxY());
        }
        for (Geometric geom : geomList) {
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                EPoint pt = ni.getAnchorCenter();
                if (llcorner == null) {
                    llcorner = new Point2D.Double(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    urcorner = new Point2D.Double(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    continue;
                }
                if (((Point2D)pt).getX() < llcorner.getX()) {
                    llcorner.setLocation(((Point2D)pt).getX(), llcorner.getY());
                }
                if (((Point2D)pt).getY() < llcorner.getY()) {
                    llcorner.setLocation(llcorner.getX(), ((Point2D)pt).getY());
                }
                if (((Point2D)pt).getX() > urcorner.getX()) {
                    urcorner.setLocation(((Point2D)pt).getX(), urcorner.getY());
                }
                if (!(((Point2D)pt).getY() > urcorner.getY())) continue;
                urcorner.setLocation(urcorner.getX(), ((Point2D)pt).getY());
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.FILLED);
            bounds = poly.getBounds2D();
            if (llcorner == null) {
                llcorner = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
                urcorner = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
                continue;
            }
            if (bounds.getMinX() < llcorner.getX()) {
                llcorner.setLocation(bounds.getMinX(), llcorner.getY());
            }
            if (bounds.getMinY() < llcorner.getY()) {
                llcorner.setLocation(llcorner.getX(), bounds.getMinY());
            }
            if (bounds.getMaxX() > urcorner.getX()) {
                urcorner.setLocation(bounds.getMaxX(), urcorner.getY());
            }
            if (!(bounds.getMaxY() > urcorner.getY())) continue;
            urcorner.setLocation(urcorner.getX(), bounds.getMaxY());
        }
        double width = urcorner.getX() - llcorner.getX();
        double height = urcorner.getY() - llcorner.getY();
        bounds = new Rectangle2D.Double(llcorner.getX(), llcorner.getY(), width, height);
        return bounds;
    }

    private static class CopyObjects
    extends Job {
        private List<Geometric> highlightedGeoms;
        private List<DisplayedText> highlightedText;
        private EDimension alignment;
        private FixpTransform inPlace;
        private Orientation inPlaceOrient;
        private boolean isDupCopiesExports = User.isDupCopiesExports();
        private boolean isIncrementRightmostIndex = User.isIncrementRightmostIndex();
        private boolean isArcsAutoIncremented = User.isArcsAutoIncremented();
        private NodeInst.ExpansionState expansionState;
        private List<NodeInst> nodesToExpand;

        protected CopyObjects(Cell cell, List<Geometric> highlightedGeoms, List<DisplayedText> highlightedText, EDimension alignment, FixpTransform inPlace, Orientation inPlaceOrient) {
            super("Copy", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlightedGeoms = highlightedGeoms;
            this.highlightedText = highlightedText;
            this.alignment = alignment;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.nodesToExpand = new ArrayList<NodeInst>();
            this.expansionState = new NodeInst.ExpansionState(cell, 1);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Clipboard.clear();
            Clipboard.copyListToCell(Clipboard.getClipCell(), this.highlightedGeoms, this.highlightedText, null, null, new Point2D.Double(), this.isDupCopiesExports, this.isIncrementRightmostIndex, this.isArcsAutoIncremented, false, this.alignment, this.inPlace, this.inPlaceOrient, this.expansionState, this.nodesToExpand, this.getEditingPreferences());
            this.fieldVariableChanged("nodesToExpand");
            return true;
        }

        @Override
        public void terminateOK() {
            for (NodeInst ni : this.nodesToExpand) {
                ni.setExpanded(true);
            }
        }
    }

    private static class CutObjects
    extends Job {
        private Cell cell;
        private List<Geometric> geomList;
        private List<DisplayedText> textList;
        private EDimension alignment;
        private boolean reconstructArcsAndExports;
        private FixpTransform inPlace;
        private Orientation inPlaceOrient;
        private List<Geometric> thingsToHighlight;
        private boolean isDupCopiesExports = User.isDupCopiesExports();
        private boolean isIncrementRightmostIndex = User.isIncrementRightmostIndex();
        private boolean isArcsAutoIncremented = User.isArcsAutoIncremented();
        private NodeInst.ExpansionState expansionState;
        private List<NodeInst> nodesToExpand;

        protected CutObjects(Cell cell, List<Geometric> geomList, List<DisplayedText> textList, EDimension alignment, boolean reconstructArcsAndExports, FixpTransform inPlace, Orientation inPlaceOrient) {
            super("Cut", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.geomList = geomList;
            this.textList = textList;
            this.alignment = alignment;
            this.reconstructArcsAndExports = reconstructArcsAndExports;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.expansionState = new NodeInst.ExpansionState(cell, 1);
            this.nodesToExpand = new ArrayList<NodeInst>();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            Clipboard.clear();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            for (Geometric geom : this.geomList) {
                if (!(geom instanceof NodeInst)) continue;
                int errorCode = CircuitChangeJobs.cantEdit(this.cell, (NodeInst)geom, true, false, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode <= 0) continue;
            }
            Clipboard.copyListToCell(Clipboard.getClipCell(), this.geomList, this.textList, null, null, new Point2D.Double(), this.isDupCopiesExports, this.isIncrementRightmostIndex, this.isArcsAutoIncremented, false, this.alignment, this.inPlace, this.inPlaceOrient, this.expansionState, this.nodesToExpand, ep);
            this.fieldVariableChanged("nodesToExpand");
            HashSet<ElectricObject> stuffToHighlight = new HashSet<ElectricObject>();
            CircuitChangeJobs.eraseObjectsInList(this.cell, this.geomList, this.reconstructArcsAndExports, stuffToHighlight, ep);
            this.thingsToHighlight = new ArrayList<Geometric>();
            for (ElectricObject eObj : stuffToHighlight) {
                if (eObj instanceof ArcInst) {
                    ArcInst ai = (ArcInst)eObj;
                    this.thingsToHighlight.add(ai);
                    continue;
                }
                if (!(eObj instanceof Export)) continue;
                Export e2 = (Export)eObj;
                this.thingsToHighlight.add(e2.getOriginalPort().getNodeInst());
            }
            this.fieldVariableChanged("thingsToHighlight");
            for (DisplayedText dt : this.textList) {
                Variable.Key key = dt.getVariableKey();
                ElectricObject eobj = dt.getElectricObject();
                if (key == NodeInst.NODE_NAME) {
                    NodeInst ni = (NodeInst)eobj;
                    ni.setName(null);
                    ni.move(0.0, 0.0);
                    continue;
                }
                if (key == ArcInst.ARC_NAME) {
                    ArcInst ai = (ArcInst)eobj;
                    ai.setName(null, ep);
                    ai.modify(0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                if (key == Export.EXPORT_NAME) {
                    Export pp = (Export)eobj;
                    pp.kill();
                    continue;
                }
                if (eobj.isParam(key)) {
                    if (eobj instanceof Cell) {
                        Cell.CellGroup cg = ((Cell)eobj).getCellGroup();
                        if (cg == null) continue;
                        cg.delParam((Variable.AttrKey)key);
                        continue;
                    }
                    if (!(eobj instanceof NodeInst)) continue;
                    ((NodeInst)eobj).delParameter(key);
                    continue;
                }
                eobj.delVar(key);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            for (NodeInst ni : this.nodesToExpand) {
                ni.setExpanded(true);
            }
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd != null) {
                wnd.clearHighlighting();
                if (this.thingsToHighlight != null) {
                    for (Geometric geom : this.thingsToHighlight) {
                        wnd.addElectricObject(geom, this.cell);
                    }
                }
                wnd.finishedHighlighting();
            }
        }
    }

    private static class PasteSpecialText
    extends Job {
        private List<DisplayedText> textList;
        private String newText;
        private Cell cell;

        protected PasteSpecialText(List<DisplayedText> tList, String newT, Cell c2) {
            super("Paste Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.textList = tList;
            this.newText = newT;
            this.cell = c2;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            for (DisplayedText obj : this.textList) {
                Variable.Key key = obj.getVariableKey();
                ElectricObject eObj = obj.getElectricObject();
                if (key == ArcInst.ARC_NAME) {
                    ((ArcInst)eObj).setName(this.newText, ep);
                    continue;
                }
                if (key == NodeInst.NODE_NAME || key == NodeInst.NODE_PROTO) {
                    ((NodeInst)eObj).setName(this.newText);
                    continue;
                }
                if (key != Export.EXPORT_NAME) continue;
                Export ex = (Export)eObj;
                ex.rename(this.newText);
            }
            return true;
        }
    }

    private static class PasteNodeToNode
    extends Job {
        private NodeInst src;
        private NodeInst dst;
        private NodeInst newNode;

        protected PasteNodeToNode(NodeInst dst, NodeInst src) {
            super("Paste Node to Node", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.dst.getParent(), null, true, false, true) != 0) {
                return false;
            }
            this.newNode = Clipboard.pasteNodeToNode(this.dst, this.src, this.getEditingPreferences());
            if (this.newNode == null) {
                System.out.println("Nothing was pasted");
            } else {
                this.fieldVariableChanged("newNode");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.newNode != null) {
                Highlighter highlighter;
                this.newNode.setExpanded(this.src.isExpanded());
                EditWindow wnd = EditWindow.getCurrent();
                if (wnd != null && (highlighter = wnd.getHighlighter()) != null) {
                    highlighter.clear();
                    highlighter.addElectricObject(this.newNode, this.newNode.getParent());
                    highlighter.finished();
                }
            }
        }
    }

    private static class PasteArcToArc
    extends Job {
        private ArcInst src;
        private ArcInst dst;
        private ArcInst newArc;

        protected PasteArcToArc(ArcInst dst, ArcInst src) {
            super("Paste Arc to Arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.dst.getParent(), null, true, false, true) != 0) {
                return false;
            }
            this.newArc = Clipboard.pasteArcToArc(this.dst, this.src, this.getEditingPreferences());
            if (this.newArc == null) {
                System.out.println("Nothing was pasted");
            } else {
                this.fieldVariableChanged("newArc");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            Highlighter highlighter;
            EditWindow wnd;
            if (this.newArc != null && (wnd = EditWindow.getCurrent()) != null && (highlighter = wnd.getHighlighter()) != null) {
                highlighter.clear();
                highlighter.addElectricObject(this.newArc, this.newArc.getParent());
                highlighter.finished();
            }
        }
    }

    private static class PasteListener
    implements WindowFrame.ElectricEventListener {
        private Cell fromCell;
        private EditWindow wnd;
        private List<Geometric> geomList;
        private List<DisplayedText> textList;
        private WindowFrame.ElectricEventListener currentListener;
        private Rectangle2D pasteBounds;
        private double translateX;
        private double translateY;
        private Point2D lastMouseDB;
        private JPopupMenu popup;
        private FixpTransform inPlace;
        private Orientation inPlaceOrient;
        private boolean convertSchLay;

        private PasteListener(Cell fromCell, EditWindow wnd, List<Geometric> geomList, List<DisplayedText> textList, WindowFrame.ElectricEventListener currentListener, FixpTransform inPlace, Orientation inPlaceOrient, boolean dup, boolean convertSchLay) {
            this.fromCell = fromCell;
            this.wnd = wnd;
            this.geomList = geomList;
            this.textList = textList;
            this.currentListener = currentListener;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.pasteBounds = Clipboard.getPasteBounds(geomList, textList, wnd);
            this.convertSchLay = convertSchLay;
            this.translateY = 0.0;
            this.translateX = 0.0;
            this.initPopup();
            Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
            Point2D mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            if (dup) {
                this.pasteBounds.setRect(this.pasteBounds.getMinX() + mouseDB.getX() - this.pasteBounds.getCenterX(), this.pasteBounds.getMinY() + mouseDB.getY() - this.pasteBounds.getCenterY(), this.pasteBounds.getWidth(), this.pasteBounds.getHeight());
            }
            Point2D delta = this.getDelta(mouseDB, false);
            wnd.getHighlighter().pushHighlight();
            this.showList(delta);
        }

        private Point2D getDelta(Point2D mouseDB, boolean orthogonal) {
            if (mouseDB == null) {
                return null;
            }
            EDimension alignment = User.getAlignmentToGrid();
            DBMath.gridAlign(mouseDB, alignment);
            Point2D.Double refPastePoint = new Point2D.Double(this.pasteBounds.getCenterX() + this.translateX, this.pasteBounds.getCenterY() + this.translateY);
            double deltaX = mouseDB.getX() - ((Point2D)refPastePoint).getX();
            double deltaY = mouseDB.getY() - ((Point2D)refPastePoint).getY();
            if (orthogonal) {
                if (mouseDB.getX() > this.pasteBounds.getMinX() && mouseDB.getX() < this.pasteBounds.getMaxX()) {
                    deltaX = 0.0;
                } else if (mouseDB.getY() > this.pasteBounds.getMinY() && mouseDB.getY() < this.pasteBounds.getMaxY()) {
                    deltaY = 0.0;
                } else if (Math.abs(deltaX) > Math.abs(deltaY)) {
                    deltaY = 0.0;
                } else {
                    deltaX = 0.0;
                }
            }
            ((Point2D)refPastePoint).setLocation(deltaX, deltaY);
            DBMath.gridAlign(refPastePoint, alignment);
            return refPastePoint;
        }

        private void showList(Point2D delta) {
            if (delta == null) {
                return;
            }
            double oX = delta.getX();
            double oY = delta.getY();
            Cell cell = this.wnd.getCell();
            EditingPreferences ep = this.wnd.getEditingPreferences();
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            for (Geometric geom : this.geomList) {
                Cell otherCell;
                if (geom instanceof ArcInst) {
                    ArcInst ai = (ArcInst)geom;
                    Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
                    if (this.inPlace != null) {
                        poly.transform(this.inPlace);
                    }
                    Point2D[] points = poly.getPoints();
                    this.showPoints(points, oX, oY, cell, highlighter);
                    continue;
                }
                NodeInst ni = (NodeInst)geom;
                if (ni.isInvisiblePinWithText()) {
                    boolean found = false;
                    Iterator<Variable> vIt = ni.getVariables();
                    while (vIt.hasNext()) {
                        Variable var = vIt.next();
                        if (!var.isDisplay()) continue;
                        Point2D[] points = Highlighter.describeHighlightText(this.wnd, geom, var.getKey());
                        if (this.inPlace != null) {
                            this.inPlace.transform(points, 0, points, 0, points.length);
                        }
                        this.showPoints(points, oX, oY, cell, highlighter);
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                if (ni.isCellInstance() && this.convertSchLay && (otherCell = Clipboard.findAlternate((Cell)ni.getProto(), cell)) != ni.getProto()) {
                    ni = NodeInst.makeDummyInstance(otherCell, ep, ni.getAnchorCenter(), otherCell.getDefWidth(), otherCell.getDefHeight(), ni.getOrient());
                }
                Poly poly = ni.getBaseShape();
                if (this.inPlace != null) {
                    poly.transform(this.inPlace);
                }
                this.showPoints(poly.getPoints(), oX, oY, cell, highlighter);
            }
            if (this.textList.size() > 0) {
                double wid = 10.0;
                double pX = oX + this.pasteBounds.getCenterX() + this.translateX;
                double pY = oY + this.pasteBounds.getCenterY() + this.translateY;
                highlighter.addLine(new Point2D.Double(pX - wid, pY), new Point2D.Double(pX + wid, pY), cell);
            }
            Rectangle2D bounds = this.wnd.getDisplayedBounds();
            highlighter.addMessage(cell, "(" + (int)oX + "," + (int)oY + ")", new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
            double halfWidth = 0.5 * this.pasteBounds.getWidth();
            double halfHeight = 0.5 * this.pasteBounds.getHeight();
            if (Math.abs(this.translateX) > halfWidth || Math.abs(this.translateY) > halfHeight) {
                Rectangle2D.Double transBounds = new Rectangle2D.Double(this.pasteBounds.getX() + oX, this.pasteBounds.getY() + oY, this.pasteBounds.getWidth(), this.pasteBounds.getHeight());
                Poly p = new Poly(transBounds);
                if (this.inPlace != null) {
                    p.transform(this.inPlace);
                }
                Point2D endPoint = p.closestPoint(this.lastMouseDB);
                highlighter.addLine(this.lastMouseDB, endPoint, cell);
                int angle = GenMath.figureAngle(this.lastMouseDB, endPoint);
                int angleOfArrow = 300;
                int backAngle1 = (angle += 1800) - angleOfArrow;
                int backAngle2 = angle + angleOfArrow;
                Point2D.Double p1 = new Point2D.Double(endPoint.getX() + DBMath.cos(backAngle1), endPoint.getY() + DBMath.sin(backAngle1));
                Point2D.Double p2 = new Point2D.Double(endPoint.getX() + DBMath.cos(backAngle2), endPoint.getY() + DBMath.sin(backAngle2));
                highlighter.addLine(endPoint, p1, cell);
                highlighter.addLine(endPoint, p2, cell);
            }
            highlighter.finished();
        }

        private void showPoints(Point2D[] points, double oX, double oY, Cell cell, Highlighter highlighter) {
            for (int i2 = 0; i2 < points.length; ++i2) {
                int lastI = i2 - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                double fX = points[lastI].getX();
                double fY = points[lastI].getY();
                double tX = points[i2].getX();
                double tY = points[i2].getY();
                highlighter.addLine(new Point2D.Double(fX + oX, fY + oY), new Point2D.Double(tX + oX, tY + oY), cell);
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (e2.isMetaDown()) {
                this.popup.show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.isMetaDown()) {
                return;
            }
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            Point2D delta = this.getDelta(mouseDB, ctrl);
            this.showList(delta);
            WindowFrame.setListener(this.currentListener);
            this.wnd.getHighlighter().popHighlight();
            Cell cell = WindowFrame.needCurCell();
            if (cell != null) {
                new PasteObjects(this.fromCell, cell, this.geomList, this.textList, delta.getX(), delta.getY(), User.getAlignmentToGrid(), User.isDupCopiesExports(), User.isIncrementRightmostIndex(), User.isArcsAutoIncremented(), this.convertSchLay, this.inPlace, this.inPlaceOrient);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            Point2D delta = this.getDelta(mouseDB, ctrl);
            this.lastMouseDB = mouseDB;
            this.showList(delta);
            this.wnd.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e2) {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 27) {
                this.abort();
            } else if (chr == 38) {
                this.moveObjectsUp();
            } else if (chr == 40) {
                this.moveObjectsDown();
            } else if (chr == 37) {
                this.moveObjectsLeft();
            } else if (chr == 39) {
                this.moveObjectsRight();
            }
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent e2) {
            Iterator<Serializable> it = this.geomList.iterator();
            while (it.hasNext()) {
                if (it.next().isLinked()) continue;
                it.remove();
            }
            it = this.textList.iterator();
            while (it.hasNext()) {
                if (((DisplayedText)it.next()).getElectricObject().isLinked()) continue;
                it.remove();
            }
        }

        private void abort() {
            this.wnd.getHighlighter().clear();
            this.wnd.getHighlighter().finished();
            WindowFrame.setListener(this.currentListener);
            this.wnd.repaint();
        }

        private void initPopup() {
            this.popup = new JPopupMenu();
            JMenuItem m2 = new JMenuItem("Move objects left");
            m2.setAccelerator(KeyStroke.getKeyStroke(37, 0));
            m2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.moveObjectsLeft();
                }
            });
            this.popup.add(m2);
            m2 = new JMenuItem("Move objects right");
            m2.setAccelerator(KeyStroke.getKeyStroke(39, 0));
            m2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.moveObjectsRight();
                }
            });
            this.popup.add(m2);
            m2 = new JMenuItem("Move objects up");
            m2.setAccelerator(KeyStroke.getKeyStroke(38, 0));
            m2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.moveObjectsUp();
                }
            });
            this.popup.add(m2);
            m2 = new JMenuItem("Move objects down");
            m2.setAccelerator(KeyStroke.getKeyStroke(40, 0));
            m2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.moveObjectsDown();
                }
            });
            this.popup.add(m2);
            m2 = new JMenuItem("Abort");
            m2.setAccelerator(KeyStroke.getKeyStroke(27, 0));
            m2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.abort();
                }
            });
            this.popup.add(m2);
        }

        private void moveObjectsLeft() {
            this.translateX += 0.5 * this.pasteBounds.getWidth();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsRight() {
            this.translateX -= 0.5 * this.pasteBounds.getWidth();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsUp() {
            this.translateY -= 0.5 * this.pasteBounds.getHeight();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsDown() {
            this.translateY += 0.5 * this.pasteBounds.getHeight();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }
    }

    private static class PasteObjects
    extends Job {
        private Cell toCell;
        private List<Geometric> geomList;
        private List<Geometric> newGeomList;
        private List<DisplayedText> textList;
        private List<DisplayedText> newTextList;
        private double dX;
        private double dY;
        private EDimension alignment;
        private boolean copyExports;
        private boolean fromRight;
        private boolean uniqueArcs;
        private boolean convertSchLay;
        private FixpTransform inPlace;
        private Orientation inPlaceOrient;
        private NodeInst.ExpansionState expansionState;
        private List<NodeInst> nodesToExpand;

        protected PasteObjects(Cell fromCell, Cell toCell, List<Geometric> geomList, List<DisplayedText> textList, double dX, double dY, EDimension alignment, boolean copyExports, boolean fromRight, boolean uniqueArcs, boolean convertSchLay, FixpTransform inPlace, Orientation inPlaceOrient) {
            super("Paste", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.toCell = toCell;
            this.geomList = geomList;
            this.textList = textList;
            this.dX = dX;
            this.dY = dY;
            this.alignment = alignment;
            this.copyExports = copyExports;
            this.fromRight = fromRight;
            this.uniqueArcs = uniqueArcs;
            this.convertSchLay = convertSchLay;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.expansionState = new NodeInst.ExpansionState(fromCell, 1);
            this.nodesToExpand = new ArrayList<NodeInst>();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.toCell, null, true, false, true) != 0) {
                return false;
            }
            this.newGeomList = new ArrayList<Geometric>();
            this.newTextList = new ArrayList<DisplayedText>();
            Clipboard.copyListToCell(this.toCell, this.geomList, this.textList, this.newGeomList, this.newTextList, new Point2D.Double(this.dX, this.dY), this.copyExports, this.fromRight, this.uniqueArcs, this.convertSchLay, this.alignment, this.inPlace, this.inPlaceOrient, this.expansionState, this.nodesToExpand, this.getEditingPreferences());
            this.fieldVariableChanged("newGeomList");
            this.fieldVariableChanged("newTextList");
            this.fieldVariableChanged("nodesToExpand");
            return true;
        }

        @Override
        public void terminateOK() {
            Clipboard.showCopiedObjects(this.newGeomList, this.newTextList);
            for (NodeInst ni : this.nodesToExpand) {
                ni.setExpanded(true);
            }
            if (this.nodesToExpand.size() > 0) {
                EditWindow.repaintAllContents();
            }
        }
    }

    private static class DuplicateObjects
    extends Job {
        private Cell cell;
        private List<Geometric> geomList;
        private List<Geometric> newGeomList;
        private List<DisplayedText> textList;
        private List<DisplayedText> newTextList;
        private boolean dupCopiesExports;
        private boolean fromRight;
        private boolean autoIncrementArcs;
        private EDimension alignment;
        private NodeInst.ExpansionState expansionState;
        private List<NodeInst> nodesToExpand;

        protected DuplicateObjects(Cell cell, List<Geometric> geomList, List<DisplayedText> textList, EDimension alignment) {
            super("Duplicate", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.geomList = geomList;
            this.textList = textList;
            this.alignment = alignment;
            this.dupCopiesExports = User.isDupCopiesExports();
            this.fromRight = User.isIncrementRightmostIndex();
            this.autoIncrementArcs = User.isArcsAutoIncremented();
            this.expansionState = new NodeInst.ExpansionState(cell, 1);
            this.nodesToExpand = new ArrayList<NodeInst>();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            this.newGeomList = new ArrayList<Geometric>();
            this.newTextList = new ArrayList<DisplayedText>();
            Clipboard.copyListToCell(this.cell, this.geomList, this.textList, this.newGeomList, this.newTextList, new Point2D.Double(lastDupX, lastDupY), this.dupCopiesExports, this.fromRight, this.autoIncrementArcs, false, this.alignment, null, null, this.expansionState, this.nodesToExpand, ep);
            this.fieldVariableChanged("newGeomList");
            this.fieldVariableChanged("newTextList");
            this.fieldVariableChanged("nodesToExpand");
            return true;
        }

        @Override
        public void terminateOK() {
            Clipboard.showCopiedObjects(this.newGeomList, this.newTextList);
            for (NodeInst ni : this.nodesToExpand) {
                ni.setExpanded(true);
            }
        }
    }
}

