/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BussedIO;
import java.util.ArrayList;
import java.util.List;

public class SimpleBus
implements BussedIO {
    private List indexNames = new ArrayList();
    private String prefix = "busNameError";

    public SimpleBus(String busName) {
        int openb = busName.lastIndexOf(91);
        if (openb == -1) {
            System.out.println("SimpleBus Error: Not a bussed signal: " + busName);
            return;
        }
        int closeb = busName.lastIndexOf(93);
        if (closeb == -1 || closeb < openb) {
            System.out.println("SimpleBus Error: Bad []'s in: " + busName);
            return;
        }
        this.prefix = busName.substring(0, openb);
        String indices = busName.substring(openb + 1, closeb);
        String[] parts = indices.split(",");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            this.parseArray(parts[i2]);
        }
    }

    void parseArray(String arr) {
        if (arr.indexOf(58) > 0) {
            int end;
            int start;
            String[] indices = arr.split(":");
            if (indices.length != 2) {
                System.out.println("SimpleBus Error: Invalid bus spec: " + arr);
                return;
            }
            try {
                start = Integer.parseInt(indices[0]);
                end = Integer.parseInt(indices[1]);
            }
            catch (NumberFormatException e2) {
                System.out.println("SimpleBus Error: Indices in range must be numeric: " + arr);
                return;
            }
            if (start > end) {
                for (int i2 = start; i2 >= end; --i2) {
                    this.indexNames.add(String.valueOf(i2));
                }
            } else {
                for (int i3 = start; i3 <= end; ++i3) {
                    this.indexNames.add(String.valueOf(i3));
                }
            }
        } else {
            this.indexNames.add(arr);
        }
    }

    @Override
    public int getWidth() {
        return this.indexNames.size();
    }

    @Override
    public String getName() {
        return this.prefix;
    }

    @Override
    public String getSignal(int index) {
        if (index < 0 || index >= this.indexNames.size()) {
            System.out.println("SimpleBus getSignal error: index out of range: " + index);
            return "";
        }
        return this.prefix + "[" + String.valueOf(this.indexNames.get(index)) + "]";
    }

    @Override
    public String getSignal(String bitname) {
        for (int i2 = 0; i2 < this.indexNames.size(); ++i2) {
            if (!this.indexNames.get(i2).equals(bitname)) continue;
            return this.getSignal(i2);
        }
        System.out.println("SimpleBus getSignal error: bitname '" + bitname + "' not found in bus " + this.prefix);
        return "";
    }

    public static void main(String[] args) {
        SimpleBus bus = new SimpleBus("top.foo.bus[1]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[1:2]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[1,3:4]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[a,b,1:4]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus[5:3,b]");
        SimpleBus.testBus(bus);
        bus = new SimpleBus("top.foo.bus");
        SimpleBus.testBus(bus);
    }

    private static void testBus(SimpleBus bus) {
        System.out.println("------------------------------------------------------");
        System.out.println("Bus " + bus.getName() + " indices: (width=" + bus.getWidth() + ")");
        for (int i2 = 0; i2 < bus.getWidth(); ++i2) {
            System.out.println("  " + bus.getSignal(i2));
        }
    }
}

