/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;

class GPIB {
    private static final int ERR_BIT = 32768;
    private static boolean errorPending = false;
    public static final String UNUSED = "unused";
    public static final String[] STATUS_BITS = new String[]{"DCAS: device clear state (brd)", "DTAS: device trigger state (brd)", "LACS: Listener (brd)", "TACS: Talker (brd)", "ATN: Attention is asserted", "CIC: Controller-In-Charge", "REM: Remote state", "LOK: Lockout state", "CMPL: I/O completed", "unused", "unused", "RQS: Device requesting service", "SRQI: SRQ interrupt received", "END: END or EOS detected", "TIMO: Time limit exceeded", "ERR: GPIB error"};
    public static final String[] ERROR_CODES = new String[]{"EDVR: UNIX error (code in ibcnt, which we currently don't return)", "ECIC: Function requires GPIB board to be CIC", "ENOL: Write handshake error (e.g., no Listener)", "EADR: GPIB board not addressed correctly", "EARG: Invalid argument to function call", "ESAC: GPIB board not System Controller as required", "EABO: I/O operation aborted (timeout)", "ENEB: Non-existent GPIB board", "EDMA: DMA hardware problem", "EBTO: DMA hardware bus timeout", "unused", "ECAP: No capability for operation", "EFSO: File system error", "unused", "EBUS: GPIB bus error", "ESTB: Serial Poll status byte queue overflow", "ESRQ: SRQ stuck in ON position", "unused", "unused", "unused", "ETAB: Table Problem"};

    private GPIB() {
    }

    public static int findDevice(String name) {
        name = (String)name + "\u0000";
        int[] istat_ierr = new int[2];
        int ud = GPIB.ibfind(((String)name).getBytes(), istat_ierr);
        String function = "ibfind(" + (String)name + ") when initializing GPIB";
        GPIB.catchError(function, ud, (String)name, istat_ierr[0], istat_ierr[1]);
        if (ud < 0) {
            Infrastructure.fatal("Cannot find device " + (String)name + " on GPIB.");
        }
        return ud;
    }

    public static void ibWrite(int ud, String name, String data) {
        data = (String)data + "\n";
        byte[] bytes = ((String)data).getBytes();
        int length = bytes.length;
        int[] ierr = new int[1];
        int status = GPIB.ibwrt(ud, bytes, length, ierr);
        String function = "ibwrt(ud=" + ud + ", data=" + (String)data + ", length=" + length + ") during write to";
        GPIB.catchError(function, ud, name, status, ierr[0]);
    }

    public static String ibRead(int ud, String name, int length) {
        byte[] bytes = new byte[length];
        int[] ierr = new int[1];
        int status = GPIB.ibrd(ud, bytes, length, ierr);
        String output = new String(bytes);
        String function = "ibrd(ud=" + ud + ", bytes, length=" + length + ") during read from";
        GPIB.catchError(function, ud, name, status, ierr[0]);
        return output;
    }

    public static int ibAsk(int ud, String name, int option) {
        int[] value = new int[1];
        int[] ierr = new int[1];
        int status = GPIB.ibask(ud, option, value, ierr);
        String function = "ibask(ud=" + ud + ", option=" + option + ", value) during query of";
        GPIB.catchError(function, ud, name, status, ierr[0]);
        return value[0];
    }

    public static void ibClr(int ud, String name) {
        int[] ierr = new int[1];
        int status = GPIB.ibclr(ud, ierr);
        String function = "ibclr(ud=" + ud + ") during clear of";
        GPIB.catchError(function, ud, name, status, ierr[0]);
    }

    public static void ibCmd(int ud, String name, String command) {
        int[] ierr = new int[1];
        command = (String)command + "\n";
        byte[] bytes = ((String)command).getBytes();
        int length = bytes.length;
        int status = GPIB.ibcmd(ud, bytes, length, ierr);
        String function = "ibcmd(ud=" + ud + ", cmd=" + String.valueOf(bytes) + ", cnt=" + length + ") while sending interface message to";
        GPIB.catchError(function, ud, name, status, ierr[0]);
    }

    private static void catchError(String function, int ud, String name, int status, int iberr) {
        if ((status & 0x8000) != 0) {
            Infrastructure.nonfatal("Bad return value ibsta=" + status + " (0x" + Integer.toHexString(status) + ") from native method\nGPIB." + function + "\ndevice " + name + ".  Error is iberr=" + iberr + ".");
            GPIB.reportStatus(status);
            GPIB.reportError(iberr);
            System.err.println("Find descriptions of these error conditions\nin Chapter 3 of ${TEST_ROOT}/manuals/NI-488.2M_sw.pdf.");
            if (!errorPending) {
                errorPending = true;
                System.err.println("\nNow querying device " + name + " itself about the error...");
                GPIB.ibWrite(ud, name, "SYST:ERR?");
                String error = GPIB.ibRead(ud, name, 200);
                System.err.println("Device " + name + " reports error: " + error);
            }
            int[] ierr = new int[1];
            status = GPIB.ibclr(ud, ierr);
            System.exit(0);
        }
    }

    private static void reportStatus(int status) {
        System.err.println("The following bits are set in the ibsta status word:");
        for (int bit = 0; bit < STATUS_BITS.length; ++bit) {
            int value = 1 << bit;
            if ((status & value) == 0) continue;
            System.err.println("  Bit " + bit + " (0x" + Integer.toHexString(value) + ") means '" + STATUS_BITS[bit] + "'");
            if (!STATUS_BITS[bit].equals(UNUSED)) continue;
            System.err.println("*** This status bit should not occur ***");
        }
    }

    private static void reportError(int iberr) {
        if (iberr < 0 || iberr >= ERROR_CODES.length || ERROR_CODES[iberr].equals(UNUSED)) {
            System.err.println("Unknown error code iberr=" + iberr);
        } else {
            System.err.println("The error code iberr=" + iberr + " means '" + ERROR_CODES[iberr] + "'");
        }
    }

    private static void printCodes() {
        for (int bit = 0; bit < STATUS_BITS.length; ++bit) {
            System.out.println(bit + " (0x" + Integer.toHexString(1 << bit) + "): " + STATUS_BITS[bit]);
        }
        for (int err = 0; err < ERROR_CODES.length; ++err) {
            System.out.println(err + ": " + ERROR_CODES[err]);
        }
    }

    public static native int ibwrt(int var0, byte[] var1, int var2, int[] var3);

    public static native int ibrd(int var0, byte[] var1, int var2, int[] var3);

    public static native int ibfind(byte[] var0, int[] var1);

    public static native int ibask(int var0, int var1, int[] var2, int[] var3);

    public static native int ibclr(int var0, int[] var1);

    public static native int ibcmd(int var0, byte[] var1, long var2, int[] var4);

    public static void main(String[] args) {
        int ista;
        GPIB.printCodes();
        do {
            String string = Infrastructure.readln("Enter ista in hex:");
            ista = Integer.parseInt(string, 16);
            GPIB.reportStatus(ista);
        } while (ista != -999);
    }

    static {
        System.loadLibrary("teste");
    }
}

