/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import com.sun.electric.tool.simulation.sctiming.SCTimingException;
import com.sun.electric.tool.simulation.sctiming.Table2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TableData {
    List<String> headers;
    List<double[]> rows;

    public TableData(List<String> headers) {
        this.headers = headers;
        this.rows = new ArrayList<double[]>();
    }

    public void addRow(double[] row) {
        if (row.length != this.headers.size()) {
            System.out.println("Cannot add row of length " + row.length + " to table of length " + this.headers.size());
            return;
        }
        this.rows.add(row);
    }

    public int getNumCols() {
        return this.headers.size();
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public double[] getRow(int row) {
        return this.rows.get(row);
    }

    public int getColumn(String headername) {
        if (headername == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            if (!this.headers.get(i2).equalsIgnoreCase(headername)) continue;
            return i2;
        }
        return -1;
    }

    public double getValue(int row, String header) {
        int col = this.getColumn(header);
        if (col < 0) {
            return Double.NaN;
        }
        if (row < 0 || row >= this.rows.size()) {
            return Double.NaN;
        }
        return this.rows.get(row)[col];
    }

    public void printData() {
        int i2;
        int colwidth = 12;
        for (String s : this.headers) {
            if (s.length() <= colwidth) continue;
            colwidth = s.length() + 1;
        }
        StringBuffer line = new StringBuffer();
        for (String s : this.headers) {
            line.append(s);
            for (i2 = s.length(); i2 < colwidth; ++i2) {
                line.append(" ");
            }
        }
        System.out.println(line);
        for (double[] row : this.rows) {
            line = new StringBuffer();
            for (i2 = 0; i2 < row.length; ++i2) {
                String s = Double.toString(row[i2]);
                line.append(s);
                for (int j2 = s.length(); j2 < colwidth; ++j2) {
                    line.append(" ");
                }
            }
            System.out.println(line);
        }
    }

    public Table2D getTable2D(String index1, String index2, String index3, String index3ExcludeValues) {
        int i1 = this.getColumn(index1);
        int i2 = this.getColumn(index2);
        int i3 = this.getColumn(index3);
        double[] excludeValues = this.getDoubleValues(index3ExcludeValues);
        if (i1 < 0 || i2 < 0) {
            return null;
        }
        ArrayList<Double> values1 = new ArrayList<Double>();
        ArrayList<Double> values2 = new ArrayList<Double>();
        for (double[] row : this.rows) {
            Double d1 = row[i1];
            Double d2 = row[i2];
            if (!values1.contains(d1)) {
                values1.add(d1);
            }
            if (values2.contains(d2)) continue;
            values2.add(d2);
        }
        double[] di1 = new double[values1.size()];
        double[] di2 = new double[values2.size()];
        int i4 = 0;
        Iterator it = values1.iterator();
        while (it.hasNext()) {
            di1[i4] = (Double)it.next();
            ++i4;
        }
        i4 = 0;
        it = values2.iterator();
        while (it.hasNext()) {
            di2[i4] = (Double)it.next();
            ++i4;
        }
        Table2D table = new Table2D(di1, index1, di2, index2);
        boolean getStdDev = false;
        if (di1.length * di2.length < this.getNumRows()) {
            System.out.println("Warning: Conversion of TableData to Table2D will average some values because the number of unique values of " + index1 + " times " + index2 + " is smaller than the dimensions of the TableData");
            getStdDev = true;
        }
        for (int j2 = 0; j2 < this.headers.size(); ++j2) {
            String key = this.headers.get(j2);
            if (key.equals(index1) || key.equals(index2)) continue;
            double[][] data = new double[di1.length][di2.length];
            int[][] count = new int[di1.length][di2.length];
            for (int x = 0; x < di1.length; ++x) {
                Arrays.fill(data[x], 0.0);
                Arrays.fill(count[x], 0);
            }
            for (double[] row : this.rows) {
                double ii1 = row[i1];
                double ii2 = row[i2];
                boolean skipThisVal = false;
                if (i3 >= 0) {
                    double ii3 = row[i3];
                    for (double excludeval : excludeValues) {
                        if (excludeval != ii3) continue;
                        skipThisVal = true;
                        break;
                    }
                }
                if (skipThisVal) continue;
                int r = 0;
                int c2 = 0;
                for (r = 0; r < di1.length && di1[r] != ii1; ++r) {
                }
                for (c2 = 0; c2 < di2.length && di2[c2] != ii2; ++c2) {
                }
                double[] dArray = data[r];
                int n2 = c2;
                dArray[n2] = dArray[n2] + row[j2];
                int[] nArray = count[r];
                int n3 = c2;
                nArray[n3] = nArray[n3] + 1;
            }
            for (int r = 0; r < di1.length; ++r) {
                for (int c3 = 0; c3 < di2.length; ++c3) {
                    if (count[r][c3] <= 1) continue;
                    double[] dArray = data[r];
                    int n4 = c3;
                    dArray[n4] = dArray[n4] / (double)count[r][c3];
                }
            }
            table.setData(key, data);
            if (!getStdDev) continue;
            double[][] stddev = new double[di1.length][di2.length];
            for (int x = 0; x < di1.length; ++x) {
                Arrays.fill(stddev[x], 0.0);
            }
            for (double[] row : this.rows) {
                double ii1 = row[i1];
                double ii2 = row[i2];
                boolean skipThisVal = false;
                if (i3 >= 0) {
                    double ii3 = row[i3];
                    for (double excludeval : excludeValues) {
                        if (excludeval != ii3) continue;
                        skipThisVal = true;
                        break;
                    }
                }
                if (skipThisVal) continue;
                int r = 0;
                int c4 = 0;
                for (r = 0; r < di1.length && di1[r] != ii1; ++r) {
                }
                for (c4 = 0; c4 < di2.length && di2[c4] != ii2; ++c4) {
                }
                double diff = data[r][c4] - row[j2];
                double[] dArray = stddev[r];
                int n5 = c4;
                dArray[n5] = dArray[n5] + diff * diff;
            }
            int thirdD = this.getNumRows() / di1.length / di2.length;
            for (int r = 0; r < di1.length; ++r) {
                for (int c5 = 0; c5 < di2.length; ++c5) {
                    stddev[r][c5] = Math.sqrt(stddev[r][c5] / (double)thirdD);
                }
            }
            table.setData(key + "_stddev", stddev);
        }
        return table;
    }

    public double getAverage(int column) {
        if (column < 0 || column >= this.headers.size()) {
            return 0.0;
        }
        double total = 0.0;
        for (double[] row : this.rows) {
            total += row[column];
        }
        return total / (double)this.rows.size();
    }

    private double[] getDoubleValues(String list) {
        if (list == null) {
            return new double[0];
        }
        String[] svals = list.split("\\s+");
        double[] dvals = new double[svals.length];
        Arrays.fill(dvals, -1.0);
        for (int i2 = 0; i2 < svals.length; ++i2) {
            try {
                dvals[i2] = Double.valueOf(svals[i2]);
                continue;
            }
            catch (NumberFormatException e2) {
                return new double[0];
            }
        }
        return dvals;
    }

    public static TableData readSpiceMeasResults(String filename) throws SCTimingException {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e2) {
            throw new SCTimingException(e2.getMessage());
        }
        try {
            int ttype;
            ArrayList<String> headers = new ArrayList<String>();
            StreamTokenizer s = new StreamTokenizer(reader);
            s.resetSyntax();
            s.wordChars(0, 255);
            s.whitespaceChars(32, 32);
            s.whitespaceChars(9, 9);
            s.whitespaceChars(13, 13);
            s.whitespaceChars(10, 10);
            s.whitespaceChars(12, 12);
            s.quoteChar(39);
            s.quoteChar(34);
            s.eolIsSignificant(true);
            boolean title = false;
            while ((ttype = s.nextToken()) != -1) {
                if (!title && ttype == -3 && s.sval.equalsIgnoreCase(".TITLE")) {
                    title = true;
                    continue;
                }
                if (!title || ttype != 10) continue;
            }
            s.eolIsSignificant(false);
            while ((ttype = s.nextToken()) != -1) {
                if (ttype != -3) {
                    throw new SCTimingException("Expected string, but got " + s.toString() + " while parsing index data of " + filename);
                }
                headers.add(s.sval);
                if (!s.sval.equals("alter#")) continue;
            }
            TableData data = new TableData(headers);
            int i2 = 0;
            double[] row = new double[headers.size()];
            while ((ttype = s.nextToken()) != -1) {
                if (i2 == 0) {
                    row = new double[headers.size()];
                }
                if (ttype != -3) {
                    throw new SCTimingException("Expected value, but got '" + s.toString() + "' while parsing index data of " + filename);
                }
                try {
                    row[i2] = Double.parseDouble(s.sval);
                }
                catch (NumberFormatException e3) {
                    if (s.sval.equalsIgnoreCase("failed")) {
                        row[i2] = Double.NaN;
                    }
                    throw new SCTimingException("Expected numeric value, but got '" + s.toString() + "' while parsing spice measurement file " + filename);
                }
                if (++i2 != headers.size()) continue;
                data.addRow(row);
                i2 = 0;
            }
            reader.close();
            return data;
        }
        catch (IOException e4) {
            throw new SCTimingException(e4.getMessage());
        }
    }
}

