/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LibData {
    public Group library;
    private static final int MAX_LINE_LENGTH = 80;

    public void write(String filename) {
        try {
            this.write(new PrintStream(new FileOutputStream(filename)));
        }
        catch (FileNotFoundException e2) {
            System.out.println("LibData: Error writing to file " + filename + ": " + e2.getMessage());
        }
    }

    public void write(PrintStream out) {
        if (this.library == null) {
            System.out.println("LibData: No Data to write");
            return;
        }
        this.library.write(out, 0);
    }

    public Group getLibrary() {
        return this.library;
    }

    public void setLibrary(Group group) {
        this.library = group;
    }

    public static String getMessage(Error error) {
        switch (error.ordinal()) {
            case 0: {
                return "";
            }
            case 1: {
                return "Internal System Error";
            }
            case 2: {
                return "Invalid Value";
            }
            case 3: {
                return "Invalid Name";
            }
            case 4: {
                return "Invalid Object Type";
            }
            case 5: {
                return "Invalid Attribute Type";
            }
            case 6: {
                return "Unusable Object Identifier?";
            }
            case 7: {
                return "Object Already Exists";
            }
            case 8: {
                return "Object Not Found";
            }
            case 9: {
                return "Syntax Error";
            }
            case 10: {
                return "Trace Files Cannot be Opened";
            }
            case 11: {
                return "PI init() not called";
            }
            case 12: {
                return "Semantic Error";
            }
            case 13: {
                return "Reference Error";
            }
            case 14: {
                return "Maximum Error";
            }
        }
        return "Unknown Error Number: " + String.valueOf((Object)error);
    }

    private static void prtabs(PrintStream out, int tabs) {
        for (int i2 = 0; i2 < tabs; ++i2) {
            out.print("  ");
        }
    }

    public static class Group {
        private String type;
        private List<String> names;
        private Group owner;
        Map<String, Attribute> attrList;
        Map<String, Define> defineList;
        List<Group> groupList;

        public Group(String type, String name, Group owner) {
            this.type = type;
            this.names = new ArrayList<String>();
            if (name != null) {
                this.names.add(name);
            }
            this.owner = owner;
            this.attrList = new LinkedHashMap<String, Attribute>();
            this.defineList = new LinkedHashMap<String, Define>();
            this.groupList = new ArrayList<Group>();
            if (owner != null) {
                owner.putGroup(this);
            }
        }

        public Group(Head h2, Group owner) {
            this.type = h2.name;
            this.names = new ArrayList<String>();
            this.owner = owner;
            this.attrList = new LinkedHashMap<String, Attribute>();
            this.defineList = new LinkedHashMap<String, Define>();
            this.groupList = new ArrayList<Group>();
            for (Value a2 : h2.getValues()) {
                this.names.add(a2.value.toString());
            }
            if (owner != null) {
                owner.putGroup(this);
            }
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            if (this.names.size() > 0) {
                return this.names.get(0);
            }
            return null;
        }

        public List<String> getNames() {
            return this.names;
        }

        public Group getOwner() {
            return this.owner;
        }

        public String getHName() {
            String parentName = this.owner == null ? "" : this.owner.getHName() + ".";
            String thisname = this.type + (String)(this.names.size() == 0 ? "" : "-" + this.names.get(0));
            return parentName + thisname;
        }

        public void putAttribute(Attribute a2) {
            if (this.attrList.containsKey(a2.name)) {
                System.out.println("Duplicate Attribute name " + a2.name + " in group " + this.getHName());
            }
            this.attrList.put(a2.name, a2);
        }

        public void putGroup(Group g2) {
            this.groupList.add(g2);
        }

        public void putDefine(Define d2) {
            if (this.defineList.containsKey(d2.name)) {
                System.out.println("Duplicate Define name " + d2.name + " in group " + this.getHName());
            }
            this.defineList.put(d2.name, d2);
        }

        public Attribute getAttribute(String name) {
            return this.attrList.get(name);
        }

        public void putAttribute(String name, double value) {
            Value val = new Value(ValueType.DOUBLE, value);
            this.putAttribute(new Attribute(name, val));
        }

        public void putAttribute(String name, String value) {
            Value val = new Value(ValueType.STRING, value);
            this.putAttribute(new Attribute(name, val));
        }

        public void putAttribute(String name, int value) {
            Value val = new Value(ValueType.INT, value);
            this.putAttribute(new Attribute(name, val));
        }

        public void putAttribute(String name, List<String> values) {
            ArrayList<Value> vals = new ArrayList<Value>();
            for (String s : values) {
                vals.add(new Value(ValueType.STRING, s));
            }
            Head h2 = new Head(name, vals);
            this.putAttribute(new Attribute(name, h2));
        }

        public void putAttributeComplex(String name, String value) {
            ArrayList<String> vals = new ArrayList<String>();
            vals.add(value);
            this.putAttribute(name, vals);
        }

        public List<Group> getGroups() {
            return this.groupList;
        }

        public List<Group> getGroups(String type, String name) {
            ArrayList<Group> groups = new ArrayList<Group>();
            if (type == null) {
                return groups;
            }
            for (Group g2 : this.groupList) {
                if (!type.equals(g2.type)) continue;
                if (name == null && g2.names.size() == 0) {
                    groups.add(g2);
                    continue;
                }
                if (name == null || !g2.names.contains(name)) continue;
                groups.add(g2);
            }
            return groups;
        }

        public Define getDefine(String name) {
            return this.defineList.get(name);
        }

        public void removeGroup(Group group) {
            for (Group g2 : this.groupList) {
                if (g2 != group) continue;
                this.groupList.remove(g2);
                return;
            }
        }

        private void write(PrintStream out, int tabs) {
            LibData.prtabs(out, tabs);
            out.print(this.type + " (");
            Iterator<String> it = this.names.iterator();
            while (it.hasNext()) {
                out.print(it.next());
                if (!it.hasNext()) continue;
                out.print(", ");
            }
            out.println(") {");
            ++tabs;
            for (Attribute attr : this.attrList.values()) {
                attr.write(out, tabs);
            }
            for (Define define : this.defineList.values()) {
                define.write(out, tabs);
            }
            for (Group group : this.groupList) {
                group.write(out, tabs);
            }
            LibData.prtabs(out, --tabs);
            out.println("}");
        }
    }

    public static enum Error {
        NO_ERROR,
        INTERNAL_SYSTEM_ERROR,
        INVALID_VALUE,
        INVALID_NAME,
        INVALID_OBJECTTYPE,
        INVALID_ATTRTYPE,
        UNUSABLE_OID,
        OBJECT_ALREADY_EXISTS,
        OBJECT_NOT_FOUND,
        SYNTAX_ERROR,
        TRACE_FILES_CANNOT_BE_OPENED,
        PIINIT_NOT_CALLED,
        SEMANTIC_ERROR,
        REFERENCE_ERROR,
        MAX_ERROR;

    }

    public static class Define {
        String name;
        String groupType;
        ValueType valueType;
        String comment;
        Group owner;

        Define(String name, Group owner, ValueType valueType) {
            this.name = name;
            this.owner = owner;
            this.valueType = valueType;
            if (owner != null) {
                owner.putDefine(this);
            }
        }

        private void write(PrintStream out, int tabs) {
        }
    }

    public static class Value {
        ValueType type;
        Object value;

        public Value(ValueType type, Object value) {
            String s;
            this.type = type;
            this.value = value;
            if (value instanceof String && (s = (String)value).startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
                this.value = s;
            }
        }

        public ValueType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public static ValueType getType(String s) {
            if (s == null) {
                return ValueType.UNDEFINED;
            }
            try {
                return ValueType.valueOf(s.trim().toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                return ValueType.UNDEFINED;
            }
        }

        public Integer getInt() {
            if (this.value == null || this.type != ValueType.DOUBLE) {
                return null;
            }
            return ((Double)this.value).intValue();
        }

        public Double getDouble() {
            if (this.value == null || this.type != ValueType.DOUBLE) {
                return null;
            }
            return (Double)this.value;
        }

        public String getString() {
            if (this.value == null || this.type != ValueType.STRING) {
                return null;
            }
            return (String)this.value;
        }

        public Boolean getBoolean() {
            if (this.value == null || this.type != ValueType.BOOLEAN) {
                return null;
            }
            return (Boolean)this.value;
        }

        private String getValueAsString() {
            String s = this.value.toString().trim();
            if (!(s.indexOf(32) == -1 && s.indexOf(47) == -1 && s.indexOf(92) == -1 && s.indexOf("(") == -1 || s.startsWith("\"") || s.endsWith("\""))) {
                return "\"" + s + "\"";
            }
            return s;
        }
    }

    public static enum ValueType {
        STRING,
        DOUBLE,
        BOOLEAN,
        INT,
        EXPR,
        UNDEFINED;

    }

    public static class Attribute {
        AttrType type;
        String name;
        List<Value> values;

        public Attribute(String name, Value value) {
            this.name = name;
            this.type = AttrType.SIMPLE;
            this.values = new ArrayList<Value>();
            this.values.add(value);
        }

        public Attribute(String name, Head complexAttributeValues) {
            this.name = name;
            this.type = AttrType.COMPLEX;
            this.values = complexAttributeValues.getValues();
        }

        public AttrType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public List<Value> getValues() {
            return this.values;
        }

        public Integer getInt() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getInt();
        }

        public Double getDouble() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getDouble();
        }

        public String getString() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getString();
        }

        public Boolean getBoolean() {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(0).getBoolean();
        }

        private void write(PrintStream out, int tabs) {
            LibData.prtabs(out, tabs);
            out.print(this.name);
            int i2 = tabs * 2 + this.name.length();
            switch (this.type.ordinal()) {
                case 0: {
                    out.print(" : ");
                    i2 += 3;
                    break;
                }
                case 1: {
                    out.print(" (");
                    i2 += 2;
                }
            }
            int start = i2;
            Iterator<Value> it = this.values.iterator();
            while (it.hasNext()) {
                Value v = it.next();
                String s = v.getValueAsString();
                if (i2 + s.length() > 80) {
                    out.println(" \\");
                    i2 = start;
                    LibData.prtabs(out, start / 2);
                }
                out.print(s);
                i2 += s.length();
                if (!it.hasNext()) continue;
                out.print(", ");
                i2 += 2;
            }
            if (this.type == AttrType.COMPLEX) {
                out.print(")");
            }
            out.println(" ;");
        }
    }

    public static enum AttrType {
        SIMPLE,
        COMPLEX;

    }

    public static class Head {
        public String name;
        int lineno;
        String filename;
        List<Value> valuesList;

        public Head(String name, List attrList) {
            this.name = name;
            this.valuesList = new ArrayList<Value>();
            for (Object obj : attrList) {
                if (!(obj instanceof Value)) continue;
                this.valuesList.add((Value)obj);
            }
        }

        public List<Value> getValues() {
            return this.valuesList;
        }
    }
}

