/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.interval;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class RawFile {
    private int numVars;
    private int numPoints;
    private double[][] data;
    private String[] varName;
    private String[] varType;

    public RawFile(int numPoints, int numVars) {
        this.numVars = numVars;
        this.numPoints = numPoints;
        this.varName = new String[numVars];
        this.varType = new String[numVars];
        this.data = new double[numPoints][];
        for (int i2 = 0; i2 < numPoints; ++i2) {
            this.data[i2] = new double[numVars];
        }
    }

    public void setVar(int iVar, String varName, String varType) {
        this.varName[iVar] = varName;
        this.varType[iVar] = varType;
    }

    public void set(int iPoint, int iVar, double v) {
        this.data[iPoint][iVar] = v;
    }

    public void write(String fileName) {
        this.write(fileName, false, null);
    }

    public void writeBinary(String fileName, ByteOrder byteOrder) {
        this.write(fileName, true, byteOrder);
    }

    private void write(String fileName, boolean binaryFormat, ByteOrder byteOrder) {
        try {
            DecimalFormat fmt = new DecimalFormat("0.000000000000000000E00");
            fmt.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
            FileOutputStream outStream = new FileOutputStream(fileName);
            PrintWriter FILE = new PrintWriter(outStream);
            FILE.println("Title: " + fileName);
            FILE.println("Plotname: Waveform");
            FILE.println("Flags: real");
            FILE.println("No. Variables: " + this.numVars);
            FILE.println("No. Points: " + this.numPoints);
            FILE.println("Variables:");
            for (int iVar = 0; iVar < this.numVars; ++iVar) {
                FILE.println("\t" + iVar + "\t" + this.varName[iVar] + "\t" + this.varType[iVar]);
            }
            if (binaryFormat) {
                FILE.println("Binary:");
                FILE.flush();
                byte[] bytes = new byte[this.numVars * 8];
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                byteBuffer.order(byteOrder != null ? byteOrder : ByteOrder.nativeOrder());
                for (int iPoint = 0; iPoint < this.numPoints; ++iPoint) {
                    byteBuffer.clear();
                    for (int iVar = 0; iVar < this.numVars; ++iVar) {
                        byteBuffer.putDouble(this.data[iPoint][iVar]);
                    }
                    outStream.write(bytes);
                }
            } else {
                FILE.println("Values:");
                for (int iPoint = 0; iPoint < this.numPoints; ++iPoint) {
                    FILE.println(iPoint + "\t" + fmt.format(this.data[iPoint][0]));
                    for (int iVar = 1; iVar < this.numVars; ++iVar) {
                        FILE.println("\t" + fmt.format(this.data[iPoint][iVar]));
                    }
                    FILE.println();
                }
            }
            FILE.close();
        }
        catch (FileNotFoundException e2) {
            System.out.println("Failure writing file " + fileName);
        }
        catch (IOException e3) {
            System.out.println("Failure writing file " + fileName);
        }
    }
}

