/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.als;

import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.als.ALS;

public class Command {
    private ALS als;
    static String[] tNames = new String[]{"01", "10", "0Z", "Z1", "1Z", "Z0", "0X", "X1", "1X", "X0", "XZ", "ZX"};

    Command(ALS als) {
        this.als = als;
    }

    /*
     * WARNING - void declaration
     */
    void printCommand(String[] par) {
        if (par.length < 1) {
            System.out.println("telltool simulation als print OPTION");
            return;
        }
        if (par[0].equals("vector")) {
            ALS.Link linkHead = this.als.setRoot;
            System.out.println("** VECTOR LINKLIST **");
            while (linkHead != null) {
                switch (linkHead.type) {
                    case 'N': {
                        ALS.Node nodeHead = (ALS.Node)linkHead.ptr;
                        String s1 = Stimuli.describeLevel((Integer)linkHead.state);
                        System.out.println("***** vector: $N" + nodeHead.getIndex() + ", state = " + s1 + ", strength = " + Stimuli.describeStrength(linkHead.strength) + ", time = " + linkHead.time + ", priority = " + linkHead.priority);
                        break;
                    }
                    case 'F': {
                        ALS.Stat statHead = (ALS.Stat)linkHead.ptr;
                        ALS.Node nodeHead = statHead.nodePtr;
                        String s1 = Stimuli.describeLevel((Integer)linkHead.state);
                        System.out.println("***** function: $N" + nodeHead.getIndex() + ", state = " + s1 + ", strength = " + Stimuli.describeStrength(linkHead.strength) + ", time = " + linkHead.time + ", priority = " + linkHead.priority);
                        break;
                    }
                    case 'R': {
                        System.out.println("***** rowptr = " + String.valueOf(linkHead.ptr) + ", time = " + linkHead.time + ", priority = " + linkHead.priority);
                        break;
                    }
                    case 'C': {
                        System.out.println("***** clokptr = " + String.valueOf(linkHead.ptr) + ", time = " + linkHead.time + ", priority = " + linkHead.priority);
                    }
                }
                linkHead = linkHead.right;
            }
            return;
        }
        if (par[0].equals("netlist")) {
            System.out.println("** NETWORK DESCRIPTION **");
            block11: for (ALS.Model primHead : this.als.primList) {
                switch (primHead.type) {
                    case 'F': {
                        StringBuffer infstr = new StringBuffer();
                        infstr.append("FUNCTION: " + primHead.name + " (instance " + (primHead.level == null ? "null" : primHead.level) + ") [");
                        boolean first = true;
                        for (ALS.ALSExport aLSExport : primHead.exList) {
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            infstr.append("N" + aLSExport.nodePtr.getIndex());
                        }
                        infstr.append("]");
                        System.out.println(infstr.toString());
                        infstr = new StringBuffer();
                        infstr.append("  Event Driving Inputs:");
                        ALS.Func funcHead = (ALS.Func)primHead.ptr;
                        for (ALS.ALSExport exHead : funcHead.inList) {
                            infstr.append(" N" + exHead.nodePtr.getIndex());
                        }
                        System.out.println(infstr.toString());
                        infstr = new StringBuffer();
                        infstr.append("  Output Ports:");
                        for (ALS.ALSExport exHead : primHead.exList) {
                            if (exHead.nodeName == null) continue;
                            infstr.append(" N" + ((ALS.Stat)exHead.nodeName).nodePtr.getIndex());
                        }
                        System.out.println(infstr.toString());
                        System.out.println("  Timing: D=" + funcHead.delta + ", L=" + funcHead.linear + ", E=" + funcHead.exp + ", R=" + funcHead.random + ", A=" + funcHead.abs);
                        System.out.println("  Firing Priority = " + primHead.priority);
                        continue block11;
                    }
                    case 'G': {
                        void var7_17;
                        System.out.println("GATE: " + primHead.name + " (instance " + (primHead.level == null ? "null" : primHead.level) + ")");
                        ALS.Row row = (ALS.Row)primHead.ptr;
                        while (var7_17 != null) {
                            System.out.println("  Timing: D=" + var7_17.delta + ", L=" + var7_17.linear + ", E=" + var7_17.exp + ", R=" + var7_17.random + ", A=" + var7_17.abs);
                            System.out.println("  Delay type: " + (var7_17.delay == null ? "null" : var7_17.delay));
                            this.printInEntry((ALS.Row)var7_17);
                            this.printOutEntry((ALS.Row)var7_17);
                            ALS.Row row2 = var7_17.next;
                        }
                        System.out.println("  Firing Priority = " + primHead.priority);
                        continue block11;
                    }
                }
                System.out.println("Illegal primitive type '" + primHead.type + "', database is bad");
            }
            return;
        }
        System.out.println("telltool simulation als print");
    }

    private void printInEntry(ALS.Row rowHead) {
        boolean flag = false;
        StringBuffer infstr = new StringBuffer();
        infstr.append("  Input: ");
        for (Object obj : rowHead.inList) {
            ALS.IO ioHead = (ALS.IO)obj;
            if (flag) {
                infstr.append("& ");
            }
            flag = true;
            ALS.Node nodeHead = (ALS.Node)ioHead.nodePtr;
            infstr.append("N" + nodeHead.getIndex());
            if (ioHead.operatr > '\u007f') {
                int operatr = ioHead.operatr - 128;
                nodeHead = (ALS.Node)ioHead.operand;
                infstr.append(operatr + "N" + nodeHead.getIndex());
                continue;
            }
            infstr.append(ioHead.operatr);
            Integer num = (Integer)ioHead.operand;
            String s2 = Stimuli.describeLevel(num);
            infstr.append(s2 + " ");
        }
        System.out.println(infstr.toString());
    }

    private void printOutEntry(ALS.Row rowHead) {
        boolean flag = false;
        StringBuffer infstr = new StringBuffer();
        infstr.append("  Output: ");
        for (Object obj : rowHead.outList) {
            ALS.IO ioHead = (ALS.IO)obj;
            if (flag) {
                infstr.append("& ");
            }
            flag = true;
            ALS.Stat statHead = (ALS.Stat)ioHead.nodePtr;
            ALS.Node nodeHead = statHead.nodePtr;
            infstr.append("N" + nodeHead.getIndex());
            if (ioHead.operatr > '\u007f') {
                int operatr = ioHead.operatr - 128;
                nodeHead = (ALS.Node)ioHead.operand;
                infstr.append(operatr + "N" + nodeHead.getIndex() + "@" + (ioHead.strength + 1) / 2 + " ");
                continue;
            }
            infstr.append(ioHead.operatr);
            Integer num = (Integer)ioHead.operand;
            String s2 = Stimuli.describeLevel(num);
            infstr.append(s2 + "@" + (ioHead.strength + 1) / 2 + " ");
        }
        System.out.println(infstr.toString());
    }
}

