/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.als;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.GenerateVHDL;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.als.Flat;
import com.sun.electric.tool.simulation.als.Sim;
import com.sun.electric.tool.simulation.als.UserCom;
import com.sun.electric.tool.user.CompileVHDL;
import com.sun.electric.tool.user.CompileVerilogStruct;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ALS
implements Engine {
    private static final double DEFTIMERANGE = 2.0E-7;
    Sim theSim;
    Flat theFlat;
    WaveformWindow ww;
    SignalCollection sc;
    double timeAbs;
    List<String> stimuliList;
    List<Model> modelList;
    List<Model> primList = new ArrayList<Model>();
    IO ioPtr2;
    Connect cellRoot = null;
    ALSExport exPtr2;
    List<Node> nodeList = new ArrayList<Node>();
    Node driveNode;
    Link linkFront = null;
    Link linkBack = null;
    Link setRoot = null;
    List ioPtr1;
    char[] instBuf = null;
    int[] instPtr = null;
    private int iPtr;
    private String delay;
    private Model modPtr2;
    private String[] netlistStrings;
    private int netlistStringPoint;
    private int iBufSize;
    private int iPtrSize;
    private double deltaDef;
    private double linearDef;
    private double expDef;
    private double randomDef;
    private double absDef;
    private Stimuli sd;
    private Node dummyNode = new Node();

    @Override
    public Stimuli getStimuli() {
        return this.sd;
    }

    ALS(Stimuli sd) {
        this.sd = sd;
        this.theSim = new Sim(this);
        this.theFlat = new Flat(this);
    }

    Sim getSim() {
        return this.theSim;
    }

    public static void simulateNetlist(Cell netlistCell, Cell cell, Stimuli sd) {
        ALS theALS = new ALS(sd);
        theALS.doSimulation(netlistCell, cell, null, null);
    }

    public static void restartSimulation(Cell netlistCell, Cell cell, ALS prevALS, Stimuli sd) {
        WaveformWindow ww = prevALS.ww;
        List<String> stimuliList = prevALS.stimuliList;
        ALS theALS = new ALS(sd);
        theALS.doSimulation(netlistCell, cell, ww, stimuliList);
    }

    @Override
    public FileType getVectorsFileType() {
        return FileType.ALSVECTOR;
    }

    @Override
    public void refresh() {
        this.stimuliList = this.getStimuliToSave();
        SimulationTool.startSimulation(0, null, this.getStimuli().getCell(), this, false);
    }

    @Override
    public void update() {
        this.theSim.initializeSimulator(true);
    }

    @Override
    public void setSignalHigh() {
        this.makeThemThus(2);
    }

    @Override
    public void setSignalLow() {
        this.makeThemThus(0);
    }

    @Override
    public void setClock(double period) {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.size() == 0) {
            Job.getUserInterface().showErrorMessage("Must select a signal before setting a Clock on it", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            String sigName = sig.getFullName();
            Node nodeHead = this.findNode(sigName);
            if (nodeHead == null) {
                System.out.println("ERROR: Unable to find node " + sigName);
                continue;
            }
            double time = this.ww.getMainXPositionCursor();
            Link vectPtr2 = new Link();
            vectPtr2.type = (char)78;
            vectPtr2.ptr = nodeHead;
            vectPtr2.state = 2;
            vectPtr2.strength = 12;
            vectPtr2.priority = 1;
            vectPtr2.time = time;
            vectPtr2.right = null;
            Link vectPtr1 = new Link();
            vectPtr1.type = (char)78;
            vectPtr1.ptr = nodeHead;
            vectPtr1.state = 0;
            vectPtr1.strength = 12;
            vectPtr1.priority = 1;
            vectPtr1.time = period / 2.0;
            vectPtr1.right = vectPtr2;
            Row clokHead = new Row();
            clokHead.inList = new ArrayList<Object>();
            clokHead.inList.add(vectPtr1);
            clokHead.inList.add(vectPtr2);
            clokHead.outList = new ArrayList<Object>();
            clokHead.delta = period;
            clokHead.linear = 0.0;
            clokHead.exp = 0.0;
            clokHead.abs = 0.0;
            clokHead.random = 0.0;
            clokHead.next = null;
            clokHead.delay = null;
            Link setHead = new Link();
            setHead.type = (char)67;
            setHead.ptr = clokHead;
            setHead.state = 0;
            setHead.priority = 1;
            setHead.time = time;
            setHead.right = null;
            this.insertSetList(setHead);
        }
        this.theSim.initializeSimulator(true);
    }

    @Override
    public void setSignalX() {
        this.makeThemThus(1);
    }

    @Override
    public void showSignalInfo() {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.size() == 0) {
            Job.getUserInterface().showErrorMessage("Must select a signal before displaying it", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            Node nodeHead = this.findNode(sig.getFullName());
            if (nodeHead == null) {
                System.out.println("ERROR: Unable to find node " + sig.getFullName());
                continue;
            }
            String s1 = Stimuli.describeLevel((Integer)nodeHead.newState);
            System.out.println("Node " + sig.getFullName() + ": State = " + s1 + ", Strength = " + Stimuli.describeStrength(nodeHead.newStrength));
            for (Stat statHead : nodeHead.statList) {
                s1 = Stimuli.describeLevel(statHead.newState);
                System.out.println("Primitive " + statHead.primPtr.name + ":    State = " + s1 + ", Strength = " + Stimuli.describeStrength(statHead.newStrength));
            }
        }
    }

    @Override
    public void removeStimuliFromSignal() {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.size() == 0) {
            Job.getUserInterface().showErrorMessage("Must select a signal on which to clear stimuli", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            sig.clearControlPoints();
            Link lastSet = null;
            Link nextSet = null;
            Link thisSet = this.setRoot;
            while (thisSet != null) {
                nextSet = thisSet.right;
                boolean delete = false;
                if (thisSet.ptr instanceof Node) {
                    Node node = (Node)thisSet.ptr;
                    if (node.sig == sig) {
                        delete = true;
                    }
                } else if (thisSet.ptr instanceof Row) {
                    Row clokHead = (Row)thisSet.ptr;
                    Iterator<Object> cIt = clokHead.inList.iterator();
                    if (cIt.hasNext()) {
                        Link vectHead = (Link)cIt.next();
                        Node node = (Node)vectHead.ptr;
                        if (node.sig == sig) {
                            delete = true;
                        }
                    }
                }
                if (delete) {
                    if (lastSet == null) {
                        this.setRoot = nextSet;
                    } else {
                        lastSet.right = nextSet;
                    }
                } else {
                    lastSet = thisSet;
                }
                thisSet = nextSet;
            }
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.theSim.initializeSimulator(true);
        }
    }

    @Override
    public boolean removeSelectedStimuli() {
        boolean found = false;
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            for (WaveSignal ws : wp.getSignals()) {
                double[] selectedCPs;
                if (!ws.isHighlighted() || (selectedCPs = ws.getSelectedControlPoints()) == null) continue;
                block2: for (int i2 = 0; i2 < selectedCPs.length; ++i2) {
                    Signal<?> sig = ws.getSignal();
                    Link lastSet = null;
                    Link nextSet = null;
                    Link thisSet = this.setRoot;
                    while (thisSet != null) {
                        nextSet = thisSet.right;
                        boolean delete = false;
                        if (thisSet.time == selectedCPs[i2]) {
                            if (thisSet.ptr instanceof Node) {
                                Node node = (Node)thisSet.ptr;
                                if (node.sig == sig) {
                                    delete = true;
                                }
                            } else if (thisSet.ptr instanceof Row) {
                                Row clokHead = (Row)thisSet.ptr;
                                Iterator<Object> cIt = clokHead.inList.iterator();
                                if (cIt.hasNext()) {
                                    Link vectHead = (Link)cIt.next();
                                    Node node = (Node)vectHead.ptr;
                                    if (node.sig == sig) {
                                        delete = true;
                                    }
                                }
                            }
                        }
                        if (delete) {
                            sig.removeControlPoint(thisSet.time);
                            if (lastSet == null) {
                                this.setRoot = nextSet;
                            } else {
                                lastSet.right = nextSet;
                            }
                            found = true;
                            continue block2;
                        }
                        lastSet = thisSet;
                        thisSet = nextSet;
                    }
                }
            }
        }
        if (!found) {
            System.out.println("There are no selected control points to remove");
            return false;
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.theSim.initializeSimulator(true);
        }
        return true;
    }

    @Override
    public void removeAllStimuli() {
        this.clearAllVectors(false);
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            for (WaveSignal ws : wp.getSignals()) {
                Signal<?> sig = ws.getSignal();
                sig.clearControlPoints();
            }
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.theSim.initializeSimulator(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveStimuli(File stimuliFile) throws IOException {
        if (stimuliFile == null) {
            throw new NullPointerException();
        }
        try (PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(stimuliFile)));){
            List<String> stimuliList = this.getStimuliToSave();
            for (String str : stimuliList) {
                printWriter.println(str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreStimuli(URL stimuliURL) throws IOException {
        if (stimuliURL == null) {
            throw new NullPointerException();
        }
        ArrayList<String> stimuliList = new ArrayList<String>();
        try (LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(stimuliURL.openStream()));){
            String s1;
            while ((s1 = lineReader.readLine()) != null) {
                stimuliList.add(s1);
            }
        }
        this.processStimuliList(stimuliList);
    }

    @Override
    public double getMinTimeRange() {
        return 2.0E-7;
    }

    private void init() {
        new UserCom.PMOSTran(this);
        new UserCom.PMOSTranWeak(this);
        new UserCom.NMOSTran(this);
        new UserCom.NMOSTranWeak(this);
        new UserCom.JKFlop(this);
        new UserCom.DFFlop(this);
        new UserCom.BusToState(this);
        new UserCom.StateToBus(this);
        if (this.instBuf == null) {
            this.iBufSize = 100;
            this.instBuf = new char[100];
        }
        if (this.instPtr == null) {
            this.iPtrSize = 100;
            this.instPtr = new int[100];
        }
    }

    private void doSimulation(Cell netlistCell, Cell cell, WaveformWindow oldWW, List<String> stimuliList) {
        this.init();
        this.eraseModel();
        if (this.readNetDesc(netlistCell)) {
            return;
        }
        if (this.theFlat.flattenNetwork(cell)) {
            return;
        }
        this.sc = this.getCircuit(cell);
        this.ww = oldWW;
        if (this.ww == null) {
            WaveformWindow.showSimulationDataInNewWindow(this.getStimuli());
            this.ww = this.getStimuli().getWaveformWindow();
        } else {
            WaveformWindow.refreshSimulationData(this.getStimuli(), this.ww);
        }
        if (stimuliList != null) {
            this.processStimuliList(stimuliList);
        }
        this.theSim.initializeSimulator(true);
    }

    private void makeThemThus(int state) {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.size() == 0) {
            Job.getUserInterface().showErrorMessage("Must select a signal on which to set stimuli", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            String sigName = sig.getFullName();
            Node nodeHead = this.findNode(sigName);
            if (nodeHead == null) {
                System.out.println("ERROR: Unable to find node " + sigName);
                return;
            }
            int strength = 4;
            double time = this.ww.getMainXPositionCursor();
            Link setHead = new Link();
            setHead.type = (char)78;
            setHead.ptr = nodeHead;
            setHead.state = state;
            setHead.strength = strength;
            setHead.priority = 2;
            setHead.time = time;
            setHead.right = null;
            sig.addControlPoint(time);
            this.insertSetList(setHead);
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            double endTime = this.theSim.initializeSimulator(true);
            if (SimulationTool.isBuiltInAutoAdvance()) {
                this.ww.setMainXPositionCursor(endTime);
            }
        }
    }

    void insertSetList(Link linkHead) {
        boolean linkPtr1Is = false;
        Link linkPtr1 = null;
        while (true) {
            Link linkPtr2 = this.setRoot;
            if (linkPtr1Is) {
                linkPtr2 = linkPtr1.right;
            }
            if (linkPtr2 == null) {
                if (!linkPtr1Is) {
                    this.setRoot = linkHead;
                    break;
                }
                linkPtr1.right = linkHead;
                break;
            }
            if (linkPtr2.time > linkHead.time || linkPtr2.time == linkHead.time && linkPtr2.priority > linkHead.priority) {
                linkHead.right = linkPtr2;
                if (!linkPtr1Is) {
                    this.setRoot = linkHead;
                    break;
                }
                linkPtr1.right = linkHead;
                break;
            }
            linkPtr1 = linkPtr2;
            linkPtr1Is = true;
        }
    }

    private void eraseModel() {
        this.linkFront = null;
        this.linkBack = null;
        this.clearAllVectors(true);
        this.cellRoot = null;
        this.nodeList = new ArrayList<Node>();
        this.primList = new ArrayList<Model>();
        this.modelList = new ArrayList<Model>();
    }

    private void clearAllVectors(boolean pwrGnd) {
        Link lastSet = null;
        Link nextSet = null;
        Link thisSet = this.setRoot;
        while (thisSet != null) {
            nextSet = thisSet.right;
            if (pwrGnd || thisSet.strength != 12) {
                if (lastSet == null) {
                    this.setRoot = nextSet;
                } else {
                    lastSet.right = nextSet;
                }
            } else {
                lastSet = thisSet;
            }
            thisSet = nextSet;
        }
    }

    private SignalCollection getCircuit(Cell cell) {
        this.sd.setEngine(this);
        SignalCollection sc = Stimuli.newSignalCollection(this.sd, "SIGNALS");
        this.sd.setSeparatorChar('.');
        this.sd.setCell(cell);
        String topLevelName = cell.getName().toUpperCase();
        Connect cr = this.cellRoot;
        while (cr != null) {
            if (cr.modelName.equals(topLevelName)) {
                this.addExports(cr, sc, null);
                break;
            }
            cr = cr.next;
        }
        return sc;
    }

    private void addExports(Connect cr, SignalCollection sc, String context) {
        for (Model modPtr1 : this.modelList) {
            if (!modPtr1.name.equals(cr.modelName)) continue;
            if (modPtr1.type == 'M') break;
            return;
        }
        for (ALSExport e2 : cr.exList) {
            if (e2.nodePtr.sig != null) continue;
            MutableSignal<DigitalSample> sig = DigitalSample.createSignal(sc, this.sd, (String)e2.nodeName, context);
            e2.nodePtr.sig = sig;
            sig.addSample(0.0, DigitalSample.LOGIC_0);
        }
        Object subContext = context;
        subContext = subContext == null ? "" : (String)subContext + ".";
        Connect child = cr.child;
        while (child != null) {
            this.addExports(child, sc, (String)subContext + child.instName);
            child = child.next;
        }
    }

    private List<String> getStimuliToSave() {
        ArrayList<String> stimuliList = new ArrayList<String>();
        Link setHead = this.setRoot;
        while (setHead != null) {
            switch (setHead.type) {
                case 'C': {
                    Row clokHead = (Row)setHead.ptr;
                    List<Object> vectList = clokHead.inList;
                    boolean first = true;
                    for (Object obj : vectList) {
                        Link vectHead = (Link)obj;
                        if (first) {
                            String s1 = this.computeNodeName((Node)vectHead.ptr);
                            stimuliList.add("CLOCK " + s1 + " D=" + clokHead.delta + " L=" + clokHead.linear + " E=" + clokHead.exp + " STRENGTH=" + Stimuli.strengthToIndex(vectHead.strength) + " TIME=" + setHead.time + " CYCLES=" + String.valueOf(setHead.state));
                            first = false;
                        }
                        String s2 = Stimuli.describeLevelBriefly((Integer)vectHead.state);
                        stimuliList.add("  " + s2 + " " + vectHead.time);
                    }
                    break;
                }
                case 'N': {
                    String s1 = this.computeNodeName((Node)setHead.ptr);
                    String s2 = Stimuli.describeLevelBriefly((Integer)setHead.state);
                    stimuliList.add("SET " + s1 + "=" + s2 + "@" + Stimuli.strengthToIndex(setHead.strength) + " TIME=" + setHead.time);
                }
            }
            setHead = setHead.right;
        }
        return stimuliList;
    }

    private void processStimuliList(List<String> stimuliList) {
        while (this.setRoot != null) {
            this.setRoot = this.setRoot.right;
        }
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            for (WaveSignal ws : wp.getSignals()) {
                Signal<?> sig = ws.getSignal();
                sig.clearControlPoints();
            }
        }
        boolean flag = true;
        String[] parts = null;
        Iterator<String> sIt = stimuliList.iterator();
        while (true) {
            Node nodeHead;
            String nodeName;
            String s1 = null;
            if (flag) {
                if (!sIt.hasNext()) break;
                s1 = sIt.next();
                s1 = s1.toUpperCase();
                parts = this.fragmentCommand(s1);
            }
            flag = true;
            if (parts == null || parts.length < 1) continue;
            void command = parts[0];
            if (command.equals("CLOCK")) {
                if (parts.length < 14) {
                    System.out.println("Error: CLOCK stimuli line has only " + parts.length + " fields: " + s1);
                    continue;
                }
                nodeName = parts[1];
                nodeHead = this.findNode(nodeName);
                if (nodeHead == null) {
                    System.out.println("ERROR: Unable to find node " + nodeName);
                    continue;
                }
                int strength = Stimuli.indexToStrength(TextUtils.atoi(parts[9]));
                Link setHead = new Link();
                setHead.type = (char)67;
                Row clokHead = new Row();
                setHead.ptr = clokHead;
                setHead.state = TextUtils.atoi(parts[13]);
                setHead.priority = 1;
                setHead.time = TextUtils.atof(parts[11]);
                setHead.right = null;
                this.insertSetList(setHead);
                if (nodeHead.sig != null) {
                    nodeHead.sig.addControlPoint(setHead.time);
                }
                clokHead.delta = TextUtils.atof(parts[3]);
                clokHead.linear = TextUtils.atof(parts[5]);
                clokHead.exp = TextUtils.atof(parts[7]);
                clokHead.abs = 0.0;
                clokHead.random = 0.0;
                clokHead.next = null;
                clokHead.delay = null;
                clokHead.inList = new ArrayList<Object>();
                while (true) {
                    if (!sIt.hasNext()) {
                        this.theSim.initializeSimulator(false);
                        return;
                    }
                    s1 = sIt.next();
                    parts = this.fragmentCommand(s1.toUpperCase());
                    String com = parts[0];
                    if (com.equals("CLOCK") || com.equals("SET")) {
                        flag = false;
                        break;
                    }
                    Link vectPtr2 = new Link();
                    vectPtr2.type = (char)78;
                    vectPtr2.ptr = nodeHead;
                    vectPtr2.state = Stimuli.parseLevel(com);
                    vectPtr2.strength = strength;
                    vectPtr2.priority = 1;
                    vectPtr2.time = TextUtils.atof(parts[1]);
                    vectPtr2.right = null;
                    clokHead.inList.add(vectPtr2);
                }
            }
            if (!command.equals("SET")) continue;
            if (parts.length < 6) {
                System.out.println("Error: SET stimuli line has only " + parts.length + " fields: " + s1);
                continue;
            }
            nodeName = parts[1];
            nodeHead = this.findNode(nodeName);
            if (nodeHead == null) {
                System.out.println("ERROR: Unable to find node " + nodeName);
                continue;
            }
            Link setHead = new Link();
            setHead.type = (char)78;
            setHead.ptr = nodeHead;
            setHead.state = Stimuli.parseLevel(parts[2]);
            setHead.strength = Stimuli.indexToStrength(TextUtils.atoi(parts[3]));
            setHead.priority = 2;
            setHead.time = TextUtils.atof(parts[5]);
            setHead.right = null;
            this.insertSetList(setHead);
            if (nodeHead.sig == null) continue;
            nodeHead.sig.addControlPoint(setHead.time);
        }
        this.theSim.initializeSimulator(true);
    }

    private String[] fragmentCommand(String line) {
        ArrayList<String> fragments = new ArrayList<String>();
        line = line.trim();
        for (int i2 = 0; i2 < line.length(); ++i2) {
            int pos;
            int atPos;
            int equalPos;
            int spacePos = line.indexOf(32, i2);
            if (spacePos < 0) {
                spacePos = line.length();
            }
            if ((equalPos = line.indexOf(61, i2)) < 0) {
                equalPos = line.length();
            }
            if ((atPos = line.indexOf(64, i2)) < 0) {
                atPos = line.length();
            }
            if ((pos = Math.min(Math.min(spacePos, equalPos), atPos)) < 0) {
                fragments.add(line.substring(i2));
                break;
            }
            fragments.add(line.substring(i2, pos));
            i2 = pos;
        }
        String[] parts = new String[fragments.size()];
        for (int i3 = 0; i3 < fragments.size(); ++i3) {
            parts[i3] = (String)fragments.get(i3);
        }
        return parts;
    }

    Connect findLevel(String sp) {
        Connect cellPtr = this.cellRoot;
        if (sp.startsWith(".")) {
            sp = sp.substring(1);
        }
        block0: while (sp.length() > 0) {
            String part = sp;
            sp = "";
            int dotPos = part.indexOf(46);
            if (dotPos >= 0) {
                sp = part.substring(dotPos + 1);
                part = part.substring(0, dotPos);
            }
            while (cellPtr != null) {
                if (part.equals(cellPtr.instName)) {
                    if (sp.length() <= 0) continue block0;
                    cellPtr = cellPtr.child;
                    continue block0;
                }
                cellPtr = cellPtr.next;
            }
            return null;
        }
        return cellPtr;
    }

    String computeNodeName(Node nodeHead) {
        Connect cellHead = nodeHead.cellPtr;
        Object sp = this.computePathName(cellHead);
        for (ALSExport exHead : cellHead.exList) {
            if (nodeHead != exHead.nodePtr) continue;
            sp = (String)sp + "." + String.valueOf(exHead.nodeName);
            return sp;
        }
        return "";
    }

    String computePathName(Connect cellHead) {
        StringBuffer infstr = new StringBuffer();
        while (cellHead != null) {
            infstr.append("." + cellHead.instName);
            cellHead = cellHead.parent;
        }
        return infstr.toString();
    }

    private Node findNode(String sp) {
        if (sp.startsWith("$N")) {
            int i2 = TextUtils.atoi(sp.substring(2));
            for (Node nodeHead : this.nodeList) {
                if (nodeHead.num != i2) continue;
                return nodeHead;
            }
            return null;
        }
        int dotPos = sp.lastIndexOf(46);
        String s2 = sp;
        Connect cellPtr = this.findLevel(this.getStimuli().getCell().getName().toUpperCase());
        if (dotPos >= 0) {
            s2 = sp.substring(dotPos + 1);
            cellPtr = this.findLevel(sp.substring(0, dotPos));
        }
        if (cellPtr == null) {
            cellPtr = this.cellRoot;
        }
        for (ALSExport exHead : cellPtr.exList) {
            if (!exHead.nodeName.equals(s2)) continue;
            return exHead.nodePtr;
        }
        return null;
    }

    private boolean readNetDesc(Cell cell) {
        String s1;
        this.netlistStrings = cell.getTextViewContents();
        if (this.netlistStrings == null) {
            System.out.println("No netlist information found in " + String.valueOf(cell));
            return true;
        }
        this.netlistStringPoint = 0;
        System.out.println("Simulating netlist in " + String.valueOf(cell));
        this.instPtr[0] = -1;
        this.iPtr = 0;
        while ((s1 = this.getAString()) != null) {
            if (s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL")) {
                if (!this.parseStructHeader(s1.charAt(0))) continue;
                return true;
            }
            System.out.println("ERROR: String '" + s1 + "' invalid (expecting gate, function, or model)");
            return true;
        }
        return false;
    }

    private boolean parseStructHeader(char flag) {
        String s1 = this.getAName();
        if (s1 == null) {
            System.out.println("Structure declaration: EOF unexpectedly found");
            return true;
        }
        for (Model modPtr1 : this.modelList) {
            if (!modPtr1.name.equals(s1)) continue;
            System.out.println("ERROR: Structure " + s1 + " already defined");
            return true;
        }
        this.modPtr2 = new Model(s1, flag);
        this.modPtr2.fanOut = '\u0001';
        this.modelList.add(this.modPtr2);
        s1 = this.getAString();
        if (s1 == null) {
            System.out.println("Structure declaration: EOF unexpectedly found");
            return true;
        }
        if (!s1.startsWith("(")) {
            System.out.println("Structure declaration: Expecting to find '(' in place of string '" + s1 + "'");
            return true;
        }
        while (true) {
            if ((s1 = this.getAName()) == null) {
                System.out.println("Structure declaration: EOF unexpectedly found");
                return true;
            }
            if (s1.startsWith(")")) break;
            for (ALSExport exPtr1 : this.modPtr2.exList) {
                if (!exPtr1.nodeName.equals(s1)) continue;
                System.out.println("Node " + s1 + " specified more than once in argument list");
                return true;
            }
            this.exPtr2 = new ALSExport();
            this.exPtr2.nodeName = s1;
            this.exPtr2.nodePtr = null;
            this.modPtr2.exList.add(this.exPtr2);
        }
        switch (flag) {
            case 'G': {
                return this.parseGate();
            }
            case 'F': {
                return this.parseFunction();
            }
            case 'M': {
                return this.parseModel();
            }
        }
        System.out.println("Error in parser: invalid structure type");
        return true;
    }

    private boolean parseGate() {
        block12: {
            String s1;
            block13: {
                this.delay = "XX";
                this.absDef = 0.0;
                this.randomDef = 0.0;
                this.expDef = 0.0;
                this.linearDef = 0.0;
                this.deltaDef = 0.0;
                Object last = this.modPtr2;
                Row rowPtr2 = null;
                while (true) {
                    if ((s1 = this.getAString()) == null || s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL")) {
                        --this.iPtr;
                        break block12;
                    }
                    if (s1.equals("I")) {
                        rowPtr2 = new Row();
                        rowPtr2.inList = new ArrayList<Object>();
                        rowPtr2.outList = new ArrayList<Object>();
                        rowPtr2.delta = this.deltaDef;
                        rowPtr2.linear = this.linearDef;
                        rowPtr2.exp = this.expDef;
                        rowPtr2.random = this.randomDef;
                        rowPtr2.abs = this.absDef;
                        rowPtr2.delay = this.delay;
                        this.delay = "XX";
                        rowPtr2.next = null;
                        if (last instanceof Row) {
                            ((Row)last).next = rowPtr2;
                        } else {
                            ((Model)last).ptr = rowPtr2;
                        }
                        last = rowPtr2;
                        this.ioPtr1 = rowPtr2.inList;
                        if (!this.parseNode()) continue;
                        return true;
                    }
                    if (s1.equals("O")) {
                        this.ioPtr1 = rowPtr2.outList;
                        if (!this.parseNode()) continue;
                        return true;
                    }
                    if (s1.equals("T")) {
                        if (!this.parseTiming()) continue;
                        return true;
                    }
                    if (s1.equals("D")) {
                        if (!this.parseDelay()) continue;
                        return true;
                    }
                    if (s1.equals("FANOUT")) {
                        if (!this.parseFanOut()) continue;
                        return true;
                    }
                    if (s1.equals("LOAD")) {
                        if (!this.parseLoad()) continue;
                        return true;
                    }
                    if (s1.equals("PRIORITY")) {
                        Integer jj = this.getAnInt();
                        if (jj == null) {
                            System.out.println("Priority declaration: EOF unexpectedly found");
                            return true;
                        }
                        this.modPtr2.priority = jj;
                        continue;
                    }
                    if (!s1.equals("SET")) break block13;
                    this.ioPtr1 = this.modPtr2.setList;
                    if (this.parseNode()) break;
                }
                return true;
            }
            System.out.println("ERROR: String '" + s1 + "' invalid gate syntax");
            return true;
        }
        return false;
    }

    private boolean parseNode() {
        while (true) {
            Integer jj;
            String s1;
            if ((s1 = this.getAName()) == null || s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL") || s1.equals("I") || s1.equals("O") || s1.equals("T") || s1.equals("FANOUT") || s1.equals("LOAD") || s1.equals("PRIORITY") || s1.equals("SET")) {
                --this.iPtr;
                break;
            }
            this.ioPtr2 = new IO();
            this.ioPtr2.nodePtr = s1;
            this.ioPtr2.strength = 8;
            this.ioPtr1.add(this.ioPtr2);
            s1 = this.getAString();
            if (s1 == null) {
                System.out.println("Node declaration: EOF unexpectedly found");
                return true;
            }
            switch (s1.charAt(0)) {
                case '!': 
                case '%': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '<': 
                case '=': 
                case '>': {
                    break;
                }
                default: {
                    System.out.println("Gate declaration: Invalid Operator '" + s1 + "'");
                    return true;
                }
            }
            this.ioPtr2.operatr = s1.charAt(0);
            s1 = this.getAString();
            if (s1 == null) {
                System.out.println("Node declaration: EOF unexpectedly found");
                return true;
            }
            if (s1.equals("L") || s1.equals("X") || s1.equals("H")) {
                this.ioPtr2.operand = Stimuli.parseLevel(s1);
            } else {
                --this.iPtr;
                if (s1.charAt(0) == '+' || s1.charAt(0) == '-' || TextUtils.isDigit(s1.charAt(0))) {
                    jj = this.getAnInt();
                    if (jj == null) {
                        System.out.println("Node declaration: EOF unexpectedly found");
                        return true;
                    }
                    this.ioPtr2.operand = jj;
                } else {
                    s1 = this.getAName();
                    if (s1 == null) {
                        System.out.println("Node declaration: EOF unexpectedly found");
                        return true;
                    }
                    this.ioPtr2.operand = s1;
                    this.ioPtr2.operatr = (char)(this.ioPtr2.operatr + 128);
                }
            }
            s1 = this.getAString();
            if (s1 == null || !s1.startsWith("@")) {
                --this.iPtr;
                continue;
            }
            jj = this.getAnInt();
            if (jj == null) {
                System.out.println("Node declaration: EOF unexpectedly found");
                return true;
            }
            this.ioPtr2.strength = Stimuli.indexToStrength(jj);
        }
        return false;
    }

    private boolean parseTiming() {
        String s1;
        this.absDef = 0.0;
        this.randomDef = 0.0;
        this.expDef = 0.0;
        this.linearDef = 0.0;
        this.deltaDef = 0.0;
        block7: do {
            if ((s1 = this.getAString()) == null) {
                System.out.println("Timing declaration: EOF unexpectedly found");
                return true;
            }
            String s2 = this.getAString();
            if (s2 == null) {
                System.out.println("Timing declaration: EOF unexpectedly found");
                return true;
            }
            if (!s2.startsWith("=")) {
                System.out.println("Timing declaration: Invalid Operator '" + s2 + "' (expecting '=')");
                return true;
            }
            Double value = this.getADouble();
            if (value == null) {
                System.out.println("Timing declaration: EOF unexpectedly found");
                return true;
            }
            switch (s1.charAt(0)) {
                case 'A': {
                    this.absDef = value;
                    break;
                }
                case 'D': {
                    this.deltaDef = value;
                    break;
                }
                case 'E': {
                    this.expDef = value;
                    break;
                }
                case 'L': {
                    this.linearDef = value;
                    break;
                }
                case 'R': {
                    this.randomDef = value;
                    if (!(value > 0.0)) continue block7;
                    this.modPtr2.priority = 2;
                    break;
                }
                default: {
                    System.out.println("Invalid timing mode '" + s1 + "'");
                    return true;
                }
            }
        } while ((s1 = this.getAString()) != null && s1.startsWith("+"));
        --this.iPtr;
        return false;
    }

    private boolean parseDelay() {
        String s1 = this.getAString();
        if (s1 == null) {
            System.out.println("Timing declaration: EOF unexpectedly found");
            return true;
        }
        if (!(s1.equals("01") || s1.equals("10") || s1.equals("OZ") || s1.equals("Z1") || s1.equals("1Z") || s1.equals("Z0") || s1.equals("0X") || s1.equals("X1") || s1.equals("1X") || s1.equals("X0") || s1.equals("XZ") || s1.equals("ZX"))) {
            System.out.println("Invalid delay transition name '" + s1 + "'");
            return true;
        }
        this.delay = s1;
        return false;
    }

    private boolean parseFanOut() {
        String s1 = this.getAString();
        if (s1 == null) {
            System.out.println("Fanout declaration: EOF unexpectedly found");
            return true;
        }
        if (!s1.startsWith("=")) {
            System.out.println("Fanout declaration: Invalid Operator '" + s1 + "' (expecting '=')");
            return true;
        }
        s1 = this.getAString();
        if (s1 == null) {
            System.out.println("Fanout declaration: EOF unexpectedly found");
            return true;
        }
        if (s1.equals("ON")) {
            this.modPtr2.fanOut = '\u0001';
            return false;
        }
        if (s1.equals("OFF")) {
            this.modPtr2.fanOut = '\u0000';
            return false;
        }
        System.out.println("Fanout declaration: Invalid option '" + s1 + "'");
        return true;
    }

    private boolean parseLoad() {
        while (true) {
            String s1;
            if ((s1 = this.getAName()) == null || s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL") || s1.equals("I") || s1.equals("O") || s1.equals("T") || s1.equals("FANOUT") || s1.equals("LOAD") || s1.equals("PRIORITY") || s1.equals("SET")) {
                --this.iPtr;
                break;
            }
            String s2 = this.getAString();
            if (s2 == null) {
                System.out.println("Load declaration: EOF unexpectedly found");
                return true;
            }
            if (s2.charAt(0) != '=') {
                System.out.println("Load declaration: Invalid Operator '" + s2 + "' (expecting '=')");
                return true;
            }
            Double load = this.getADouble();
            if (load == null) {
                System.out.println("Load declaration: EOF unexpectedly found");
                return true;
            }
            Load loadPtr2 = new Load();
            loadPtr2.ptr = s1;
            loadPtr2.load = load;
            this.modPtr2.loadList.add(loadPtr2);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseModel() {
        block0: while (true) {
            if ((s1 = this.getAName()) == null || s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL")) {
                --this.iPtr;
                break;
            }
            if (s1.charAt(0) == '}') continue;
            if (s1.equals("SET")) {
                this.ioPtr1 = this.modPtr2.setList;
                if (!this.parseNode()) continue;
                return true;
            }
            conptr1 = this.modPtr2.ptr;
            while (conptr1 != null) {
                cp1 = (Connect)conptr1;
                if (cp1.instName.equals(s1)) {
                    System.out.println("ERROR: Instance name '" + s1 + "' defined more than once");
                    return true;
                }
                conptr1 = ((Connect)conptr1).next;
            }
            conPtr2 = new Connect();
            conPtr2.instName = s1;
            conPtr2.modelName = null;
            conPtr2.exList = new ArrayList<ALSExport>();
            conPtr2.next = (Connect)this.modPtr2.ptr;
            this.modPtr2.ptr = conPtr2;
            s1 = this.getAName();
            if (s1 == null) {
                System.out.println("Model declaration: EOF unexpectedly found");
                return true;
            }
            conPtr2.modelName = s1;
            s1 = this.getAString();
            if (s1 == null) {
                System.out.println("Model declaration: EOF unexpectedly found");
                return true;
            }
            if (s1.charAt(0) != '(') {
                System.out.println("Model declaration: Expecting to find '(' in place of string '" + s1 + "'");
                return true;
            }
            while (true) {
                if ((s1 = this.getAName()) == null) {
                    System.out.println("Model declaration: EOF unexpectedly found");
                    return true;
                }
                if (s1.charAt(0) != ')') ** break;
                continue block0;
                this.exPtr2 = new ALSExport();
                this.exPtr2.nodePtr = null;
                this.exPtr2.nodeName = s1;
                conPtr2.exList.add(this.exPtr2);
            }
            break;
        }
        return false;
    }

    private boolean parseFunction() {
        block9: {
            String s1;
            this.modPtr2.fanOut = '\u0000';
            Func funcHead = new Func();
            this.modPtr2.ptr = funcHead;
            funcHead.procPtr = null;
            funcHead.inList = new ArrayList<ALSExport>();
            funcHead.delta = 0.0;
            funcHead.linear = 0.0;
            funcHead.exp = 0.0;
            funcHead.abs = 0.0;
            funcHead.random = 0.0;
            funcHead.userPtr = null;
            while (true) {
                if ((s1 = this.getAString()) == null || s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL")) {
                    --this.iPtr;
                    break block9;
                }
                if (s1.equals("I")) {
                    this.parseFuncInput(funcHead);
                    continue;
                }
                if (s1.equals("O")) {
                    if (!this.parseFuncOutput()) continue;
                    return true;
                }
                if (s1.equals("T")) {
                    if (this.parseTiming()) {
                        return true;
                    }
                    funcHead.delta = this.deltaDef;
                    funcHead.linear = this.linearDef;
                    funcHead.exp = this.expDef;
                    funcHead.abs = this.absDef;
                    funcHead.random = this.randomDef;
                    continue;
                }
                if (s1.equals("LOAD")) {
                    if (!this.parseLoad()) continue;
                    return true;
                }
                if (s1.equals("PRIORITY")) {
                    Integer jj = this.getAnInt();
                    if (jj == null) {
                        System.out.println("Priority declaration: EOF unexpectedly found");
                        return true;
                    }
                    this.modPtr2.priority = jj;
                    continue;
                }
                if (!s1.equals("SET")) break;
                this.ioPtr1 = this.modPtr2.setList;
                this.parseNode();
            }
            System.out.println("ERROR: String '" + s1 + "' invalid function syntax");
            return true;
        }
        return false;
    }

    private void parseFuncInput(Func funcHead) {
        while (true) {
            String s1;
            if ((s1 = this.getAName()) == null || s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL") || s1.equals("I") || s1.equals("O") || s1.equals("T") || s1.equals("FANOUT") || s1.equals("LOAD") || s1.equals("PRIORITY") || s1.equals("SET")) {
                --this.iPtr;
                break;
            }
            this.exPtr2 = new ALSExport();
            this.exPtr2.nodePtr = null;
            this.exPtr2.nodeName = s1;
            funcHead.inList.add(this.exPtr2);
        }
    }

    private boolean parseFuncOutput() {
        block3: {
            String s1;
            boolean found;
            block0: do {
                if ((s1 = this.getAName()) == null || s1.equals("GATE") || s1.equals("FUNCTION") || s1.equals("MODEL") || s1.equals("I") || s1.equals("O") || s1.equals("T") || s1.equals("FANOUT") || s1.equals("LOAD") || s1.equals("PRIORITY") || s1.equals("SET")) {
                    --this.iPtr;
                    break block3;
                }
                found = false;
                for (ALSExport this.exPtr2 : this.modPtr2.exList) {
                    if (!s1.equals(this.exPtr2.nodeName)) continue;
                    this.exPtr2.nodePtr = this.dummyNode;
                    found = true;
                    continue block0;
                }
            } while (found);
            System.out.println("ERROR: Unable to find node " + s1 + " in port list");
            return true;
        }
        return false;
    }

    private String getAString() {
        while (this.instPtr[this.iPtr] < 0 || this.instBuf[this.instPtr[this.iPtr]] == '#') {
            if (this.netlistStringPoint >= this.netlistStrings.length) {
                ++this.iPtr;
                return null;
            }
            String line = this.netlistStrings[this.netlistStringPoint++];
            this.fragmentLine(line);
            this.iPtr = 0;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = this.instPtr[this.iPtr];
        while (this.instBuf[i2] != '\u0000') {
            sb.append(this.instBuf[i2]);
            ++i2;
        }
        ++this.iPtr;
        return sb.toString();
    }

    private Integer getAnInt() {
        Object s1 = this.getAString();
        if (s1 == null) {
            return null;
        }
        if (((String)s1).startsWith("+") || ((String)s1).startsWith("-")) {
            String s2 = this.getAString();
            if (s2 == null) {
                return null;
            }
            s1 = (String)s1 + s2;
        }
        return TextUtils.atoi((String)s1);
    }

    private Double getADouble() {
        String s2;
        Object s1 = this.getAString();
        if (s1 == null) {
            return null;
        }
        if (((String)s1).startsWith("+") || ((String)s1).startsWith("-")) {
            s2 = this.getAString();
            if (s2 == null) {
                return null;
            }
            s1 = (String)s1 + s2;
        }
        if (!((String)s1).endsWith("E")) {
            return TextUtils.atof((String)s1);
        }
        s2 = this.getAString();
        if (s2 == null) {
            return null;
        }
        s1 = (String)s1 + s2;
        if (s2.startsWith("+") || s2.startsWith("-")) {
            String s3 = this.getAString();
            if (s3 == null) {
                return null;
            }
            s1 = (String)s1 + s3;
        }
        return TextUtils.atof((String)s1);
    }

    private String getAName() {
        String s1 = this.getAString();
        if (s1 == null) {
            return null;
        }
        String s2 = this.getAString();
        if (s2 == null || !s2.startsWith("[")) {
            --this.iPtr;
            return s1;
        }
        s1 = s2;
        do {
            if ((s2 = this.getAString()) == null) {
                return null;
            }
            s1 = s2;
        } while (!s2.startsWith("]"));
        return s1;
    }

    private void fragmentLine(String line) {
        int j2 = 0;
        int count = 0;
        this.instPtr[0] = 0;
        int k2 = 1;
        int i2 = 0;
        while (true) {
            int x;
            Object[] newBuf;
            int newSize;
            if (j2 > this.iBufSize - 3) {
                newSize = this.iBufSize * 5;
                newBuf = new char[newSize];
                for (x = 0; x < this.iBufSize; ++x) {
                    newBuf[x] = this.instBuf[x];
                }
                this.instBuf = newBuf;
                this.iBufSize = newSize;
            }
            if (k2 > this.iPtrSize - 2) {
                newSize = this.iPtrSize * 5;
                newBuf = new int[newSize];
                for (x = 0; x < this.iPtrSize; ++x) {
                    newBuf[x] = this.instPtr[x];
                }
                this.instPtr = newBuf;
                this.iPtrSize = newSize;
            }
            if (i2 >= line.length()) {
                if (count != 0) {
                    this.instBuf[j2] = '\u0000';
                    this.instPtr[k2] = -1;
                    break;
                }
                this.instPtr[k2 - 1] = -1;
                break;
            }
            char chr = line.charAt(i2);
            switch (chr) {
                case '\t': 
                case ' ': 
                case ',': 
                case ':': {
                    if (count == 0) break;
                    this.instBuf[j2] = '\u0000';
                    this.instPtr[k2] = j2 + 1;
                    ++j2;
                    ++k2;
                    count = 0;
                    break;
                }
                case '!': 
                case '#': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '@': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (count != 0) {
                        this.instBuf[j2] = '\u0000';
                        this.instBuf[j2 + 1] = chr;
                        this.instBuf[j2 + 2] = '\u0000';
                        this.instPtr[k2] = j2 + 1;
                        this.instPtr[k2 + 1] = j2 + 3;
                        j2 += 3;
                        k2 += 2;
                        count = 0;
                        break;
                    }
                    this.instBuf[j2] = chr;
                    this.instBuf[j2 + 1] = '\u0000';
                    this.instPtr[k2] = j2 + 2;
                    j2 += 2;
                    ++k2;
                    break;
                }
                default: {
                    this.instBuf[j2] = Character.toUpperCase(chr);
                    ++j2;
                    ++count;
                }
            }
            ++i2;
        }
    }

    static class Connect {
        String instName;
        String modelName;
        List<ALSExport> exList;
        Connect parent;
        Connect child;
        Connect next;

        Connect() {
        }
    }

    static class Link {
        Link left;
        Link right;
        Link up;
        Link down;
        Object ptr;
        char type;
        char operatr;
        Object state;
        int strength;
        int priority;
        double time;
        Model primHead;

        Link() {
        }
    }

    static class Node {
        Connect cellPtr;
        Signal<DigitalSample> sig;
        private int num = nSeq++;
        int sumState;
        int sumStrength;
        Object newState;
        int newStrength;
        boolean traceNode;
        List<Stat> statList;
        List<Load> pinList;
        double load;
        int visit;
        int arrive;
        int depart;
        double tLast;
        private static int nSeq = 1;

        Node() {
        }

        int getIndex() {
            return this.num;
        }
    }

    static class Row {
        List<Object> inList;
        List<Object> outList;
        double delta;
        double linear;
        double exp;
        double random;
        double abs;
        Row next;
        String delay;

        Row() {
        }
    }

    static class Stat {
        Model primPtr;
        Node nodePtr;
        int newState;
        int newStrength;
        char schedOp;
        Object schedState;
        int schedStrength;

        Stat() {
        }
    }

    static class Model {
        String name;
        char type;
        Object ptr;
        List<ALSExport> exList;
        List<IO> setList;
        List<Load> loadList;
        char fanOut;
        int priority;
        String level;

        Model(String name, char type) {
            this.name = name;
            this.type = type;
            this.ptr = null;
            this.exList = new ArrayList<ALSExport>();
            this.setList = new ArrayList<IO>();
            this.loadList = new ArrayList<Load>();
            this.fanOut = '\u0000';
            this.priority = 1;
        }
    }

    static class ALSExport {
        Object nodeName;
        Node nodePtr;

        ALSExport() {
        }
    }

    static class IO {
        Object nodePtr;
        char operatr;
        Object operand;
        int strength;

        IO() {
        }
    }

    static class Load {
        Object ptr;
        double load;

        Load() {
        }
    }

    static class Func {
        UserProc procPtr;
        List<ALSExport> inList;
        double delta;
        double linear;
        double exp;
        double abs;
        double random;
        Object userPtr;

        Func() {
        }
    }

    static class UserProc {
        protected ALS als;
        private static HashMap<String, UserProc> funcMap = new HashMap();
        private Node targetNode;
        private int biDirClock = 0;

        UserProc() {
        }

        void nameMe(ALS als, String name) {
            this.als = als;
            funcMap.put(name.toUpperCase(), this);
        }

        void simulate(Model primHead) {
        }

        static UserProc getFunctionAddress(String s1) {
            UserProc ret = funcMap.get(s1);
            if (ret == null) {
                System.out.println("ERROR: Unable to find user function " + s1 + " in library");
            }
            return ret;
        }

        protected void scheduleNodeUpdate(Model primHead, ALSExport exHead, int operator2, Object state, int strength, double time) {
            Stat statHead = (Stat)exHead.nodeName;
            if (statHead.schedOp == operator2 && statHead.schedState == state && statHead.schedStrength == strength) {
                return;
            }
            if (this.als.getSim().tracing) {
                String s2 = this.als.computeNodeName(statHead.nodePtr);
                System.out.println("      Schedule(F) gate " + statHead.primPtr.name + statHead.primPtr.level + ", net " + s2 + "  at " + TextUtils.convertToEngineeringNotation(time));
            }
            Link linkPtr2 = new Link();
            linkPtr2.type = (char)71;
            linkPtr2.ptr = statHead;
            linkPtr2.operatr = statHead.schedOp = (char)operator2;
            linkPtr2.state = statHead.schedState = state;
            linkPtr2.strength = statHead.schedStrength = strength;
            linkPtr2.priority = 1;
            linkPtr2.time = time;
            linkPtr2.primHead = primHead;
            this.als.getSim().insertLinkList(linkPtr2);
        }

        protected void calculateBidirOutputs(Model primHead, ALSExport[] side, int outStrength) {
            for (int i2 = 0; i2 < 2; ++i2) {
                ALSExport thisSide = side[i2];
                ALSExport otherSide = side[(i2 + 1) % 2];
                Node sumNode = thisSide.nodePtr;
                this.targetNode = otherSide.nodePtr;
                if (this.targetNode == this.als.driveNode) continue;
                int state = (Integer)sumNode.newState;
                int strength = sumNode.newStrength;
                ++this.biDirClock;
                for (Stat statHead : sumNode.statList) {
                    if (statHead.primPtr == primHead) continue;
                    sumNode.visit = this.biDirClock;
                    int thisStrength = statHead.newStrength;
                    int thisState = statHead.newState;
                    if (thisStrength > strength) {
                        state = thisState;
                        strength = thisStrength;
                        continue;
                    }
                    if (thisStrength != strength || thisState == state) continue;
                    state = 1;
                }
                if (strength > outStrength) {
                    strength = outStrength;
                }
                Func funcHead = (Func)primHead.ptr;
                double time = this.als.timeAbs + funcHead.delta * this.targetNode.load;
                this.scheduleNodeUpdate(primHead, otherSide, 61, state, strength, time);
            }
        }
    }

    public static class DoALSActivity
    extends Job {
        private Cell cell;
        private Cell originalCell;
        private boolean convert;
        private boolean compile;
        private boolean doNow;
        private transient Engine prevEngine;
        private List<Cell> textCellsToRedraw;
        private GenerateVHDL.VHDLPreferences vp = new GenerateVHDL.VHDLPreferences(false);

        public DoALSActivity(Cell cell, boolean convert, boolean compile, Cell originalCell, Engine prevEngine, SimulationTool tool, boolean doNow) {
            super("ALS Simulation", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.convert = convert;
            this.compile = compile;
            this.doNow = doNow;
            this.originalCell = originalCell;
            this.prevEngine = prevEngine;
            if (doNow) {
                try {
                    this.doIt();
                }
                catch (JobException jobException) {}
            } else {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            Library destLib = this.cell.getLibrary();
            this.textCellsToRedraw = new ArrayList<Cell>();
            if (!this.doNow) {
                this.fieldVariableChanged("textCellsToRedraw");
            }
            if (this.convert) {
                System.out.print("Generating VHDL from '" + String.valueOf(this.cell) + "' ...");
                List<String> vhdlStrings = GenerateVHDL.convertCell(this.cell, this.vp);
                if (vhdlStrings == null) {
                    throw new JobException("No VHDL produced");
                }
                String cellName = this.cell.getName() + "{vhdl}";
                Cell vhdlCell = this.cell.getLibrary().findNodeProto(cellName);
                if (vhdlCell == null && (vhdlCell = Cell.makeInstance(ep, this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[vhdlStrings.size()];
                for (int i2 = 0; i2 < vhdlStrings.size(); ++i2) {
                    array[i2] = vhdlStrings.get(i2);
                }
                vhdlCell.setTextViewContents(array, ep);
                this.textCellsToRedraw.add(vhdlCell);
                System.out.println(" Done, created " + String.valueOf(vhdlCell));
                this.cell = vhdlCell;
                if (!this.doNow) {
                    this.fieldVariableChanged("cell");
                }
            }
            if (this.compile) {
                List<String> netlistStrings;
                boolean vhdl = true;
                if (this.cell.getView() == View.VERILOG) {
                    vhdl = false;
                }
                System.out.print("Compiling " + (vhdl ? "VHDL" : "Verilog") + " in " + String.valueOf(this.cell) + " ...");
                if (vhdl) {
                    c = new CompileVHDL(this.cell);
                    if (((CompileVHDL)c).hasErrors()) {
                        throw new JobException("ERRORS during compilation, no netlist produced");
                    }
                    netlistStrings = ((CompileVHDL)c).getALSNetlist(destLib);
                } else {
                    c = new CompileVerilogStruct(this.cell, true);
                    if (((CompileVerilogStruct)c).hasErrors()) {
                        throw new JobException("ERRORS during compilation, no netlist produced");
                    }
                    netlistStrings = ((CompileVerilogStruct)c).getALSNetlist(destLib);
                }
                if (netlistStrings == null) {
                    throw new JobException("No netlist produced");
                }
                String cellName = this.cell.getName() + "{net.als}";
                Cell netlistCell = this.cell.getLibrary().findNodeProto(cellName);
                if (netlistCell == null && (netlistCell = Cell.makeInstance(ep, this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[netlistStrings.size()];
                for (int i3 = 0; i3 < netlistStrings.size(); ++i3) {
                    array[i3] = netlistStrings.get(i3);
                }
                netlistCell.setTextViewContents(array, ep);
                this.textCellsToRedraw.add(netlistCell);
                System.out.println(" Done, created " + String.valueOf(netlistCell));
                this.cell = netlistCell;
                if (!this.doNow) {
                    this.fieldVariableChanged("cell");
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            for (Cell cell : this.textCellsToRedraw) {
                TextWindow.updateText(cell);
            }
            if (this.prevEngine != null) {
                ALS.restartSimulation(this.cell, this.originalCell, (ALS)this.prevEngine, new Stimuli());
            } else {
                ALS.simulateNetlist(this.cell, this.originalCell, new Stimuli());
            }
        }
    }

    static class Trak {
        int state;
        double time;

        Trak() {
        }
    }
}

