/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Rsh;
import java.math.BigInteger;
import java.util.Map;

public class Vec4PartSelect<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> lsb;
    public final Svex<N> width;
    public final Svex<N> in;

    private Vec4PartSelect(Svex<N> lsb, Svex<N> width, Svex<N> in) {
        super(FUNCTION, lsb, width, in);
        this.lsb = lsb;
        this.width = width;
        this.in = in;
    }

    @Override
    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        int lv;
        Vec4 lval;
        if (this.lsb instanceof SvexQuote && (lval = ((SvexQuote)this.lsb).val).isVec2() && (lv = ((Vec2)lval).getVal().intValueExact()) >= 0) {
            SvexCall<N> svexRsh = sm.newCall(Vec4Rsh.FUNCTION, this.lsb, this.in.lhsPreproc(sm));
            return sm.newCall(Vec4Concat.FUNCTION, this.width, svexRsh, SvexQuote.valueOf(0));
        }
        return super.lhsPreproc(sm);
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_PARTSEL, 3, "4vec-part-select");
        }

        public <N extends SvarName> Vec4PartSelect<N> build(Svex<N>[] args) {
            return new Vec4PartSelect<N>(args[0], args[1], args[2]);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            Vec4 lsb = args[0];
            Vec4 width = args[1];
            Vec4 in = args[2];
            if (lsb.isVec2() && width.isVec2()) {
                int lsbVal = ((Vec2)lsb).getVal().intValueExact();
                int widthVal = ((Vec2)width).getVal().intValueExact();
                if (widthVal >= 0) {
                    BigInteger u = in.getUpper().shiftRight(lsbVal);
                    BigInteger l2 = in.getLower().shiftRight(lsbVal);
                    if (lsbVal < 0) {
                        BigInteger lsbMask = BigInteger.ONE.shiftRight(lsbVal).subtract(BigInteger.ONE);
                        u = u.or(lsbMask);
                        l2 = l2.or(lsbMask);
                    }
                    BigInteger mask = BigIntegerUtil.logheadMask(widthVal);
                    return Vec4.valueOf(u.and(mask), l2.and(mask));
                }
            }
            return Vec4.X;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            if (mask.signum() == 0) {
                return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO};
            }
            Svex<N> lsb = args[0];
            Svex<N> width = args[1];
            Vec4 lsbVal = lsb.xeval(xevalMemoize);
            Vec4 widthVal = width.xeval(xevalMemoize);
            if (!widthVal.isVec2()) {
                if (lsbVal.isVec2()) {
                    int lsbV = ((Vec2)lsbVal).getVal().intValueExact();
                    return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE, mask.shiftLeft(lsbV)};
                }
                return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE};
            }
            int widthV = ((Vec2)widthVal).getVal().intValueExact();
            if (widthV < 0) {
                return new BigInteger[]{BigInteger.ZERO, BigIntegerUtil.MINUS_ONE, BigInteger.ZERO};
            }
            if (!lsbVal.isVec2()) {
                if (BigIntegerUtil.loghead(widthV, mask).signum() == 0) {
                    return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE, BigInteger.ZERO};
                }
                return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE};
            }
            int lsbV = ((Vec2)lsbVal).getVal().intValueExact();
            BigInteger xMask = BigIntegerUtil.loghead(widthV, mask).shiftLeft(lsbV);
            return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE, xMask};
        }
    }
}

