/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public abstract class Vec4
implements ACL2Backed {
    private static final Map<Impl, Impl> INTERN = new HashMap<Impl, Impl>();
    public static final Vec4 X = Vec4.valueOf(BigInteger.valueOf(-1L), BigInteger.valueOf(0L));
    public static final Vec4 Z = Vec4.valueOf(BigInteger.valueOf(0L), BigInteger.valueOf(-1L));
    public static final Vec4 X1 = Vec4.valueOf(BigInteger.valueOf(1L), BigInteger.valueOf(0L));
    public static final Vec4 Z1 = Vec4.valueOf(BigInteger.valueOf(0L), BigInteger.valueOf(1L));
    public static final int BIT_LIMIT = 0x1000000;

    public abstract boolean isVec2();

    public abstract boolean isIndex();

    public abstract boolean isVec3();

    public abstract BigInteger getUpper();

    public abstract BigInteger getLower();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vec4 valueOf(BigInteger upper, BigInteger lower) {
        if (upper.equals(lower)) {
            return Vec2.valueOf(upper);
        }
        Impl key = new Impl(upper, lower);
        Map<Impl, Impl> map = INTERN;
        synchronized (map) {
            Impl result = INTERN.get(key);
            if (result == null) {
                result = key;
                INTERN.put(key, result);
            }
            return result;
        }
    }

    public static Vec4 fromACL2(ACL2Object impl) {
        if (ACL2.consp(impl).bool()) {
            BigInteger upper = ACL2.car(impl).bigIntegerValueExact();
            BigInteger lower = ACL2.cdr(impl).bigIntegerValueExact();
            return Vec4.valueOf(upper, lower);
        }
        Vec2 result = Vec2.valueOf(impl.bigIntegerValueExact());
        assert (((Object)result).hashCode() == impl.hashCode());
        return result;
    }

    public abstract Vec4 fix3();

    static class Impl
    extends Vec4 {
        private final BigInteger upper;
        private final BigInteger lower;
        private final int hashCode;

        Impl(BigInteger upper, BigInteger lower) {
            if (upper.equals(lower)) {
                throw new IllegalArgumentException();
            }
            this.upper = upper;
            this.lower = lower;
            this.hashCode = ACL2Object.hashCodeOfCons(upper.hashCode(), lower.hashCode());
        }

        @Override
        public boolean isVec2() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isVec3() {
            return this.lower.andNot(this.upper).signum() == 0;
        }

        @Override
        public BigInteger getUpper() {
            return this.upper;
        }

        @Override
        public BigInteger getLower() {
            return this.lower;
        }

        @Override
        public Vec4 fix3() {
            if (this.isVec3()) {
                return this;
            }
            return Impl.valueOf(this.upper.or(this.lower), this.upper.and(this.lower));
        }

        public boolean equals(Object o2) {
            if (o2 instanceof Impl) {
                Impl that = (Impl)o2;
                return this.upper.equals(that.upper) && this.lower.equals(that.lower);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public ACL2Object getACL2Object() {
            ACL2Object result = ACL2.hons(ACL2Object.valueOf(this.upper), ACL2Object.valueOf(this.lower));
            assert (result.hashCode() == this.hashCode());
            return result;
        }

        public String toString() {
            return "vec4[" + String.valueOf(this.upper) + "," + String.valueOf(this.lower) + "]";
        }
    }
}

