/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4SignExt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ZeroExt;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class SvexCall<N extends SvarName>
extends Svex<N> {
    public final SvexFunction fun;
    protected final Svex<N>[] args;
    private final int hashCode;
    private SvexManager owner;

    @SafeVarargs
    public static <N extends SvarName> SvexCall<N> newCall(SvexFunction fun, Svex<N> ... args) {
        return fun.build(args);
    }

    @SafeVarargs
    protected SvexCall(SvexFunction fun, Svex<N> ... args) {
        assert (fun.arity == args.length);
        this.fun = fun;
        for (Svex<N> arg : this.args = (Svex[])args.clone()) {
            if (arg != null) continue;
            throw new NullPointerException();
        }
        int hashCode = ACL2Object.HASH_CODE_NIL;
        for (int i2 = args.length - 1; i2 >= 0; --i2) {
            hashCode = ACL2Object.hashCodeOfCons(args[i2].hashCode(), hashCode);
        }
        this.hashCode = ACL2Object.hashCodeOfCons(fun.fn.hashCode(), hashCode);
    }

    void setOwner(SvexManager<N> owner) {
        assert (this.owner == null);
        this.owner = owner;
    }

    public Svex<N>[] getArgs() {
        return (Svex[])this.args.clone();
    }

    @Override
    public <N1 extends SvarName> Svex<N1> convertVars(Function<N, N1> rename, SvexManager<N1> sm, Map<Svex<N>, Svex<N1>> cache) {
        Svex<N1> svex = cache.get(this);
        if (svex == null) {
            Svex<N>[] newArgs = Svex.newSvexArray(this.fun.arity);
            for (int i2 = 0; i2 < this.fun.arity; ++i2) {
                newArgs[i2] = this.args[i2].convertVars(rename, sm, cache);
            }
            svex = sm.newCall(this.fun, newArgs);
            cache.put(this, svex);
        }
        return svex;
    }

    @Override
    public Svex<N> addDelay(int delay, SvexManager<N> sm, Map<Svex<N>, Svex<N>> cache) {
        Svex<N> svex = cache.get(this);
        if (svex == null) {
            Svex<N>[] newArgs = Svex.newSvexArray(this.fun.arity);
            for (int i2 = 0; i2 < this.fun.arity; ++i2) {
                newArgs[i2] = this.args[i2].addDelay(delay, sm, cache);
            }
            svex = sm.newCall(this.fun, newArgs);
            cache.put(this, svex);
        }
        return svex;
    }

    @Override
    protected void collectVarsRev(Set<Svar<N>> result, Set<SvexCall<N>> visited) {
        if (visited.add(this)) {
            for (Svex<N> arg : this.args) {
                arg.collectVarsRev(result, visited);
            }
        }
    }

    @Override
    public <R, D> R accept(Svex.Visitor<N, R, D> visitor, D data) {
        return visitor.visitCall(this.fun, this.args, data);
    }

    @Override
    <R> R traverse(Svex.TraverseVisitor<N, R> visitor, Map<Svex<N>, R> cache) {
        R result = cache.get(this);
        if (result == null && !cache.containsKey(this)) {
            R[] argVals = visitor.newVals(this.args.length);
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                argVals[i2] = this.args[i2].traverse(visitor, cache);
            }
            result = visitor.visitCall(this.fun, this.args, argVals);
            cache.put(this, result);
        }
        return result;
    }

    @Override
    public Vec4 xeval(Map<Svex<N>, Vec4> memoize) {
        Vec4 result = memoize.get(this);
        if (result == null) {
            result = this.fun.apply(Svex.listXeval(this.args, memoize));
            memoize.put(this, result);
        }
        return result;
    }

    @Override
    void toposort(Set<Svex<N>> downTop) {
        if (!downTop.contains(this)) {
            for (Svex<N> arg : this.args) {
                arg.toposort(downTop);
            }
            downTop.add(this);
        }
    }

    @Override
    public Svex<N> patch(Map<Svar<N>, Vec4> subst, SvexManager<N> sm, Map<SvexCall<N>, SvexCall<N>> memoize) {
        SvexCall<N> svex = memoize.get(this);
        if (svex == null) {
            Svex<N>[] newArgs = Svex.newSvexArray(this.args.length);
            boolean changed = false;
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                newArgs[i2] = this.args[i2].patch(subst, sm, memoize);
                changed = changed || newArgs[i2] != this.args[i2];
            }
            svex = changed ? sm.newCall(this.fun, newArgs) : this;
            memoize.put(this, svex);
        }
        return svex;
    }

    @Override
    public boolean isLhsUnbounded() {
        return false;
    }

    @Override
    public boolean isLhs() {
        return false;
    }

    @Override
    public Lhs<N> lhsBound(int w) {
        return new Lhs(Collections.emptyList());
    }

    @Override
    public Lhs<N> toLhs() {
        return new Lhs(Collections.emptyList());
    }

    @Override
    public Svex.MatchConcat<N> matchConcat() {
        return null;
    }

    @Override
    public Svex.MatchExt<N> matchExt() {
        Vec4 wval;
        Svex<N> width;
        if ((this.fun == Vec4ZeroExt.FUNCTION || this.fun == Vec4SignExt.FUNCTION) && (width = this.args[0]) instanceof SvexQuote && (wval = ((SvexQuote)width).val).isVec2() && ((Vec2)wval).getVal().signum() >= 0) {
            return new Svex.MatchExt<N>(((Vec2)wval).getVal().intValueExact(), this.args[1], this.fun == Vec4SignExt.FUNCTION);
        }
        return null;
    }

    @Override
    public Svex.MatchRsh<N> matchRsh() {
        return null;
    }

    @Override
    void multirefs(Set<SvexCall<N>> seen, Set<SvexCall<N>> multirefs) {
        if (seen.contains(this)) {
            multirefs.add(this);
            return;
        }
        seen.add(this);
        for (Svex<N> arg : this.args) {
            arg.multirefs(seen, multirefs);
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof SvexCall) {
            SvexCall that = (SvexCall)o2;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (this.owner != null && this.owner == that.owner) {
                return false;
            }
            if (!this.fun.equals(that.fun)) {
                return false;
            }
            return Arrays.equals(this.args, that.args);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ACL2Object getACL2Object(Map<ACL2Backed, ACL2Object> backedCache) {
        ACL2Object result = backedCache.get(this);
        if (result == null) {
            result = ACL2.NIL;
            for (int i2 = this.args.length - 1; i2 >= 0; --i2) {
                result = ACL2.hons(this.args[i2].getACL2Object(backedCache), result);
            }
            result = ACL2.hons(this.fun.fn, result);
            backedCache.put(this, result);
        }
        assert (result.hashCode() == this.hashCode);
        return result;
    }
}

