/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;

public class SvarImpl<N extends SvarName>
implements Svar<N> {
    private final N name;
    private final int delayImpl;
    private final int hashCode;

    SvarImpl(N name, int delayImpl) {
        this.name = name;
        this.delayImpl = delayImpl;
        this.hashCode = name.isSimpleSvarName() && delayImpl == 0 ? name.hashCode() : ACL2Object.hashCodeOfCons(KEYWORD_VAR.hashCode(), ACL2Object.hashCodeOfCons(name.hashCode(), ACL2Object.hashCodeOf(delayImpl)));
    }

    @Override
    public N getName() {
        return this.name;
    }

    @Override
    public ACL2Object getACL2Name() {
        return this.getName().getACL2Object();
    }

    @Override
    public int getDelay() {
        return this.delayImpl >= 0 ? this.delayImpl : ~this.delayImpl;
    }

    @Override
    public boolean isNonblocking() {
        return this.delayImpl < 0;
    }

    public static <N extends SvarName> Svar<N> fromACL2(SvarName.Builder<N> snb, SvexManager<N> sm, ACL2Object impl) {
        int delayImpl;
        ACL2Object nameImpl;
        if (ACL2.consp(impl).bool()) {
            Util.check(ACL2.car(impl).equals(KEYWORD_VAR));
            nameImpl = ACL2.car(ACL2.cdr(impl));
            delayImpl = ACL2.cdr(ACL2.cdr(impl)).intValueExact();
        } else {
            nameImpl = impl;
            delayImpl = 0;
        }
        N name = snb.fromACL2(nameImpl);
        boolean isNonblocking = delayImpl < 0;
        int delay = isNonblocking ? ~delayImpl : delayImpl;
        return sm.getVar(name, delay, isNonblocking);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof SvarImpl) {
            SvarImpl that = (SvarImpl)o2;
            return this.hashCode == that.hashCode && this.name.equals(that.name) && this.delayImpl == that.delayImpl;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ACL2Object getACL2Object() {
        if (this.name.isSimpleSvarName() && this.delayImpl == 0) {
            return this.name.getACL2Object();
        }
        return ACL2.hons(KEYWORD_VAR, ACL2.hons(this.name.getACL2Object(), ACL2Object.valueOf(this.delayImpl)));
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(BigInteger mask) {
        Object s;
        Object object = s = mask != null ? this.name.toString(mask) : this.name.toString();
        if (this.isNonblocking()) {
            s = "#?" + this.getDelay() + " " + (String)s;
        } else if (this.getDelay() != 0) {
            s = "#" + this.getDelay() + " " + (String)s;
        }
        return s;
    }
}

