/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.modsext.DriverExt;
import com.sun.electric.tool.simulation.acl2.modsext.ModExport;
import com.sun.electric.tool.simulation.acl2.modsext.ModInstExt;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.WireExt;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PathExt
implements SvarName {
    final Path b;
    final ModuleExt parent;
    final int width;
    private final Bit[] bits;
    final Bit[] parentBits;
    Lhs<PathExt> namedLhs;

    PathExt(ModuleExt parent, Path b2, int width) {
        this.b = b2;
        this.parent = parent;
        this.width = width;
        this.bits = new Bit[width];
        this.parentBits = new Bit[width];
        for (int bit = 0; bit < width; ++bit) {
            this.parentBits[bit] = this.bits[bit] = new Bit(bit);
        }
        Lhrange<PathExt> range = new Lhrange<PathExt>(width, Lhatom.valueOf(parent.sm.getVar(this)));
        this.namedLhs = new Lhs(Collections.singletonList(range));
    }

    @Override
    public boolean isSimpleSvarName() {
        return this.b.isSimpleSvarName();
    }

    public String showFinePortDeps(Map<Object, Set<Object>> graph0, Map<Object, Set<Object>> graph1) {
        return this.parent.showFinePortDeps(this.bits, graph0, graph1);
    }

    List<Map<Svar<PathExt>, BigInteger>> gatherFineBitDeps(BitSet stateDeps, Map<Object, Set<Object>> graph) {
        return this.parent.gatherFineBitDeps(stateDeps, this.bits, graph);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    public ACL2Object getACL2Object() {
        ACL2Object result = this.b.getACL2Object();
        assert (result.hashCode() == this.hashCode());
        return this.b.getACL2Object();
    }

    public String toString() {
        return this.toString(BigIntegerUtil.logheadMask(this.getWidth()));
    }

    public abstract WireExt getWire();

    abstract int getIndexInParent();

    public final int getWidth() {
        return this.width;
    }

    public Svar<PathExt> getVar(int delay) {
        return this.parent.sm.getVar(this, delay, false);
    }

    public Bit getBit(int bit) {
        return this.bits[bit];
    }

    Bit getParentBit(int bit) {
        return this.parentBits[bit];
    }

    public class Bit {
        final int bit;

        private Bit(int bit) {
            this.bit = bit;
        }

        public PathExt getPath() {
            return PathExt.this;
        }

        public String toString() {
            return PathExt.this.toString(BigInteger.ONE.shiftLeft(this.bit));
        }

        public boolean equals(Object o2) {
            if (o2 instanceof Bit) {
                Bit that = (Bit)o2;
                return this.getPath().equals(that.getPath()) && this.bit == that.bit;
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + this.getPath().hashCode();
            hash = 29 * hash + this.bit;
            return hash;
        }
    }

    public static class PortInst
    extends PathExt {
        public final ModExport proto;
        public final WireExt wire;
        public final ModInstExt inst;
        Lhs<PathExt> source;
        Object driver;
        public boolean splitIt;

        PortInst(ModInstExt inst, Path.Scope path, ModExport export) {
            super(inst.parent, path, export.wire.getWidth());
            this.proto = export;
            this.wire = export.wire;
            this.inst = inst;
            assert (inst.proto == this.wire.parent);
        }

        @Override
        public WireExt getWire() {
            return this.wire;
        }

        @Override
        int getIndexInParent() {
            return this.inst.elabModInst.wireOffset + this.proto.index;
        }

        public boolean isInput() {
            return this.proto.isInput();
        }

        public boolean isOutput() {
            return this.proto.isOutput();
        }

        public Name getProtoName() {
            return this.wire.getName();
        }

        Bit getProtoBit(int bit) {
            return this.wire.getBit(bit);
        }

        void setSource(Lhs<PathExt> source) {
            Util.check(this.driver == null);
            Util.check(this.source == null);
            this.source = source;
            this.setLhs(source);
        }

        void setDriver(DriverExt driver) {
            Util.check(this.source == null);
            Util.check(this.driver == null);
            this.driver = driver;
            for (int bit = 0; bit < this.getWidth(); ++bit) {
                assert (this.parentBits[bit] == this.getBit(bit));
            }
        }

        void setDriver(Lhs<PathExt> driver) {
            Util.check(this.source == null);
            Util.check(this.driver == null);
            this.driver = driver;
            this.setLhs(driver);
        }

        private void setLhs(Lhs<PathExt> lhs) {
            Util.check(lhs.width() == this.getWidth());
            int lsh = 0;
            for (Lhrange range : lhs.ranges) {
                Svar svar = range.getVar();
                Util.check(svar.getDelay() == 0);
                WireExt lw = (WireExt)svar.getName();
                for (int i2 = 0; i2 < range.getWidth(); ++i2) {
                    this.parentBits[lsh + i2] = lw.getBit(range.getRsh() + i2);
                }
                lsh += range.getWidth();
            }
            assert (lsh == this.getWidth());
            this.namedLhs = lhs;
        }

        DriverExt getDriverExt() {
            assert (this.driver instanceof DriverExt);
            return (DriverExt)this.driver;
        }

        Lhs<PathExt> getDriverLhs() {
            assert (this.driver instanceof Lhs);
            return (Lhs)this.driver;
        }

        @Override
        public String toString(BigInteger mask) {
            return String.valueOf(this.inst.getInstname()) + "." + this.wire.toString(mask);
        }
    }
}

