/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Aliaspair;
import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.ElabMod;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.ModDb;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.mods.Wire;
import com.sun.electric.tool.simulation.acl2.modsext.Compile;
import com.sun.electric.tool.simulation.acl2.modsext.DesignExt;
import com.sun.electric.tool.simulation.acl2.modsext.DriverExt;
import com.sun.electric.tool.simulation.acl2.modsext.ModExport;
import com.sun.electric.tool.simulation.acl2.modsext.ModInstExt;
import com.sun.electric.tool.simulation.acl2.modsext.ParameterizedModule;
import com.sun.electric.tool.simulation.acl2.modsext.PathExt;
import com.sun.electric.tool.simulation.acl2.modsext.SymbolicDriver;
import com.sun.electric.tool.simulation.acl2.modsext.WireExt;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Res;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public class ModuleExt
implements Comparator<Svar<PathExt>> {
    static final String STATE = "STATE";
    public final DesignExt design;
    public final ModName modName;
    public final Module<Address> b;
    public final ParameterizedModule parMod;
    public final List<WireExt> wires = new ArrayList<WireExt>();
    public final List<ModInstExt> insts = new ArrayList<ModInstExt>();
    public final Map<Lhs<PathExt>, DriverExt> assigns = new LinkedHashMap<Lhs<PathExt>, DriverExt>();
    public final Map<Lhs<PathExt>, Lhs<PathExt>> aliaspairs = new LinkedHashMap<Lhs<PathExt>, Lhs<PathExt>>();
    final Map<Name, WireExt> wiresIndex = new HashMap<Name, WireExt>();
    final Map<Name, ModInstExt> instsIndex = new HashMap<Name, ModInstExt>();
    public final SvexManager<PathExt> sm = new SvexManager();
    final ElabMod elabMod;
    final List<ModExport> exports = new ArrayList<ModExport>();
    int useCount;
    boolean isTop;
    final boolean hasSvtvState;
    boolean hasPhaseState;
    boolean hasCycleState;
    final Set<WireExt> stateWires = new LinkedHashSet<WireExt>();
    final Map<Svar<PathExt>, BigInteger> stateVars0 = new LinkedHashMap<Svar<PathExt>, BigInteger>();
    final Map<Svar<PathExt>, BigInteger> stateVars1 = new LinkedHashMap<Svar<PathExt>, BigInteger>();
    final Function<Address, PathExt> rename = new Function<Address, PathExt>(){

        @Override
        public PathExt apply(Address address) {
            assert (address.index == -1);
            assert (address.scope == 0);
            Path path = address.path;
            if (path instanceof Path.Wire) {
                Path.Wire pw = (Path.Wire)path;
                WireExt wire = ModuleExt.this.wiresIndex.get(pw.name);
                assert (wire != null);
                return wire;
            }
            Path.Scope ps = (Path.Scope)path;
            ModInstExt inst = ModuleExt.this.instsIndex.get(ps.namespace);
            assert (inst != null);
            return inst.newPortInst(ps);
        }
    };

    /*
     * WARNING - void declaration
     */
    ModuleExt(DesignExt design, ModName modName) {
        Lhs<PathExt> lhs;
        this.design = design;
        this.modName = modName;
        this.b = design.b.modalist.get(modName);
        this.elabMod = design.moddb.modnameGetIndex(modName);
        for (Wire wire : this.b.wires) {
            WireExt w = new WireExt(this, wire, this.wires.size());
            this.wires.add(w);
            WireExt old = this.wiresIndex.put(w.getName(), w);
            Util.check(old == null);
        }
        boolean hasSvtvState = false;
        for (ModInst modInst : this.b.insts) {
            Iterator mi = new ModInstExt(this, modInst, this.insts.size(), design.downTop);
            this.insts.add((ModInstExt)((Object)mi));
            ModInstExt modInstExt = (ModInstExt)((Object)this.instsIndex.put(((ModInstExt)((Object)mi)).getInstname(), (ModInstExt)((Object)mi)));
            Util.check(modInstExt == null);
            if (!((ModInstExt)((Object)mi)).proto.hasSvtvState) continue;
            hasSvtvState = true;
        }
        HashMap hashMap = new HashMap();
        int driverCount = 0;
        for (Assign assign : this.b.assigns) {
            Driver<PathExt> driver;
            DriverExt drv;
            lhs = assign.lhs.convertVars(this.rename, this.sm);
            DriverExt old = this.assigns.put(lhs, drv = new DriverExt(this, driver = assign.driver.convertVars(this.rename, this.sm, hashMap), "dr" + driverCount++));
            Util.check(old == null);
            int lsh = 0;
            for (Lhrange<PathExt> lhrange : lhs.ranges) {
                Svar svar = lhrange.getVar();
                if (svar.getName() instanceof WireExt) {
                    ((WireExt)svar.getName()).addDriver(lhrange, lsh, drv);
                } else {
                    assert (lhs.ranges.size() == 1 && lhrange.getRsh() == 0 && lsh == 0);
                    ((PathExt.PortInst)svar.getName()).setDriver(drv);
                }
                lsh += lhrange.getWidth();
            }
            ModuleExt.markAssigned(lhs, BigIntegerUtil.MINUS_ONE);
            drv.setSource(lhs);
            drv.markUsed();
            for (Svar svar : drv.getOrigVars()) {
                if (svar.getDelay() == 0) continue;
                Util.check(svar.getDelay() == 1);
                WireExt lw = (WireExt)svar.getName();
                this.stateWires.add(lw);
            }
        }
        this.hasSvtvState = hasSvtvState || !this.stateWires.isEmpty();
        for (Aliaspair aliaspair : this.b.aliaspairs) {
            lhs = aliaspair.lhs.convertVars(this.rename, this.sm);
            Lhs<PathExt> rhs = aliaspair.rhs.convertVars(this.rename, this.sm);
            Util.check(lhs.ranges.size() == 1);
            Lhrange<PathExt> lhsRange = lhs.ranges.get(0);
            Util.check(lhsRange.getRsh() == 0);
            Svar lhsVar = lhsRange.getVar();
            Util.check(lhsVar.getDelay() == 0 && !lhsVar.isNonblocking());
            Lhs<PathExt> old = this.aliaspairs.put(lhs, rhs);
            Util.check(old == null);
            Util.check(lhs.width() == rhs.width());
            if (lhsVar.getName() instanceof PathExt.PortInst) {
                PathExt.PortInst pi = (PathExt.PortInst)lhsVar.getName();
                Util.check(lhsRange.getWidth() == pi.getWidth());
                boolean bl = false;
                for (Lhrange lhrange : rhs.ranges) {
                    Svar rhsVar = lhrange.getVar();
                    Util.check(rhsVar.getName() instanceof WireExt);
                    WireExt lw = (WireExt)rhsVar.getName();
                    if (pi.isOutput()) {
                        void var14_29;
                        lw.addDriver(lhrange, (int)var14_29, pi);
                    }
                    var14_29 += lhrange.getWidth();
                }
                if (pi.isOutput()) {
                    pi.setSource(rhs);
                    BigInteger assignedBits = pi.wire.getAssignedBits();
                    Util.check(assignedBits.equals(BigIntegerUtil.logheadMask(pi.getWidth())));
                    ModuleExt.markAssigned(rhs, assignedBits);
                } else {
                    pi.setDriver(rhs);
                }
                if (!pi.wire.used) continue;
                for (Lhrange lhrange : rhs.ranges) {
                    Svar name = lhrange.getVar();
                    if (name == null) continue;
                    Util.check(name.getName() instanceof WireExt);
                    ((WireExt)name.getName()).markUsed();
                }
                continue;
            }
            WireExt lw = (WireExt)lhsVar.getName();
            if (lw.getName().isString()) {
                Util.check(rhs.ranges.size() == 1);
                PathExt.PortInst portInst = (PathExt.PortInst)rhs.ranges.get(0).getVar().getName();
                Util.check(portInst.inst.getModname().isCoretype());
                portInst.setDriver(lhs);
                continue;
            }
            if (lw.getName().isInteger()) {
                WireExt rhsLw;
                Util.check(modName.isCoretype());
                Util.check(rhs.ranges.size() == 1);
                Lhrange lhrange = rhs.ranges.get(0);
                WireExt wireExt = rhsLw = (WireExt)lhrange.getVar().getName();
                assert (wireExt != null);
                assert (wireExt.index < lw.index);
                assert (lhsRange.getRsh() == 0);
                lw.addDriver(lhsRange, lhrange.getRsh(), wireExt);
                continue;
            }
            Util.check(false);
        }
        ParameterizedModule parMod = null;
        for (ParameterizedModule parModule : design.paremterizedModules) {
            if (!parModule.setCurBuilder(modName, this.b.sm)) continue;
            assert (parMod == null);
            parMod = parModule;
            Module<Address> genM = parModule.genModule();
            if (genM == null) {
                System.out.println("Module specializition is unfamiliar " + String.valueOf(modName));
                continue;
            }
            if (!genM.equals(this.b)) {
                System.out.println("Module mismatch " + String.valueOf(modName));
                continue;
            }
            Util.check(parModule.getNumInsts() == this.elabMod.modNInsts());
            Util.check(parModule.getNumAssigns() == this.elabMod.modNAssigns());
            Util.check(parModule.getTotalInsts() == this.elabMod.modTotalInsts());
            Util.check(parModule.getTotalAssigns() == this.elabMod.modTotalAssigns());
        }
        this.parMod = parMod;
    }

    public static void markAssigned(Lhs<PathExt> lhs, BigInteger assignedBits) {
        for (Lhrange lr : lhs.ranges) {
            Svar name = lr.getVar();
            if (name != null) {
                BigInteger assignedBitsRange = BigIntegerUtil.loghead(lr.getWidth(), assignedBits);
                int rsh = lr.getRsh();
                assignedBitsRange = assignedBitsRange.shiftLeft(rsh);
                if (name.getName() instanceof WireExt) {
                    WireExt lw = (WireExt)name.getName();
                    lw.markAssigned(assignedBitsRange);
                } else {
                    Util.check(lhs.ranges.size() == 1);
                    Util.check(lr.getRsh() == 0);
                    PathExt.PortInst pi = (PathExt.PortInst)name.getName();
                    Util.check(assignedBitsRange.signum() >= 0 && assignedBitsRange.bitLength() <= pi.getWidth());
                    Util.check(pi.isInput());
                }
            }
            assignedBits = assignedBits.shiftRight(lr.getWidth());
        }
    }

    void markTop(String[] exportNames) {
        this.isTop = true;
        this.useCount = 1;
        List<String> exportList = null;
        if (exportNames != null) {
            exportList = Arrays.asList(exportNames);
        }
        int numExported = 0;
        for (WireExt w : this.wires) {
            if (exportList != null && exportList.indexOf(w.getName().toString()) < 0) continue;
            ModExport export = this.makeExport(w);
            ++numExported;
            if (w.getWidth() != 1 || w.getLowIdx() != 0) continue;
            export.global = w.getName().toString();
        }
        Util.check(numExported == (exportNames != null ? exportNames.length : this.wires.size()));
    }

    void markDown(Map<String, Integer> globalCounts) {
        for (ModInstExt modInstExt : this.insts) {
            modInstExt.proto.useCount += this.useCount;
        }
        for (Map.Entry entry : this.aliaspairs.entrySet()) {
            Svar svar1;
            WireExt w;
            ModExport export;
            Svar svar;
            Lhs lhs = (Lhs)entry.getKey();
            Lhs rhs = (Lhs)entry.getValue();
            if (rhs.ranges.size() != 1 || rhs.ranges.get(0).getWidth() != 1 || rhs.ranges.get(0).getVar() == null || rhs.ranges.get(0).getRsh() != 0 || !((svar = rhs.ranges.get(0).getVar()).getName() instanceof WireExt) || (export = (w = (WireExt)svar.getName()).getExport()) == null || !export.isGlobal() || lhs.ranges.size() != 1 || lhs.ranges.get(0).getWidth() != 1 || lhs.ranges.get(0).getVar() == null || rhs.ranges.get(0).getRsh() != 0 || !((svar1 = lhs.ranges.get(0).getVar()).getName() instanceof PathExt.PortInst)) continue;
            ((PathExt.PortInst)svar1.getName()).proto.markGlobal(export.global);
        }
        for (ModExport modExport : this.exports) {
            if (!modExport.isGlobal()) continue;
            Integer count = globalCounts.get(modExport.global);
            globalCounts.put(modExport.global, count == null ? 1 : count + 1);
        }
    }

    ModExport makeExport(WireExt wire) {
        assert (wire.parent == this && this.wires.get(wire.index) == wire);
        while (this.exports.size() <= wire.index) {
            this.exports.add(null);
        }
        ModExport export = this.exports.get(wire.index);
        if (export == null) {
            wire.exported = export = new ModExport(wire);
            this.exports.set(wire.index, export);
        }
        return export;
    }

    void checkExports() {
        boolean prevIsExport = true;
        for (WireExt wire : this.wires) {
            if (wire.isExport()) {
                if (prevIsExport) continue;
                System.out.println("Module " + String.valueOf(this.modName) + " export " + String.valueOf(wire) + " is not at the beginning");
                Util.check(false);
                prevIsExport = true;
                continue;
            }
            prevIsExport = false;
        }
        for (ModExport export : this.exports) {
            Util.check(export != null);
        }
        for (ModInstExt inst : this.insts) {
            inst.checkExports();
        }
    }

    public Svar<IndexName> absindexed(Svar<PathExt> x, SvexManager<IndexName> sm) {
        PathExt i2 = x.getName();
        int index = i2.getIndexInParent();
        return sm.getVar(IndexName.valueOf(index), x.getDelay(), x.isNonblocking());
    }

    public Svex<IndexName> absindexed(Svex<PathExt> x, SvexManager<IndexName> sm, Map<Svex<PathExt>, Svex<IndexName>> svexCache) {
        Svex<IndexName> result = svexCache.get(x);
        if (result == null) {
            if (x instanceof SvexVar) {
                SvexVar xv = (SvexVar)x;
                Svar<IndexName> name = this.absindexed(xv.svar, sm);
                result = new SvexVar<IndexName>(name);
            } else if (x instanceof SvexQuote) {
                result = SvexQuote.valueOf(((SvexQuote)x).val);
            } else {
                SvexCall sc = (SvexCall)x;
                Svex<N>[] args = sc.getArgs();
                Svex<N>[] newArgs = Svex.newSvexArray(args.length);
                for (int i2 = 0; i2 < args.length; ++i2) {
                    newArgs[i2] = this.absindexed(args[i2], sm, svexCache);
                }
                result = sm.newCall(sc.fun, newArgs);
            }
            svexCache.put(x, result);
        }
        return result;
    }

    private PathExt findPathExtByIndex(int i2) {
        if (i2 < this.wires.size()) {
            return this.wires.get(i2);
        }
        int instIndex = this.elabMod.wireFindInst(i2);
        ModInstExt inst = this.insts.get(instIndex);
        return inst.portInsts.get(i2 - this.elabMod.getInst((int)instIndex).wireOffset);
    }

    private Svar<PathExt> indexedToNamedExt(Svar<IndexName> var) {
        int idx = var.getName().getIndex();
        PathExt name = this.findPathExtByIndex(idx);
        return this.sm.getVar(name);
    }

    public Lhs<PathExt> indexedToNamedExt(Lhs<IndexName> lhs) {
        ArrayList newRanges = new ArrayList();
        for (Lhrange range : lhs.ranges) {
            Svar<IndexName> svar = range.getVar();
            Lhatom<Object> newAtom = svar == null ? Lhatom.Z() : Lhatom.valueOf(this.indexedToNamedExt(svar), range.getRsh());
            newRanges.add(new Lhrange(range.getWidth(), newAtom));
        }
        return new Lhs<PathExt>(newRanges);
    }

    private Lhs<IndexName> flattenLhs(Lhs<PathExt> lhs, int offset, List<Lhs<IndexName>> portMap, SvexManager<IndexName> sm) {
        LinkedList newRanges = new LinkedList();
        for (Lhrange range : lhs.ranges) {
            Lhs<IndexName> portLhs;
            int wid = range.getWidth();
            int rsh = range.getRsh();
            Svar svar = range.getVar();
            assert (svar.getDelay() == 0 && !svar.isNonblocking());
            int index = ((PathExt)svar.getName()).getIndexInParent();
            Lhs<IndexName> lhs2 = portLhs = index < portMap.size() ? portMap.get(index) : null;
            if (portLhs != null) {
                for (Lhrange portRange : portLhs.ranges) {
                    assert (wid > 0);
                    int portWid = portRange.getWidth();
                    if (portWid > rsh) {
                        Svar portSvar = portRange.getVar();
                        int w = Math.min(portWid - rsh, wid);
                        Lhrange newRange = rsh == 0 && w == portWid ? portRange : new Lhrange(w, Lhatom.valueOf(portSvar, portRange.getRsh() + rsh));
                        newRanges.add(newRange);
                        rsh = 0;
                        if ((wid -= w) > 0) continue;
                        break;
                    }
                    rsh -= portWid;
                }
                assert (rsh == 0 && wid == 0);
                continue;
            }
            IndexName name = IndexName.valueOf(offset + index);
            Svar<IndexName> newSvar = sm.getVar(name);
            newRanges.add(new Lhrange<IndexName>(wid, Lhatom.valueOf(newSvar, rsh)));
        }
        return new Lhs(newRanges).norm();
    }

    private void makeAliases(List<Lhs<IndexName>> portMap, List<Lhs<IndexName>> arr, SvexManager<IndexName> sm, boolean useParMods) {
        int wireOffset = arr.size();
        for (WireExt wire : this.wires) {
            arr.add(this.flattenLhs(wire.namedLhs, wireOffset, portMap, sm));
        }
        for (ModInstExt inst : this.insts) {
            LinkedList<Lhs<IndexName>> newPortMap = new LinkedList<Lhs<IndexName>>();
            for (PathExt.PortInst pi : inst.portInsts) {
                Lhs<IndexName> newLhs = this.flattenLhs(pi.namedLhs, wireOffset, portMap, sm);
                newPortMap.add(newLhs);
            }
            inst.proto.makeAliases(newPortMap, arr, sm, useParMods);
        }
    }

    private void testAliases(ModDb.FlattenResult flattenResult) {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ArrayList<Lhs<IndexName>> arr = new ArrayList<Lhs<IndexName>>();
        ArrayList<Lhs<IndexName>> topPortMap = new ArrayList<Lhs<IndexName>>();
        for (ModExport export : this.exports) {
            Lhs<IndexName> lhs = this.flattenLhs(export.wire.namedLhs, 0, Collections.emptyList(), flattenResult.sm);
            assert (lhs.ranges.size() == 1 && ((IndexName)lhs.ranges.get(0).getVar().getName()).getIndex() == export.index);
            topPortMap.add(lhs);
        }
        this.makeAliases(topPortMap, arr, flattenResult.sm, true);
        Util.check(flattenResult.aliases.size() == arr.size());
        for (int i2 = 0; i2 < arr.size(); ++i2) {
            Lhs<IndexName> flatLhs = flattenResult.aliases.getAlias(i2);
            Lhs hierLhs = (Lhs)arr.get(i2);
            Util.check(flatLhs.equals(hierLhs));
            Util.check(flatLhs.getACL2Object(backedCache).equals(hierLhs.getACL2Object(backedCache)));
        }
    }

    private void makeNormAssignsSymbolic(int wireOffset, int assignOffset, List<Lhs<IndexName>> portMap, Map<Lhs<IndexName>, SymbolicDriver<IndexName>> normAssigns, SvexManager<IndexName> sm) {
        int assignI = 0;
        for (Map.Entry<Lhs<PathExt>, DriverExt> e2 : this.assigns.entrySet()) {
            Lhs<PathExt> lhs = e2.getKey();
            DriverExt drv = e2.getValue();
            Lhs<IndexName> newLhs = this.flattenLhs(lhs, wireOffset, portMap, sm);
            List<Svar<PathExt>> drvVars = drv.getOrigVars();
            Lhs<N>[] args = Lhs.newLhsArray(drvVars.size());
            for (int i2 = 0; i2 < drvVars.size(); ++i2) {
                Svar<PathExt> svar = drvVars.get(i2);
                PathExt pathExt = svar.getName();
                args[i2] = this.flattenLhs(pathExt.namedLhs, wireOffset, portMap, sm);
            }
            SymbolicDriver sDrv = new SymbolicDriver(drv, assignOffset + assignI, args, 0, drv.getWidth(), 0);
            normAssigns.put(newLhs, sDrv);
            ++assignI;
        }
        for (ModInstExt inst : this.insts) {
            LinkedList<Lhs<IndexName>> newPortMap = new LinkedList<Lhs<IndexName>>();
            for (PathExt.PortInst pi : inst.portInsts) {
                Lhs<IndexName> newLhs = this.flattenLhs(pi.namedLhs, wireOffset, portMap, sm);
                newPortMap.add(newLhs);
            }
            inst.proto.makeNormAssignsSymbolic(wireOffset + inst.elabModInst.wireOffset, assignOffset + inst.elabModInst.assignOffset, newPortMap, normAssigns, sm);
        }
    }

    private void testNormAssigns(Compile<IndexName> compile, SvexManager<IndexName> sm) {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        LinkedHashMap<Lhs<IndexName>, SymbolicDriver<IndexName>> normAssignsSym = new LinkedHashMap<Lhs<IndexName>, SymbolicDriver<IndexName>>();
        this.makeNormAssignsSymbolic(0, 0, Collections.emptyList(), normAssignsSym, sm);
        Util.check(normAssignsSym.size() == compile.normAssigns.size());
        Iterator iter1 = normAssignsSym.entrySet().iterator();
        Iterator iter2 = compile.normAssigns.iterator();
        while (iter1.hasNext() || iter2.hasNext()) {
            Map.Entry e1 = iter1.next();
            Lhs lhs1 = (Lhs)e1.getKey();
            SymbolicDriver sDrv1 = (SymbolicDriver)e1.getValue();
            Assign e2 = iter2.next();
            Lhs lhs2 = e2.lhs;
            Driver drv2 = e2.driver;
            Util.check(lhs1.getACL2Object(backedCache).equals(lhs2.getACL2Object(backedCache)));
            Driver<IndexName> drv1 = sDrv1.makeWideDriver(sm);
            Util.check(drv1.getACL2Object(backedCache).equals(drv2.getACL2Object(backedCache)));
        }
        assert (!iter1.hasNext() && !iter2.hasNext());
    }

    private void assignsToNetassigns(int wireOffset, int assignOffset, List<Lhs<IndexName>> portMap, Map<Lhs<IndexName>, SymbolicDriver<IndexName>> symNormAssignsRev, Map<Svar<IndexName>, List<SymbolicDriver<IndexName>>> symNetassignsRev, SvexManager<IndexName> sm) {
        for (int i2 = this.insts.size() - 1; i2 >= 0; --i2) {
            ModInstExt inst = this.insts.get(i2);
            LinkedList<Lhs<IndexName>> newPortMap = new LinkedList<Lhs<IndexName>>();
            for (PathExt.PortInst pi : inst.portInsts) {
                Lhs<IndexName> newLhs = this.flattenLhs(pi.namedLhs, wireOffset, portMap, sm);
                newPortMap.add(newLhs);
            }
            inst.proto.assignsToNetassigns(wireOffset + inst.elabModInst.wireOffset, assignOffset + inst.elabModInst.assignOffset, newPortMap, symNormAssignsRev, symNetassignsRev, sm);
        }
        ArrayList<Map.Entry<Lhs<PathExt>, DriverExt>> localAssignsEntries = new ArrayList<Map.Entry<Lhs<PathExt>, DriverExt>>(this.assigns.entrySet());
        for (int assignI = localAssignsEntries.size() - 1; assignI >= 0; --assignI) {
            Map.Entry e2 = (Map.Entry)localAssignsEntries.get(assignI);
            Lhs oldLhs = (Lhs)e2.getKey();
            DriverExt oldDrv = (DriverExt)e2.getValue();
            Lhs<IndexName> lhs = this.flattenLhs(oldLhs, wireOffset, portMap, sm);
            List<Svar<PathExt>> drvVars = oldDrv.getOrigVars();
            Lhs<N>[] args = Lhs.newLhsArray(drvVars.size());
            for (int j2 = 0; j2 < drvVars.size(); ++j2) {
                Svar<PathExt> svar = drvVars.get(j2);
                PathExt pathExt = svar.getName();
                args[j2] = this.flattenLhs(pathExt.namedLhs, wireOffset, portMap, sm);
            }
            assert (lhs.isNormp());
            SymbolicDriver sDrv = new SymbolicDriver(oldDrv, assignOffset + assignI, args, 0, lhs.width(), 0);
            symNormAssignsRev.put(lhs, sDrv);
            int offset = lhs.width();
            for (int j3 = lhs.ranges.size() - 1; j3 >= 0; --j3) {
                Lhrange range = lhs.ranges.get(j3);
                offset -= range.getWidth();
                Svar svar = range.getVar();
                if (svar == null) continue;
                sDrv = new SymbolicDriver(oldDrv, assignOffset + assignI, args, range.getRsh(), range.getWidth(), offset);
                List<SymbolicDriver<IndexName>> sDrivers = symNetassignsRev.get(svar);
                if (sDrivers == null) {
                    sDrivers = new LinkedList<SymbolicDriver<IndexName>>();
                    symNetassignsRev.put(svar, sDrivers);
                }
                sDrivers.add(sDrv);
            }
        }
    }

    private void testAssignsToNetassigns(Compile<IndexName> compile, SvexManager<IndexName> sm) {
        LinkedHashMap<Lhs<IndexName>, SymbolicDriver<IndexName>> symNormAssignsRev = new LinkedHashMap<Lhs<IndexName>, SymbolicDriver<IndexName>>();
        LinkedHashMap<Svar<IndexName>, List<SymbolicDriver<IndexName>>> symNetassignsRev = new LinkedHashMap<Svar<IndexName>, List<SymbolicDriver<IndexName>>>();
        this.assignsToNetassigns(0, 0, Collections.emptyList(), symNormAssignsRev, symNetassignsRev, sm);
        ArrayList symNormAssignsEntries = new ArrayList(symNormAssignsRev.entrySet());
        assert (symNormAssignsEntries.size() == compile.normAssigns.size());
        int normI = symNormAssignsEntries.size();
        for (Assign assign1 : compile.normAssigns) {
            Lhs lhs1 = assign1.lhs;
            Driver drv1 = assign1.driver;
            Map.Entry e2 = (Map.Entry)symNormAssignsEntries.get(--normI);
            Lhs lhs2 = (Lhs)e2.getKey();
            SymbolicDriver sDrv2 = (SymbolicDriver)e2.getValue();
            assert (lhs1.equals(lhs2));
            assert (lhs1.getACL2Object().equals(lhs2.getACL2Object()));
            Driver<IndexName> drv2 = sDrv2.makeWideDriver(sm);
            assert (drv1.equals(drv2));
            assert (drv1.getACL2Object().equals(drv2.getACL2Object()));
        }
        assert (normI == 0);
        ArrayList symNetassignsEntries = new ArrayList(symNetassignsRev.entrySet());
        assert (symNetassignsEntries.size() == compile.resAssigns.size());
        int netI = symNetassignsEntries.size();
        Iterator iter = compile.resAssigns.entrySet().iterator();
        for (Map.Entry e1 : compile.netAssigns.entrySet()) {
            Svar svar1 = e1.getKey();
            List l1 = e1.getValue();
            Map.Entry e2 = (Map.Entry)symNetassignsEntries.get(--netI);
            Svar svar2 = (Svar)e2.getKey();
            List l2 = (List)e2.getValue();
            Util.check(svar1.equals(svar2));
            Map.Entry e3 = iter.next();
            Svar svar3 = e3.getKey();
            Svex svex3 = e3.getValue();
            Util.check(svar1.equals(svar3));
            assert (l1.size() == l2.size());
            assert (!l1.isEmpty());
            Svex svexRes = null;
            for (int j2 = l1.size() - 1; j2 >= 0; --j2) {
                Driver d1 = l1.get(j2);
                SymbolicDriver d2 = (SymbolicDriver)l2.get(j2);
                Driver<IndexName> newDrv = d2.makeDriver(sm);
                Util.check(d1.equals(newDrv));
                Util.check(newDrv.strength == 6);
                svexRes = svexRes == null ? newDrv.svex : SvexCall.newCall(Vec4Res.FUNCTION, newDrv.svex, svexRes);
            }
            Util.check(svexRes.equals(svex3));
            Util.check(svexRes.getACL2Object().equals(svex3.getACL2Object()));
        }
        assert (netI == 0);
    }

    void testAliasesAndCompile() {
        IndexName.curElabMod = this.elabMod;
        ModDb.FlattenResult flattenResult = this.elabMod.svexmodFlatten(this.design.b.modalist);
        SvexManager<IndexName> sm = flattenResult.sm;
        Compile<IndexName> compile = new Compile<IndexName>(flattenResult.aliases.getArr(), flattenResult.assigns, sm);
        this.testAliases(flattenResult);
        this.testNormAssigns(compile, sm);
        this.testAssignsToNetassigns(compile, sm);
        IndexName.curElabMod = null;
    }

    void computeCombinationalInputs(String global) {
        Object lw;
        Svar<PathExt> svar;
        this.checkExports();
        this.testAliasesAndCompile();
        this.computeDriverDeps(global, false);
        this.computeDriverDeps(global, true);
        for (Map.Entry<Svar<PathExt>, BigInteger> e2 : this.stateVars0.entrySet()) {
            svar = e2.getKey();
            BigInteger mask0 = e2.getValue();
            Util.check(svar.getDelay() == 1);
            lw = (WireExt)svar.getName();
            Util.check(this.stateWires.contains(lw));
            Util.check(mask0.equals(BigIntegerUtil.logheadMask(((PathExt)lw).getWidth())));
        }
        for (Map.Entry<Svar<PathExt>, BigInteger> e2 : this.stateVars1.entrySet()) {
            svar = e2.getKey();
            BigInteger mask1 = e2.getValue();
            Util.check(svar.getDelay() == 1);
            lw = (WireExt)svar.getName();
            Util.check(this.stateWires.contains(lw));
            Util.check(mask1.equals(BigIntegerUtil.logheadMask(((PathExt)lw).getWidth())));
        }
        this.hasPhaseState = !this.stateVars0.isEmpty() || !this.stateVars1.isEmpty();
        this.hasCycleState = !this.stateVars0.isEmpty();
        for (ModInstExt inst : this.insts) {
            if (inst.proto.hasPhaseState) {
                this.hasPhaseState = true;
            }
            if (!inst.proto.hasCycleState) continue;
            this.hasCycleState = true;
        }
        Map<Object, Set<Object>> fineGraph0 = this.computeFineDepsGraph(false);
        Map<Object, Set<Object>> fineGraph1 = this.computeFineDepsGraph(true);
        Map<Object, Set<Object>> fineClosure0 = this.closure(fineGraph0);
        Map<Object, Set<Object>> fineClosure1 = this.closure(fineGraph1);
        for (ModExport out : this.exports) {
            if (!out.isOutput()) continue;
            out.setFineDeps(false, fineClosure0);
            out.setFineDeps(true, fineClosure1);
        }
        Map<Object, Set<Object>> fineTransdep0 = this.transdep(fineGraph0);
        Map<Object, Set<Object>> fineTransdep1 = this.transdep(fineGraph1);
        this.markInstancesToSplit(fineTransdep0, false);
        this.markInstancesToSplit(fineTransdep1, true);
        Map<Object, Set<Object>> crudeGraph0 = this.computeDepsGraph(false);
        Map<Object, Set<Object>> crudeGraph1 = this.computeDepsGraph(true);
        Map<Object, Set<Object>> crudeClosure0 = this.closure(crudeGraph0);
        Map<Object, Set<Object>> crudeClosure1 = this.closure(crudeGraph1);
        for (ModExport out : this.exports) {
            if (!out.isOutput()) continue;
            out.crudePortStateDep0 = this.gatherDep(out.crudePortDeps0, out.wire, crudeClosure0);
            out.crudePortStateDep1 = this.gatherDep(out.crudePortDeps1, out.wire, crudeClosure1);
        }
    }

    private void computeDriverDeps(String global, boolean clkOne) {
        Map<Svar<PathExt>, Vec4> patchEnv = this.makePatchEnv(global, clkOne ? Vec2.ONE : Vec2.ZERO);
        HashMap<SvexCall<PathExt>, SvexCall<PathExt>> patchMemoize = new HashMap<SvexCall<PathExt>, SvexCall<PathExt>>();
        for (Map.Entry<Lhs<PathExt>, DriverExt> e2 : this.assigns.entrySet()) {
            Lhs<PathExt> l2 = e2.getKey();
            DriverExt d2 = e2.getValue();
            d2.computeDeps(l2.width(), clkOne, patchEnv, patchMemoize);
        }
    }

    private Map<Svar<PathExt>, Vec4> makePatchEnv(String global, Vec4 globalVal) {
        HashMap<Svar<PathExt>, Vec4> env = new HashMap<Svar<PathExt>, Vec4>();
        for (ModExport export : this.exports) {
            if (!export.isGlobal() || !export.global.equals(global)) continue;
            env.put(export.wire.getVar(0), globalVal);
        }
        return env;
    }

    Map<Object, Set<Object>> computeDepsGraph(boolean clockHigh) {
        LinkedHashMap<Object, Set<Object>> graph = new LinkedHashMap<Object, Set<Object>>();
        for (WireExt wireExt : this.wires) {
            if (wireExt.isInput()) continue;
            BigInteger mask = BigIntegerUtil.logheadMask(wireExt.getWidth());
            LinkedHashSet<Object> outputDeps = new LinkedHashSet<Object>();
            this.addWireDeps(wireExt.getVar(0), mask, outputDeps);
            graph.put(wireExt, outputDeps);
        }
        for (ModInstExt modInstExt : this.insts) {
            for (PathExt.PortInst piOut : modInstExt.portInsts) {
                if (!piOut.isOutput()) continue;
                if (piOut.splitIt) {
                    BitSet fineBitStateDeps = piOut.proto.getFineBitStateDeps(clockHigh);
                    List<Map<Svar<PathExt>, BigInteger>> fineBitDeps = piOut.proto.getFineBitDeps(clockHigh);
                    for (int bit = 0; bit < piOut.getWidth(); ++bit) {
                        PathExt.Bit pb = piOut.getBit(bit);
                        boolean fineBitStateDep = fineBitStateDeps.get(bit);
                        Map<Svar<PathExt>, BigInteger> fineBitDep = fineBitDeps.get(bit);
                        this.putPortInsDeps(pb, modInstExt, fineBitStateDep, fineBitDep, graph);
                    }
                    continue;
                }
                boolean finePortStateDeps = piOut.proto.getCrudePortStateDeps(clockHigh);
                Map<Svar<PathExt>, BigInteger> finePortDeps = piOut.proto.getCrudePortDeps(clockHigh);
                this.putPortInsDeps(piOut, modInstExt, finePortStateDeps, finePortDeps, graph);
            }
        }
        for (Map.Entry entry : this.assigns.entrySet()) {
            Lhs l2 = (Lhs)entry.getKey();
            DriverExt d2 = (DriverExt)entry.getValue();
            if (d2.splitIt) {
                List<Map<Svar<PathExt>, BigInteger>> fineDeps = d2.getFineBitLocDeps(clockHigh);
                assert (fineDeps.size() == l2.width());
                for (int bit = 0; bit < l2.width(); ++bit) {
                    Map<Svar<PathExt>, BigInteger> fineDep = fineDeps.get(bit);
                    this.putVarMasksDeps(d2.getBit(bit), fineDep, graph);
                }
                continue;
            }
            assert (!l2.ranges.isEmpty());
            this.putVarMasksDeps(d2, d2.getCrudeDeps(clockHigh), graph);
        }
        return graph;
    }

    private void putPortInsDeps(Object node, ModInstExt mi, boolean state, Map<Svar<PathExt>, BigInteger> portMasks, Map<Object, Set<Object>> graph) {
        LinkedHashSet<Object> deps = new LinkedHashSet<Object>();
        if (state) {
            deps.add(STATE);
        }
        for (Map.Entry<Svar<PathExt>, BigInteger> e2 : portMasks.entrySet()) {
            Svar<PathExt> svar = e2.getKey();
            BigInteger mask = e2.getValue();
            WireExt lw = (WireExt)svar.getName();
            PathExt.PortInst piIn = mi.portInstsIndex.get(lw.getName());
            this.addPortInDeps(piIn, mask, deps);
        }
        graph.put(node, deps);
    }

    private void putVarMasksDeps(Object node, Map<Svar<PathExt>, BigInteger> varMasks, Map<Object, Set<Object>> graph) {
        LinkedHashSet<Object> deps = new LinkedHashSet<Object>();
        for (Map.Entry<Svar<PathExt>, BigInteger> e2 : varMasks.entrySet()) {
            Svar<PathExt> svar = e2.getKey();
            BigInteger mask = e2.getValue();
            this.addWireDeps(svar, mask, deps);
        }
        graph.put(node, deps);
    }

    private void addPortInDeps(PathExt.PortInst piIn, BigInteger mask, Set<Object> deps) {
        if (piIn.driver instanceof DriverExt) {
            this.addDriverDeps(piIn.getDriverExt(), mask, deps);
        } else {
            this.addLhsDeps(piIn.getDriverLhs(), mask, deps);
        }
    }

    private void addLhsDeps(Lhs<PathExt> lhs, BigInteger mask, Set<Object> deps) {
        for (Lhrange lr : lhs.ranges) {
            BigInteger mask1 = BigIntegerUtil.loghead(lr.getWidth(), mask).shiftLeft(lr.getRsh());
            this.addWireDeps(lr.getVar(), mask1, deps);
            mask = mask.shiftRight(lr.getWidth());
        }
    }

    private void addWireDeps(Svar<PathExt> svar, BigInteger mask, Set<Object> deps) {
        if (mask.signum() == 0) {
            return;
        }
        if (svar.getDelay() != 0) {
            deps.add(STATE);
            return;
        }
        WireExt lw = (WireExt)svar.getName();
        if (lw.isInput()) {
            for (int bit = 0; bit < lw.getWidth(); ++bit) {
                if (!mask.testBit(bit)) continue;
                deps.add(lw.getBit(bit));
            }
            return;
        }
        for (Map.Entry<Lhrange<PathExt>, WireExt.WireDriver> e2 : lw.drivers.entrySet()) {
            int i2;
            Lhrange<PathExt> lhr = e2.getKey();
            WireExt.WireDriver wd = e2.getValue();
            BigInteger mask1 = BigIntegerUtil.loghead(lhr.getWidth(), mask.shiftRight(lhr.getRsh()));
            if (lhr.getVar().getDelay() != 0 || mask1.signum() <= 0) continue;
            if (wd.driver != null) {
                this.addDriverDeps(wd.driver, mask1.shiftLeft(wd.lsh), deps);
            }
            if (wd.pi != null) {
                assert (wd.pi.isOutput());
                if (wd.pi.splitIt) {
                    for (i2 = 0; i2 < lhr.getWidth(); ++i2) {
                        if (!mask1.testBit(i2)) continue;
                        deps.add(wd.pi.getBit(wd.lsh + i2));
                    }
                } else {
                    deps.add(wd.pi);
                }
            }
            if (wd.inp == null) continue;
            assert (wd.inp.getExport().isInput());
            for (i2 = 0; i2 < lhr.getWidth(); ++i2) {
                if (!mask1.testBit(i2)) continue;
                deps.add(wd.inp.getBit(wd.lsh + i2));
            }
        }
    }

    private void addDriverDeps(DriverExt driver, BigInteger mask, Set<Object> deps) {
        if (driver.splitIt) {
            for (int bit = 0; bit < driver.getWidth(); ++bit) {
                if (!mask.testBit(bit)) continue;
                deps.add(driver.getBit(bit));
            }
        } else if (mask.signum() > 0) {
            deps.add(driver);
        }
    }

    Map<Object, Set<Object>> computeFineDepsGraph(boolean clockHigh) {
        LinkedHashMap<Object, Set<Object>> graph = new LinkedHashMap<Object, Set<Object>>();
        for (WireExt w : this.wires) {
            if (w.isInput()) continue;
            for (Map.Entry<Lhrange<PathExt>, WireExt.WireDriver> e2 : w.drivers.entrySet()) {
                Lhrange<PathExt> range = e2.getKey();
                WireExt.WireDriver wd = e2.getValue();
                if (wd.inp == null) continue;
                assert (wd.inp.getExport().isInput());
                for (int bit = 0; bit < range.getWidth(); ++bit) {
                    graph.put(w.getBit(range.getRsh() + bit), Collections.singleton(wd.inp.getBit(wd.lsh + bit)));
                }
            }
            BigInteger assignedBits = w.getAssignedBits();
            for (int bit = 0; bit < w.getWidth(); ++bit) {
                if (assignedBits.testBit(bit)) continue;
                PathExt.Bit pb = w.getBit(bit);
                graph.put(pb, Collections.emptySet());
            }
        }
        for (ModInstExt inst : this.insts) {
            for (PathExt.PortInst pi : inst.portInsts) {
                if (pi.isOutput()) {
                    assert (pi.source.width() == pi.getWidth());
                    assert (pi.driver == null);
                    BitSet fineBitStateTransDeps = pi.proto.getFineBitStateDeps(clockHigh);
                    List<Map<Svar<PathExt>, BigInteger>> fineBitTransDeps = pi.proto.getFineBitDeps(clockHigh);
                    for (int bitOut = 0; bitOut < pi.getWidth(); ++bitOut) {
                        LinkedHashSet<Object> dep = new LinkedHashSet<Object>();
                        if (fineBitStateTransDeps.get(bitOut)) {
                            dep.add(STATE);
                        }
                        Map<Svar<PathExt>, BigInteger> fineBitDep = fineBitTransDeps.get(bitOut);
                        for (Map.Entry<Svar<PathExt>, BigInteger> e1 : fineBitDep.entrySet()) {
                            WireExt lw = (WireExt)e1.getKey().getName();
                            BigInteger mask = e1.getValue();
                            PathExt.PortInst piIn = inst.portInstsIndex.get(lw.getName());
                            Util.check(piIn != null);
                            for (int bitIn = 0; bitIn < piIn.getWidth(); ++bitIn) {
                                assert (piIn.getBit(bitIn) != null);
                                if (!mask.testBit(bitIn)) continue;
                                dep.add(piIn.getBit(bitIn));
                            }
                        }
                        graph.put(pi.getBit(bitOut), dep);
                        graph.put(pi.getParentBit(bitOut), Collections.singleton(pi.getBit(bitOut)));
                    }
                    continue;
                }
                assert (pi.isInput());
                assert (pi.source == null);
                if (pi.driver instanceof DriverExt) {
                    for (int bit = 0; bit < pi.getWidth(); ++bit) {
                        Util.check(pi.getBit(bit) == pi.getParentBit(bit));
                    }
                    continue;
                }
                assert (pi.driver instanceof Lhs);
                for (int bit = 0; bit < pi.getWidth(); ++bit) {
                    graph.put(pi.getBit(bit), Collections.singleton(pi.getParentBit(bit)));
                }
            }
        }
        for (DriverExt drv : this.assigns.values()) {
            for (int bitDrv = 0; bitDrv < drv.getWidth(); ++bitDrv) {
                LinkedHashSet<Object> dep = new LinkedHashSet<Object>();
                Map<Svar<PathExt>, BigInteger> varMasks = drv.getFineBitLocDeps(clockHigh).get(bitDrv);
                for (Map.Entry<Svar<PathExt>, BigInteger> e3 : varMasks.entrySet()) {
                    Svar<PathExt> svar = e3.getKey();
                    BigInteger maskIn = e3.getValue();
                    if (svar.getDelay() == 0) {
                        PathExt pathExt = svar.getName();
                        assert (maskIn.signum() >= 0);
                        for (int bitIn = 0; bitIn < maskIn.bitLength(); ++bitIn) {
                            if (!maskIn.testBit(bitIn)) continue;
                            PathExt.Bit pb = pathExt.getBit(bitIn);
                            assert (pb != null);
                            dep.add(pb);
                        }
                        continue;
                    }
                    dep.add(STATE);
                }
                graph.put(drv.getBit(bitDrv), dep);
            }
        }
        return graph;
    }

    private void markInstancesToSplit(Map<Object, Set<Object>> transdep, boolean clockHigh) {
        int bit;
        LinkedHashSet<PathExt.Bit> outDeps;
        Set<Object> deps;
        Svar<PathExt> svar;
        HashSet<Object> inputDeps;
        for (ModInstExt modInstExt : this.insts) {
            for (PathExt.PortInst piOut : modInstExt.portInsts) {
                if (!piOut.isOutput()) continue;
                inputDeps = new HashSet<Object>();
                Map<Svar<PathExt>, BigInteger> crudePortDeps = piOut.proto.getCrudePortDeps(clockHigh);
                for (Map.Entry<Svar<PathExt>, BigInteger> e2 : crudePortDeps.entrySet()) {
                    svar = e2.getKey();
                    e2.getValue();
                    WireExt lw = (WireExt)svar.getName();
                    PathExt.PortInst piIn = modInstExt.portInstsIndex.get(lw.getName());
                    for (int bit2 = 0; bit2 < piIn.getWidth(); ++bit2) {
                        deps = transdep.get(piIn.getBit(bit2));
                        if (deps == null) continue;
                        inputDeps.addAll(deps);
                    }
                }
                outDeps = new LinkedHashSet();
                for (bit = 0; bit < piOut.getWidth(); ++bit) {
                    if (!inputDeps.contains(piOut.getBit(bit))) continue;
                    outDeps.add(piOut.getProtoBit(bit));
                }
                if (outDeps.isEmpty()) continue;
                piOut.splitIt = true;
            }
        }
        for (Map.Entry entry : this.assigns.entrySet()) {
            Lhs lhs = (Lhs)entry.getKey();
            DriverExt drv = (DriverExt)entry.getValue();
            inputDeps = new HashSet();
            Map<Svar<PathExt>, BigInteger> crudeDeps = drv.getCrudeDeps(clockHigh);
            for (Map.Entry<Svar<PathExt>, BigInteger> e1 : crudeDeps.entrySet()) {
                svar = e1.getKey();
                BigInteger mask = e1.getValue();
                if (svar.getDelay() != 0) continue;
                PathExt pathExt = svar.getName();
                for (int bit2 = 0; bit2 < pathExt.getWidth(); ++bit2) {
                    if (!mask.testBit(bit2) || (deps = transdep.get(pathExt.getBit(bit2))) == null) continue;
                    inputDeps.addAll(deps);
                }
            }
            outDeps = new LinkedHashSet<PathExt.Bit>();
            for (bit = 0; bit < lhs.width(); ++bit) {
                PathExt.Bit pb = drv.getBit(bit);
                assert (pb != null);
                if (!inputDeps.contains(pb)) continue;
                outDeps.add(pb);
            }
            if (outDeps.isEmpty()) continue;
            drv.splitIt = true;
        }
    }

    void markPortInstancesToSplit(String[] portInstancesToSplit) {
        for (String portInstanceToSplit : portInstancesToSplit) {
            int indexOfDot = portInstanceToSplit.indexOf(46);
            String instStr = portInstanceToSplit.substring(0, indexOfDot);
            String portStr = portInstanceToSplit.substring(indexOfDot + 1);
            Name instName = Name.fromACL2(ACL2Object.valueOf(instStr));
            Name portName = Name.fromACL2(ACL2Object.valueOf(portStr));
            ModInstExt inst = this.instsIndex.get(instName);
            PathExt.PortInst pi = inst.portInstsIndex.get(portName);
            pi.splitIt = true;
        }
    }

    void markDriversToSplit(int[] driversToSplit) {
        for (int driverToSplit : driversToSplit) {
            Iterator<DriverExt> it = this.assigns.values().iterator();
            for (int i2 = 0; i2 < driverToSplit; ++i2) {
                it.next();
            }
            it.next().splitIt = true;
        }
    }

    static Map<Svar<PathExt>, BigInteger> combineDeps(List<Map<Svar<PathExt>, BigInteger>> deps) {
        LinkedHashMap<Svar<PathExt>, BigInteger> result = new LinkedHashMap<Svar<PathExt>, BigInteger>();
        for (Map<Svar<PathExt>, BigInteger> dep : deps) {
            for (Map.Entry<Svar<PathExt>, BigInteger> e2 : dep.entrySet()) {
                Svar<PathExt> svar = e2.getKey();
                BigInteger mask = e2.getValue();
                if (mask.signum() <= 0) continue;
                BigInteger oldMask = (BigInteger)result.get(svar);
                if (oldMask == null) {
                    oldMask = BigInteger.ZERO;
                }
                result.put(svar, oldMask.or(mask));
            }
        }
        return result;
    }

    void showGraph(Map<Object, Set<Object>> graph) {
        for (Map.Entry<Object, Set<Object>> e2 : graph.entrySet()) {
            System.out.print(String.valueOf(e2.getKey()) + " <=");
            for (Object o2 : e2.getValue()) {
                System.out.print(" " + String.valueOf(o2));
            }
            System.out.println();
        }
    }

    public String showFinePortDeps(PathExt.Bit[] pathBits, Map<Object, Set<Object>> graph0, Map<Object, Set<Object>> graph1) {
        BitSet fineBitState0 = new BitSet();
        BitSet fineBitState1 = new BitSet();
        List<Map<Svar<PathExt>, BigInteger>> fineBitDeps0 = this.gatherFineBitDeps(fineBitState0, pathBits, graph0);
        List<Map<Svar<PathExt>, BigInteger>> fineBitDeps1 = this.gatherFineBitDeps(fineBitState1, pathBits, graph1);
        boolean fineState0 = !fineBitState0.isEmpty();
        Map<Svar<PathExt>, BigInteger> fineExportDeps0 = this.sortDeps(ModuleExt.combineDeps(fineBitDeps0));
        boolean fineState1 = !fineBitState1.isEmpty();
        Map<Svar<PathExt>, BigInteger> fineExportDeps1 = this.sortDeps(ModuleExt.combineDeps(fineBitDeps1));
        return ModuleExt.showFineDeps(fineState0, fineExportDeps0, fineState1, fineExportDeps1);
    }

    public String showCrudePortDeps(Object node, Map<Object, Set<Object>> graph0, Map<Object, Set<Object>> graph1) {
        LinkedHashMap<Svar<PathExt>, BigInteger> dep0 = new LinkedHashMap<Svar<PathExt>, BigInteger>();
        LinkedHashMap<Svar<PathExt>, BigInteger> dep1 = new LinkedHashMap<Svar<PathExt>, BigInteger>();
        boolean stateDep0 = this.gatherDep(dep0, node, graph0);
        boolean stateDep1 = this.gatherDep(dep1, node, graph1);
        return ModuleExt.showFineDeps(stateDep0, this.sortDeps(dep0), stateDep1, this.sortDeps(dep1));
    }

    public static String showFineDeps(BitSet stateDeps0, List<Map<Svar<PathExt>, BigInteger>> deps0, BitSet stateDeps1, List<Map<Svar<PathExt>, BigInteger>> deps1, int bit) {
        return ModuleExt.showFineDeps(stateDeps0.get(bit), deps0.get(bit), stateDeps1.get(bit), deps1.get(bit));
    }

    public static String showFineDeps(boolean stateDep0, Map<Svar<PathExt>, BigInteger> dep0, boolean stateDep1, Map<Svar<PathExt>, BigInteger> dep1) {
        if (dep0.equals(dep1) && stateDep0 == stateDep1) {
            return ModuleExt.showFineDeps(stateDep0, dep0);
        }
        return "0=>" + ModuleExt.showFineDeps(stateDep0, dep0) + " | 1=>" + ModuleExt.showFineDeps(stateDep1, dep1);
    }

    private static String showFineDeps(boolean stateDep, Map<Svar<PathExt>, BigInteger> dep) {
        Object s = stateDep ? STATE : "";
        for (Map.Entry<Svar<PathExt>, BigInteger> e2 : dep.entrySet()) {
            Svar<PathExt> svar = e2.getKey();
            BigInteger mask = e2.getValue();
            if (!((String)s).isEmpty()) {
                s = (String)s + ",";
            }
            s = (String)s + svar.toString(mask);
        }
        return s;
    }

    List<Map<Svar<PathExt>, BigInteger>> gatherFineBitDeps(BitSet stateDeps, PathExt.Bit[] pathBits, Map<Object, Set<Object>> graph) {
        ArrayList<Map<Svar<PathExt>, BigInteger>> fineDeps = new ArrayList<Map<Svar<PathExt>, BigInteger>>();
        stateDeps.clear();
        for (int bit = 0; bit < pathBits.length; ++bit) {
            LinkedHashMap<Svar<PathExt>, BigInteger> fineDep = new LinkedHashMap<Svar<PathExt>, BigInteger>();
            if (this.gatherDep(fineDep, pathBits[bit], graph)) {
                stateDeps.set(bit);
            }
            fineDeps.add(fineDep);
        }
        return fineDeps;
    }

    boolean gatherDep(Map<Svar<PathExt>, BigInteger> dep, Object node, Map<Object, Set<Object>> graph) {
        boolean state = false;
        dep.clear();
        for (Object o2 : graph.get(node)) {
            if (o2.equals(STATE)) {
                state = true;
                continue;
            }
            if (o2 instanceof PathExt) {
                PathExt pathExt = (PathExt)o2;
                dep.put(pathExt.getVar(0), BigIntegerUtil.logheadMask(pathExt.getWidth()));
                continue;
            }
            if (o2 instanceof DriverExt) {
                DriverExt drv = (DriverExt)o2;
                for (int bit = 0; bit < drv.getWidth(); ++bit) {
                    this.gatherBitDep(dep, drv.getBit(bit));
                }
                continue;
            }
            PathExt.Bit pb = (PathExt.Bit)o2;
            this.gatherBitDep(dep, pb);
        }
        return state;
    }

    void gatherBitDep(Map<Svar<PathExt>, BigInteger> dep, PathExt.Bit pb) {
        BigInteger mask = dep.get(pb.getPath().getVar(0));
        if (mask == null) {
            mask = BigInteger.ZERO;
        }
        dep.put(pb.getPath().getVar(0), mask.setBit(pb.bit));
    }

    Map<Svar<PathExt>, BigInteger> sortDeps(Map<Svar<PathExt>, BigInteger> deps) {
        TreeMap<Svar<PathExt>, BigInteger> sortedDeps = new TreeMap<Svar<PathExt>, BigInteger>(this);
        sortedDeps.putAll(deps);
        assert (sortedDeps.size() == deps.size());
        return sortedDeps;
    }

    Set<WireExt> sortWires(Set<WireExt> wires) {
        LinkedHashSet<WireExt> sortedWires = new LinkedHashSet<WireExt>();
        for (WireExt wire : this.wires) {
            if (!wires.contains(wire)) continue;
            sortedWires.add(wire);
        }
        for (WireExt wire : wires) {
            sortedWires.add(wire);
        }
        assert (sortedWires.equals(wires));
        return sortedWires;
    }

    Map<Object, Set<Object>> closure(Map<Object, Set<Object>> rel) {
        HashMap<Object, Set<Object>> closure = new HashMap<Object, Set<Object>>();
        HashSet<Object> visited = new HashSet<Object>();
        for (Object key : rel.keySet()) {
            this.closure(key, rel, closure, visited);
        }
        Util.check(closure.size() == visited.size());
        return closure;
    }

    private Set<Object> closure(Object top, Map<Object, Set<Object>> rel, Map<Object, Set<Object>> closure, Set<Object> visited) {
        Set<Object> ret = closure.get(top);
        if (ret == null) {
            boolean ok = visited.add(top);
            if (!ok) {
                System.out.println("CombinationalLoop!!! in " + String.valueOf(top) + " of " + String.valueOf(this.modName));
                return Collections.singleton(top);
            }
            Set<Object> dep = rel.get(top);
            if (dep == null) {
                ret = Collections.singleton(top);
            } else {
                ret = new LinkedHashSet<Object>();
                for (Object svar : dep) {
                    ret.addAll(this.closure(svar, rel, closure, visited));
                }
            }
            closure.put(top, ret);
        }
        return ret;
    }

    Map<Object, Set<Object>> transdep(Map<Object, Set<Object>> rel) {
        HashMap<Object, Set<Object>> transdep = new HashMap<Object, Set<Object>>();
        HashSet<Object> visited = new HashSet<Object>();
        for (Object key : rel.keySet()) {
            this.transdep(key, rel, transdep, visited);
        }
        Util.check(transdep.size() == visited.size());
        return transdep;
    }

    private Set<Object> transdep(Object top, Map<Object, Set<Object>> rel, Map<Object, Set<Object>> transdep, Set<Object> visited) {
        Set<Object> ret = transdep.get(top);
        if (ret == null) {
            boolean ok = visited.add(top);
            if (!ok) {
                System.out.println("CombinationalLoop!!! in " + String.valueOf(top) + " of " + String.valueOf(this.modName));
                return Collections.singleton(top);
            }
            Set<Object> dep = rel.get(top);
            if (dep == null) {
                ret = Collections.singleton(top);
            } else {
                ret = new LinkedHashSet<Object>();
                ret.add(top);
                for (Object svar : dep) {
                    ret.addAll(this.transdep(svar, rel, transdep, visited));
                }
            }
            transdep.put(top, ret);
        }
        return ret;
    }

    @Override
    public int compare(Svar<PathExt> o1, Svar<PathExt> o2) {
        String s2;
        if (o1.getDelay() > o2.getDelay()) {
            return -1;
        }
        if (o1.getDelay() < o2.getDelay()) {
            return 1;
        }
        PathExt p1 = o1.getName();
        PathExt p2 = o2.getName();
        if (p1 instanceof WireExt) {
            if (p2 instanceof WireExt) {
                WireExt lw1 = (WireExt)p1;
                WireExt lw2 = (WireExt)p2;
                return Integer.compare(lw1.index, lw2.index);
            }
            return -1;
        }
        if (p2 instanceof WireExt) {
            return 1;
        }
        PathExt.PortInst pi1 = (PathExt.PortInst)p1;
        PathExt.PortInst pi2 = (PathExt.PortInst)p2;
        String s1 = pi1.inst.getInstname().toString();
        int res = s1.compareTo(s2 = pi2.inst.getInstname().toString());
        if (res != 0) {
            return res;
        }
        return Integer.compare(pi1.proto.index, pi2.proto.index);
    }
}

