/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.Design;
import com.sun.electric.tool.simulation.acl2.mods.ElabMod;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.ModDb;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.mods.Wire;
import com.sun.electric.tool.simulation.acl2.modsext.DesignExplore;
import com.sun.electric.tool.simulation.acl2.modsext.DesignExt;
import com.sun.electric.tool.simulation.acl2.modsext.DesignHints;
import com.sun.electric.tool.simulation.acl2.modsext.DriverExt;
import com.sun.electric.tool.simulation.acl2.modsext.GenBase;
import com.sun.electric.tool.simulation.acl2.modsext.ModInstExt;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.ParameterizedModule;
import com.sun.electric.tool.simulation.acl2.modsext.PathExt;
import com.sun.electric.tool.simulation.acl2.modsext.WireExt;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Reader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GenFsmNew
extends GenBase {
    final Map<ModName, ParameterizedModule> modToParMod = new HashMap<ModName, ParameterizedModule>();
    final Map<ParameterizedModule, Map<String, ModName>> parModuleInstances = new LinkedHashMap<ParameterizedModule, Map<String, ModName>>();
    private final Set<Integer> vec4sizes = new TreeSet<Integer>();
    private String designName;
    private final DesignHints designHints;
    private final List<ParameterizedModule> parameterizedModules;

    public static <H extends DesignHints> void genFsm(Class<H> cls, File saoFile, String designName) {
        new GenFsmJob<H>(cls, saoFile, designName).startJob();
    }

    protected GenFsmNew(DesignHints designHints) {
        this.designHints = designHints;
        this.parameterizedModules = designHints.getParameterizedModules();
    }

    ParameterizedModule matchParameterized(ModName modName) {
        for (ParameterizedModule parMod : this.parameterizedModules) {
            if (!parMod.setCurBuilder(modName, null)) continue;
            return parMod;
        }
        return null;
    }

    public void scanLib(File saoFile) throws IOException {
        ACL2Reader sr = new ACL2Reader(saoFile);
        Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
        Design<Address> design = new Design<Address>(snb, sr.root);
        this.scanDesign(design);
        for (ModName modName : design.modalist.keySet()) {
            if (this.modToParMod.containsKey(modName)) continue;
            System.out.println(modName);
        }
    }

    public void showLibs() {
        System.out.println("========= Instances of libs ============");
        for (ParameterizedModule parModule : this.parameterizedModules) {
            Map<String, ModName> parInsts = this.parModuleInstances.get(parModule);
            if (parInsts.isEmpty()) continue;
            System.out.println(parModule);
            for (ModName modName : parInsts.values()) {
                System.out.println("   " + String.valueOf(parModule.matchModName(modName)));
            }
        }
        System.out.println("vec4 sizes");
        for (Integer width : this.vec4sizes) {
            System.out.println("(def-4vec-p " + width + ")");
        }
    }

    void scanDesign(Design<Address> design) {
        this.scanDesign(design, null);
    }

    void scanDesign(Design<Address> design, ModDb modDb) {
        List<ParameterizedModule> parModules = this.parameterizedModules;
        for (ParameterizedModule parameterizedModule : parModules) {
            this.parModuleInstances.put(parameterizedModule, new TreeMap(TextUtils.STRING_NUMBER_ORDER));
        }
        for (Map.Entry entry : design.modalist.entrySet()) {
            ModName modName = (ModName)entry.getKey();
            Module m2 = (Module)entry.getValue();
            ParameterizedModule parMod = null;
            for (ParameterizedModule parameterizedModule : this.parameterizedModules) {
                if (!parameterizedModule.setCurBuilder(modName, m2.sm)) continue;
                assert (parMod == null);
                parMod = parameterizedModule;
                Module<Address> genM = null;
                try {
                    genM = parameterizedModule.genModule();
                }
                catch (NumberFormatException exc) {
                    exc.printStackTrace(System.out);
                }
                if (genM == null) {
                    System.out.println("Module specialization is unfamiliar " + String.valueOf(modName));
                    continue;
                }
                if (!genM.equals(m2)) {
                    System.out.println("Module mismatch " + String.valueOf(modName));
                    DesignExplore.showMod(System.out, modName, m2);
                    DesignExplore.showMod(System.out, modName, genM);
                    continue;
                }
                if (modDb == null) continue;
                ElabMod elabMod = modDb.modnameGetIndex(modName);
                Util.check(parameterizedModule.getNumInsts() == elabMod.modNInsts());
                Util.check(parameterizedModule.getNumAssigns() == elabMod.modNAssigns());
                ModDb newModDb = new ModDb(elabMod, modDb);
                ModName[] depModNames = parMod.genDepModNames();
                Util.check(newModDb.nMods() == depModNames.length + 1);
                Util.check(newModDb.topMod() == elabMod);
                for (int modIdx = 0; modIdx < depModNames.length; ++modIdx) {
                    Util.check(newModDb.getMod(modIdx).modidxGetName().equals(depModNames[modIdx]));
                }
                ModInst[] allInsts = parameterizedModule.genAllModInsts(parMod.genDepModNames());
                Util.check(allInsts.length == elabMod.modTotalInsts());
                for (int i2 = 0; i2 < allInsts.length; ++i2) {
                    Util.check(allInsts[i2].equals(elabMod.instIndexToInstDecl(i2)));
                }
                Util.check(parameterizedModule.getTotalAssigns() == elabMod.modTotalAssigns());
            }
            if (parMod != null) {
                Map<String, ModName> parInsts = this.parModuleInstances.get(parMod);
                assert (parInsts != null);
                parInsts.put(modName.toString(), modName);
                this.modToParMod.put(modName, parMod);
            }
            for (Wire wire : m2.wires) {
                this.vec4sizes.add(wire.width);
            }
            for (Assign assign : m2.assigns) {
                this.vec4sizes.add(assign.lhs.width());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gen(String designName, DesignExt design, File outDir) throws FileNotFoundException {
        File locFile;
        ModName modName;
        PrintStream out;
        File statesFile;
        Map specializations;
        ParameterizedModule parMod;
        this.scanDesign(design.b);
        this.designName = designName;
        File readSaoFile = new File(outDir, designName + "-sao.lisp");
        try (PrintStream out2 = new PrintStream(readSaoFile);){
            this.out = out2;
            this.printReadSao();
        }
        finally {
            this.out = null;
        }
        String clockName = this.designHints.getGlobalClock();
        design.computeCombinationalInputs(clockName);
        for (Map.Entry<ParameterizedModule, Map<String, ModName>> entry : this.parModuleInstances.entrySet()) {
            parMod = entry.getKey();
            specializations = entry.getValue();
            if (!parMod.hasState() || specializations.isEmpty()) continue;
            statesFile = new File(outDir, parMod.modName + "-st.lisp");
            try {
                out = new PrintStream(statesFile);
                try {
                    this.out = out;
                    this.printPhaseStates(design, parMod, specializations.values());
                }
                finally {
                    out.close();
                }
            }
            finally {
                this.out = null;
            }
        }
        for (Map.Entry<Object, Object> entry : design.downTop.entrySet()) {
            modName = (ModName)entry.getKey();
            ModuleExt m2 = (ModuleExt)entry.getValue();
            if (this.modToParMod.containsKey(modName) || !m2.hasSvtvState) continue;
            statesFile = new File(outDir, String.valueOf(modName) + "-st.lisp");
            try {
                out = new PrintStream(statesFile);
                try {
                    this.out = out;
                    this.printPhaseStates(design, null, Collections.singleton(modName));
                }
                finally {
                    out.close();
                }
            }
            finally {
                this.out = null;
            }
        }
        for (Map.Entry<Object, Object> entry : this.parModuleInstances.entrySet()) {
            parMod = (ParameterizedModule)entry.getKey();
            specializations = (Map)entry.getValue();
            if (specializations.isEmpty()) continue;
            locFile = new File(outDir, parMod.modName + "-loc.lisp");
            try {
                out = new PrintStream(locFile);
                try {
                    this.out = out;
                    this.printLocs(design, parMod, specializations.values());
                }
                finally {
                    out.close();
                }
            }
            finally {
                this.out = null;
            }
        }
        for (ModName modName2 : design.downTop.keySet()) {
            if (this.modToParMod.containsKey(modName2)) continue;
            File statesFile2 = new File(outDir, String.valueOf(modName2) + "-loc.lisp");
            try (PrintStream out3 = new PrintStream(statesFile2);){
                this.out = out3;
                this.printLocs(design, null, Collections.singleton(modName2));
            }
            finally {
                this.out = null;
            }
        }
        for (Map.Entry entry : this.parModuleInstances.entrySet()) {
            parMod = (ParameterizedModule)entry.getKey();
            specializations = (Map)entry.getValue();
            if (specializations.isEmpty() || !parMod.exportsAreStrings()) continue;
            locFile = new File(outDir, parMod.modName + "-svtv.lisp");
            try {
                out = new PrintStream(locFile);
                try {
                    this.out = out;
                    this.printSvtvs(design, parMod, specializations.values());
                }
                finally {
                    out.close();
                }
            }
            finally {
                this.out = null;
            }
        }
        for (Map.Entry entry : design.downTop.entrySet()) {
            modName = (ModName)entry.getKey();
            entry.getValue();
            if (this.modToParMod.containsKey(modName)) continue;
            File statesFile3 = new File(outDir, String.valueOf(modName) + "-svtv.lisp");
            try (PrintStream out4 = new PrintStream(statesFile3);){
                this.out = out4;
                this.printSvtvs(design, null, Collections.singleton(modName));
            }
            finally {
                this.out = null;
            }
        }
    }

    private void printReadSao() {
        this.s("(in-package \"SV\")");
        this.s("(include-book \"std/util/defconsts\" :dir :system)");
        this.s("(include-book \"std/util/define\" :dir :system)");
        this.s("(include-book \"../4vec-nnn\")");
        this.s("(include-book \"../design-fetch-svex\")");
        this.s();
        this.s("(defconsts (*" + this.designName + "-sao* state)");
        this.sb("(serialize-read \"" + this.designName + ".sao\"))");
        this.e();
        this.s();
        this.s("(define " + this.designName + "-sao ()");
        this.sb(":returns (design design-p)");
        this.s("*" + this.designName + "-sao*)");
        this.e();
        this.s();
        this.s("(in-theory (disable (:executable-counterpart " + this.designName + "-sao)))");
        this.s();
        this.s("(define " + this.designName + "-sao-fetch-svex-guard (modname assign-idx)");
        this.sb(":returns (ok booleanp)");
        this.s("(design-fetch-svex-guard (" + this.designName + "-sao) modname assign-idx))");
        this.e();
        this.s();
        this.s("(define " + this.designName + "-sao-fetch-svex");
        this.sb("(modname");
        this.sb("assign-idx)");
        this.e();
        this.s(":guard (" + this.designName + "-sao-fetch-svex-guard modname assign-idx)");
        this.s(":returns (svex svex-p)");
        this.s("(design-fetch-svex (" + this.designName + "-sao) modname assign-idx)");
        this.s(":guard-hints ((\"goal\" :in-theory (enable " + this.designName + "-sao-fetch-svex-guard))))");
        this.e();
        this.s();
        this.s("(define " + this.designName + "-sao-svex-eval");
        this.sb("(modname");
        this.sb("assign-idx");
        this.s("(width posp)");
        this.s("(env svex-env-p))");
        this.e();
        this.s(":guard (" + this.designName + "-sao-fetch-svex-guard modname assign-idx)");
        this.s(":returns (result (4vec-n-p width result) :hyp (posp width))");
        this.s(":guard-hints ((\"goal\" :in-theory (enable " + this.designName + "-sao-fetch-svex-guard)))");
        this.s("(let*");
        this.sb("((svex (" + this.designName + "-sao-fetch-svex modname assign-idx))");
        this.sb("(width (pos-fix width))");
        this.s("(svex (list 'concat width svex 0)))");
        this.e();
        this.s("(with-fast-alist env (svex-eval svex env)))");
        this.e();
        this.s("///");
        this.s("(deffixequiv " + this.designName + "-sao-svex-eval))");
        this.e();
        assert (this.indent == 0);
    }

    private void printPhaseStates(DesignExt design, ParameterizedModule parMod, Collection<ModName> modNames) {
        ModuleExt m2;
        this.s("(in-package \"SV\")");
        this.s("(include-book \"centaur/fty/top\" :dir :system)");
        this.s("(include-book \"../4vec-nnn\")");
        this.s();
        this.s("(set-rewrite-stack-limit 2000)");
        HashSet<String> imports = new HashSet<String>();
        for (ModName modName : modNames) {
            m2 = design.downTop.get(modName);
            if (!m2.hasPhaseState) continue;
            for (ModInstExt inst : m2.insts) {
                ParameterizedModule protoParMod;
                String importStr;
                ModuleExt proto = inst.proto;
                if (!proto.hasPhaseState || imports.contains(importStr = (protoParMod = this.modToParMod.get(proto.modName)) != null ? protoParMod.modName : proto.modName.toString())) continue;
                this.s("(include-book \"" + importStr + "-st\")");
                imports.add(importStr);
            }
        }
        for (ModName modName : modNames) {
            m2 = design.downTop.get(modName);
            if (!m2.hasPhaseState) continue;
            this.s();
            this.s("; " + String.valueOf(modName));
            this.printPhaseState(modName, m2);
            if (!m2.hasCycleState) continue;
            this.printCycleState(modName, m2);
        }
    }

    private void printLocs(DesignExt design, ParameterizedModule parMod, Collection<ModName> modNames) {
        this.s("(in-package \"SV\")");
        this.s("(include-book \"centaur/fty/top\" :dir :system)");
        this.s("(include-book \"../4vec-nnn\")");
        this.s("(include-book \"" + this.designName + "-sao\")");
        for (ModName modName : modNames) {
            ModuleExt m2 = design.downTop.get(modName);
            this.printPhase2(modName, m2);
        }
    }

    private void printSvtvs(DesignExt design, ParameterizedModule parMod, Collection<ModName> modNames) {
        ModName modName0 = modNames.iterator().next();
        ModuleExt m0 = design.downTop.get(modName0);
        String parModName = parMod != null ? parMod.modName : modNames.iterator().next().toString();
        this.s("(in-package \"SV\")");
        this.s();
        this.s("(include-book \"centaur/gl/gl\" :dir :system)");
        this.s("(include-book \"centaur/gl/bfr-satlink\" :dir :system)");
        this.s("(include-book \"centaur/sv/svtv/top\" :dir :system)");
        this.s("(include-book \"" + this.designName + "-sao\")");
        if (parMod != null ? parMod.hasState() : m0.hasSvtvState) {
            this.s("(include-book \"" + parModName + "-st\")");
        }
        this.s();
        this.s("(local (include-book \"centaur/sv/svex/gl-rules\" :dir :system))");
        this.s("(local (include-book \"centaur/bitops/top\" :dir :system))");
        this.s();
        this.s("(value-triple (acl2::tshell-ensure))");
        this.s("(local (include-book \"centaur/aig/g-aig-eval\" :dir :system))");
        this.s("(local (gl::def-gl-clause-processor boothpipe-glcp))");
        this.s();
        this.s("(local (gl::gl-satlink-mode))");
        this.s();
        this.s("(define check-design-flatten-and-normalize");
        this.s("  ((x design-p))");
        this.s("  :guard (svarlist-addr-p (modalist-vars (design->modalist x)))");
        this.s("  :returns (mv (flat-assigns svex-alist-p)");
        this.s("               (flat-delays svar-map-p))");
        this.s("  (b* (((acl2::local-stobjs moddb aliases)");
        this.s("        (mv flat-aliases flat-assigns moddb aliases))");
        this.s("       ((mv err flat-assigns flat-delays moddb aliases)");
        this.s("        (svex-design-flatten-and-normalize x))");
        this.s("       ((when err) (raise \"Error flattening design: ~@0\" err)");
        this.s("        (mv nil nil moddb aliases)))");
        this.s("    (mv flat-assigns flat-delays moddb aliases)))");
        for (ModName modName : modNames) {
            ModuleExt m2 = design.downTop.get(modName);
            this.printSvtv(design, modName, m2);
        }
    }

    private void printPhase2(ModName modName, ModuleExt m2) {
        this.s();
        this.s("; " + String.valueOf(modName));
        int assignIndex = 0;
        for (Map.Entry<Lhs<PathExt>, DriverExt> e1 : m2.assigns.entrySet()) {
            WireExt lw;
            Lhs<PathExt> lhs = e1.getKey();
            DriverExt drv = e1.getValue();
            this.s();
            this.s("(define |" + String.valueOf(modName) + "-" + String.valueOf(lhs) + "-loc| (");
            this.b();
            this.b();
            List<Svar<PathExt>> svars = drv.getOrigVars();
            for (Svar<PathExt> svar : svars) {
                lw = (WireExt)svar.getName();
                this.s("(|" + String.valueOf(svar) + "| 4vec-" + lw.getWidth() + "-p)");
            }
            this.out.print(")");
            this.e();
            this.s(":returns (|" + String.valueOf(lhs) + "| 4vec-" + lhs.width() + "-p)");
            this.s("(let ((env (list");
            this.b();
            for (Svar<PathExt> svar : svars) {
                lw = (WireExt)svar.getName();
                Object s = "(cons ";
                s = svar.getDelay() == 0 ? (String)s + "\"" + String.valueOf(lw.getName()) + "\"" : (String)s + "'(:var \"" + String.valueOf(lw.getName()) + "\" . " + svar.getDelay() + ")";
                s = (String)s + " (4vec-" + lw.getWidth() + "-fix |" + String.valueOf(svar) + "|))";
                this.s((String)s);
            }
            this.out.print(")))");
            this.e();
            this.s("(" + this.designName + "-sao-svex-eval " + modName.toLispString() + " " + assignIndex + " " + lhs.width() + " env))");
            this.s("///");
            this.s("(deffixequiv |" + String.valueOf(modName) + "-" + String.valueOf(lhs) + "-loc|))");
            this.e();
            if (svars.isEmpty()) {
                this.s("(in-theory (disable (|" + String.valueOf(modName) + "-" + String.valueOf(lhs) + "-loc|)))");
            }
            ++assignIndex;
        }
    }

    private void printPhaseState(ModName modName, ModuleExt m2) {
        this.s();
        this.s("(defprod |" + String.valueOf(modName) + "-phase-st| (");
        this.b();
        this.b();
        for (WireExt wire : m2.wires) {
            Svar<PathExt> svar;
            if (!m2.stateWires.contains(wire) || !m2.stateVars0.containsKey(svar = wire.getVar(1)) && !m2.stateVars1.containsKey(svar)) continue;
            this.s("(|" + String.valueOf(wire) + "| 4vec-" + wire.getWidth() + ")");
        }
        for (ModInstExt inst : m2.insts) {
            if (!inst.proto.hasPhaseState) continue;
            this.s("(|" + String.valueOf(inst.getInstname()) + "| |" + String.valueOf(inst.proto.modName) + "-phase-st|)");
        }
        this.out.print(")");
        this.e();
        this.s(":layout :fulltree)");
        this.e();
        assert (this.indent == 0);
    }

    private void printCycleState(ModName modName, ModuleExt m2) {
        this.s();
        this.s("(defprod |" + String.valueOf(modName) + "-cycle-st| (");
        this.b();
        this.b();
        for (WireExt wire : m2.wires) {
            Svar<PathExt> svar;
            if (!m2.stateWires.contains(wire) || !m2.stateVars0.containsKey(svar = wire.getVar(1))) continue;
            this.s("(|" + String.valueOf(wire) + "| 4vec-" + wire.getWidth() + ")");
        }
        for (ModInstExt inst : m2.insts) {
            if (!inst.proto.hasCycleState) continue;
            this.s("(|" + String.valueOf(inst.getInstname()) + "| |" + String.valueOf(inst.proto.modName) + "-cycle-st|)");
        }
        this.out.print(")");
        this.e();
        this.s(":layout :fulltree)");
        this.e();
        assert (this.indent == 0);
    }

    private void printSvtv(DesignExt design, ModName modName, ModuleExt m2) {
        design.moddb.modnameGetIndex(modName);
        this.s();
        this.s("(defconst |*" + String.valueOf(modName) + "-design*|");
        this.sb("(change-design *" + this.designName + "-sao* :top " + modName.toLispString() + "))");
        this.e();
        this.s();
        this.s("(defsvtv |" + String.valueOf(modName) + "-phase|");
        this.sb(":mod |*" + String.valueOf(modName) + "-design*|");
        this.s(":inputs '(");
        this.b();
        for (WireExt wire : m2.wires) {
            if (!wire.isInput()) continue;
            this.s("(" + wire.b.name.toLispString() + " |" + String.valueOf(wire.b.name) + "|)");
        }
        this.out.print(")");
        this.e();
        this.s(":outputs '(");
        this.b();
        for (WireExt wire : m2.wires) {
            if (!wire.isOutput()) continue;
            this.s("(" + wire.b.name.toLispString() + " |" + String.valueOf(wire.b.name) + "|)");
        }
        this.out.print(")");
        this.e();
        this.s(":state-machine t)");
        this.e();
        this.s();
        this.s("(rule");
        this.sb("(equal");
        this.sb("(strip-cars (svtv->outexprs (|" + String.valueOf(modName) + "-phase|))) '(");
        this.b();
        for (WireExt wire : m2.wires) {
            if (!wire.isOutput()) continue;
            this.s("|" + String.valueOf(wire.b.name) + "|");
        }
        this.out.print("))");
        this.e();
        this.s(":enable ((|" + String.valueOf(modName) + "-phase|)))");
        this.e();
        this.e();
        for (int clk = 0; clk <= 1; ++clk) {
            this.s();
            this.s("(rule");
            this.s(" (b* ((pre-simplify t)");
            this.s("      (verbosep t)");
            this.s("      (clk " + clk + ")");
            this.s("      (clk-update (list (cons \"" + this.designHints.getGlobalClock() + "\" clk)))");
            this.s("      (clk-update (make-fast-alist clk-update))");
            this.s("      ((mv flat-assigns flat-delays)");
            this.s("       (check-design-flatten-and-normalize |*" + String.valueOf(modName) + "-design*|))");
            this.s("      (flat-assigns-clk (svex-alist-compose flat-assigns clk-update))");
            this.s();
            this.s("      ((mv updates ?next-states)");
            this.s("       (svex-compose-assigns/delays flat-assigns flat-delays");
            this.s("                                    :rewrite pre-simplify))");
            this.s("      ((mv updates-clk ?next-states-clk)");
            this.s("       (svex-compose-assigns/delays flat-assigns-clk flat-delays");
            this.s("                                    :rewrite pre-simplify))");
            this.s("      (rewritten-updates (svex-alist-rewrite-fixpoint");
            this.s("                          (svex-alist-compose updates clk-update)");
            this.s("                          :verbosep verbosep");
            this.s("                          :count 2))");
            this.s("      (rewritten-updates-clk (svex-alist-rewrite-fixpoint");
            this.s("                              updates-clk");
            this.s("                              :verbosep verbosep");
            this.s("                              :count 2))");
            this.s("      (- (fast-alist-free clk-update)))");
            this.s("   (set-equiv rewritten-updates rewritten-updates-clk)))");
        }
    }

    public static <N extends SvarName> void printSvex(PrintStream out, int indent, Svex<N> top) {
        Set<SvexCall<N>> multirefs = top.multirefs();
        GenFsmNew.printSvex(out, indent, top, multirefs, new HashMap<Svex<N>, String>(), "temp");
    }

    public static <N extends SvarName> void printSvex(PrintStream out, int indent, Svex<N> top, Set<SvexCall<N>> multirefs, Map<Svex<N>, String> multirefNames, String svexName) {
        int i2;
        Svex<N>[] toposort = top.toposort();
        boolean needMultirefs = false;
        for (i2 = 1; i2 < toposort.length; ++i2) {
            if (!(toposort[i2] instanceof SvexCall) || !multirefs.contains((SvexCall)toposort[i2])) continue;
            needMultirefs = true;
            break;
        }
        if (needMultirefs) {
            for (i2 = 0; i2 < indent; ++i2) {
                out.print(' ');
            }
            out.println(";; MULTIREFS " + multirefs.size());
            for (i2 = 0; i2 < indent; ++i2) {
                out.print(' ');
            }
            out.print("(let* (");
            indent += 2;
            assert (toposort[0] == top);
            int tempCount = 0;
            for (int i3 = toposort.length - 1; i3 >= 1; --i3) {
                Svex<N> svex = toposort[i3];
                if (!(svex instanceof SvexCall) || !multirefs.contains((SvexCall)svex)) continue;
                SvexCall sc = (SvexCall)svex;
                Object name = multirefNames.get(sc);
                if (name == null) {
                    name = svexName + "$" + tempCount++;
                    multirefNames.put(sc, (String)name);
                }
                out.println();
                for (int j2 = 0; j2 < indent - 1; ++j2) {
                    out.print(' ');
                }
                out.print("(" + (String)name);
                GenFsmNew.printSvexPart(out, indent, svex, multirefNames, true);
                out.print(')');
                multirefs.remove(sc);
            }
            out.print(')');
        }
        GenFsmNew.printSvexPart(out, indent, top, multirefNames, svexName.equals(multirefNames.get(top)));
        out.println(multirefs.isEmpty() ? ")" : "))");
        if (!multirefNames.containsKey(top)) {
            multirefNames.put(top, svexName);
        }
        if (top instanceof SvexCall) {
            multirefs.remove((SvexCall)top);
        }
    }

    private static <N extends SvarName> void printSvexPart(PrintStream out, int indent, Svex<N> top, Map<Svex<N>, String> multirefsNames, boolean isRoot) {
        out.println();
        for (int i2 = 0; i2 < indent; ++i2) {
            out.print(' ');
        }
        if (top instanceof SvexQuote) {
            SvexQuote sq = (SvexQuote)top;
            if (sq.val.isVec2()) {
                Vec2 val = (Vec2)sq.val;
                out.print(val.getVal());
            } else if (sq.val.equals(Vec4.X)) {
                out.print("(4vec-x)");
            } else if (sq.val.equals(Vec4.Z)) {
                out.print("(4vec-z)");
            } else {
                out.print("'(" + String.valueOf(sq.val.getUpper()) + " . " + String.valueOf(sq.val.getLower()) + ")");
            }
        } else if (top instanceof SvexVar) {
            SvexVar sv = (SvexVar)top;
            out.print("|" + String.valueOf(sv.svar) + "|");
        } else {
            SvexCall sc = (SvexCall)top;
            String name = multirefsNames.get(sc);
            if (name != null && !isRoot) {
                out.print(name);
            } else {
                out.print("(" + sc.fun.applyFn);
                for (Svex arg : sc.getArgs()) {
                    GenFsmNew.printSvexPart(out, indent + 1, arg, multirefsNames, false);
                }
                out.print(')');
            }
        }
    }

    static class GenFsmJob<H extends DesignHints>
    extends Job {
        private final Class<H> cls;
        private final File saoFile;
        private final String designName;

        private GenFsmJob(Class<H> cls, File saoFile, String designName) {
            super("Dump SV Design", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFile = saoFile;
            this.designName = designName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger(this.designName);
                DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                DesignExt design = new DesignExt(sr.root, designHints);
                GenFsmNew gen = new GenFsmNew(designHints);
                File outDir = this.saoFile.getParentFile();
                gen.gen(this.designName, design, outDir);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                System.out.println(e2.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }
    }
}

