/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Design;
import com.sun.electric.tool.simulation.acl2.mods.ElabMod;
import com.sun.electric.tool.simulation.acl2.mods.ModDb;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.modsext.DesignHints;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.ParameterizedModule;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DesignExt {
    public final Design<Address> b;
    public final DesignHints designHints;
    public final ModDb moddb;
    public final Map<ModName, ModuleExt> downTop = new LinkedHashMap<ModName, ModuleExt>();
    public final Map<ModName, ModuleExt> topDown = new LinkedHashMap<ModName, ModuleExt>();
    final List<ParameterizedModule> paremterizedModules;

    public DesignExt(ACL2Object impl) {
        this(impl, (DesignHints)new DesignHints.Dummy());
    }

    public DesignExt(ACL2Object impl, DesignHints designHints) {
        this(new Design<Address>(new Address.SvarNameBuilder(), impl), designHints);
    }

    /*
     * WARNING - void declaration
     */
    public DesignExt(Design<Address> b2, DesignHints designHints) {
        this.b = b2;
        this.designHints = designHints;
        this.paremterizedModules = designHints.getParameterizedModules();
        this.moddb = new ModDb(b2.top, b2.modalist);
        this.addToDownTop(b2.top);
        int modidx = 0;
        Iterator<ModName> it = this.downTop.keySet().iterator();
        while (it.hasNext()) {
            ElabMod elabMod = this.moddb.getMod(modidx);
            Util.check(elabMod.modidxGetName().equals(it.next()));
            ++modidx;
        }
        assert (modidx == this.moddb.nMods());
        ArrayList<ModName> keys = new ArrayList<ModName>(this.downTop.keySet());
        for (int i2 = keys.size() - 1; i2 >= 0; --i2) {
            Iterator<Map.Entry<ModName, ModuleExt>> key = (ModName)keys.get(i2);
            this.topDown.put((ModName)((Object)key), this.downTop.get(key));
        }
        Util.check(this.topDown.size() == this.downTop.size());
        this.topDown.get(b2.top).markTop(designHints.getExportNames(b2.top));
        TreeMap<String, Integer> globalCounts = new TreeMap<String, Integer>();
        for (ModuleExt moduleExt : this.topDown.values()) {
            moduleExt.markDown(globalCounts);
        }
        for (Map.Entry<ModName, ModuleExt> entry : this.downTop.entrySet()) {
            int[] driversToSplit;
            ModName modName = entry.getKey();
            ModuleExt m3 = entry.getValue();
            String[] portInstancesToSplit = designHints.getPortInstancesToSplit(modName);
            if (portInstancesToSplit != null) {
                m3.markPortInstancesToSplit(portInstancesToSplit);
            }
            if ((driversToSplit = designHints.getDriversToSplit(modName)) == null) continue;
            m3.markDriversToSplit(driversToSplit);
        }
        ArrayList filteredGlobalCounts = new ArrayList();
        for (Map.Entry entry : globalCounts.entrySet()) {
            String canonicGlobal = TextUtils.canonicString((String)entry.getKey());
            if (!canonicGlobal.contains("clk") && !canonicGlobal.contains("clock")) continue;
            filteredGlobalCounts.add(entry);
        }
        if (!globalCounts.isEmpty()) {
            Collections.sort(filteredGlobalCounts, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return Integer.compare(o2.getValue(), o1.getValue());
                }
            });
            System.out.print("Probable clocks:");
            boolean bl = false;
            for (Map.Entry e4 : filteredGlobalCounts) {
                void var7_14;
                String global = (String)e4.getKey();
                Integer count = (Integer)e4.getValue();
                if (++var7_14 >= 5) break;
                System.out.print(" " + global + "(" + count + ")");
            }
            System.out.println();
        }
    }

    private void addToDownTop(ModName mn) {
        if (this.downTop.containsKey(mn)) {
            return;
        }
        Module module = this.b.modalist.get(mn);
        for (ModInst modInst : module.insts) {
            this.addToDownTop(modInst.modname);
        }
        ModuleExt m2 = new ModuleExt(this, mn);
        ModuleExt old = this.downTop.put(mn, m2);
        Util.check(old == null);
    }

    public ModName getTop() {
        return this.b.top;
    }

    public void computeCombinationalInputs(String clockName) {
        for (ModuleExt m2 : this.downTop.values()) {
            m2.computeCombinationalInputs(clockName);
        }
    }
}

