/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;

public abstract class Name
implements ACL2Backed {
    public static final Name SELF = new Name(){

        @Override
        public boolean isSimpleSvarName() {
            return true;
        }

        public int hashCode() {
            return Util.KEYWORD_SELF.hashCode();
        }

        @Override
        public ACL2Object getACL2Object() {
            return Util.KEYWORD_SELF;
        }

        public String toString() {
            return ":SELF";
        }
    };

    public static Name fromACL2(ACL2Object impl) {
        Name result = ACL2.stringp(impl).bool() ? Name.valueOf(impl.stringValueExact()) : (ACL2.integerp(impl).bool() ? Name.valueOf(impl.intValueExact()) : (impl.equals(Util.KEYWORD_SELF) ? SELF : new AnonymousImpl(impl)));
        assert (result.hashCode() == impl.hashCode());
        return result;
    }

    public static Name valueOf(String s) {
        return new StringImpl(s);
    }

    public static Name valueOf(BigInteger i2) {
        return new IntegerImpl(i2);
    }

    public static Name valueOf(int i2) {
        return new IntegerImpl(BigInteger.valueOf(i2));
    }

    public boolean isString() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isSimpleSvarName() {
        return false;
    }

    public String toLispString() {
        return this.toString();
    }

    private static class AnonymousImpl
    extends Name {
        private ACL2Object args;

        AnonymousImpl(ACL2Object impl) {
            if (!ACL2.car(impl).equals(Util.KEYWORD_ANONYMOIUS)) {
                throw new IllegalArgumentException();
            }
            this.args = ACL2.cdr(impl);
        }

        public boolean equals(Object o2) {
            return o2 instanceof AnonymousImpl && this.args.equals(((AnonymousImpl)o2).args);
        }

        public int hashCode() {
            return ACL2Object.hashCodeOfCons(Util.KEYWORD_ANONYMOIUS.hashCode(), this.args.hashCode());
        }

        @Override
        public ACL2Object getACL2Object() {
            ACL2Object result = ACL2.hons(Util.KEYWORD_ANONYMOIUS, this.args);
            assert (result.hashCode() == this.hashCode());
            return result;
        }

        public String toString() {
            return "'(:ANONYMOUS . " + this.args.rep() + ")";
        }
    }

    private static class StringImpl
    extends Name {
        private String s;

        StringImpl(String s) {
            this.s = s;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isSimpleSvarName() {
            return true;
        }

        public boolean equals(Object o2) {
            return o2 instanceof StringImpl && this.s.equals(((StringImpl)o2).s);
        }

        public int hashCode() {
            return ACL2Object.hashCodeOf(this.s);
        }

        @Override
        public ACL2Object getACL2Object() {
            ACL2Object result = ACL2.honscopy(ACL2Object.valueOf(this.s));
            assert (result.hashCode() == this.hashCode());
            return result;
        }

        public String toString() {
            return this.s;
        }

        @Override
        public String toLispString() {
            return "\"" + this.s + "\"";
        }
    }

    private static class IntegerImpl
    extends Name {
        private BigInteger val;

        IntegerImpl(BigInteger val) {
            this.val = val;
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        public boolean equals(Object o2) {
            return o2 instanceof IntegerImpl && this.val.equals(((IntegerImpl)o2).val);
        }

        public int hashCode() {
            return ACL2Object.hashCodeOf(this.val);
        }

        @Override
        public ACL2Object getACL2Object() {
            ACL2Object result = ACL2.honscopy(ACL2Object.valueOf(this.val));
            assert (result.hashCode() == this.hashCode());
            return result;
        }

        public String toString() {
            return "'" + String.valueOf(this.val);
        }
    }
}

