/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Aliaspair;
import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.mods.Wire;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Module<N extends SvarName> {
    public final SvexManager<N> sm;
    public final List<Wire> wires = new ArrayList<Wire>();
    public final List<ModInst> insts = new ArrayList<ModInst>();
    public final List<Assign<N>> assigns = new ArrayList<Assign<N>>();
    public final List<Aliaspair<N>> aliaspairs = new ArrayList<Aliaspair<N>>();

    public Module(SvexManager<N> sm, Collection<Wire> wires, Collection<ModInst> insts, Collection<Assign<N>> assigns, Collection<Aliaspair<N>> aliaspairs) {
        this.sm = sm;
        this.wires.addAll(wires);
        this.insts.addAll(insts);
        this.assigns.addAll(assigns);
        this.aliaspairs.addAll(aliaspairs);
    }

    static <N extends SvarName> Module<N> fromACL2(SvarName.Builder<N> snb, ACL2Object impl) {
        Object modInst;
        SvexManager sm = new SvexManager();
        List<ACL2Object> fields = Util.getList(impl, true);
        Util.check(fields.size() == 4);
        ACL2Object pair = fields.get(0);
        Util.check(ACL2.car(pair).equals(Util.SV_WIRES));
        ArrayList<Wire> wires = new ArrayList<Wire>();
        for (ACL2Object aCL2Object : Util.getList(ACL2.cdr(pair), true)) {
            Wire wire = new Wire(aCL2Object);
            wires.add(wire);
        }
        pair = fields.get(1);
        Util.check(ACL2.car(pair).equals(Util.SV_INSTS));
        ArrayList<ModInst> insts = new ArrayList<ModInst>();
        for (ACL2Object o3 : Util.getList(ACL2.cdr(pair), true)) {
            modInst = ModInst.fromACL2(o3);
            insts.add((ModInst)modInst);
        }
        pair = fields.get(2);
        Util.check(ACL2.car(pair).equals(Util.SV_ASSIGNS));
        ArrayList<Assign<N>> arrayList = new ArrayList<Assign<N>>();
        HashMap svexCache = new HashMap();
        modInst = Util.getList(ACL2.cdr(pair), true).iterator();
        while (modInst.hasNext()) {
            ACL2Object o4;
            pair = o4 = (ACL2Object)modInst.next();
            Lhs<N> lhs = Lhs.fromACL2(snb, sm, ACL2.car(pair));
            Driver<N> driver = Driver.fromACL2(snb, sm, ACL2.cdr(pair), svexCache);
            Assign<N> assign = new Assign<N>(lhs, driver);
            arrayList.add(assign);
        }
        pair = fields.get(3);
        Util.check(ACL2.car(pair).equals(Util.SV_ALIASPAIRS));
        ArrayList<Aliaspair<N>> aliaspairs = new ArrayList<Aliaspair<N>>();
        Iterator<ACL2Object> iterator = Util.getList(ACL2.cdr(pair), true).iterator();
        while (iterator.hasNext()) {
            ACL2Object o5;
            pair = o5 = iterator.next();
            Lhs<N> lhs = Lhs.fromACL2(snb, sm, ACL2.car(pair));
            Lhs<N> rhs = Lhs.fromACL2(snb, sm, ACL2.cdr(pair));
            Aliaspair<N> aliaspair = new Aliaspair<N>(lhs, rhs);
            aliaspairs.add(aliaspair);
        }
        return new Module(sm, wires, insts, arrayList, aliaspairs);
    }

    public ACL2Object getACL2Object() {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ACL2Object wiresList = ACL2.NIL;
        for (int i2 = this.wires.size() - 1; i2 >= 0; --i2) {
            wiresList = ACL2.cons(this.wires.get(i2).getACL2Object(), wiresList);
        }
        ACL2Object instsList = ACL2.NIL;
        for (int i3 = this.insts.size() - 1; i3 >= 0; --i3) {
            instsList = ACL2.cons(this.insts.get(i3).getACL2Object(backedCache), instsList);
        }
        ACL2Object assignsList = ACL2.NIL;
        for (int i4 = this.assigns.size() - 1; i4 >= 0; --i4) {
            Assign<N> assign = this.assigns.get(i4);
            assignsList = ACL2.cons(ACL2.cons(assign.lhs.getACL2Object(backedCache), assign.driver.getACL2Object(backedCache)), assignsList);
        }
        ACL2Object aliasesList = ACL2.NIL;
        for (int i5 = this.aliaspairs.size() - 1; i5 >= 0; --i5) {
            Aliaspair<N> aliaspair = this.aliaspairs.get(i5);
            aliasesList = ACL2.cons(ACL2.cons(aliaspair.lhs.getACL2Object(backedCache), aliaspair.rhs.getACL2Object(backedCache)), aliasesList);
        }
        return ACL2.cons(ACL2.cons(Util.SV_WIRES, wiresList), ACL2.cons(ACL2.cons(Util.SV_INSTS, instsList), ACL2.cons(ACL2.cons(Util.SV_ASSIGNS, assignsList), ACL2.cons(ACL2.cons(Util.SV_ALIASPAIRS, aliasesList), ACL2.NIL))));
    }

    public boolean equals(Object o2) {
        if (o2 instanceof Module) {
            Module that = (Module)o2;
            return this.wires.equals(that.wires) && this.insts.equals(that.insts) && this.assigns.equals(that.assigns) && this.aliaspairs.equals(that.aliaspairs);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.wires.hashCode();
        hash = 89 * hash + this.insts.hashCode();
        hash = 89 * hash + this.assigns.hashCode();
        hash = 89 * hash + this.aliaspairs.hashCode();
        return hash;
    }

    void vars(Collection<Svar<N>> vars) {
        for (Assign<N> assign : this.assigns) {
            assign.lhs.vars(vars);
            assign.driver.vars(vars);
        }
        for (Aliaspair aliaspair : this.aliaspairs) {
            aliaspair.lhs.vars(vars);
            aliaspair.rhs.vars(vars);
        }
    }
}

